/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.util.HashMap;
import java.util.Map;

public final class BitUtil {
    private static final Map<Integer, Integer> LOG2S;
    private static final int[] BASE2S;
    private static final int[] BIT_REVERSED;

    public static final int moveBit(int value, int sourceBit, int destinationBit) {
        return BitUtil.moveBit(value, sourceBit, destinationBit, false);
    }

    public static final int moveBit(int value, int sourceBit, int destinationBit, boolean invert) {
        if (invert) {
            return (value >> sourceBit & 1 ^ 1) << destinationBit;
        }
        return (value >> sourceBit & 1) << destinationBit;
    }

    public static final int reverseBits(int value) {
        return BIT_REVERSED[value];
    }

    public static final int reverseBits16(int value) {
        return BIT_REVERSED[value & 0xFF] << 8 | BIT_REVERSED[value >> 8];
    }

    public static final boolean isTrue(int value) {
        return value != 0;
    }

    public static final boolean isFalse(int value) {
        return value == 0;
    }

    public static final int toBit(boolean value) {
        return value ? 1 : 0;
    }

    public static final int toBit(boolean value, int bit) {
        return (value ? 1 : 0) << bit;
    }

    public static final boolean toBitBool(int value) {
        return (value & 1) != 0;
    }

    public static final boolean toBitBool(int value, int bit) {
        return (value >> bit & 1) != 0;
    }

    public static final boolean getBitBool(int x, int bit) {
        return BitUtil.getBit(x, bit) == 1;
    }

    public static final int getBit(int x, int bit) {
        return x >> bit & 1;
    }

    public static final int setBit(int x, int bit) {
        return x | 1 << bit;
    }

    public static final int resetBit(int x, int bit) {
        return x & ~(1 << bit);
    }

    public static final int setBit(int x, int bit, boolean value) {
        if (value) {
            return x | 1 << bit;
        }
        return x & ~(1 << bit);
    }

    public static final int setBit(int x, int bit, int value) {
        if (value != 0) {
            return x | 1 << bit;
        }
        return x & ~(1 << bit);
    }

    public static final int toggleBit(int x, int bit) {
        return x ^ 1 << bit;
    }

    public static final boolean isBase2(int value) {
        for (int i = BASE2S.length - 1; i >= 0; --i) {
            if (value != BASE2S[i]) continue;
            return true;
        }
        return false;
    }

    public static final int ceilBase2(int value) {
        for (int i = 0; i < BASE2S.length; ++i) {
            if (BASE2S[i] < value) continue;
            return BASE2S[i];
        }
        return value;
    }

    public static final int log2(int value) {
        return LOG2S.get(value);
    }

    private BitUtil() {
    }

    static {
        int i;
        LOG2S = new HashMap<Integer, Integer>();
        BASE2S = new int[32];
        BIT_REVERSED = new int[256];
        for (i = 0; i < 32; ++i) {
            BitUtil.BASE2S[i] = 1 << i;
            LOG2S.put(BASE2S[i], i);
        }
        for (i = 0; i < 256; ++i) {
            int value = i;
            for (int j = 0; j < 8; ++j) {
                BitUtil.BIT_REVERSED[i] = BIT_REVERSED[i] << 1 | value & 1;
                value >>= 1;
            }
        }
    }
}

