/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static boolean isBlank(Object array) {
        return array == null || Array.getLength(array) == 0;
    }

    public static boolean isBlank(List list) {
        return list == null || list.isEmpty();
    }

    public static <T> boolean contains(T[] a, T element) {
        for (int i = a.length - 1; i >= 0; --i) {
            if (!Objects.equals(a[i], element)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Comparable<T>> int compare(T a, T b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int[] toIntArray(byte[] values) {
        if (values == null) {
            return null;
        }
        int[] vs = new int[values.length];
        for (int i = vs.length - 1; i >= 0; --i) {
            vs[i] = values[i] & 0xFF;
        }
        return vs;
    }

    public static int[] toIntArray(Integer[] values) {
        if (values == null) {
            return null;
        }
        int[] vs = new int[values.length];
        for (int i = vs.length - 1; i >= 0; --i) {
            Integer value = values[i];
            vs[i] = value == null ? 0 : value;
        }
        return vs;
    }

    public static Integer[] toIntegerArray(int[] values) {
        if (values == null) {
            return null;
        }
        Integer[] vs = new Integer[values.length];
        for (int i = vs.length - 1; i >= 0; --i) {
            vs[i] = values[i];
        }
        return vs;
    }

    public static <T> T[] convertToArray(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return CollectionsUtil.convertToArray(list.get(0).getClass(), list);
    }

    public static <T> T[] convertToArray(Class<T> c, List<T> list) {
        return CollectionsUtil.convertToArray(c, list, true);
    }

    public static <T> T[] convertToArray(Class<T> c, List<T> list, boolean returnNullForEmptyList) {
        if (list == null || list.isEmpty()) {
            if (returnNullForEmptyList) {
                return null;
            }
            return (Object[])Array.newInstance(c, 0);
        }
        Object[] ts = (Object[])Array.newInstance(c, list.size());
        list.toArray(ts);
        return ts;
    }

    public static <T> T[] resize(Class<T> c, T[] a, int length) {
        Object[] b = (Object[])Array.newInstance(c, length);
        if (a != null) {
            System.arraycopy(a, 0, b, 0, Math.min(a.length, b.length));
        }
        return b;
    }

    public static <T> T[] concat(Class<T> c, T[] a, T[] b) {
        if (a != null && a.length == 0) {
            a = null;
        }
        if (b != null && b.length == 0) {
            b = null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        Object[] array = (Object[])Array.newInstance(c, a.length + b.length);
        System.arraycopy(a, 0, array, 0, a.length);
        System.arraycopy(b, 0, array, a.length, b.length);
        return array;
    }

    public static <T> T[] addElement(Class<T> c, T[] array, T element) {
        Object[] a;
        if (array == null) {
            a = (Object[])Array.newInstance(c, 1);
            a[0] = element;
        } else {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!Objects.equals(array[i], element)) continue;
                return array;
            }
            a = (Object[])Array.newInstance(c, array.length + 1);
            System.arraycopy(array, 0, a, 0, array.length);
            a[a.length - 1] = element;
        }
        return a;
    }

    public static <T> T[] removeAllElements(Class<T> c, T[] array, T element) {
        if (array == null) {
            return null;
        }
        T[] result = array;
        for (int i = result.length - 1; i >= 0; --i) {
            if (!Objects.equals(result[i], element)) continue;
            result = CollectionsUtil.removeElement(c, result, i);
        }
        return result;
    }

    public static <T> T[] removeAll(Class<T> c, T[] array, Predicate<T> predicate) {
        if (array == null) {
            return null;
        }
        T[] result = array;
        for (int i = result.length - 1; i >= 0; --i) {
            if (!predicate.test(result[i])) continue;
            result = CollectionsUtil.removeElement(c, result, i);
        }
        return result;
    }

    public static <T> T[] removeElement(Class<T> c, T[] array, T element) {
        int i;
        block3: {
            if (array == null) {
                return null;
            }
            for (i = array.length - 1; i >= 0; --i) {
                if (!Objects.equals(array[i], element)) {
                    continue;
                }
                break block3;
            }
            return array;
        }
        int index = i;
        return CollectionsUtil.removeElement(c, array, index);
    }

    public static <T> T[] removeElement(Class<T> c, T[] array, int index) {
        if (array == null) {
            return null;
        }
        if (index >= array.length || index < 0) {
            return array;
        }
        if (array.length <= 1) {
            return null;
        }
        Object[] a = (Object[])Array.newInstance(c, array.length - 1);
        if (index != 0) {
            System.arraycopy(array, 0, a, 0, index);
        }
        if (index != array.length - 1) {
            System.arraycopy(array, index + 1, a, index, array.length - index - 1);
        }
        return a;
    }

    public static boolean compareArrays(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = a.length - 1; i >= 0; --i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean compareArrays(T[] a, T[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = a.length - 1; i >= 0; --i) {
            if (Objects.equals(a[i], b[i])) continue;
            return false;
        }
        return true;
    }
}

