/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public final class CsvUtil {
    private CsvUtil() {
    }

    public static List<List<String>> convert(String[][] lines) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (String[] line : lines) {
            ArrayList<String> row = new ArrayList<String>();
            result.add(row);
            for (String str : line) {
                row.add(str);
            }
        }
        return result;
    }

    public static String[][] convert(List<List<String>> lines) {
        int maxSize = 0;
        for (List<String> line : lines) {
            maxSize = Math.max(line.size(), maxSize);
        }
        String[][] result = new String[lines.size()][maxSize];
        for (int i = lines.size() - 1; i >= 0; --i) {
            List<String> line = lines.get(i);
            for (int j = line.size() - 1; j >= 0; --j) {
                result[i][j] = line.get(j);
            }
        }
        return result;
    }

    public static void write(PrintStream out, List<List<String>> lines) throws Throwable {
        for (List<String> line : lines) {
            StringBuilder sb = new StringBuilder();
            for (String str : line) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                CsvUtil.append(str, sb);
            }
            out.println(sb);
        }
    }

    private static void append(String str, StringBuilder sb) {
        char c;
        int i;
        block5: {
            if (str == null) {
                return;
            }
            str = str.trim();
            for (i = str.length() - 1; i >= 0; --i) {
                c = str.charAt(i);
                if (c != '\"' && c != ',' && c != '\n' && c != '\r') {
                    continue;
                }
                break block5;
            }
            sb.append(str);
            return;
        }
        sb.append('\"');
        for (i = 0; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c == '\"') {
                sb.append("\"\"");
                continue;
            }
            sb.append(c);
        }
        sb.append('\"');
    }

    public static List<List<String>> read(BufferedReader br) throws Throwable {
        StringBuilder sb = new StringBuilder();
        String input = null;
        while ((input = br.readLine()) != null) {
            sb.append(input).append('\n');
        }
        for (int i = sb.length() - 1; i >= 0; --i) {
            if (sb.charAt(i) == '\r') {
                if (i > 0 && sb.charAt(i - 1) == '\n') {
                    sb.delete(i, i + 1);
                    continue;
                }
                sb.setCharAt(i, '\n');
                continue;
            }
            if (sb.charAt(i) != '\n' || i <= 0 || sb.charAt(i - 1) != '\r') continue;
            sb.delete(i, i + 1);
            sb.setCharAt(i - 1, '\n');
        }
        boolean insideQuotes = false;
        boolean insideValue = false;
        boolean advance = false;
        boolean rightOfComma = false;
        StringBuilder s = new StringBuilder();
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        ArrayList<String> line = new ArrayList<String>();
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (advance) {
                if (c == ',') {
                    rightOfComma = true;
                    advance = false;
                    continue;
                }
                if (c != '\n') continue;
                if (rightOfComma) {
                    line.add(null);
                    rightOfComma = false;
                }
                lines.add(line);
                line = new ArrayList();
                advance = false;
                continue;
            }
            if (!insideValue) {
                if (Character.isWhitespace(c)) {
                    if (c != '\n') continue;
                    if (rightOfComma) {
                        line.add(null);
                        rightOfComma = false;
                    }
                    lines.add(line);
                    line = new ArrayList();
                    continue;
                }
                insideValue = true;
                rightOfComma = false;
                if (c == '\"') {
                    insideQuotes = true;
                    continue;
                }
            }
            if (insideQuotes) {
                if (c == '\"') {
                    if (sb.charAt(i + 1) == '\"') {
                        s.append('\"');
                        ++i;
                        continue;
                    }
                    insideQuotes = false;
                    insideValue = false;
                    advance = true;
                    line.add(s.toString().trim());
                    s.setLength(0);
                    continue;
                }
                s.append(c);
                continue;
            }
            if (c == ',' || c == '\n') {
                insideValue = false;
                line.add(s.toString().trim());
                s.setLength(0);
                if (c == '\n') {
                    if (rightOfComma) {
                        line.add(null);
                        rightOfComma = false;
                    }
                    lines.add(line);
                    line = new ArrayList();
                    continue;
                }
                rightOfComma = true;
                continue;
            }
            s.append(c);
        }
        return lines;
    }
}

