/*
 * Decompiled with CFR 0.152.
 */
package nintaco.util;

import java.util.concurrent.locks.LockSupport;
import nintaco.App;
import nintaco.gui.userinterface.InterframeDelay;
import nintaco.mappers.Mapper;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;

public class TimeUtil {
    private static volatile int speedPercent = 100;
    private static volatile TVSystem tvSystem = TVSystem.NTSC;
    private static volatile long nanosPerFrame;
    private static volatile boolean diskActivity;
    private static volatile boolean highSpeed;
    private static volatile int maxLagFrames;
    private static volatile InterframeDelay interframeDelay;
    private static volatile long frameLostThreshold;

    private static void updateSpeed() {
        AppPrefs prefs = AppPrefs.getInstance();
        int percent = highSpeed ? prefs.getInputs().getHighSpeedRate() : speedPercent;
        nanosPerFrame = percent == 0 || diskActivity && prefs.getFamicomDiskSystemPrefs().isFastForwardDuringDiskAccess() ? 0L : tvSystem.getNanosPerFrame() * 100L / (long)percent;
        TimeUtil.updateFrameLostThreshold();
    }

    public static boolean isHighSpeed() {
        return highSpeed;
    }

    public static void setHighSpeed(boolean highSpeed) {
        TimeUtil.highSpeed = highSpeed;
        TimeUtil.updateSpeed();
    }

    public static int getSpeed() {
        return speedPercent;
    }

    public static void setSpeed(int speedPercent) {
        TimeUtil.speedPercent = speedPercent;
        TimeUtil.updateSpeed();
    }

    public static void setMaxLagFrames(int maxLagFrames) {
        TimeUtil.maxLagFrames = maxLagFrames;
        TimeUtil.updateFrameLostThreshold();
    }

    public static void setInterframeDelay(InterframeDelay interframeDelay) {
        TimeUtil.interframeDelay = interframeDelay;
    }

    private static void updateFrameLostThreshold() {
        frameLostThreshold = (long)maxLagFrames * nanosPerFrame;
    }

    public static long sleep(long next, Mapper mapper) {
        TVSystem system;
        if (mapper != null) {
            boolean activity = mapper.isDiskActivity();
            if (diskActivity != activity) {
                diskActivity = activity;
                TimeUtil.updateSpeed();
            }
            App.setDiskActivity(activity);
            system = mapper.getTVSystem();
        } else {
            system = TVSystem.NTSC;
        }
        if (tvSystem != system) {
            tvSystem = system;
            TimeUtil.updateSpeed();
        }
        if (nanosPerFrame > 0L) {
            if (System.nanoTime() - (next += nanosPerFrame) > frameLostThreshold) {
                next = System.nanoTime();
            } else {
                TimeUtil.delayUntil(next);
            }
        } else {
            next = System.nanoTime();
        }
        return next;
    }

    private static void delayUntil(long nanoTime) {
        switch (interframeDelay) {
            case Sleep: {
                LockSupport.parkNanos(nanoTime - System.nanoTime());
                break;
            }
            case Yield: {
                while (nanoTime - System.nanoTime() > 0L) {
                    Thread.yield();
                }
                break;
            }
            case Spin: {
                while (nanoTime - System.nanoTime() > 0L) {
                }
                break;
            }
        }
    }

    static {
        TimeUtil.updateSpeed();
        TimeUtil.setMaxLagFrames(60);
    }
}

