/*
 * Decompiled with CFR 0.152.
 */
package nintaco;

import java.util.List;
import nintaco.App;
import nintaco.Breakpoint;
import nintaco.CPU;
import nintaco.Machine;
import nintaco.PPU;
import nintaco.PauseStepType;
import nintaco.ServicedType;
import nintaco.api.local.LocalAPI;
import nintaco.apu.APU;
import nintaco.apu.SystemAudioProcessor;
import nintaco.cheats.GameCheats;
import nintaco.disassembler.TraceLogger;
import nintaco.gui.image.ImagePane;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.gui.rob.RobController;
import nintaco.gui.rob.RobState;
import nintaco.input.DeviceMapper;
import nintaco.input.InputUtil;
import nintaco.input.OtherInput;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.movie.MovieFrame;
import nintaco.netplay.client.NetplayClient;
import nintaco.netplay.protocol.ControllerInput;
import nintaco.netplay.server.NetplayServer;
import nintaco.task.Task;
import nintaco.util.CollectionsUtil;
import nintaco.util.GuiUtil;
import nintaco.util.StreamUtil;
import nintaco.util.ThreadUtil;
import nintaco.util.TimeUtil;

public class MachineRunner
extends Task {
    protected static final int JSR = 32;
    protected static final int PLP = 40;
    protected static final int RTI = 64;
    protected static final int RTS = 96;
    protected static final int PLA = 104;
    protected final ControllerInput controllerInput = new ControllerInput();
    protected volatile boolean forwardTime = true;
    protected volatile int noStepPause;
    protected volatile boolean stepPause;
    protected volatile boolean pauseRequested;
    protected volatile boolean paused;
    protected volatile PauseStepType pauseStepType = PauseStepType.None;
    protected volatile int stepToValue;
    protected volatile int stepToValue2;
    protected volatile Thread runningThread;
    protected volatile TraceLogger traceLogger;
    protected volatile MovieBlock currentMovieBlock;
    protected volatile MovieBlock movieBlock;
    protected volatile Movie movie;
    protected volatile Movie rewindMovie;
    protected int generatingOffset;
    protected int generatingIndex;
    protected int renderingIndex;
    protected volatile NetplayClient netplayClient;
    protected volatile NetplayServer netplayServer;
    protected volatile LocalAPI localAPI;
    protected Machine machine;
    protected Mapper mapper;
    protected CPU cpu;
    protected PPU ppu;
    protected APU apu;
    protected volatile transient Breakpoint[] breakpoints;
    protected boolean terminated = true;

    public MachineRunner(Machine machine) {
        this.setMachine(machine);
    }

    public void setMachine(Machine machine) {
        if (machine == null) {
            this.machine = null;
            this.mapper = null;
            this.cpu = null;
            this.ppu = null;
            this.apu = null;
        } else {
            this.machine = machine;
            this.mapper = machine.getMapper();
            this.cpu = machine.getCPU();
            this.ppu = machine.getPPU();
            this.apu = machine.getAPU();
        }
    }

    public Machine getMachine() {
        return this.machine;
    }

    public CPU getCPU() {
        return this.cpu;
    }

    public PPU getPPU() {
        return this.ppu;
    }

    public APU getAPU() {
        return this.apu;
    }

    public Mapper getMapper() {
        return this.mapper;
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setCurrentMovieBlock(MovieBlock currentMovieBlock) {
        this.currentMovieBlock = currentMovieBlock;
    }

    public MovieBlock getCurrentMovieBlock() {
        return this.currentMovieBlock;
    }

    public void setMovieBlock(MovieBlock movieBlock) {
        this.movieBlock = movieBlock;
    }

    public MovieBlock getMovieBlock() {
        return this.movieBlock;
    }

    public void setMovie(Movie movie) {
        this.movie = movie;
        if (movie == null) {
            this.setForwardTime(true);
            this.ppu.setMachineRunner(null);
        } else {
            this.ppu.setMachineRunner(this);
        }
    }

    public NetplayClient getClient() {
        return this.netplayClient;
    }

    public void setClient(NetplayClient netplayClient) {
        this.netplayClient = netplayClient;
    }

    public void clearClient() {
        this.setClient(null);
    }

    public NetplayServer getServer() {
        return this.netplayServer;
    }

    public void setServer(NetplayServer netplayServer) {
        this.netplayServer = netplayServer;
    }

    public void clearServer() {
        this.setServer(null);
    }

    public LocalAPI getLocalAPI() {
        return this.localAPI;
    }

    public void setLocalAPI(LocalAPI localAPI) {
        this.localAPI = localAPI;
    }

    public void clearLocalAPI() {
        this.setLocalAPI(null);
    }

    public void setBreakpoints(List<Breakpoint> breakpoints) {
        Breakpoint[] bs = CollectionsUtil.convertToArray(Breakpoint.class, breakpoints);
        if (bs == null) {
            this.breakpoints = null;
            this.cpu.setBreakpoints(null);
        } else {
            for (int i = bs.length - 1; i >= 0; --i) {
                bs[i] = new Breakpoint(bs[i]);
            }
            this.breakpoints = bs;
            this.cpu.setBreakpoints(bs);
        }
    }

    public void setTraceLogger(TraceLogger traceLogger) {
        this.traceLogger = traceLogger;
    }

    public void frameRendered(int[] screen) {
        Movie m = this.movie;
        if (m != null) {
            m.updateMovieFrame(screen, this.machine);
        }
    }

    public void setForwardTime(boolean forwardTime) {
        Movie m = this.movie;
        this.forwardTime = m == null || this.netplayClient == null && m.getMovieBlocks().isEmpty() ? true : forwardTime;
    }

    public boolean isForwardTime() {
        return this.forwardTime;
    }

    protected void applyInputs(MovieBlock movieBlock, int frameIndex) {
        OtherInput[] otherInputs;
        this.machine.getPPU().setZapper(null);
        DeviceMapper[] mappers = this.mapper.getDeviceMappers();
        for (int i = mappers.length - 1; i >= 0; --i) {
            mappers[i].setMachine(this.machine);
        }
        this.mapper.updateButtons(movieBlock.buttons[frameIndex]);
        if (movieBlock.otherInputs != null && (otherInputs = movieBlock.otherInputs[frameIndex]) != null) {
            for (OtherInput otherInput : otherInputs) {
                otherInput.run(this.machine);
            }
        }
    }

    public void runFrame(MovieBlock movieBlock, int frameIndex) {
        this.runFrame(movieBlock, frameIndex, 0L);
    }

    public long runFrame(MovieBlock movieBlock, int frameIndex, long next) {
        this.applyInputs(movieBlock, frameIndex);
        while (this.ppu.frameRendering) {
            this.cpu.executeInstruction();
        }
        this.ppu.frameRendering = true;
        this.mapper.handleFrameRendered();
        return next;
    }

    @Override
    public void loop() {
        try {
            this.setTerminated(false);
            this.runningThread = Thread.currentThread();
            App.fireStepPausedChanged(this.stepPause);
            while (this.running) {
                if (this.forwardTime) {
                    this.play();
                    continue;
                }
                this.rewind();
            }
        }
        finally {
            App.setMachineRunner(null);
            App.updateFrames(null);
            this.setTerminated(true);
        }
    }

    protected synchronized void setTerminated(boolean terminated) {
        this.terminated = terminated;
        this.notifyAll();
    }

    protected synchronized void waitForTermination() {
        while (!this.terminated) {
            ThreadUtil.threadWait(this);
        }
    }

    protected void play() {
        LocalAPI api;
        Movie m;
        NetplayServer server;
        RobController rob = this.ppu.getRob();
        if (rob != null) {
            App.updateRobFrame(rob);
        }
        App.setMachineRunner(this);
        App.updateFrames(this);
        ImagePane imagePane = App.getImageFrame().getImagePane();
        imagePane.setRewinding(false);
        imagePane.setTVSystem(this.mapper.getTVSystem());
        GameCheats.updateMachine();
        long next = System.nanoTime();
        while (this.running && this.forwardTime) {
            GuiUtil.suppressScreensaver();
            NetplayClient client = this.netplayClient;
            if (client != null && client.isRewind()) {
                this.forwardTime = false;
                break;
            }
            while (this.ppu.frameRendering) {
                TraceLogger logger;
                Breakpoint[] bs = this.breakpoints;
                if (bs != null) {
                    for (int i = bs.length - 1; i >= 0; --i) {
                        Breakpoint breakpoint = bs[i];
                        if (!breakpoint.hit) continue;
                        breakpoint.hit = false;
                        this.setStepPause(true);
                    }
                }
                if ((logger = this.traceLogger) != null) {
                    logger.log(true, this.cpu, this.ppu, this.mapper);
                }
                if (this.pauseRequested) {
                    next = this.handlePause(next);
                }
                this.cpu.executeInstruction();
                if (logger == null) continue;
                logger.log(false, this.cpu, this.ppu, this.mapper);
            }
            this.ppu.frameRendering = true;
            this.mapper.handleFrameRendered();
            App.handleFrameRendered(this);
            if (client == null) {
                next = TimeUtil.sleep(next, this.mapper);
            }
            InputUtil.pollControllers(this.machine);
            this.controllerInput.input = InputUtil.getButtons();
            this.controllerInput.otherInputs = InputUtil.getOtherInputs();
            server = this.netplayServer;
            if (client != null) {
                client.writeControllerInput(this.controllerInput);
                client.readControllerInput(this.controllerInput);
            } else if (server != null) {
                server.mergeControllerInput(this.controllerInput);
                server.writeControllerInput(this.controllerInput);
            }
            LocalAPI api2 = this.localAPI;
            if (api2 != null) {
                this.controllerInput.input = api2.controllersProbed(this.controllerInput.input);
            }
            if ((m = this.movie) != null) {
                m.updateMovieBlock(this.machine, this.controllerInput, client == null);
            }
            this.mapper.updateButtons(this.controllerInput.input);
            if (this.controllerInput.otherInputs == null) continue;
            for (OtherInput otherInput : this.controllerInput.otherInputs) {
                otherInput.run(this.machine);
            }
        }
        if ((api = this.localAPI) != null) {
            api.machineStopped();
        }
        server = this.netplayServer;
        if (this.running && !this.forwardTime) {
            NetplayClient client = this.netplayClient;
            if (client != null) {
                int movieFrameIndex = client.readMovieFrameIndex();
                Movie m2 = this.movie;
                if (m2 != null) {
                    m2.frameIndex = movieFrameIndex;
                }
            } else if (server != null && (m = this.movie) != null) {
                server.post(14, m.frameIndex);
            }
        }
    }

    protected void rewind() {
        SubMonitorFrame subMonitorFrame;
        SubMonitorFrame subMonitorFrame2;
        this.rewindMovie = this.movie;
        NetplayClient client = this.netplayClient;
        NetplayServer server = this.netplayServer;
        if (this.rewindMovie == null || client == null && this.rewindMovie.getMovieBlocks().isEmpty()) {
            this.setForwardTime(true);
            return;
        }
        boolean vsDualSystem = this.rewindMovie.isVsDualSystem();
        this.setMachine(null);
        SystemAudioProcessor systemAudioProcessor = App.getSystemAudioProcessor();
        SystemAudioProcessor.setMovie(null);
        ImagePane imagePane = App.getImageFrame().getImagePane();
        imagePane.setRewinding(true);
        int[] screen = imagePane.render();
        int[] screen2 = null;
        if (vsDualSystem && (subMonitorFrame2 = App.getSubMonitorFrame()) != null) {
            screen2 = subMonitorFrame2.getImagePane().render();
        }
        int displayIndex = this.rewindMovie.frameIndex & 0x3F;
        int displayOffset = this.rewindMovie.frameIndex & 0x40;
        this.generatingOffset = displayOffset ^ 0x40;
        this.generatingIndex = 0;
        this.renderingIndex = 0;
        if (this.currentMovieBlock == null) {
            this.currentMovieBlock = this.removeLastMovieBlock(this.rewindMovie, client, server);
            this.movieBlock = this.removeLastMovieBlock(this.rewindMovie, client, server);
        }
        boolean reachedMovieStart = false;
        long next = System.nanoTime();
        while (this.running && !this.forwardTime) {
            SubMonitorFrame subMonitorFrame3;
            GuiUtil.suppressScreensaver();
            if (client != null && client.isPlay()) {
                this.forwardTime = true;
                break;
            }
            if (this.pauseRequested) {
                next = this.handlePause(next);
            }
            --this.rewindMovie.frameIndex;
            ++this.generatingIndex;
            if (--displayIndex < 0) {
                int temp = this.generatingOffset;
                this.generatingOffset = displayOffset;
                displayOffset = temp;
                for (int i = 63; i >= 0; --i) {
                    this.rewindMovie.movieFrames[this.generatingOffset + i].audioLength = 0;
                }
                if (this.movieBlock == null) {
                    reachedMovieStart = true;
                    break;
                }
                this.currentMovieBlock = this.movieBlock;
                displayIndex = 63;
                this.movieBlock = this.removeLastMovieBlock(this.rewindMovie, client, server);
                this.setMachine(null);
                if (this.movieBlock != null) {
                    this.generatingIndex = 0;
                    this.renderingIndex = 0;
                    try {
                        this.setMachine((Machine)StreamUtil.readObject(this.movieBlock.saveState));
                    }
                    catch (Throwable i) {
                        // empty catch block
                    }
                    InputUtil.setMachine(this.machine);
                    this.mapper.restore(App.getCartFile());
                    this.mapper.restore(App.getFdsFile());
                    this.mapper.restore(App.getNsfFile());
                    this.ppu.setScreenRenderer(this::rewindRender);
                    if (vsDualSystem) {
                        ((MainCPU)this.cpu).getSubPPU().setScreenRenderer(this::rewindRender2);
                    }
                    this.apu.setAudioProcessor(this::rewindProcessOutputSample);
                }
            }
            MovieFrame displayFrame = this.rewindMovie.movieFrames[displayOffset + displayIndex];
            System.arraycopy(displayFrame.screen, 0, screen, 0, screen.length);
            screen = imagePane.render();
            if (vsDualSystem && (subMonitorFrame3 = App.getSubMonitorFrame()) != null) {
                if (screen2 != null) {
                    System.arraycopy(displayFrame.screen2, 0, screen2, 0, screen2.length);
                }
                screen2 = subMonitorFrame3.getImagePane().render();
            }
            int[] audioSamples = displayFrame.audioSamples;
            for (int i = displayFrame.audioLength - 1; i >= 0; --i) {
                systemAudioProcessor.processOutputSample(audioSamples[i]);
            }
            this.rewindCaptureRobState(this.machine);
            App.updateRobFrame(displayFrame.robState);
            App.updateGlassesFrame(displayFrame.screen);
            InputUtil.rewindPollControls(this.machine);
            if (this.machine != null) {
                next = this.runFrame(this.movieBlock, this.generatingIndex, next);
            }
            if (client == null) {
                next = TimeUtil.sleep(next, this.mapper);
                if (server == null) continue;
                server.post(16);
                continue;
            }
            client.readFrameEnd();
        }
        while (this.running && reachedMovieStart && !this.forwardTime) {
            InputUtil.rewindPollControls(this.machine);
            if (this.pauseRequested) {
                next = this.handlePause(next);
            }
            if (client == null) {
                next = TimeUtil.sleep(next, this.mapper);
                if (server == null) continue;
                server.post(16);
                continue;
            }
            client.readFrameEnd();
        }
        if (this.running && this.forwardTime && server != null) {
            server.post(13);
        }
        if (this.machine != null) {
            while (++this.generatingIndex < 64) {
                next = this.runFrame(this.movieBlock, this.generatingIndex, next);
            }
            this.setMachine(null);
        }
        if (this.movieBlock != null) {
            if (client == null) {
                this.rewindMovie.movieBlocks.add(this.movieBlock);
            }
            this.movieBlock = null;
        }
        if (this.currentMovieBlock != null) {
            if (client == null) {
                this.rewindMovie.movieBlocks.add(this.currentMovieBlock);
            }
            try {
                int i;
                this.generatingOffset = displayOffset;
                for (i = 63; i >= 0; --i) {
                    this.rewindMovie.movieFrames[this.generatingOffset + i].audioLength = 0;
                }
                this.generatingIndex = 0;
                this.renderingIndex = 0;
                this.setMachine((Machine)StreamUtil.readObject(this.currentMovieBlock.saveState));
                InputUtil.setMachine(this.machine);
                this.mapper.restore(App.getCartFile());
                this.mapper.restore(App.getFdsFile());
                this.mapper.restore(App.getNsfFile());
                this.ppu.setScreenRenderer(this::rewindRender);
                if (vsDualSystem) {
                    ((MainCPU)this.cpu).getSubPPU().setScreenRenderer(this::rewindRender2);
                }
                this.apu.setAudioProcessor(this::rewindProcessOutputSample);
                if (displayIndex >= 0) {
                    for (i = 0; i < displayIndex; ++i) {
                        next = this.runFrame(this.currentMovieBlock, this.generatingIndex++, next);
                    }
                    for (i = displayIndex; i < 64; ++i) {
                        this.currentMovieBlock.buttons[i] = 0;
                    }
                }
                this.mapper.updateButtons(0);
                SystemAudioProcessor.setMovie(this.rewindMovie);
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        this.currentMovieBlock = null;
        this.movieBlock = null;
        this.apu.setAudioProcessor(systemAudioProcessor);
        this.ppu.setScreenRenderer(imagePane);
        if (vsDualSystem && (subMonitorFrame = App.getSubMonitorFrame()) != null) {
            ((MainCPU)this.cpu).getSubPPU().setScreenRenderer(subMonitorFrame.getImagePane());
        }
        this.ppu.setMachineRunner(this);
    }

    protected MovieBlock removeLastMovieBlock(Movie movie, NetplayClient client, NetplayServer server) {
        if (client == null) {
            MovieBlock movieBlock = null;
            if (movie != null) {
                List<MovieBlock> movieBlocks = movie.movieBlocks;
                MovieBlock movieBlock2 = movieBlock = movieBlocks.isEmpty() ? null : movieBlocks.remove(movieBlocks.size() - 1);
            }
            if (server != null) {
                server.post(15, movieBlock);
            }
            return movieBlock;
        }
        return client.readMovieBlock();
    }

    protected int[] rewindRender() {
        return this.rewindMovie.movieFrames[this.generatingOffset + (0x3F & this.renderingIndex++)].screen;
    }

    protected int[] rewindRender2() {
        return this.rewindMovie.movieFrames[this.generatingOffset + (0x3F & this.renderingIndex - 1)].screen2;
    }

    protected void rewindProcessOutputSample(int value) {
        this.rewindMovie.movieFrames[this.generatingOffset + (0x3F & this.generatingIndex)].processOutputSample(value);
    }

    protected void rewindCaptureRobState(Machine machine) {
        if (machine != null) {
            RobState movieFrameRobState = this.rewindMovie.movieFrames[this.generatingOffset + (0x3F & this.renderingIndex - 1)].robState;
            RobController rob = machine.getPPU().getRob();
            if (rob == null) {
                movieFrameRobState.game = 0;
            } else {
                movieFrameRobState.init(rob.getState());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long handlePause(long next) {
        if (this.shouldPause()) {
            MachineRunner machineRunner = this;
            synchronized (machineRunner) {
                if (this.shouldPause()) {
                    this.setPaused(true);
                    do {
                        ThreadUtil.threadWait(this);
                    } while (this.shouldPause());
                    this.setPaused(false);
                    return System.nanoTime();
                }
            }
        }
        return next;
    }

    protected void setPaused(boolean paused) {
        this.paused = paused;
        this.notifyAll();
        App.firePauseChanged(paused);
    }

    protected boolean shouldPause() {
        if (!this.running) {
            return false;
        }
        if (this.noStepPause > 0) {
            return true;
        }
        if (this.stepPause) {
            switch (this.pauseStepType) {
                case None: {
                    return true;
                }
                case Frame: {
                    return this.ppu.getFrameCounter() == this.stepToValue;
                }
                case Into: {
                    return this.cpu.getInstructionsCounter() == this.stepToValue;
                }
                case Out: {
                    switch (this.mapper.peekCpuMemory(this.cpu.getPC())) {
                        case 40: 
                        case 104: {
                            int stackSize = 255 - this.cpu.getS() - 1;
                            if (stackSize >= this.stepToValue) break;
                            this.stepToValue = stackSize;
                            break;
                        }
                        case 64: 
                        case 96: {
                            if (255 - this.cpu.getS() - 2 >= this.stepToValue) break;
                            this.stepToValue = this.cpu.getInstructionsCounter() + 1;
                            this.pauseStepType = PauseStepType.Into;
                        }
                    }
                    return false;
                }
                case Address: {
                    return this.cpu.getPC() == this.stepToValue;
                }
                case Scanline: {
                    return this.ppu.getFrameCounter() == this.stepToValue2 && this.ppu.getScanline() >= this.stepToValue;
                }
                case Dot: {
                    return this.ppu.getScanlineCycle() >= this.stepToValue && this.ppu.getScanline() != this.stepToValue2;
                }
                case Sprite0: {
                    return this.ppu.getFrameCounter() == this.stepToValue && this.ppu.isSprite0Hit();
                }
                case Opcode: {
                    if (this.stepToValue2 == 1) {
                        this.stepToValue2 = 0;
                    } else {
                        return this.mapper.peekCpuMemory(this.cpu.getPC()) == this.stepToValue;
                    }
                }
                case NMI: {
                    if (this.stepToValue == 1) {
                        this.stepToValue = this.cpu.getServiced() == ServicedType.NMI ? 1 : 0;
                        break;
                    }
                    return this.cpu.getServiced() == ServicedType.NMI;
                }
                case IRQ: {
                    if (this.stepToValue == 1) {
                        this.stepToValue = this.cpu.getServiced() == ServicedType.IRQ ? 1 : 0;
                        break;
                    }
                    return this.cpu.getServiced() == ServicedType.IRQ;
                }
                case BRK: {
                    if (this.stepToValue == 1) {
                        this.stepToValue = this.cpu.getServiced() == ServicedType.BRK ? 1 : 0;
                        break;
                    }
                    return this.cpu.getServiced() == ServicedType.BRK;
                }
                case RST: {
                    if (this.stepToValue == 1) {
                        this.stepToValue = this.cpu.getServiced() == ServicedType.RST ? 1 : 0;
                        break;
                    }
                    return this.cpu.getServiced() == ServicedType.RST;
                }
            }
        }
        return false;
    }

    public synchronized void setNoStepPause(boolean noStepPause) {
        this.setNoStepPause(noStepPause, true);
    }

    public synchronized void setNoStepPause(boolean noStepPause, boolean waitUntilPaused) {
        if (noStepPause) {
            ++this.noStepPause;
        } else {
            --this.noStepPause;
            if (this.noStepPause < 0) {
                this.noStepPause = 0;
            }
        }
        this.pauseRequested = this.noStepPause > 0 || this.stepPause;
        this.notifyAll();
        if (this.running && noStepPause && this.runningThread != null) {
            this.runningThread.interrupt();
            if (waitUntilPaused && Thread.currentThread() != this.runningThread) {
                this.waitUntilPaused();
            }
        }
    }

    public synchronized void setStepPause(boolean stepPause) {
        this.pauseStepType = PauseStepType.None;
        this.stepPause = stepPause;
        this.pauseRequested = this.noStepPause > 0 || this.stepPause;
        this.notifyAll();
        if (this.running && stepPause && this.runningThread != null) {
            this.runningThread.interrupt();
        }
        App.fireStepPausedChanged(stepPause);
    }

    public synchronized void step(PauseStepType pauseStepType) {
        if (this.paused) {
            switch (pauseStepType) {
                case Frame: {
                    this.stepToValue = this.ppu.getFrameCounter() + 1;
                    break;
                }
                case Into: {
                    this.stepToValue = this.cpu.getInstructionsCounter() + 1;
                    break;
                }
                case Out: {
                    int opCode = this.mapper.peekCpuMemory(this.cpu.getPC());
                    if (opCode == 64 || opCode == 96) {
                        pauseStepType = PauseStepType.Into;
                        this.stepToValue = this.cpu.getInstructionsCounter() + 1;
                        break;
                    }
                    this.stepToValue = 255 - this.cpu.getS();
                    break;
                }
                case Over: {
                    int opCode = this.mapper.peekCpuMemory(this.cpu.getPC());
                    if (opCode == 32) {
                        pauseStepType = PauseStepType.Address;
                        this.stepToValue = this.cpu.getPC() + 3 & 0xFFFF;
                        break;
                    }
                    pauseStepType = PauseStepType.Into;
                    this.stepToValue = this.cpu.getInstructionsCounter() + 1;
                    break;
                }
                case Sprite0: {
                    this.stepToValue = this.ppu.getFrameCounter() + (this.ppu.isSprite0Hit() ? 1 : 0);
                    break;
                }
                case NMI: {
                    this.stepToValue = this.cpu.getServiced() == ServicedType.NMI ? 1 : 0;
                    break;
                }
                case IRQ: {
                    this.stepToValue = this.cpu.getServiced() == ServicedType.IRQ ? 1 : 0;
                    break;
                }
                case BRK: {
                    this.stepToValue = this.cpu.getServiced() == ServicedType.BRK ? 1 : 0;
                    break;
                }
                case RST: {
                    this.stepToValue = this.cpu.getServiced() == ServicedType.RST ? 1 : 0;
                }
            }
            this.pauseStepType = pauseStepType;
            this.notifyAll();
        }
    }

    public synchronized void stepToAddress(int address) {
        if (this.paused) {
            this.stepToValue = address;
            this.step(PauseStepType.Address);
        }
    }

    public synchronized void stepToScanline(int scanline) {
        if (this.paused) {
            this.stepToValue = scanline;
            this.stepToValue2 = this.ppu.getFrameCounter() + (this.ppu.getScanline() >= scanline ? 1 : 0);
            this.step(PauseStepType.Scanline);
        }
    }

    public synchronized void stepToDot(int scanlineCycle) {
        if (this.paused) {
            this.stepToValue = scanlineCycle;
            this.stepToValue2 = this.ppu.getScanlineCycle() >= scanlineCycle ? this.ppu.getScanline() : -2;
            this.step(PauseStepType.Dot);
        }
    }

    public synchronized void stepToOpcode(int opcode) {
        if (this.paused) {
            this.stepToValue = opcode;
            this.stepToValue2 = this.mapper.peekCpuMemory(this.cpu.getPC()) == opcode ? 1 : 0;
            this.step(PauseStepType.Opcode);
        }
    }

    public synchronized void stepToInstructions(int instructions) {
        if (this.paused) {
            this.stepToValue = this.cpu.getInstructionsCounter() + instructions;
            this.pauseStepType = PauseStepType.Into;
            this.notifyAll();
        }
    }

    public synchronized void kill() {
        this.noStepPause = 0;
        this.stepPause = false;
        this.running = false;
        this.canceled = true;
        this.notifyAll();
    }

    public synchronized void waitUntilPaused() {
        while (this.running && !this.paused) {
            ThreadUtil.threadWait(this);
        }
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    public void dispose() {
        this.cancel();
        this.waitForTermination();
    }

    @Override
    public void cancel() {
        App.disposeTraceLogger();
        if (this.running) {
            this.kill();
        }
    }
}

