/*
 * Decompiled with CFR 0.152.
 */
package nintaco.api.local;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nintaco.App;
import nintaco.CPU;
import nintaco.MachineRunner;
import nintaco.PPU;
import nintaco.PauseStepType;
import nintaco.api.API;
import nintaco.api.AccessPointListener;
import nintaco.api.ActivateListener;
import nintaco.api.ControllersListener;
import nintaco.api.DeactivateListener;
import nintaco.api.FrameListener;
import nintaco.api.ScanlineCycleListener;
import nintaco.api.ScanlineListener;
import nintaco.api.SpriteZeroListener;
import nintaco.api.StatusListener;
import nintaco.api.StopListener;
import nintaco.api.local.AccessPoint;
import nintaco.api.local.ApiMethod;
import nintaco.api.local.ScanlineCyclePoint;
import nintaco.api.local.ScanlinePoint;
import nintaco.api.local.Sprite;
import nintaco.cheats.Cheat;
import nintaco.cheats.GameCheats;
import nintaco.cheats.GameGenie;
import nintaco.cheats.ProActionRocky;
import nintaco.files.ArchiveEntry;
import nintaco.files.FilePath;
import nintaco.files.FileUtil;
import nintaco.gui.fonts.FontUtil;
import nintaco.input.InputUtil;
import nintaco.input.other.EjectDisk;
import nintaco.input.other.FlipDiskSide;
import nintaco.input.other.Glitch;
import nintaco.input.other.InsertCoin;
import nintaco.input.other.PressServiceButton;
import nintaco.input.other.ScreamIntoMicrophone;
import nintaco.input.other.SetDiskSide;
import nintaco.input.other.SetTVSystem;
import nintaco.input.zapper.ZapperMapper;
import nintaco.mappers.Mapper;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.CollectionsUtil;
import nintaco.util.StringUtil;

public class LocalAPI
implements API {
    private static volatile LocalAPI localAPI;
    private final Map<Integer, Sprite> sprites = new ConcurrentHashMap<Integer, Sprite>();
    private AccessPoint[] accessPoints;
    private ControllersListener[] controllersListeners;
    private FrameListener[] frameListeners;
    private ScanlinePoint[] scanlinePoints;
    private ActivateListener[] activateListeners;
    private DeactivateListener[] deactivateListeners;
    private SpriteZeroListener[] spriteZeroListeners;
    private StopListener[] stopListeners;
    private ScanlineCyclePoint[][][] scanlineCyclePoints;
    private StatusListener[] statusListeners;
    private final BufferedImage image = new BufferedImage(256, 240, 2);
    private final Graphics2D g = this.image.createGraphics();
    private final int[] pixels = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    private boolean pixelsModified;
    private boolean disposed;
    private int requestColor = 32;
    private int buttons;
    private int buttonsAND = -1;
    private int buttonsOR;
    private volatile MachineRunner _machineRunner;
    private volatile CPU _cpu;
    private volatile PPU _ppu;
    private volatile Mapper _mapper;
    private volatile int[] screen;
    private volatile boolean stopped = true;

    public static void setLocalAPI(LocalAPI localAPI) {
        LocalAPI.localAPI = localAPI;
    }

    public static LocalAPI getLocalAPI() {
        return localAPI;
    }

    public LocalAPI() {
        for (int i = this.pixels.length - 1; i >= 0; --i) {
            this.pixels[i] = -1;
        }
    }

    @Override
    @ApiMethod(value=0, autogenerated=false)
    public void run() {
        App.setLocalAPI(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MachineRunner machineRunner;
        PPU ppu;
        LocalAPI localAPI = this;
        synchronized (localAPI) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        StopListener[] listeners = this.stopListeners;
        if (listeners != null) {
            for (int i = listeners.length - 1; i >= 0; --i) {
                listeners[i].dispose();
            }
        }
        this.g.dispose();
        App.setLocalAPI(null);
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setAccessPoints(null);
        }
        if ((ppu = this._ppu) != null) {
            ppu.clearLocalAPI();
        }
        if ((machineRunner = this._machineRunner) != null) {
            machineRunner.clearLocalAPI();
        }
    }

    public synchronized void setMachineRunner(MachineRunner machineRunner) {
        if (machineRunner == null) {
            this._machineRunner = null;
            this._cpu = null;
            this._ppu = null;
            this._mapper = null;
            this.screen = null;
        } else {
            this._machineRunner = machineRunner;
            this._cpu = machineRunner.getCPU();
            this._ppu = machineRunner.getPPU();
            this._mapper = machineRunner.getMapper();
            this._machineRunner.setLocalAPI(this);
        }
    }

    public void frameRendered(int[] screen) {
        block6: {
            this.screen = screen;
            FrameListener[] listeners = this.frameListeners;
            if (listeners != null) {
                for (int i = listeners.length - 1; i >= 0; --i) {
                    listeners[i].frameRendered();
                }
            }
            int[] s = this.screen;
            if (!this.pixelsModified) break block6;
            this.pixelsModified = false;
            if (s == null) {
                for (int i = this.pixels.length - 1; i >= 0; --i) {
                    this.pixels[i] = -1;
                }
            } else {
                for (int i = s.length - 1; i >= 0; --i) {
                    if (this.pixels[i] == -1) continue;
                    s[i] = this.pixels[i] & 0x1FF;
                    this.pixels[i] = -1;
                }
            }
        }
    }

    public void scanlineRendered(int scanline) {
        ScanlinePoint[] points = this.scanlinePoints;
        if (points != null) {
            for (int i = points.length - 1; i >= 0; --i) {
                ScanlinePoint point = this.scanlinePoints[i];
                if (point.scanline != scanline) continue;
                point.listener.scanlineRendered(scanline);
            }
        }
    }

    public void cyclePerformed(int scanline, int scanlineCycle, int address, boolean rendering) {
        ScanlineCyclePoint[] points;
        ScanlineCyclePoint[][] row;
        ScanlineCyclePoint[][][] matrix = this.scanlineCyclePoints;
        if (matrix != null && (row = matrix[scanline + 1]) != null && (points = row[scanlineCycle]) != null) {
            for (int i = points.length - 1; i >= 0; --i) {
                points[i].listener.cyclePerformed(scanline, scanlineCycle, address, rendering);
            }
        }
    }

    public int controllersProbed(int buttons) {
        if (this.stopped) {
            PPU ppu = this._ppu;
            CPU cpu = this._cpu;
            if (ppu != null && cpu != null) {
                this.stopped = false;
                ppu.setLocalAPI(this);
                cpu.setAccessPoints(this.accessPoints);
                ActivateListener[] listeners = this.activateListeners;
                if (listeners != null) {
                    for (int i = listeners.length - 1; i >= 0; --i) {
                        listeners[i].apiEnabled();
                    }
                }
            }
        }
        this.buttons = buttons;
        ControllersListener[] listeners = this.controllersListeners;
        if (listeners != null) {
            for (int i = listeners.length - 1; i >= 0; --i) {
                listeners[i].controllersProbed();
            }
        }
        int result = this.getButtons();
        this.buttonsAND = -1;
        this.buttonsOR = 0;
        return result;
    }

    public void spriteZeroHit(int scanline, int scanlineCycle) {
        SpriteZeroListener[] listeners = this.spriteZeroListeners;
        if (listeners != null) {
            for (int i = listeners.length - 1; i >= 0; --i) {
                listeners[i].spriteZeroHit(scanline, scanlineCycle);
            }
        }
    }

    public void machineStopped() {
        this.stopped = true;
        DeactivateListener[] listeners = this.deactivateListeners;
        if (listeners != null) {
            for (int i = listeners.length - 1; i >= 0; --i) {
                listeners[i].apiDisabled();
            }
        }
    }

    public void setPalettePPU(PalettePPU palettePPU) {
        int[] map = palettePPU.getMap();
        this.updateColor(map);
        for (Sprite sprite : this.sprites.values()) {
            this.updateSpriteImage(sprite, map);
        }
    }

    private void updateSpriteImage(Sprite sprite, int[] map) {
        int[] pixels = sprite.pixels;
        int[] data = ((DataBufferInt)sprite.image.getRaster().getDataBuffer()).getData();
        for (int i = pixels.length - 1; i >= 0; --i) {
            data[i] = pixels[i] < 0 ? 0 : 0xFF000000 | 0x1C0 & pixels[i] | map[0x3F & pixels[i]];
        }
    }

    private void updateColor(int[] map) {
        this.g.setColor(new Color(0xFF000000 | 0x1C0 & this.requestColor | map[0x3F & this.requestColor]));
    }

    private int getZapperShift() {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return 8;
        }
        ZapperMapper zapper = (ZapperMapper)mapper.getDeviceMapper(4);
        return zapper == null ? 8 : zapper.getShift();
    }

    private int getButtons() {
        return this.buttons & this.buttonsAND | this.buttonsOR;
    }

    @Override
    @ApiMethod(value=1, autogenerated=false)
    public void addActivateListener(ActivateListener listener) {
        if (listener != null) {
            this.activateListeners = CollectionsUtil.addElement(ActivateListener.class, this.activateListeners, listener);
        }
    }

    @Override
    @ApiMethod(value=2, autogenerated=false)
    public void removeActivateListener(ActivateListener listener) {
        this.activateListeners = CollectionsUtil.removeAllElements(ActivateListener.class, this.activateListeners, listener);
    }

    @Override
    @ApiMethod(value=3, autogenerated=false)
    public void addDeactivateListener(DeactivateListener listener) {
        if (listener != null) {
            this.deactivateListeners = CollectionsUtil.addElement(DeactivateListener.class, this.deactivateListeners, listener);
        }
    }

    @Override
    @ApiMethod(value=4, autogenerated=false)
    public void removeDeactivateListener(DeactivateListener listener) {
        this.deactivateListeners = CollectionsUtil.removeAllElements(DeactivateListener.class, this.deactivateListeners, listener);
    }

    @Override
    @ApiMethod(value=5, autogenerated=false)
    public void addStopListener(StopListener listener) {
        if (listener != null) {
            this.stopListeners = CollectionsUtil.addElement(StopListener.class, this.stopListeners, listener);
        }
    }

    @Override
    @ApiMethod(value=6, autogenerated=false)
    public void removeStopListener(StopListener listener) {
        this.stopListeners = CollectionsUtil.removeAllElements(StopListener.class, this.stopListeners, listener);
    }

    @Override
    @ApiMethod(value=7, autogenerated=false)
    public void addAccessPointListener(AccessPointListener listener, int accessPointType, int address) {
        this.addAccessPointListener(listener, accessPointType, address, -1, -1);
    }

    @Override
    @ApiMethod(value=8, autogenerated=false)
    public void addAccessPointListener(AccessPointListener listener, int accessPointType, int minAddress, int maxAddress) {
        this.addAccessPointListener(listener, accessPointType, minAddress, maxAddress, -1);
    }

    @Override
    @ApiMethod(value=9, autogenerated=false)
    public void addAccessPointListener(AccessPointListener listener, int accessPointType, int minAddress, int maxAddress, int bank) {
        if (listener != null) {
            this.accessPoints = CollectionsUtil.addElement(AccessPoint.class, this.accessPoints, new AccessPoint(listener, accessPointType, minAddress, maxAddress, bank));
            CPU cpu = this._cpu;
            if (cpu != null) {
                cpu.setAccessPoints(this.accessPoints);
            }
        }
    }

    @Override
    @ApiMethod(value=10, autogenerated=false)
    public void removeAccessPointListener(AccessPointListener listener) {
        this.accessPoints = CollectionsUtil.removeAll(AccessPoint.class, this.accessPoints, a -> a.listener == listener);
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setAccessPoints(this.accessPoints);
        }
    }

    @Override
    @ApiMethod(value=11, autogenerated=false)
    public void addControllersListener(ControllersListener listener) {
        if (listener != null) {
            this.controllersListeners = CollectionsUtil.addElement(ControllersListener.class, this.controllersListeners, listener);
        }
    }

    @Override
    @ApiMethod(value=12, autogenerated=false)
    public void removeControllersListener(ControllersListener listener) {
        this.controllersListeners = CollectionsUtil.removeAllElements(ControllersListener.class, this.controllersListeners, listener);
    }

    @Override
    @ApiMethod(value=13, autogenerated=false)
    public void addFrameListener(FrameListener listener) {
        if (listener != null) {
            this.frameListeners = CollectionsUtil.addElement(FrameListener.class, this.frameListeners, listener);
        }
    }

    @Override
    @ApiMethod(value=14, autogenerated=false)
    public void removeFrameListener(FrameListener listener) {
        this.frameListeners = CollectionsUtil.removeAllElements(FrameListener.class, this.frameListeners, listener);
    }

    @Override
    @ApiMethod(value=15, autogenerated=false)
    public void addScanlineListener(ScanlineListener listener, int scanline) {
        if (listener != null || scanline < -1 || scanline >= TVSystem.PAL.getScanlineCount() - 1) {
            this.scanlinePoints = CollectionsUtil.addElement(ScanlinePoint.class, this.scanlinePoints, new ScanlinePoint(listener, scanline));
        }
    }

    @Override
    @ApiMethod(value=16, autogenerated=false)
    public void removeScanlineListener(ScanlineListener listener) {
        this.scanlinePoints = CollectionsUtil.removeAll(ScanlinePoint.class, this.scanlinePoints, s -> s.listener == listener);
    }

    @Override
    @ApiMethod(value=17, autogenerated=false)
    public void addScanlineCycleListener(ScanlineCycleListener listener, int scanline, int scanlineCycle) {
        int sl;
        if (listener == null || scanline < -1 || scanline >= TVSystem.PAL.getScanlineCount() - 1 || scanlineCycle < 0 || scanlineCycle > 340) {
            return;
        }
        if (this.scanlineCyclePoints == null) {
            this.scanlineCyclePoints = new ScanlineCyclePoint[TVSystem.PAL.getScanlineCount()][][];
        }
        if (this.scanlineCyclePoints[sl = scanline + 1] == null) {
            this.scanlineCyclePoints[sl] = new ScanlineCyclePoint[341][];
        }
        this.scanlineCyclePoints[sl][scanlineCycle] = CollectionsUtil.addElement(ScanlineCyclePoint.class, this.scanlineCyclePoints[sl][scanlineCycle], new ScanlineCyclePoint(listener, scanline, scanlineCycle));
    }

    @Override
    @ApiMethod(value=18, autogenerated=false)
    public void removeScanlineCycleListener(ScanlineCycleListener listener) {
        if (this.scanlineCyclePoints == null) {
            return;
        }
        boolean allRowsEmpty = true;
        for (int i = TVSystem.PAL.getScanlineCount() - 1; i >= 0; --i) {
            if (this.scanlineCyclePoints[i] != null) {
                ScanlineCyclePoint[][] row = this.scanlineCyclePoints[i];
                boolean rowEmpty = true;
                for (int j = 340; j >= 0; --j) {
                    if (row[j] != null) {
                        row[j] = CollectionsUtil.removeAll(ScanlineCyclePoint.class, row[j], s -> s.listener == listener);
                    }
                    if (row[j] == null) continue;
                    rowEmpty = false;
                }
                if (rowEmpty) {
                    this.scanlineCyclePoints[i] = null;
                }
            }
            if (this.scanlineCyclePoints[i] == null) continue;
            allRowsEmpty = false;
        }
        if (allRowsEmpty) {
            this.scanlineCyclePoints = null;
        }
    }

    @Override
    @ApiMethod(value=19, autogenerated=false)
    public void addSpriteZeroListener(SpriteZeroListener listener) {
        if (listener != null) {
            this.spriteZeroListeners = CollectionsUtil.addElement(SpriteZeroListener.class, this.spriteZeroListeners, listener);
        }
    }

    @Override
    @ApiMethod(value=20, autogenerated=false)
    public void removeSpriteZeroListener(SpriteZeroListener listener) {
        this.spriteZeroListeners = CollectionsUtil.removeAllElements(SpriteZeroListener.class, this.spriteZeroListeners, listener);
    }

    @Override
    @ApiMethod(value=21, autogenerated=false)
    public void addStatusListener(StatusListener listener) {
        if (listener != null) {
            this.statusListeners = CollectionsUtil.addElement(StatusListener.class, this.statusListeners, listener);
        }
    }

    @Override
    @ApiMethod(value=22, autogenerated=false)
    public void removeStatusListener(StatusListener listener) {
        this.statusListeners = CollectionsUtil.removeAllElements(StatusListener.class, this.statusListeners, listener);
    }

    @Override
    @ApiMethod(value=23)
    public void setPaused(boolean paused) {
        App.setStepPause(paused);
    }

    @Override
    @ApiMethod(value=24)
    public boolean isPaused() {
        MachineRunner runner = App.getMachineRunner();
        if (runner == null) {
            return false;
        }
        return runner.isPaused();
    }

    @Override
    @ApiMethod(value=25)
    public int getFrameCount() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getFrameCounter();
    }

    @Override
    @ApiMethod(value=26)
    public int getA() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return -1;
        }
        return cpu.getA();
    }

    @Override
    @ApiMethod(value=27)
    public void setA(int A) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setA(A);
        }
    }

    @Override
    @ApiMethod(value=28)
    public int getS() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return -1;
        }
        return cpu.getS();
    }

    @Override
    @ApiMethod(value=29)
    public void setS(int S) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setS(S);
        }
    }

    @Override
    @ApiMethod(value=30)
    public int getPC() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return -1;
        }
        return cpu.getPC();
    }

    @Override
    @ApiMethod(value=31)
    public void setPC(int PC) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setPC(PC);
        }
    }

    @Override
    @ApiMethod(value=32)
    public int getX() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return -1;
        }
        return cpu.getX();
    }

    @Override
    @ApiMethod(value=33)
    public void setX(int X) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setX(X);
        }
    }

    @Override
    @ApiMethod(value=34)
    public int getY() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return -1;
        }
        return cpu.getY();
    }

    @Override
    @ApiMethod(value=35)
    public void setY(int Y) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setY(Y);
        }
    }

    @Override
    @ApiMethod(value=36)
    public int getP() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return -1;
        }
        return cpu.getP();
    }

    @Override
    @ApiMethod(value=37)
    public void setP(int P) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setP(P);
        }
    }

    @Override
    @ApiMethod(value=38)
    public boolean isN() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return false;
        }
        return BitUtil.toBitBool(cpu.getN());
    }

    @Override
    @ApiMethod(value=39)
    public void setN(boolean N) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setN(BitUtil.toBit(N));
        }
    }

    @Override
    @ApiMethod(value=40)
    public boolean isV() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return false;
        }
        return BitUtil.toBitBool(cpu.getV());
    }

    @Override
    @ApiMethod(value=41)
    public void setV(boolean V) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setV(BitUtil.toBit(V));
        }
    }

    @Override
    @ApiMethod(value=42)
    public boolean isD() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return false;
        }
        return BitUtil.toBitBool(cpu.getD());
    }

    @Override
    @ApiMethod(value=43)
    public void setD(boolean D) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setD(BitUtil.toBit(D));
        }
    }

    @Override
    @ApiMethod(value=44)
    public boolean isI() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return false;
        }
        return BitUtil.toBitBool(cpu.getI());
    }

    @Override
    @ApiMethod(value=45)
    public void setI(boolean I) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setI(BitUtil.toBit(I));
        }
    }

    @Override
    @ApiMethod(value=46)
    public boolean isZ() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return false;
        }
        return BitUtil.toBitBool(cpu.getZ());
    }

    @Override
    @ApiMethod(value=47)
    public void setZ(boolean Z) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setZ(BitUtil.toBit(Z));
        }
    }

    @Override
    @ApiMethod(value=48)
    public boolean isC() {
        CPU cpu = this._cpu;
        if (cpu == null) {
            return false;
        }
        return BitUtil.toBitBool(cpu.getC());
    }

    @Override
    @ApiMethod(value=49)
    public void setC(boolean C) {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setC(BitUtil.toBit(C));
        }
    }

    @Override
    @ApiMethod(value=50)
    public int getPPUv() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getV();
    }

    @Override
    @ApiMethod(value=51)
    public void setPPUv(int v) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setV(v);
        }
    }

    @Override
    @ApiMethod(value=52)
    public int getPPUt() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getT();
    }

    @Override
    @ApiMethod(value=53)
    public void setPPUt(int t) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setT(t);
        }
    }

    @Override
    @ApiMethod(value=54)
    public int getPPUx() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getX();
    }

    @Override
    @ApiMethod(value=55)
    public void setPPUx(int x) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setX(x);
        }
    }

    @Override
    @ApiMethod(value=56)
    public boolean isPPUw() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return false;
        }
        return ppu.isW();
    }

    @Override
    @ApiMethod(value=57)
    public void setPPUw(boolean w) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setW(w);
        }
    }

    @Override
    @ApiMethod(value=58)
    public int getCameraX() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getScrollX();
    }

    @Override
    @ApiMethod(value=59)
    public void setCameraX(int scrollX) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setScrollX(scrollX);
        }
    }

    @Override
    @ApiMethod(value=60)
    public int getCameraY() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getScrollY();
    }

    @Override
    @ApiMethod(value=61)
    public void setCameraY(int scrollY) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setScrollY(scrollY);
        }
    }

    @Override
    @ApiMethod(value=62)
    public int getScanline() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getScanline();
    }

    @Override
    @ApiMethod(value=63)
    public int getDot() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getScanlineCycle();
    }

    @Override
    @ApiMethod(value=64)
    public boolean isSpriteZeroHit() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return false;
        }
        return ppu.isSprite0Hit();
    }

    @Override
    @ApiMethod(value=65)
    public void setSpriteZeroHit(boolean sprite0Hit) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setSprite0Hit(sprite0Hit);
        }
    }

    @Override
    @ApiMethod(value=66)
    public int getScanlineCount() {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getScanlineCount();
    }

    @Override
    @ApiMethod(value=67)
    public void requestInterrupt() {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setMapperIrq(true);
        }
    }

    @Override
    @ApiMethod(value=68)
    public void acknowledgeInterrupt() {
        CPU cpu = this._cpu;
        if (cpu != null) {
            cpu.setMapperIrq(false);
        }
    }

    @Override
    @ApiMethod(value=69)
    public int peekCPU(int address) {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return -1;
        }
        return mapper.peekCpuMemory(address);
    }

    @Override
    @ApiMethod(value=70)
    public int readCPU(int address) {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return -1;
        }
        return mapper.readCpuMemory(address);
    }

    @Override
    @ApiMethod(value=71)
    public void writeCPU(int address, int value) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            mapper.writeCpuMemory(address, value);
        }
    }

    @Override
    @ApiMethod(value=72)
    public int peekCPU16(int address) {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return -1;
        }
        int b0 = mapper.peekCpuMemory(address);
        int b1 = mapper.peekCpuMemory(address + 1);
        return b1 << 8 | b0;
    }

    @Override
    @ApiMethod(value=73)
    public int readCPU16(int address) {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return -1;
        }
        int b0 = mapper.readCpuMemory(address);
        int b1 = mapper.readCpuMemory(address + 1);
        return b1 << 8 | b0;
    }

    @Override
    @ApiMethod(value=74)
    public void writeCPU16(int address, int value) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            mapper.writeCpuMemory(address, value & 0xFF);
            mapper.writeCpuMemory(address + 1, value >> 8 & 0xFF);
        }
    }

    @Override
    @ApiMethod(value=75)
    public int peekCPU32(int address) {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return -1;
        }
        int b0 = mapper.peekCpuMemory(address);
        int b1 = mapper.peekCpuMemory(address + 1);
        int b2 = mapper.peekCpuMemory(address + 2);
        int b3 = mapper.peekCpuMemory(address + 3);
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    @Override
    @ApiMethod(value=76)
    public int readCPU32(int address) {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return -1;
        }
        int b0 = mapper.readCpuMemory(address);
        int b1 = mapper.readCpuMemory(address + 1);
        int b2 = mapper.readCpuMemory(address + 2);
        int b3 = mapper.readCpuMemory(address + 3);
        return b3 << 24 | b2 << 16 | b1 << 8 | b0;
    }

    @Override
    @ApiMethod(value=77)
    public void writeCPU32(int address, int value) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            mapper.writeCpuMemory(address, value & 0xFF);
            mapper.writeCpuMemory(address + 1, value >> 8 & 0xFF);
            mapper.writeCpuMemory(address + 2, value >> 16 & 0xFF);
            mapper.writeCpuMemory(address + 3, value >> 24 & 0xFF);
        }
    }

    @Override
    @ApiMethod(value=78)
    public int readPPU(int address) {
        Mapper mapper = this._mapper;
        if (mapper == null) {
            return -1;
        }
        return mapper.readVRAM(mapper.maskVRAMAddress(address));
    }

    @Override
    @ApiMethod(value=79)
    public void writePPU(int address, int value) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            mapper.writeVRAM(mapper.maskVRAMAddress(address), value);
        }
    }

    @Override
    @ApiMethod(value=80)
    public int readPaletteRAM(int address) {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getPaletteRamValue(address);
    }

    @Override
    @ApiMethod(value=81)
    public void writePaletteRAM(int address, int value) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.setPaletteRamValue(address, value);
        }
    }

    @Override
    @ApiMethod(value=82)
    public int readOAM(int address) {
        PPU ppu = this._ppu;
        if (ppu == null) {
            return -1;
        }
        return ppu.getOAM()[address & 0xFF];
    }

    @Override
    @ApiMethod(value=83)
    public void writeOAM(int address, int value) {
        PPU ppu = this._ppu;
        if (ppu != null) {
            ppu.getOAM()[address & 0xFF] = value;
        }
    }

    @Override
    @ApiMethod(value=84)
    public boolean readGamepad(int gamepad, int button) {
        return BitUtil.getBitBool(this.getButtons(), (gamepad & 3) << 3 | button & 7);
    }

    @Override
    @ApiMethod(value=85)
    public void writeGamepad(int gamepad, int button, boolean value) {
        int bit = (gamepad & 3) << 3 | button & 7;
        this.buttonsAND = BitUtil.resetBit(this.buttonsAND, bit);
        this.buttonsOR = BitUtil.setBit(this.buttonsOR, bit, value);
    }

    @Override
    @ApiMethod(value=86)
    public boolean isZapperTrigger() {
        return BitUtil.getBitBool(this.getButtons(), this.getZapperShift() + 2);
    }

    @Override
    @ApiMethod(value=87)
    public void setZapperTrigger(boolean zapperTrigger) {
        int bit = this.getZapperShift() + 2;
        this.buttonsAND = BitUtil.resetBit(this.buttonsAND, bit);
        this.buttonsOR = BitUtil.setBit(this.buttonsOR, bit, zapperTrigger);
    }

    @Override
    @ApiMethod(value=88)
    public int getZapperX() {
        int bs = this.getButtons();
        if ((bs & 0xFFFF0000) == -65536) {
            return -1;
        }
        return bs >> 16 & 0xFF;
    }

    @Override
    @ApiMethod(value=89)
    public void setZapperX(int x) {
        if (x < 0 || x > 255) {
            this.buttonsAND &= 0xFFFF;
            this.buttonsOR = 0xFFFF0000 | this.buttonsOR & 0xFFFF;
        } else {
            this.buttonsAND &= 0xFF00FFFF;
            this.buttonsOR = x << 16 | this.buttonsOR & 0xFF00FFFF;
        }
    }

    @Override
    @ApiMethod(value=90)
    public int getZapperY() {
        int bs = this.getButtons();
        if ((bs & 0xFFFF0000) == -65536) {
            return -1;
        }
        return bs >> 24 & 0xFF;
    }

    @Override
    @ApiMethod(value=91)
    public void setZapperY(int y) {
        if (y < 0 || y > 239) {
            this.buttonsAND &= 0xFFFF;
            this.buttonsOR = 0xFFFF0000 | this.buttonsOR & 0xFFFF;
        } else {
            this.buttonsAND &= 0xFFFFFF;
            this.buttonsOR = y << 24 | this.buttonsOR & 0xFFFFFF;
        }
    }

    @Override
    @ApiMethod(value=92)
    public void setColor(int color) {
        this.requestColor = color;
        this.updateColor(PaletteUtil.getPalettePPU().getMap());
    }

    @Override
    @ApiMethod(value=93)
    public int getColor() {
        return this.requestColor;
    }

    @Override
    @ApiMethod(value=94)
    public void setClip(int x, int y, int width, int height) {
        this.g.setClip(x, y, width, height);
    }

    @Override
    @ApiMethod(value=95)
    public void clipRect(int x, int y, int width, int height) {
        this.g.clipRect(x, y, width, height);
    }

    @Override
    @ApiMethod(value=96)
    public void resetClip() {
        this.g.setClip(null);
    }

    @Override
    @ApiMethod(value=97)
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.pixelsModified = true;
        this.g.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    @ApiMethod(value=98)
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.pixelsModified = true;
        this.g.drawLine(x1, y1, x2, y2);
    }

    @Override
    @ApiMethod(value=99)
    public void drawOval(int x, int y, int width, int height) {
        this.pixelsModified = true;
        this.g.drawOval(x, y, width, height);
    }

    @Override
    @ApiMethod(value=100)
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.pixelsModified = true;
        this.g.drawPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    @ApiMethod(value=101)
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.pixelsModified = true;
        this.g.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    @ApiMethod(value=102)
    public void drawRect(int x, int y, int width, int height) {
        this.pixelsModified = true;
        this.g.drawRect(x, y, width, height);
    }

    @Override
    @ApiMethod(value=103)
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.pixelsModified = true;
        this.g.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    @ApiMethod(value=104)
    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.pixelsModified = true;
        this.g.draw3DRect(x, y, width, height, raised);
    }

    @Override
    @ApiMethod(value=105)
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.pixelsModified = true;
        this.g.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    @ApiMethod(value=106)
    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.pixelsModified = true;
        this.g.fill3DRect(x, y, width, height, raised);
    }

    @Override
    @ApiMethod(value=107)
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.pixelsModified = true;
        this.g.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    @Override
    @ApiMethod(value=108)
    public void fillOval(int x, int y, int width, int height) {
        this.pixelsModified = true;
        this.g.fillOval(x, y, width, height);
    }

    @Override
    @ApiMethod(value=109)
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.pixelsModified = true;
        this.g.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    @ApiMethod(value=110)
    public void fillRect(int x, int y, int width, int height) {
        this.pixelsModified = true;
        this.g.fillRect(x, y, width, height);
    }

    @Override
    @ApiMethod(value=111)
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.pixelsModified = true;
        this.g.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    @ApiMethod(value=112)
    public void drawChar(char c, int x, int y) {
        this.pixelsModified = true;
        FontUtil.setColor(this.requestColor);
        FontUtil.drawChar(this.g, c, x, y);
    }

    @Override
    @ApiMethod(value=113)
    public void drawChars(char[] data, int offset, int length, int x, int y, boolean monospaced) {
        this.pixelsModified = true;
        FontUtil.setColor(this.requestColor);
        FontUtil.drawChars(this.g, data, offset, length, x, y, monospaced);
    }

    @Override
    @ApiMethod(value=114)
    public void drawString(String str, int x, int y, boolean monospaced) {
        this.pixelsModified = true;
        FontUtil.setColor(this.requestColor);
        FontUtil.drawString(this.g, str, x, y, monospaced);
    }

    @Override
    @ApiMethod(value=115)
    public void createSprite(int id, int width, int height, int[] pixels) {
        if (pixels == null || width <= 0 || height <= 0) {
            return;
        }
        int length = width * height;
        if (pixels.length != length) {
            int[] ps = new int[length];
            System.arraycopy(pixels, 0, ps, 0, Math.min(pixels.length, length));
            pixels = ps;
        }
        Sprite sprite = new Sprite();
        sprite.pixels = pixels;
        sprite.image = new BufferedImage(width, height, 2);
        this.updateSpriteImage(sprite, PaletteUtil.getPalettePPU().getMap());
        this.sprites.put(id, sprite);
    }

    @Override
    @ApiMethod(value=116)
    public void drawSprite(int id, int x, int y) {
        BufferedImage image = this.sprites.get((Object)Integer.valueOf((int)id)).image;
        if (image == null) {
            return;
        }
        this.pixelsModified = true;
        this.g.drawImage((Image)image, x, y, null);
    }

    @Override
    @ApiMethod(value=117)
    public void setPixel(int x, int y, int color) {
        if (x < 0 || y < 0 || x >= 256 || y >= 240 || color < 0) {
            return;
        }
        this.pixelsModified = true;
        this.pixels[y << 8 | x] = 0x1FF & color;
    }

    @Override
    @ApiMethod(value=118)
    public int getPixel(int x, int y) {
        int value;
        if (x < 0 || y < 0 || x >= 256 || y >= 240) {
            return -1;
        }
        int index = y << 8 | x;
        if (this.pixelsModified && (value = this.pixels[index]) != 0) {
            return value;
        }
        int[] s = this.screen;
        if (s == null) {
            return -1;
        }
        return 0x1FF & this.screen[index];
    }

    @Override
    @ApiMethod(value=119, autogenerated=false)
    public void getPixels(int[] pixels) {
        if (pixels == null) {
            return;
        }
        int[] s = this.screen;
        if (s == null) {
            return;
        }
        System.arraycopy(s, 0, pixels, 0, Math.min(s.length, pixels.length));
    }

    public int[] getScreen() {
        return this.screen;
    }

    @Override
    @ApiMethod(value=120)
    public void powerCycle() {
        App.powerCycle();
    }

    @Override
    @ApiMethod(value=121)
    public void reset() {
        App.reset();
    }

    @Override
    @ApiMethod(value=122)
    public void deleteSprite(int id) {
        this.sprites.remove(id);
    }

    @Override
    @ApiMethod(value=123)
    public void setSpeed(int percent) {
        App.setSpeed(percent);
    }

    @Override
    @ApiMethod(value=124)
    public void stepToNextFrame() {
        App.step(PauseStepType.Frame);
    }

    @Override
    @ApiMethod(value=125)
    public void showMessage(String message) {
        App.showMessage(message);
    }

    @Override
    @ApiMethod(value=126)
    public String getWorkingDirectory() {
        return FileUtil.getWorkingDirectory();
    }

    @Override
    @ApiMethod(value=127)
    public String getContentDirectory() {
        return AppPrefs.getInstance().getPaths().getContentDirectory();
    }

    @Override
    @ApiMethod(value=128)
    public void open(String fileName) {
        App.getImageFrame().open(new FilePath(fileName));
    }

    @Override
    @ApiMethod(value=129)
    public void openArchiveEntry(String archiveFileName, String entryFileName) {
        App.getImageFrame().open(new FilePath(entryFileName, archiveFileName));
    }

    @Override
    @ApiMethod(value=130)
    public String[] getArchiveEntries(String archiveFileName) {
        List<String> entries = null;
        try {
            entries = ArchiveEntry.toNames(FileUtil.getArchiveEntries(archiveFileName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (entries == null) {
            return new String[0];
        }
        return entries.toArray(new String[entries.size()]);
    }

    @Override
    @ApiMethod(value=131)
    public String getDefaultArchiveEntry(String archiveFileName) {
        List<String> entries = null;
        try {
            entries = ArchiveEntry.toNames(FileUtil.getArchiveEntries(archiveFileName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (CollectionsUtil.isBlank(entries)) {
            return "";
        }
        int index = FileUtil.getDefaultArchiveEntry(archiveFileName, entries);
        if (index < 0) {
            return "";
        }
        return entries.get(index);
    }

    @Override
    @ApiMethod(value=132)
    public void openDefaultArchiveEntry(String archiveFileName) {
        String entryFileName = this.getDefaultArchiveEntry(archiveFileName);
        if (!StringUtil.isBlank(entryFileName)) {
            this.openArchiveEntry(archiveFileName, entryFileName);
        }
    }

    @Override
    @ApiMethod(value=133)
    public void close() {
        App.close();
    }

    @Override
    @ApiMethod(value=134)
    public void saveState(String stateFileName) {
        EventQueue.invokeLater(() -> App.getImageFrame().saveState(new File(stateFileName)));
    }

    @Override
    @ApiMethod(value=135)
    public void loadState(String stateFileName) {
        EventQueue.invokeLater(() -> App.getImageFrame().loadState(new File(stateFileName)));
    }

    @Override
    @ApiMethod(value=136)
    public void quickSaveState(int slot) {
        if (slot >= 0 && slot <= 9) {
            EventQueue.invokeLater(() -> App.getImageFrame().quickSaveState(slot));
        }
    }

    @Override
    @ApiMethod(value=137)
    public void quickLoadState(int slot) {
        if (slot >= 0 && slot <= 9) {
            EventQueue.invokeLater(() -> App.getImageFrame().quickLoadState(slot));
        }
    }

    @Override
    @ApiMethod(value=138)
    public void setTVSystem(String tvSystem) {
        switch (tvSystem.toUpperCase(Locale.ENGLISH)) {
            case "NTSC": {
                InputUtil.addOtherInput(new SetTVSystem(TVSystem.NTSC));
                break;
            }
            case "PAL": {
                InputUtil.addOtherInput(new SetTVSystem(TVSystem.PAL));
                break;
            }
            case "DENDY": {
                InputUtil.addOtherInput(new SetTVSystem(TVSystem.Dendy));
            }
        }
    }

    @Override
    @ApiMethod(value=139)
    public String getTVSystem() {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            switch (mapper.getTVSystem()) {
                case NTSC: {
                    return "NTSC";
                }
                case PAL: {
                    return "PAL";
                }
                case Dendy: {
                    return "Dendy";
                }
            }
        }
        return "NTSC";
    }

    @Override
    @ApiMethod(value=140)
    public int getDiskSides() {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            return mapper.getDiskSideCount();
        }
        return 0;
    }

    @Override
    @ApiMethod(value=141)
    public void insertDisk(int disk, int side) {
        int index;
        if (side >= 0 && side <= 1 && (index = disk << 1 | side) < this.getDiskSides()) {
            InputUtil.addOtherInput(new SetDiskSide(index));
        }
    }

    @Override
    @ApiMethod(value=142)
    public void flipDiskSide() {
        InputUtil.addOtherInput(new FlipDiskSide());
    }

    @Override
    @ApiMethod(value=143)
    public void ejectDisk() {
        InputUtil.addOtherInput(new EjectDisk());
    }

    @Override
    @ApiMethod(value=144)
    public void insertCoin() {
        InputUtil.addOtherInput(new InsertCoin(0, 0));
    }

    @Override
    @ApiMethod(value=145)
    public void pressServiceButton() {
        InputUtil.addOtherInput(new PressServiceButton(0));
    }

    @Override
    @ApiMethod(value=146)
    public void screamIntoMicrophone() {
        InputUtil.addOtherInput(new ScreamIntoMicrophone());
    }

    @Override
    @ApiMethod(value=147)
    public void glitch() {
        InputUtil.addOtherInput(new Glitch());
    }

    @Override
    @ApiMethod(value=148)
    public String getFileInfo() {
        String fileInfo = App.getImageFrame().getFileInfo();
        if (fileInfo == null) {
            return "";
        }
        return fileInfo;
    }

    @Override
    @ApiMethod(value=149)
    public void setFullscreenMode(boolean fullscreenMode) {
        EventQueue.invokeLater(() -> App.getImageFrame().setFullscreenMode(fullscreenMode));
    }

    @Override
    @ApiMethod(value=150)
    public void saveScreenshot() {
        App.getImageFrame().getImagePane().requestScreenshot();
    }

    @Override
    @ApiMethod(value=151)
    public void addCheat(int address, int value, int compare, String description, boolean enabled) {
        Cheat cheat = new Cheat(address, value, compare);
        cheat.setDescription(description);
        cheat.setEnabled(enabled);
        GameCheats.addCheat(cheat, true);
        GameCheats.save();
        GameCheats.updateMachine();
    }

    @Override
    @ApiMethod(value=152)
    public void removeCheat(int address, int value, int compare) {
        if (GameCheats.removeCheat(new Cheat(address, value, compare))) {
            GameCheats.save();
            GameCheats.updateMachine();
        }
    }

    @Override
    @ApiMethod(value=153)
    public void addGameGenie(String gameGenieCode, String description, boolean enabled) {
        Cheat cheat = GameGenie.convert(gameGenieCode);
        if (cheat != null) {
            cheat.setDescription(description);
            cheat.setEnabled(enabled);
            GameCheats.addCheat(cheat, true);
            GameCheats.save();
            GameCheats.updateMachine();
        }
    }

    @Override
    @ApiMethod(value=154)
    public void removeGameGenie(String gameGenieCode) {
        Cheat cheat = GameGenie.convert(gameGenieCode);
        if (cheat != null && GameCheats.removeCheat(cheat)) {
            GameCheats.save();
            GameCheats.updateMachine();
        }
    }

    @Override
    @ApiMethod(value=155)
    public void addProActionRocky(String proActionRockyCode, String description, boolean enabled) {
        Cheat cheat = ProActionRocky.convert(proActionRockyCode);
        if (cheat != null) {
            cheat.setDescription(description);
            cheat.setEnabled(enabled);
            GameCheats.addCheat(cheat, true);
            GameCheats.save();
            GameCheats.updateMachine();
        }
    }

    @Override
    @ApiMethod(value=156)
    public void removeProActionRocky(String proActionRockyCode) {
        Cheat cheat = ProActionRocky.convert(proActionRockyCode);
        if (cheat != null && GameCheats.removeCheat(cheat)) {
            GameCheats.save();
            GameCheats.updateMachine();
        }
    }

    @Override
    @ApiMethod(value=157)
    public int getPrgRomSize() {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            return mapper.getPrgRomLength();
        }
        return 0;
    }

    @Override
    @ApiMethod(value=158)
    public int readPrgRom(int index) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            return mapper.readPrgRom(index);
        }
        return -1;
    }

    @Override
    @ApiMethod(value=159)
    public void writePrgRom(int index, int value) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            mapper.writePrgRom(index, value & 0xFF);
        }
    }

    @Override
    @ApiMethod(value=160)
    public int getChrRomSize() {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            return mapper.getChrRomLength();
        }
        return 0;
    }

    @Override
    @ApiMethod(value=161)
    public int readChrRom(int index) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            return mapper.readChrRom(index);
        }
        return -1;
    }

    @Override
    @ApiMethod(value=162)
    public void writeChrRom(int index, int value) {
        Mapper mapper = this._mapper;
        if (mapper != null) {
            mapper.writeChrRom(index, value & 0xFF);
        }
    }

    @Override
    @ApiMethod(value=163)
    public int getStringWidth(String str, boolean monospaced) {
        return FontUtil.getWidth(str, monospaced);
    }

    @Override
    @ApiMethod(value=164)
    public int getCharsWidth(char[] chars, boolean monospaced) {
        return FontUtil.getWidth(chars, monospaced);
    }
}

