/*
 * Decompiled with CFR 0.152.
 */
package nintaco.api.server;

import java.net.ServerSocket;
import java.net.Socket;
import nintaco.App;
import nintaco.api.server.LocalProxy;
import nintaco.gui.api.server.ProgramServerFrame;
import nintaco.gui.api.server.ProgramServerPrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.ThreadUtil;

public class ProgramServer {
    private static final String NAME = "[Server]";
    private static final long DELAY_MILLIS = 1000L;
    private ProgramServerPrefs prefs;
    private Thread mainThread;
    private ServerSocket serverSocket;
    private LocalProxy proxy;
    private volatile boolean running;

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        if (this.mainThread != null) {
            this.stop();
        }
        this.mainThread = new Thread(this::run, "Program Server Thread");
        this.mainThread.start();
    }

    void addActivity(String activity, Object ... params) {
        ProgramServerFrame programFrame = App.getProgramServerFrame();
        if (programFrame != null) {
            programFrame.addActivity(activity, params);
        }
    }

    private void setServerStatus(boolean serverUp) {
        ProgramServerFrame programFrame = App.getProgramServerFrame();
        if (programFrame != null) {
            programFrame.setServerStatus(serverUp);
        }
    }

    private void run() {
        this.prefs = AppPrefs.getInstance().getProgramServerPrefs();
        try {
            this.serverSocket = new ServerSocket(this.prefs.getPort(), 50, this.prefs.getLocalIPAddress());
        }
        catch (Throwable t) {
            this.addActivity("%s Failed to start: %s", NAME, t.getMessage());
            this.setServerStatus(false);
            return;
        }
        this.addActivity("%s Started.", NAME);
        this.addActivity("%s Listening for client on port %d.", NAME, this.prefs.getPort());
        this.setServerStatus(true);
        try {
            this.running = true;
            while (this.running) {
                this.handleSocket(this.serverSocket.accept());
                ThreadUtil.sleep(1000L);
            }
        }
        catch (Throwable t) {
            this.stop();
        }
        this.addActivity("%s Stopped.", NAME);
        this.setServerStatus(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSocket(Socket socket) {
        String remoteAddress = null;
        try {
            remoteAddress = String.format("[%s]", socket.getInetAddress().getHostAddress());
            this.addActivity("%s Connected.", remoteAddress);
            this.proxy = new LocalProxy();
            this.proxy.run(socket);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this.proxy != null) {
                this.proxy.dispose();
                this.proxy = null;
            }
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
        }
        if (remoteAddress != null) {
            this.addActivity("%s Disconnected.", remoteAddress);
        }
    }

    public void stop() {
        this.running = false;
        LocalProxy localProxy = this.proxy;
        if (localProxy != null) {
            localProxy.dispose();
        }
        try {
            ServerSocket s = this.serverSocket;
            if (s != null) {
                this.serverSocket = null;
                s.close();
            }
        }
        catch (Throwable s) {
            // empty catch block
        }
        Thread t = this.mainThread;
        if (t != null) {
            this.mainThread = null;
            ThreadUtil.interrupt(t);
            ThreadUtil.join(t);
        }
    }
}

