/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.Serializable;
import nintaco.util.BitUtil;

public class EnvelopeGenerator
implements Serializable {
    private static final long serialVersionUID = 0L;
    private boolean loop;
    private boolean constantVolume;
    private int volumePeriod;
    private boolean start;
    private int divider;
    private int counter;

    public void reset() {
        this.loop = false;
        this.constantVolume = false;
        this.volumePeriod = 0;
        this.start = false;
        this.divider = 0;
        this.counter = 0;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public boolean getStart() {
        return this.start;
    }

    public void write(int value) {
        this.loop = BitUtil.getBitBool(value, 5);
        this.constantVolume = BitUtil.getBitBool(value, 4);
        this.volumePeriod = value & 0xF;
    }

    public void update() {
        if (this.start) {
            this.start = false;
            this.counter = 15;
            this.divider = this.volumePeriod;
        } else if (--this.divider < 0) {
            this.divider = this.volumePeriod;
            if (this.counter == 0) {
                if (this.loop) {
                    this.counter = 15;
                }
            } else {
                --this.counter;
            }
        }
    }

    public int getVolume() {
        if (this.constantVolume) {
            return this.volumePeriod;
        }
        return this.counter;
    }
}

