/*
 * Decompiled with CFR 0.152.
 */
package nintaco.apu;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import nintaco.apu.AudioProcessor;
import nintaco.gui.sound.SoundPrefs;
import nintaco.movie.Movie;
import nintaco.preferences.AppPrefs;
import nintaco.util.MathUtil;
import nintaco.util.StringUtil;
import nintaco.util.ThreadUtil;

public class SystemAudioProcessor
implements AudioProcessor {
    public static final double OUTPUT_SAMPLING_FREQUENCY = 48000.0;
    public static final int FLUSH_LATENCY = 5;
    public static final int LINE_BUFFER_SIZE = 131072;
    public static final AudioFormat AUDIO_FORMAT = new AudioFormat(48000.0f, 16, 1, true, true);
    private static final String[] DEFAULT_DEVICE_KEYWORDS = new String[]{"primary", "default", "main"};
    private static final ExecutorService flushExecutor = Executors.newSingleThreadExecutor();
    private static AudioFileFormat.Type[] supportedAudioFileTypes;
    private static SourceDataLine sourceDataLine;
    private static FloatControl masterGainControl;
    private static int masterVolume;
    private static byte[] buffer;
    private static byte[] flushBuffer;
    private static int bufferSize;
    private static int flushSize;
    private static int overrun;
    private static int underrun;
    private static int lineBufferSize;
    private static int bufferIndex;
    private static int lastSample;
    private static volatile Movie movie;

    public static void init() {
        AppPrefs appPrefs = AppPrefs.getInstance();
        masterVolume = appPrefs.getVolumeMixerPrefs().getMasterVolume();
        SystemAudioProcessor.applySoundPrefs(appPrefs.getSoundPrefs());
    }

    public static AudioFileFormat.Type[] getSupportedAudioFileTypes() {
        if (supportedAudioFileTypes == null) {
            byte[] byteBuffer = new byte[2 * (int)Math.round(2400.0)];
            try (AudioInputStream in = new AudioInputStream(new ByteArrayInputStream(byteBuffer), AUDIO_FORMAT, byteBuffer.length >> 1);){
                supportedAudioFileTypes = AudioSystem.getAudioFileTypes(in);
                Arrays.sort(supportedAudioFileTypes, (a, b) -> a.getExtension().compareTo(b.getExtension()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return supportedAudioFileTypes;
    }

    public static void applySoundPrefs(SoundPrefs prefs) {
        SystemAudioProcessor.disposeLine();
        String[] audioDevices = SystemAudioProcessor.getAudioDevices();
        String audioDevice = prefs.getAudioDevice();
        int deviceIndex = -1;
        if (!StringUtil.isBlank(audioDevice)) {
            deviceIndex = StringUtil.findMatch(audioDevices, audioDevice);
        }
        if (deviceIndex < 0) {
            deviceIndex = SystemAudioProcessor.getDefaultAudioDevice(audioDevices);
        }
        if (deviceIndex > 0) {
            try {
                Mixer.Info info = SystemAudioProcessor.getMixerInfo(audioDevices[deviceIndex]);
                if (info != null && (sourceDataLine = SystemAudioProcessor.getSourceDataLine(info)) != null) {
                    sourceDataLine.open(AUDIO_FORMAT, 131072);
                    masterGainControl = (FloatControl)sourceDataLine.getControl(FloatControl.Type.MASTER_GAIN);
                    SystemAudioProcessor.setMasterVolume(masterVolume);
                    sourceDataLine.start();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        lineBufferSize = sourceDataLine.getBufferSize();
        bufferSize = SystemAudioProcessor.computeBufferLength(prefs.getLatencyMillis());
        flushSize = SystemAudioProcessor.computeBufferLength(5);
        buffer = new byte[bufferSize];
        overrun = lineBufferSize - bufferSize - (flushSize << 2);
        underrun = lineBufferSize - flushSize;
        bufferIndex = 0;
        flushBuffer = new byte[flushSize];
    }

    private static int computeBufferLength(int milliseconds) {
        return (int)Math.round(48000.0 * (double)milliseconds / 1000.0) << 1;
    }

    private static void disposeLine() {
        try {
            SourceDataLine line = sourceDataLine;
            sourceDataLine = null;
            masterGainControl = null;
            if (line != null) {
                SystemAudioProcessor.flush(line, lineBufferSize, true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Mixer.Info getMixerInfo(String name) {
        for (Mixer.Info info : AudioSystem.getMixerInfo()) {
            if (!info.getName().equalsIgnoreCase(name)) continue;
            return info;
        }
        return null;
    }

    public static String[] getAudioDevices() {
        ArrayList<String> devices = new ArrayList<String>();
        devices.add("None");
        try {
            for (Mixer.Info info : AudioSystem.getMixerInfo()) {
                if (!SystemAudioProcessor.isLineAssignable(info)) continue;
                devices.add(info.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return devices.toArray(new String[devices.size()]);
    }

    public static int getDefaultAudioDevice(String[] audioDevices) {
        for (String keyword : DEFAULT_DEVICE_KEYWORDS) {
            int index = StringUtil.findContaining(audioDevices, keyword, 1, audioDevices.length - 1);
            if (index < 0) continue;
            return index;
        }
        return audioDevices.length >= 2 ? 1 : 0;
    }

    private static boolean isLineAssignable(Mixer.Info info) {
        return SystemAudioProcessor.getSourceDataLine(info) != null;
    }

    private static SourceDataLine getSourceDataLine(Mixer.Info info) {
        try {
            return (SourceDataLine)AudioSystem.getMixer(info).getLine(new DataLine.Info(SourceDataLine.class, AUDIO_FORMAT));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void setMasterVolume(int volume) {
        masterVolume = volume;
        try {
            FloatControl masterGain = masterGainControl;
            if (masterGain != null) {
                masterGain.setValue((float)MathUtil.clamp(20.0 * Math.log10((double)volume / 100.0), (double)masterGain.getMinimum(), (double)masterGain.getMaximum()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getMasterVolume() {
        return masterVolume;
    }

    public static Movie getMovie() {
        return movie;
    }

    public static void setMovie(Movie movie) {
        SystemAudioProcessor.movie = movie;
    }

    public void processOutputSamples(int[] audioSamples, int length) {
        for (int i = 0; i < length; ++i) {
            this.processOutputSample(audioSamples[i]);
        }
    }

    @Override
    public void processOutputSample(int value) {
        SourceDataLine line;
        lastSample = value;
        Movie m = movie;
        if (m != null) {
            m.getCurrentMovieFrame().processOutputSample(value);
        }
        if ((line = sourceDataLine) != null) {
            SystemAudioProcessor.buffer[SystemAudioProcessor.bufferIndex] = (byte)(value >> 8);
            SystemAudioProcessor.buffer[SystemAudioProcessor.bufferIndex + 1] = (byte)value;
            if ((bufferIndex += 2) == flushSize && line.available() < underrun || bufferIndex == bufferSize) {
                if (line.available() >= overrun) {
                    if (line.available() == lineBufferSize) {
                        float warmup = 0.0f;
                        float dw = 1.0f / (float)(bufferIndex >> 1);
                        for (int i = 0; i < bufferIndex; i += 2) {
                            int v = (int)((warmup += dw) * (float)((short)((buffer[i] & 0xFF) << 8 | buffer[i | 1] & 0xFF)));
                            SystemAudioProcessor.buffer[i] = (byte)(v >> 8);
                            SystemAudioProcessor.buffer[i | 1] = (byte)v;
                        }
                    }
                    line.write(buffer, 0, bufferIndex);
                }
                bufferIndex = 0;
            }
        }
    }

    public static void flush() {
        SystemAudioProcessor.flush(sourceDataLine, lineBufferSize, false);
    }

    private static void flush(SourceDataLine sourceDataLine, int lineBufferSize, boolean close) {
        try {
            if (sourceDataLine != null) {
                float value = lastSample;
                bufferIndex = 0;
                lastSample = 0;
                float dv = -value / (float)(flushBuffer.length >> 1);
                for (int i = 0; i < flushBuffer.length; i += 2) {
                    int v = (int)(value += dv);
                    SystemAudioProcessor.flushBuffer[i] = (byte)(v >> 8);
                    SystemAudioProcessor.flushBuffer[i | 1] = (byte)v;
                }
                sourceDataLine.write(flushBuffer, 0, flushBuffer.length);
                flushExecutor.submit(new FlushThread(sourceDataLine, lineBufferSize, close));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class FlushThread
    implements Runnable {
        private final SourceDataLine sourceDataLine;
        private final int lineBufferSize;
        private final boolean close;

        public FlushThread(SourceDataLine sourceDataLine, int lineBufferSize, boolean close) {
            this.sourceDataLine = sourceDataLine;
            this.lineBufferSize = lineBufferSize;
            this.close = close;
        }

        @Override
        public void run() {
            try {
                if (this.sourceDataLine != null && this.lineBufferSize > 0) {
                    for (int i = 0; i < 1000 && this.sourceDataLine.available() != this.lineBufferSize; ++i) {
                        ThreadUtil.sleep(1L);
                    }
                    if (this.close) {
                        this.sourceDataLine.stop();
                        this.sourceDataLine.flush();
                        this.sourceDataLine.close();
                    } else {
                        this.sourceDataLine.flush();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

