/*
 * Decompiled with CFR 0.152.
 */
package nintaco.cheats;

import java.io.Serializable;
import java.util.Objects;
import nintaco.util.StringUtil;

public final class Cheat
implements Serializable {
    private static final long serialVersionUID = 0L;
    private int address;
    private int dataValue;
    private int compareValue;
    private boolean hasCompareValue;
    private String description = "";
    private boolean enabled = true;

    public Cheat() {
    }

    public Cheat(int address, int dataValue) {
        this(address, dataValue, -1);
    }

    public Cheat(int address, int dataValue, int compareValue) {
        this.setAddress(address);
        this.setDataValue(dataValue);
        this.setCompareValue(compareValue);
    }

    public Cheat(Cheat cheat) {
        this.address = cheat.address;
        this.dataValue = cheat.dataValue;
        this.compareValue = cheat.compareValue;
        this.hasCompareValue = cheat.hasCompareValue;
        this.description = cheat.description;
        this.enabled = cheat.enabled;
    }

    public boolean equals(Object obj) {
        Cheat cheat = (Cheat)obj;
        return this.effectivelyEquals(cheat) && this.enabled == cheat.enabled && Objects.equals(this.description, cheat.description);
    }

    public boolean effectivelyEquals(Cheat cheat) {
        return this.address == cheat.address && this.dataValue == cheat.dataValue && this.hasCompareValue == cheat.hasCompareValue && (!this.hasCompareValue || this.compareValue == cheat.compareValue);
    }

    public void generateDescription() {
        this.description = this.hasCompareValue ? String.format("$%04X : %d > %d", this.address, this.compareValue, this.dataValue) : String.format("$%04X : %d", this.address, this.dataValue);
    }

    public void setAddress(int address) {
        this.address = address & 0xFFFF;
    }

    public int getAddress() {
        return this.address;
    }

    public void setDataValue(int dataValue) {
        this.dataValue = dataValue & 0xFF;
    }

    public int getDataValue() {
        return this.dataValue;
    }

    public void setCompareValue(int compareValue) {
        this.compareValue = compareValue & 0xFF;
        this.hasCompareValue = compareValue >= 0;
    }

    public int getCompareValue() {
        return this.compareValue;
    }

    public boolean hasCompareValue() {
        return this.hasCompareValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int apply(int address, int value) {
        return this.address == address && (!this.hasCompareValue || this.compareValue == value) ? this.dataValue : -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Cheat { address = %04X, data = %02X, ", this.address, this.dataValue));
        if (this.hasCompareValue) {
            sb.append(String.format("compareValue = %02X, ", this.compareValue));
        }
        sb.append(String.format("hasCompareValue = %b, enabled = %b", this.hasCompareValue, this.enabled));
        if (!StringUtil.isBlank(this.description)) {
            sb.append(", description = ").append(this.description);
        }
        sb.append(" }");
        return sb.toString();
    }
}

