/*
 * Decompiled with CFR 0.152.
 */
package nintaco.cheats;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nintaco.cartdb.CartDB;
import nintaco.cheats.CheatsDBEntry;
import nintaco.cheats.GameGenie;

public final class CheatsDB {
    private static final Map<Integer, CheatsDBEntry[]> cheats = new HashMap<Integer, CheatsDBEntry[]>();

    public static void init() {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(CartDB.class.getResourceAsStream("/nintaco/cheats/cheats-db.dat")));
            Throwable throwable = null;
            try {
                ArrayList<Integer> crcs = new ArrayList<Integer>();
                try {
                    block12: while (true) {
                        int i;
                        crcs.clear();
                        for (int i2 = in.readShort() - 1; i2 >= 0; --i2) {
                            crcs.add(in.readInt());
                        }
                        CheatsDBEntry[] entries = new CheatsDBEntry[in.readUnsignedByte()];
                        for (i = 0; i < entries.length; ++i) {
                            String description = in.readUTF();
                            String[][] codes = new String[in.readUnsignedByte()][];
                            for (int j = 0; j < codes.length; ++j) {
                                codes[j] = new String[in.readUnsignedByte()];
                                for (int k = 0; k < codes[j].length; ++k) {
                                    int address = in.readUnsignedShort();
                                    boolean hasCompareValue = address >= 32768;
                                    int dataValue = in.readUnsignedByte();
                                    int compareValue = in.readUnsignedByte();
                                    codes[j][k] = GameGenie.convert(address |= 0x8000, dataValue, compareValue, hasCompareValue);
                                }
                            }
                            entries[i] = new CheatsDBEntry(description, codes);
                        }
                        i = 0;
                        while (true) {
                            if (i >= crcs.size()) continue block12;
                            cheats.put((Integer)crcs.get(i), entries);
                            ++i;
                        }
                        break;
                    }
                }
                catch (EOFException eof) {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            in.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized CheatsDBEntry[] getCheats(int fileCRC) {
        return cheats.get(fileCRC);
    }

    private CheatsDB() {
    }
}

