/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.io.Serializable;
import java.util.Objects;
import nintaco.files.FileUtil;
import nintaco.util.StringUtil;

public class FilePath
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String archivePath;
    private final String entryPath;

    public static FilePath fromLongString(String longString) {
        int lt = longString.indexOf(60);
        if (lt < 2) {
            return new FilePath(longString);
        }
        int gt = longString.lastIndexOf(62);
        if (gt - lt < 2) {
            return null;
        }
        return new FilePath(longString.substring(lt + 1, gt).trim(), longString.substring(0, lt).trim());
    }

    public FilePath(String entryPath) {
        this(entryPath, null);
    }

    public FilePath(String entryPath, String archivePath) {
        this.entryPath = StringUtil.isBlank(archivePath) ? FileUtil.getCanonicalName(entryPath) : entryPath;
        this.archivePath = FileUtil.getCanonicalName(archivePath);
    }

    public String getOuterPath() {
        return this.archivePath == null ? this.entryPath : this.archivePath;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public String getEntryPath() {
        return this.entryPath;
    }

    public String getArchiveFileName() {
        return FileUtil.getFileName(this.archivePath);
    }

    public String getEntryFileName() {
        return FileUtil.getFileName(this.entryPath);
    }

    public boolean isArchivedEntry() {
        return !StringUtil.isBlank(this.archivePath);
    }

    public int hashCode() {
        return Objects.hashCode(this.entryPath) ^ Objects.hashCode(this.archivePath);
    }

    public boolean equals(Object obj) {
        FilePath other = (FilePath)obj;
        return Objects.equals(this.archivePath, other.archivePath) && Objects.equals(this.entryPath, other.entryPath);
    }

    public String toLongString() {
        if (this.archivePath == null) {
            return this.entryPath;
        }
        return String.format("%s <%s>", this.archivePath, this.entryPath);
    }

    public String toString() {
        if (this.archivePath == null) {
            return this.getEntryFileName();
        }
        return String.format("%s <%s>", this.getArchiveFileName(), this.getEntryFileName());
    }
}

