/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nintaco.MessageException;
import nintaco.files.FilePath;
import nintaco.files.FileUtil;
import nintaco.preferences.AppPrefs;
import nintaco.util.InvocationContainer;
import nintaco.util.StreamUtil;
import nintaco.util.StringUtil;

public final class IpsUtil {
    private static final int EOF = 4542278;

    private static IpsFile loadIpsFile(FilePath filePath) throws Throwable {
        InvocationContainer container = new InvocationContainer();
        try {
            FileUtil.getInputStream(filePath, (in, fileSize) -> container.setObject(IpsUtil.loadIpsFile(in, fileSize)));
        }
        catch (FileNotFoundException e) {
            throw new MessageException("The patch file does not exist.");
        }
        return (IpsFile)container.getObject();
    }

    private static IpsFile loadIpsFile(String fileName) throws Throwable {
        return IpsUtil.loadIpsFile(new File(fileName));
    }

    private static IpsFile loadIpsFile(File file) throws Throwable {
        return IpsUtil.loadIpsFile(new FileInputStream(file), file.length());
    }

    private static IpsFile loadIpsFile(InputStream inputStream, long fileSize) throws Throwable {
        IpsFile ipsFile = new IpsFile();
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(inputStream));){
            int[] header = new int[5];
            StreamUtil.readBytes(in, header);
            if (!StringUtil.compareStrings("PATCH", header)) {
                throw new MessageException("Invalid IPS file: Bad header.");
            }
            int index = 5;
            while (true) {
                int offset;
                if ((offset = (in.readByte() & 0xFF) << 16 | (in.readByte() & 0xFF) << 8 | in.readByte() & 0xFF) == 4542278) {
                    if ((long)index == fileSize - 6L) {
                        ipsFile.truncatedLength = (in.readByte() & 0xFF) << 16 | (in.readByte() & 0xFF) << 8 | in.readByte() & 0xFF;
                        break;
                    }
                    if ((long)index == fileSize - 3L) {
                        break;
                    }
                }
                IpsRecord record = new IpsRecord(offset);
                record.length = (in.readByte() & 0xFF) << 8 | in.readByte() & 0xFF;
                index += 5;
                if (record.length == 0) {
                    record.length = (in.readByte() & 0xFF) << 8 | in.readByte() & 0xFF;
                    record.rle = in.readByte() & 0xFF;
                    index += 3;
                } else {
                    record.data = new byte[record.length];
                    in.readFully(record.data);
                    index += record.length;
                }
                ipsFile.records.add(record);
            }
        }
        catch (EOFException e) {
            throw new MessageException("Invalid IPS file: Missing or misplaced EOF marker.");
        }
        catch (MessageException m) {
            throw m;
        }
        catch (Throwable t) {
            throw new MessageException("Failed to read patch file.");
        }
        Iterator<IpsRecord> i = ipsFile.records.iterator();
        while (i.hasNext()) {
            IpsRecord record = i.next();
            if (record.length != 0) continue;
            i.remove();
        }
        Collections.sort(ipsFile.records);
        return ipsFile;
    }

    private static byte[] loadFileData(String fileType, FilePath filePath) throws Throwable {
        return IpsUtil.loadFileData(fileType, filePath, -1);
    }

    private static byte[] loadFileData(String fileType, FilePath filePath, int minFileSize) throws Throwable {
        InvocationContainer container = new InvocationContainer();
        try {
            FileUtil.getInputStream(filePath, (in, fileSize) -> container.setObject(IpsUtil.loadFileData(fileType, in, fileSize, minFileSize)));
        }
        catch (FileNotFoundException e) {
            throw new MessageException("The %s file does not exist.", fileType);
        }
        return (byte[])container.getObject();
    }

    private static byte[] loadFileData(String fileType, InputStream in, long fileSize, int minFileSize) throws Throwable {
        if (fileSize > 0xFFFFFFL) {
            throw new MessageException("An IPS patch cannot be applied to a file larger than 16 MB.");
        }
        byte[] data = new byte[Math.max(minFileSize, (int)fileSize)];
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(in));){
            dis.readFully(data, 0, (int)fileSize);
        }
        catch (Throwable t) {
            throw new MessageException("Failed to read the %s file.", fileType);
        }
        return data;
    }

    private static int getMinFileSize(IpsFile ipsFile) {
        int minFileSize = ipsFile.truncatedLength;
        for (IpsRecord record : ipsFile.records) {
            minFileSize = Math.max(minFileSize, record.offset + record.length);
        }
        return minFileSize;
    }

    private static void applyIpsFile(IpsFile ipsFile, byte[] data) {
        for (IpsRecord record : ipsFile.records) {
            if (record.rle >= 0) {
                for (int i = record.length - 1; i >= 0; --i) {
                    data[record.offset + i] = (byte)record.rle;
                }
                continue;
            }
            System.arraycopy(record.data, 0, data, record.offset, record.length);
        }
    }

    public static void getArchiveInputStream(String archiveFileName, String entryFileName, FileUtil.InputStreamListener listener) throws Throwable {
        FileUtil.getArchiveInputStream(archiveFileName, entryFileName, (stream, size) -> {
            OpenFileHandle handle = IpsUtil.getOpenFileHandle(archiveFileName, stream, size);
            listener.handleInputStream(handle.getInputStream(), handle.getFileSize());
        });
    }

    public static OpenFileHandle getOpenFileHandle(String fileName) throws Throwable {
        return IpsUtil.getOpenFileHandle(fileName, new FileInputStream(fileName), new File(fileName).length());
    }

    public static OpenFileHandle getOpenFileHandle(String sourceFile, InputStream in, long fileSize) throws Throwable {
        if (StringUtil.isBlank(sourceFile) || fileSize <= 0L) {
            return new OpenFileHandle(in, fileSize);
        }
        File ips = new File(sourceFile + ".ips");
        if (!ips.exists() || !AppPrefs.getInstance().getUserInterfacePrefs().isApplyIpsPatches()) {
            return new OpenFileHandle(in, fileSize);
        }
        IpsFile ipsFile = IpsUtil.loadIpsFile(ips);
        byte[] data = IpsUtil.loadFileData("specified", in, fileSize, IpsUtil.getMinFileSize(ipsFile));
        IpsUtil.applyIpsFile(ipsFile, data);
        int length = ipsFile.truncatedLength >= 0 ? ipsFile.truncatedLength : data.length;
        return new OpenFileHandle(new ByteArrayInputStream(data, 0, length), length);
    }

    public static void applyIPS(String original, String patch, String modified) throws Throwable {
        IpsFile ipsFile = IpsUtil.loadIpsFile(FilePath.fromLongString(patch));
        byte[] data = IpsUtil.loadFileData("original", FilePath.fromLongString(original), IpsUtil.getMinFileSize(ipsFile));
        IpsUtil.applyIpsFile(ipsFile, data);
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(modified)));){
            if (ipsFile.truncatedLength >= 0) {
                out.write(data, 0, ipsFile.truncatedLength);
            } else {
                out.write(data);
            }
        }
        catch (Throwable t) {
            throw new MessageException("Failed to create the modified file.");
        }
    }

    public static void createIPS(String original, String modified, String patch) throws Throwable {
        int index;
        byte[] originalBytes = IpsUtil.loadFileData("original", FilePath.fromLongString(original));
        byte[] modifiedBytes = IpsUtil.loadFileData("modified", FilePath.fromLongString(modified));
        ArrayList<IpsRecord> records = new ArrayList<IpsRecord>();
        IpsRecord record = null;
        for (int i = 0; i < modifiedBytes.length; ++i) {
            if (i >= originalBytes.length || originalBytes[i] != modifiedBytes[i]) {
                if (record == null) {
                    if (i == 4542278) {
                        record = new IpsRecord(0x454F45);
                        record.length = 2;
                    } else {
                        record = new IpsRecord(i);
                    }
                    records.add(record);
                    continue;
                }
                ++record.length;
                continue;
            }
            record = null;
        }
        int i = 0;
        while (i + 1 < records.size()) {
            IpsRecord r1 = (IpsRecord)records.get(i);
            Iterator r2 = (IpsRecord)records.get(i + 1);
            if (((IpsRecord)((Object)r2)).offset - r1.offset - r1.length < 15) {
                r1.length = ((IpsRecord)((Object)r2)).offset + ((IpsRecord)((Object)r2)).length - r1.offset;
                records.remove(i + 1);
                continue;
            }
            ++i;
        }
        ArrayList<IpsRecord> rles = new ArrayList<IpsRecord>();
        BitSet regions = new BitSet(modifiedBytes.length);
        for (IpsRecord record2 : records) {
            int i2 = 0;
            block14: while (i2 < record2.length) {
                int startIndex = record2.offset + i2;
                if (startIndex == 4542278) {
                    ++i2;
                    continue;
                }
                byte startByte = modifiedBytes[startIndex];
                for (int j = i2 + 1; j <= record2.length; ++j) {
                    if (j != record2.length && startByte == modifiedBytes[record2.offset + j]) continue;
                    int spanLength = j - i2;
                    if (spanLength > 15) {
                        IpsRecord r = new IpsRecord(startIndex);
                        r.length = spanLength;
                        r.rle = startByte & 0xFF;
                        rles.add(r);
                        for (int k = 0; k < r.length; ++k) {
                            regions.set(r.offset + k);
                        }
                    }
                    i2 = j;
                    continue block14;
                }
            }
        }
        for (IpsRecord record2 : records) {
            IpsRecord r = null;
            for (int i3 = 0; i3 < record2.length; ++i3) {
                index = record2.offset + i3;
                if (!regions.get(index)) {
                    if (r == null) {
                        if (index == 4542278) {
                            r = new IpsRecord(0x454F45);
                            r.length = 2;
                        } else {
                            r = new IpsRecord(index);
                        }
                        rles.add(r);
                        continue;
                    }
                    ++r.length;
                    continue;
                }
                r = null;
            }
        }
        for (int i4 = 0; i4 < rles.size(); ++i4) {
            IpsRecord r;
            IpsRecord record2;
            record2 = (IpsRecord)rles.get(i4);
            if (record2.length <= 65535) continue;
            int index2 = record2.offset + 65535;
            if (index2 == 4542278) {
                r = new IpsRecord(0x454F45);
                r.length = record2.length - 65534;
                record2.length = 65534;
            } else {
                r = new IpsRecord(index2);
                r.length = record2.length - 65535;
                record2.length = 65535;
            }
            r.rle = record2.rle;
            rles.add(r);
        }
        Iterator i5 = rles.iterator();
        block20: while (i5.hasNext()) {
            IpsRecord r = (IpsRecord)i5.next();
            for (int j = r.length - 1; j >= 0; --j) {
                int index3 = r.offset + j;
                if (index3 >= originalBytes.length || originalBytes[index3] != modifiedBytes[index3]) continue block20;
            }
            i5.remove();
        }
        for (IpsRecord r : rles) {
            int firstDifferenceIndex = 0;
            for (int i6 = 0; i6 < r.length; ++i6) {
                index = r.offset + i6;
                if (index < originalBytes.length && originalBytes[index] == modifiedBytes[index]) continue;
                firstDifferenceIndex = i6;
                break;
            }
            r.offset += firstDifferenceIndex;
            r.length -= firstDifferenceIndex;
            if (r.offset != 4542278) continue;
            --r.offset;
            ++r.length;
        }
        for (IpsRecord r : rles) {
            int firstDifferenceIndex = r.length - 1;
            for (int i7 = r.length - 1; i7 >= 0; --i7) {
                index = r.offset + i7;
                if (index < originalBytes.length && originalBytes[index] == modifiedBytes[index]) continue;
                firstDifferenceIndex = i7;
                break;
            }
            r.length = firstDifferenceIndex + 1;
        }
        Collections.sort(rles);
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(patch)));){
            out.writeBytes("PATCH");
            for (IpsRecord record3 : rles) {
                out.write(record3.offset >> 16);
                out.write(record3.offset >> 8);
                out.write(record3.offset);
                if (record3.rle < 0) {
                    out.write(record3.length >> 8);
                    out.write(record3.length);
                    out.write(modifiedBytes, record3.offset, record3.length);
                    continue;
                }
                out.write(0);
                out.write(0);
                out.write(record3.length >> 8);
                out.write(record3.length);
                out.write(record3.rle);
            }
            out.writeBytes("EOF");
            if (modifiedBytes.length < originalBytes.length) {
                out.write(modifiedBytes.length >> 16);
                out.write(modifiedBytes.length >> 8);
                out.write(modifiedBytes.length);
            }
        }
        catch (Throwable t) {
            throw new MessageException("Failed to create the patch file.");
        }
    }

    private IpsUtil() {
    }

    private static class IpsFile {
        public List<IpsRecord> records = new ArrayList<IpsRecord>();
        public int truncatedLength = -1;

        private IpsFile() {
        }
    }

    private static class IpsRecord
    implements Comparable<IpsRecord> {
        public int offset;
        public int length = 1;
        public int rle = -1;
        public byte[] data;

        public IpsRecord() {
        }

        public IpsRecord(int offset) {
            this.offset = offset;
        }

        @Override
        public int compareTo(IpsRecord o) {
            return Integer.compare(this.offset, o.offset);
        }
    }

    public static class OpenFileHandle {
        private final InputStream inputStream;
        private final long fileSize;

        public OpenFileHandle(InputStream inputStream, long fileSize) {
            this.inputStream = inputStream;
            this.fileSize = fileSize;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public long getFileSize() {
            return this.fileSize;
        }
    }
}

