/*
 * Decompiled with CFR 0.152.
 */
package nintaco.files;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.zip.CRC32;
import nintaco.MessageException;
import nintaco.cartdb.Cart;
import nintaco.cartdb.CartDB;
import nintaco.files.CartFile;
import nintaco.files.Console;
import nintaco.files.ExtendedConsole;
import nintaco.files.FileUtil;
import nintaco.mappers.NametableMirroring;
import nintaco.mappers.nintendo.vs.VsGame;
import nintaco.mappers.nintendo.vs.VsHardware;
import nintaco.mappers.nintendo.vs.VsPPU;
import nintaco.tv.TVSystem;
import nintaco.util.BitUtil;
import nintaco.util.StreamUtil;
import nintaco.util.StringUtil;

public class NesFile
implements CartFile,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    public static final String HEADER_ID = "NES\u001a";
    protected static final String[] PAL_IDENTIFIERS = new String[]{"(e)", "(europe)", "(pal)", "(f)", "(g)", "(i)"};
    protected static final String[] PC10_IDENTIFIERS = new String[]{"(pc10)", "(pc10 version)"};
    protected static final String[] MAPPER_NAMES = new String[]{"NROM", "MMC1", "UNROM", "CNROM", "MMC3", "MMC5", "FFE Rev. A", "ANROM", "", "MMC2", "MMC4", "Color Dreams", "REX DBZ 5", "CPROM", "REX SL-1632", "100-in-1", "BANDAI 24C02", "FFE Rev. B", "JALECO SS880006", "Namcot 106", "", "Konami VRC2/VRC4 A", "Konami VRC2/VRC4 B", "Konami VRC2/VRC4 C", "Konami VRC6 Rev. A", "Konami VRC2/VRC4 D", "Konami VRC6 Rev. B", "CC-21 MI HUN CHE", "", "", "", "", "IREM G-101", "TC0190FMC/TC0350FMR", "IREM I-IM/BNROM", "Wario Land 2", "TXC Policeman", "PAL-ZZ SMB/TETRIS/NWC", "Bit Corp.", "", "SMB2j FDS", "CALTRON 6-in-1", "BIO MIRACLE FDS", "FDS SMB2j LF36", "MMC3 BMC PIRATE A", "MMC3 BMC PIRATE B", "RUMBLESTATION 15-in-1", "NES-QJ SSVB/NWC", "TAITO TCxxx", "MMC3 BMC PIRATE C", "SMB2j FDS Rev. A", "11-in-1 BALL SERIES", "MMC3 BMC PIRATE D", "SUPERVISION 16-in-1", "", "", "SMB3 Pirate", "SIMBPLE BMC PIRATE A", "SIMBPLE BMC PIRATE B", "", "SIMBPLE BMC PIRATE C", "20-in-1 KAISER Rev. A", "700-in-1", "Hello Kitty 255 in 1", "TENGEN RAMBO1", "IREM-H3001", "MHROM", "SUNSOFT-FZII", "Sunsoft Mapper #4", "SUNSOFT-5/FME-7", "BANDAI KAMEN DISCRETE", "CAMERICA BF9093", "JALECO JF-17", "KONAMI VRC3", "TW MMC3+VRAM Rev. A", "KONAMI VRC1", "NAMCOT 108 Rev. A", "IREM LROG017", "Irem 74HC161/32", "AVE/C&E/TXC BOARD", "TAITO X1-005 Rev. A", "", "TAITO X1-017", "YOKO VRC Rev. B", "", "KONAMI VRC7", "JALECO JF-13", "74*139/74 DISCRETE", "NAMCO 3433", "SUNSOFT-3", "HUMMER/JY BOARD", "EARLY HUMMER/JY BOARD", "JALECO JF-19", "SUNSOFT-3R", "HVC-UN1ROM", "NAMCOT 108 Rev. B", "BANDAI OEKAKIDS", "IREM TAM-S1", "", "VS Uni/Dual- system", "", "", "", "FDS DOKIDOKI FULL", "", "NES-EVENT NWC1990", "SMB3 PIRATE A", "MAGIC CORP A", "FDS UNROM BOARD", "", "", "", "ASDER/NTDEC BOARD", "HACKER/SACHEN BOARD", "MMC3 SG PROT. A", "MMC3 PIRATE A", "MMC1/MMC3/VRC PIRATE", "FUTURE MEDIA BOARD", "TSKROM", "NES-TQROM", "FDS TOBIDASE", "MMC3 PIRATE PROT. A", "", "MMC3 PIRATE H2288", "", "FDS LH32", "", "Double Dragon pirate", "", "", "", "", "TXC/MGENIUS 22111", "SA72008", "MMC3 BMC PIRATE", "", "TCU02", "S8259D", "S8259B", "S8259C", "JALECO JF-11/14", "S8259A", "UNLKS7032", "TCA01", "AGCI 50282", "SA72007", "SA0161M", "TCU01", "SA0037", "SA0036", "S74LS374N", "", "BANDAI 74161/7432", "BANDAI SRAM", "", "", "", "BANDAI BARCODE", "", "BANDAI 24C01", "SA009", "", "", "", "", "", "SUBOR Rev. A", "SUBOR Rev. B", "", "", "", "", "", "", "", "", "BMCFK23C", "", "", "", "", "", "Super Donkey Kong", "", "Atlantis no Nazo", "CNROM (CHR disabled)", "", "", "", "Thunder Warrior", "", "", "TW MMC3+VRAM Rev. B", "NTDEC TC-112", "TW MMC3+VRAM Rev. C", "TW MMC3+VRAM Rev. D", "", "", "TW MMC3+VRAM Rev. E", "", "", "", "", "", "", "", "NAMCOT 108 Rev. C", "TAITO X1-005 Rev. B", "", "", "", "", "", "", "", "", "", "", "", "UNLA9746", "Debug Mapper", "UNLN625092", "", "", "", "72-in-1", "BMC 22+20-in-1", "1200-in-1", "Action 52", "31-in-1", "BMC Contra+22-in-1", "20-in-1", "BMC QUATTRO", "BMC 22+20-in-1 RST", "BMC MAXI", "Golden Game 150-in-1", "", "", "UNL6035052", "", "", "", "", "S74LS374NA", "DECATHLON", "", "FONG SHEN BANG", "", "", "", "Time Diver Avenger", "", "SAN GUO ZHI PIRATE", "DRAGON BALL PIRATE", "Ai Senshi Nicol", ""};
    public static final int PRG_ROM_PAGE_SIZE = 16384;
    public static final int PRG_RAM_PAGE_SIZE = 8192;
    public static final int CHR_ROM_PAGE_SIZE = 8192;
    protected transient int[] prgROM;
    protected transient int[] chrROM;
    protected transient int[] trainer;
    protected int[] header = new int[16];
    protected int chrRomPages;
    protected int prgRomPages;
    protected int prgRamPages;
    protected int prgRamSize;
    protected int mapperNumber;
    protected int originalMapperNumber;
    protected int submapperNumber;
    protected int originalSubmapperNumber;
    protected int mirroring;
    protected int originalMirroring;
    protected int nonVolatilePrgRamSize;
    protected int originalNonVolatilePrgRamSize;
    protected int nonVolatileChrRamSize;
    protected int chrRamSize;
    protected int originalConsole;
    protected int console;
    protected int extendedConsole;
    protected int miscellaneousROMs;
    protected int defaultExpansionDevice;
    protected int cpuPpuTiming;
    protected int originalCpuPpuTiming;
    protected int vsPPU;
    protected int vsHardware;
    protected boolean trainerPresent;
    protected boolean chrRamPresent;
    protected boolean nonVolatilePrgRamPresent;
    protected boolean originalNonVolatilePrgRamPresent;
    protected boolean nes20Format;
    protected String fileName;
    protected String entryFileName;
    protected String archiveFileName;
    protected String description;
    protected String mapperName;
    protected int prgRomCRC;
    protected int chrRomCRC;
    protected int fileCRC;
    protected int prgRomLength;
    protected int chrRomLength;
    protected Cart cart;
    protected VsGame vsGame;

    public NesFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName) throws Throwable {
        this(in, fileSize, entryFileName, archiveFileName, true);
    }

    public NesFile(DataInputStream in, long fileSize, String entryFileName, String archiveFileName, boolean modifyHeader) throws Throwable {
        boolean unknown;
        int exponent;
        int multiplier;
        this.archiveFileName = archiveFileName;
        if (StringUtil.isBlank(entryFileName)) {
            this.entryFileName = archiveFileName;
            this.fileName = FileUtil.getFileName(archiveFileName).toLowerCase(Locale.ENGLISH);
        } else {
            this.entryFileName = entryFileName;
            this.fileName = FileUtil.getFileName(entryFileName).toLowerCase(Locale.ENGLISH);
        }
        StreamUtil.readBytes(in, this.header);
        if (!StringUtil.compareStrings(HEADER_ID, this.header)) {
            throw new MessageException("Invalid or unknown file format.");
        }
        this.prgRomPages = this.header[4];
        this.chrRomPages = this.header[5];
        this.mapperNumber = this.header[6] >> 4;
        this.mirroring = BitUtil.getBitBool(this.header[6], 3) ? 4 : (BitUtil.getBitBool(this.header[6], 0) ? 0 : 1);
        this.originalMirroring = this.mirroring;
        this.trainerPresent = BitUtil.getBitBool(this.header[6], 2);
        this.nonVolatilePrgRamPresent = BitUtil.getBitBool(this.header[6], 1);
        this.nonVolatilePrgRamSize = this.nonVolatilePrgRamPresent ? 8192 : 0;
        boolean bl = this.nes20Format = (this.header[7] & 0xC) == 8;
        if (!this.nes20Format) {
            if ((this.header[7] & 0xC) != 0 || (this.header[7] & 3) == 3) {
                this.header[9] = 0;
                this.header[8] = 0;
                this.header[7] = 0;
            } else {
                for (int i = 10; i < 16; ++i) {
                    if (this.header[i] == 0) continue;
                    this.header[9] = 0;
                    this.header[8] = 0;
                    this.header[7] = 0;
                    break;
                }
            }
        }
        this.mapperNumber |= this.header[7] & 0xF0;
        this.originalConsole = this.console = this.header[7] & 3;
        if (this.nes20Format) {
            this.submapperNumber = this.header[8] >> 4;
            this.mapperNumber |= (this.header[8] & 0xF) << 8;
            this.chrRomPages |= (this.header[9] & 0xF0) << 4;
            this.prgRomPages |= (this.header[9] & 0xF) << 8;
            this.nonVolatilePrgRamSize = this.decodeRamSize(this.header[10] >> 4);
            this.nonVolatilePrgRamPresent = this.nonVolatilePrgRamSize > 0;
            this.prgRamSize = this.decodeRamSize(this.header[10] & 0xF);
            this.prgRamPages = this.prgRamSize / 8192;
            this.nonVolatileChrRamSize = this.decodeRamSize(this.header[11] >> 4);
            this.chrRamSize = this.decodeRamSize(this.header[11] & 0xF);
            this.originalCpuPpuTiming = this.cpuPpuTiming = this.header[12] & 3;
            switch (this.console) {
                case 1: {
                    this.vsPPU = this.header[13] & 0xF;
                    this.vsHardware = this.header[13] >> 4;
                    break;
                }
                case 3: {
                    this.extendedConsole = this.header[13] & 0xF;
                }
            }
            this.miscellaneousROMs = this.header[14] & 3;
            this.defaultExpansionDevice = this.header[15] & 0x3F;
        } else {
            if (this.console == 3) {
                this.console = 0;
            }
            if (modifyHeader) {
                for (String pc10Identifier : PC10_IDENTIFIERS) {
                    if (!this.fileName.contains(pc10Identifier)) continue;
                    this.console = 2;
                    break;
                }
            }
            this.prgRamPages = this.header[8];
            this.prgRamSize = 8192 * this.prgRamPages;
            if (BitUtil.getBitBool(this.header[9], 0)) {
                this.cpuPpuTiming = 1;
                this.originalCpuPpuTiming = 1;
            } else {
                this.cpuPpuTiming = 0;
                this.originalCpuPpuTiming = 0;
                if (modifyHeader) {
                    for (String palIdentifier : PAL_IDENTIFIERS) {
                        if (!this.fileName.contains(palIdentifier)) continue;
                        this.cpuPpuTiming = 1;
                        break;
                    }
                }
            }
        }
        if (this.prgRomPages == 0) {
            this.prgRomPages = 256;
        }
        if (this.prgRomPages >> 8 == 15) {
            multiplier = this.prgRomPages & 3;
            exponent = this.prgRomPages >> 2 & 0x3F;
            this.prgRomLength = (1 << exponent) * ((multiplier << 1) + 1);
        } else {
            this.prgRomLength = 16384 * this.prgRomPages;
        }
        if (this.chrRomPages >> 8 == 15) {
            multiplier = this.chrRomPages & 3;
            exponent = this.chrRomPages >> 2 & 0x3F;
            this.chrRomLength = (1 << exponent) * ((multiplier << 1) + 1);
        } else {
            this.chrRomLength = 8192 * this.chrRomPages;
        }
        this.readROMs(in, fileSize);
        this.originalMapperNumber = this.mapperNumber;
        this.originalSubmapperNumber = this.submapperNumber;
        this.cart = CartDB.getCart(this.fileCRC);
        this.originalNonVolatilePrgRamPresent = this.nonVolatilePrgRamPresent;
        this.originalNonVolatilePrgRamSize = this.nonVolatilePrgRamSize;
        if (modifyHeader) {
            this.vsGame = VsGame.getVsGame(this);
            if (this.vsGame != null) {
                this.console = 1;
                this.vsHardware = this.vsGame.getHardware();
                this.vsPPU = this.vsGame.getPPU();
                this.cart = new Cart(this.fileCRC, this.vsGame.getMapper(), 0, TVSystem.NTSC, this.vsGame.isZapperGame() ? 32 : -1, this.vsGame.getMirroring(), false);
                if (this.vsGame.isNonVolatilePrgRamPresent()) {
                    this.nonVolatilePrgRamPresent = true;
                    this.nonVolatilePrgRamSize = 2048;
                }
            }
            if (this.cart != null && CartDB.isEnabled()) {
                this.mapperNumber = this.cart.getMapper();
                this.submapperNumber = this.cart.getSubmapper();
                if (this.cart.getMirroring() >= 0) {
                    this.mirroring = this.cart.getMirroring();
                }
                this.cpuPpuTiming = CpuPpuTiming.fromTVSystem(this.cart.getTVSystem());
            }
        }
        boolean bl2 = unknown = this.cart == null;
        if (this.cart == null) {
            this.cart = new Cart(this.getFileCRC(), this.getMapperNumber(), this.getSubmapperNumber(), this.getTvSystem(), this.getCartDevice(), this.getMirroring(), false);
        }
        this.mapperName = this.mapperNumber < MAPPER_NAMES.length ? MAPPER_NAMES[this.mapperNumber] : "";
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isBlank(archiveFileName)) {
            if (StringUtil.isBlank(entryFileName)) {
                StringUtil.appendLine(sb, "File name: %s", FileUtil.getFileName(archiveFileName));
            } else {
                StringUtil.appendLine(sb, "File name: %s <%s>", FileUtil.getFileName(archiveFileName), FileUtil.getFileName(entryFileName));
            }
            StringUtil.appendLine(sb, "Directory: %s", FileUtil.getDirectoryPath(archiveFileName));
        } else if (!StringUtil.isBlank(entryFileName)) {
            StringUtil.appendLine(sb, "File name: %s", FileUtil.getFileName(entryFileName));
            StringUtil.appendLine(sb, "Directory: %s", FileUtil.getDirectoryPath(entryFileName));
        }
        StringUtil.appendLine(sb, "File format: %s", this.nes20Format ? "NES 2.0" : "iNES");
        StringUtil.appendLine(sb, "File CRC: %08X%s", this.fileCRC, unknown ? " (unknown)" : "");
        if (this.originalMapperNumber != this.mapperNumber) {
            StringUtil.appendLine(sb, "Mapper #: %d (modified, was %d)", this.mapperNumber, this.originalMapperNumber);
        } else {
            StringUtil.appendLine(sb, "Mapper #: %d", this.mapperNumber);
        }
        if (this.nes20Format || this.submapperNumber != 0) {
            if (this.originalSubmapperNumber != this.submapperNumber) {
                StringUtil.appendLine(sb, "Submapper #: %d (modified, was %d)", this.submapperNumber, this.originalSubmapperNumber);
            } else {
                StringUtil.appendLine(sb, "Submapper #: %d", this.submapperNumber);
            }
        }
        StringUtil.appendLine(sb, "Mapper name: %s", this.mapperName);
        StringUtil.appendLine(sb, "Mirroring: %s", NametableMirroring.toString(this.mirroring));
        if (this.prgRomPages >> 8 == 15) {
            StringUtil.append(sb, "PRG ROM size: %d bytes", this.prgRomLength);
        } else {
            StringUtil.append(sb, "PRG ROM size: %d bytes (%d pages x %d bytes)", this.prgRomLength, this.prgRomPages, 16384);
        }
        if (this.prgRomLength != this.prgROM.length) {
            StringUtil.append(sb, ", %d bytes (adjusted)", this.prgROM.length);
        }
        StringUtil.appendLine(sb);
        StringUtil.appendLine(sb, "PRG ROM CRC: %08X", this.prgRomCRC);
        if (this.chrRomPages >> 8 == 15) {
            StringUtil.append(sb, "CHR ROM size: %d bytes", this.chrRomLength);
        } else {
            StringUtil.append(sb, "CHR ROM size: %d bytes (%d pages x %d bytes)", this.chrRomLength, this.chrRomPages, 8192);
        }
        if (this.chrRomLength != this.chrROM.length) {
            StringUtil.append(sb, ", %d bytes (adjusted)", this.chrROM.length);
        }
        StringUtil.appendLine(sb);
        StringUtil.appendLine(sb, "CHR ROM CRC: %08X", this.chrRomCRC);
        StringUtil.appendLine(sb, "CHR RAM: %s", StringUtil.toYesNo(this.chrRamPresent));
        if (this.nes20Format) {
            StringUtil.appendLine(sb, "PRG RAM size: %d bytes", this.prgRamSize);
        } else {
            StringUtil.appendLine(sb, "PRG RAM size: %d bytes (%d pages x %d bytes)", this.prgRamSize, this.prgRamPages, 8192);
        }
        if (this.originalNonVolatilePrgRamPresent != this.nonVolatilePrgRamPresent) {
            StringUtil.appendLine(sb, "Non-Volatile PRG RAM: %s (modified, was %s)", StringUtil.toYesNo(this.nonVolatilePrgRamPresent), StringUtil.toYesNo(this.originalNonVolatilePrgRamPresent));
        } else {
            StringUtil.appendLine(sb, "Non-Volatile PRG RAM: %s", StringUtil.toYesNo(this.nonVolatilePrgRamPresent));
        }
        if (this.nes20Format) {
            if (this.originalNonVolatilePrgRamSize != this.nonVolatilePrgRamSize) {
                StringUtil.appendLine(sb, "Non-Volatile PRG RAM size: %d bytes (modified, was %d bytes)", this.nonVolatilePrgRamSize, this.originalNonVolatilePrgRamSize);
            } else {
                StringUtil.appendLine(sb, "Non-Volatile PRG RAM size: %d bytes", this.nonVolatilePrgRamSize);
            }
            StringUtil.appendLine(sb, "Non-Volatile CHR RAM size: %d bytes", this.nonVolatileChrRamSize);
            StringUtil.appendLine(sb, "CHR RAM size: %d bytes", this.chrRamSize);
        }
        if (this.cpuPpuTiming != this.originalCpuPpuTiming) {
            StringUtil.appendLine(sb, "TV System: %s (modified, was %s)", CpuPpuTiming.toString(this.cpuPpuTiming), CpuPpuTiming.toString(this.originalCpuPpuTiming));
        } else {
            StringUtil.appendLine(sb, "TV System: %s", CpuPpuTiming.toString(this.cpuPpuTiming));
        }
        if (this.console == 3) {
            StringUtil.appendLine(sb, "Console type: %s", ExtendedConsole.toString(this.extendedConsole));
        } else if (this.console != this.originalConsole) {
            StringUtil.appendLine(sb, "Console type: %s (modified, was %s)", Console.toString(this.console), Console.toString(this.originalConsole));
        } else {
            StringUtil.appendLine(sb, "Console type: %s", Console.toString(this.console));
        }
        if (this.isVsSystem()) {
            StringUtil.appendLine(sb, "VS. PPU: %s", VsPPU.toString(this.vsPPU));
            StringUtil.appendLine(sb, "VS. Hardware: %s", VsHardware.toString(this.vsHardware));
        }
        if (this.nes20Format) {
            StringUtil.appendLine(sb, "Miscellaneous ROMs: %d", this.miscellaneousROMs);
            StringUtil.appendLine(sb, "Default expansion device: %s", DefaultExpansionDevice.toString(this.defaultExpansionDevice));
        }
        StringUtil.appendLine(sb, "Trainer: %s", StringUtil.toYesNo(this.trainerPresent));
        this.description = sb.toString();
    }

    protected void readROMs(DataInputStream in, long fileSize) throws Throwable {
        if (this.trainerPresent) {
            this.trainer = new int[512];
            this.readFully(in, this.trainer, 0, this.trainer.length, null);
        } else {
            this.trainer = new int[0];
        }
        this.prgROM = new int[BitUtil.ceilBase2(this.prgRomLength)];
        CRC32 crc = new CRC32();
        this.prgRomCRC = this.readFully(in, this.prgROM, 0, this.prgRomLength, crc);
        if (this.mapperNumber == 1 && this.prgRomLength == 32768 && this.prgRomCRC == 1013747308) {
            this.prgRomPages <<= 1;
            this.prgRomLength <<= 1;
            int[] rom = new int[65536];
            System.arraycopy(this.prgROM, 0, rom, 0, 32768);
            this.prgROM = rom;
            this.readFully(in, this.prgROM, 32768, 32768, crc);
            this.prgRomCRC = (int)crc.getValue();
        }
        if (this.chrRomLength == 0) {
            this.chrRamPresent = true;
            this.chrROM = new int[0];
            this.chrRomCRC = 0;
        } else {
            this.chrRamPresent = false;
            this.chrROM = new int[BitUtil.ceilBase2(this.chrRomLength)];
            this.chrRomCRC = this.readFully(in, this.chrROM, 0, this.chrRomLength, crc);
        }
        this.fileCRC = (int)crc.getValue();
        switch (this.fileCRC) {
            case 128119730: {
                System.arraycopy(this.prgROM, 32768, this.prgROM, 40960, 8192);
                break;
            }
            case 1372023107: {
                System.arraycopy(this.prgROM, 24576, this.prgROM, 40960, 24576);
                System.arraycopy(this.prgROM, 0, this.prgROM, 8192, 24576);
                break;
            }
            case 1895806353: {
                System.arraycopy(this.prgROM, 32768, this.prgROM, 57344, 8192);
                break;
            }
            case -997018415: {
                System.arraycopy(this.prgROM, 0, this.prgROM, 8192, 24576);
            }
        }
    }

    private int readFully(DataInputStream in, int[] data, int offset, int length, CRC32 crc) throws IOException {
        int d;
        CRC32 dataCRC = new CRC32();
        int bytesRead = 0;
        int i = 0;
        while (i < length && (d = in.read()) >= 0) {
            data[offset + i] = d;
            dataCRC.update(d);
            if (crc != null) {
                crc.update(d);
            }
            ++i;
            ++bytesRead;
        }
        if (bytesRead > 0) {
            for (i = offset + bytesRead; i < data.length; ++i) {
                data[i] = data[i % bytesRead];
            }
        }
        return (int)dataCRC.getValue();
    }

    private int decodeRamSize(int value) {
        if (value == 0 || value == 15) {
            return 0;
        }
        return 64 << value;
    }

    @Override
    public int[] getPrgROM() {
        return this.prgROM;
    }

    @Override
    public int[] getChrROM() {
        return this.chrROM;
    }

    @Override
    public boolean isTrainerPresent() {
        return this.trainerPresent;
    }

    @Override
    public int getTrainerSize() {
        return this.trainer.length;
    }

    @Override
    public int[] getTrainer() {
        return this.trainer;
    }

    @Override
    public int getMapperNumber() {
        return this.mapperNumber;
    }

    public int getOriginalMapperNumber() {
        return this.originalMapperNumber;
    }

    @Override
    public int getSubmapperNumber() {
        return this.submapperNumber;
    }

    public int getOriginalSubmapperNumber() {
        return this.originalSubmapperNumber;
    }

    @Override
    public int getMirroring() {
        return this.mirroring;
    }

    public int getOriginalMirroring() {
        return this.originalMirroring;
    }

    public int getNonVolatilePrgRamSize() {
        return this.nonVolatilePrgRamSize;
    }

    public int getNonVolatileChrRamSize() {
        return this.nonVolatileChrRamSize;
    }

    @Override
    public int getChrRamSize() {
        return this.chrRamSize;
    }

    public int getCpuPpuTiming() {
        return this.cpuPpuTiming;
    }

    public int getOriginalCpuPpuTiming() {
        return this.originalCpuPpuTiming;
    }

    public void setOriginalCpuPpuTiming(int originalCpuPpuTiming) {
        this.originalCpuPpuTiming = originalCpuPpuTiming;
    }

    @Override
    public TVSystem getTvSystem() {
        return CpuPpuTiming.toTVSystem(this.cpuPpuTiming);
    }

    public int getVsPPU() {
        return this.vsPPU;
    }

    @Override
    public int getVsHardware() {
        return this.vsHardware;
    }

    @Override
    public Cart getCart() {
        return this.cart;
    }

    @Override
    public VsGame getVsGame() {
        return this.vsGame;
    }

    @Override
    public boolean isChrRamPresent() {
        return this.chrRamPresent;
    }

    @Override
    public boolean isNonVolatilePrgRamPresent() {
        return this.nonVolatilePrgRamPresent;
    }

    public int getOriginalConsole() {
        return this.originalConsole;
    }

    @Override
    public int getConsole() {
        return this.console;
    }

    @Override
    public int getExtendedConsole() {
        return this.extendedConsole;
    }

    public boolean isPlaychoice10() {
        return this.console == 2 || this.console == 3 && this.extendedConsole == 2;
    }

    @Override
    public boolean isVsSystem() {
        return this.vsGame != null || (this.nes20Format ? this.console == 1 || this.console == 3 && this.extendedConsole == 1 : BitUtil.getBitBool(this.console, 0));
    }

    @Override
    public boolean isVsUniSystem() {
        return this.vsGame != null ? this.vsGame.isUniSystemGame() : this.nes20Format && this.isVsSystem() && this.vsHardware < 5;
    }

    @Override
    public boolean isVsDualSystem() {
        return this.vsGame != null ? this.vsGame.isDualSystemGame() : this.nes20Format && this.isVsSystem() && this.vsHardware >= 5;
    }

    public int getMiscellaneousROMs() {
        return this.miscellaneousROMs;
    }

    public int getDefaultExpansionDevice() {
        return this.defaultExpansionDevice;
    }

    public int getCartDevice() {
        return this.cart == null ? DefaultExpansionDevice.toCartDevice(this.defaultExpansionDevice) : this.cart.getDevice();
    }

    public boolean isNes20Format() {
        return this.nes20Format;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getEntryFileName() {
        return this.entryFileName;
    }

    @Override
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    public int getChrRomPages() {
        return this.chrRomPages;
    }

    public int getChrRomSize() {
        return 8192 * this.chrRomPages;
    }

    public int[] getHeader() {
        return this.header;
    }

    public int getHeaderSize() {
        return this.header.length;
    }

    public int getPrgRomPages() {
        return this.prgRomPages;
    }

    public int getPrgRomSize() {
        return 16384 * this.prgRomPages;
    }

    public int getPrgRamPages() {
        return this.prgRamPages;
    }

    public int getPrgRamSize() {
        return this.prgRamSize;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    @Override
    public int getFileCRC() {
        return this.fileCRC;
    }

    public int getPrgRomCRC() {
        return this.prgRomCRC;
    }

    public int getChrRomCRC() {
        return this.chrRomCRC;
    }

    @Override
    public int getPrgRomLength() {
        return this.prgRomLength;
    }

    @Override
    public int getChrRomLength() {
        return this.chrRomLength;
    }

    @Override
    public int getFileType() {
        return 1;
    }

    public String toString() {
        return this.description;
    }

    @Override
    public int[] getFileContents() {
        int[] data = new int[this.getHeaderSize() + this.getTrainerSize() + this.getPrgRomSize() + this.getChrRomSize()];
        System.arraycopy(this.header, 0, data, 0, this.getHeaderSize());
        System.arraycopy(this.trainer, 0, data, this.getHeaderSize(), this.getTrainerSize());
        System.arraycopy(this.prgROM, 0, data, this.getHeaderSize() + this.getTrainerSize(), this.getPrgRomSize());
        System.arraycopy(this.chrROM, 0, data, this.getHeaderSize() + this.getTrainerSize() + this.getPrgRomSize(), this.getChrRomSize());
        return data;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.prgROM = StreamUtil.readByteArray(in);
        this.chrROM = StreamUtil.readByteArray(in);
        this.trainer = StreamUtil.readByteArray(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        StreamUtil.writeByteArray(out, this.prgROM);
        StreamUtil.writeByteArray(out, this.chrROM);
        StreamUtil.writeByteArray(out, this.trainer);
    }

    public static interface DefaultExpansionDevice {
        public static final int UNSPECIFIED = 0;
        public static final int STANDARD_CONTROLLERS = 1;
        public static final int NES_MULTITAP_WITH_4_STANDARD_CONTROLLERS = 2;
        public static final int FAMICOM_MULTITAP_WITH_4_STANDARD_CONTROLLERS = 3;
        public static final int VS_SYSTEM = 4;
        public static final int VS_SYSTEM_WITH_REVERSED_INPUTS = 5;
        public static final int VS_PINBALL_JAPAN = 6;
        public static final int VS_ZAPPER = 7;
        public static final int ZAPPER = 8;
        public static final int TWO_ZAPPERS = 9;
        public static final int BANDAI_HYPER_SHOT = 10;
        public static final int POWER_PAD_SIDE_A = 11;
        public static final int POWER_PAD_SIDE_B = 12;
        public static final int FAMILY_TRAINER_SIDE_A = 13;
        public static final int FAMILY_TRAINER_SIDE_B = 14;
        public static final int NES_ARKANOID_VAUS = 15;
        public static final int FAMICOM_ARKANOID_VAUS = 16;
        public static final int TWO_VAUS_CONTROLLERS_WITH_DATA_RECORDER = 17;
        public static final int KONAMI_HYPER_SHOT = 18;
        public static final int COCONUTS_PACHINKO = 19;
        public static final int EXCITING_BOXING_PUNCHING_BAG = 20;
        public static final int JISSEN_MAHJONG = 21;
        public static final int PARTY_TAP = 22;
        public static final int OEKA_KIDS_TABLET = 23;
        public static final int SUNSOFT_BARCODE_BATTLER = 24;
        public static final int MIRACLE_PIANO_KEYBOARD = 25;
        public static final int POKKUN_MOGURAA = 26;
        public static final int TOP_RIDER = 27;
        public static final int DOUBLE_FISTED = 28;
        public static final int FAMICOM_3D_SYSTEM = 29;
        public static final int DOREMIKKO_KEYBOARD = 30;
        public static final int ROB_GYRO_SET = 31;
        public static final int FAMICOM_DATA_RECORDER_NO_KEYBOARD = 32;
        public static final int ASCII_TURBO_FILE = 33;
        public static final int IGS_STORAGE_BATTLE_BOX = 34;
        public static final int FAMILY_BASIC_KEYBOARD_AND_DATA_RECORDER = 35;
        public static final int DONGDA_PEC_586_KEYBOARD = 36;
        public static final int BIT_CORP_BIT_79_KEYBOARD = 37;
        public static final int SUBOR_KEYBOARD = 38;
        public static final int SUBOR_KEYBOARD_WITH_MOUSE_3X8_BIT_PROTOCOL = 39;
        public static final int SUBOR_KEYBOARD_WITH_MOUSE_24_BIT_PROTOCOL = 40;
        public static final int SNES_MOUSE = 41;
        public static final int MULTICART = 42;
        public static final int TWO_SNES_CONTROLLERS = 43;
        public static final int RACERMATE_BICYCLE = 44;
        public static final int U_FORCE = 45;
        public static final int ROB_STACK_UP = 46;
        public static final String[] NAMES = new String[]{"Unspecified", "Standard controllers", "NES multitap with 4 standard controllers", "Famicom multitap with 4 standard controllers", "VS. System", "VS. System with reversed inputs", "VS. Pinball (Japan)", "VS. Zapper", "Zapper", "2 Zappers", "Bandai Hyper Shot", "Power Pad (Side A)", "Power Pad (Side B)", "Family Trainer (Side A)", "Family Trainer (Side B)", "NES Arkanoid Vaus", "Famicom Arkanoid Vaus", "2 Vaus controllers with Data Recorder", "Konami Hyper Shot", "Coconuts Pachinko", "Exciting Boxing Punching Bag", "Jissen Mahjong", "Party Tap", "Oeka Kids Tablet", "Sunsoft Barcode Battler", "Miracle Piano Keyboard", "Pokkun Moguraa", "Top Rider", "Double-Fisted", "Famicom 3D System", "Doremikko Keyboard", "R.O.B. Gyro Set", "Famicom Data Recorder (no keyboard)", "ASCII Turbo File", "IGS Storage Battle Box", "Family BASIC Keyboard and Data Recorder", "Dongda PEC-586 Keyboard", "Bit Corp. Bit-79 Keyboard", "Subor Keyboard", "Subor Keyboard with mouse (3x8-bit protocol)", "Subor Keyboard with mouse (24-bit protocol)", "SNES Mouse", "Multicart", "2 SNES controllers", "RacerMate Bicycle", "U-Force", "R.O.B. Stack-Up"};

        public static String toString(int defaultExpansionDevice) {
            return defaultExpansionDevice < 0 || defaultExpansionDevice >= NAMES.length ? "Other" : NAMES[defaultExpansionDevice];
        }

        public static int toCartDevice(int defaultExpansionDevice) {
            switch (defaultExpansionDevice) {
                case 7: 
                case 8: 
                case 9: {
                    return 32;
                }
                case 10: {
                    return 4;
                }
                case 11: 
                case 12: {
                    return 22;
                }
                case 13: 
                case 14: {
                    return 13;
                }
                case 15: 
                case 16: 
                case 17: {
                    return 3;
                }
                case 18: {
                    return 15;
                }
                case 19: {
                    return 19;
                }
                case 20: {
                    return 10;
                }
                case 21: {
                    return 16;
                }
                case 22: {
                    return 20;
                }
                case 23: {
                    return 18;
                }
                case 24: {
                    return 5;
                }
                case 25: {
                    return 17;
                }
                case 27: {
                    return 28;
                }
                case 29: {
                    return 1;
                }
                case 31: 
                case 46: {
                    return 24;
                }
                case 32: {
                    return 8;
                }
                case 33: {
                    return 30;
                }
                case 34: {
                    return 6;
                }
                case 35: {
                    return 12;
                }
                case 36: {
                    return 9;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    return 26;
                }
                case 44: {
                    return 23;
                }
                case 45: {
                    return 31;
                }
            }
            return 0;
        }
    }

    public static interface CpuPpuTiming {
        public static final int NTSC = 0;
        public static final int PAL = 1;
        public static final int MULTI_REGION = 2;
        public static final int DENDY = 3;
        public static final String[] NAMES = new String[]{"NTSC", "PAL", "Multi-region", "Dendy"};

        public static String toString(int cpuPpuTiming) {
            return cpuPpuTiming < 0 || cpuPpuTiming >= NAMES.length ? "Other" : NAMES[cpuPpuTiming];
        }

        public static TVSystem toTVSystem(int cpuPpuTiming) {
            switch (cpuPpuTiming) {
                case 1: {
                    return TVSystem.PAL;
                }
                case 3: {
                    return TVSystem.Dendy;
                }
            }
            return TVSystem.NTSC;
        }

        public static int fromTVSystem(TVSystem tvSystem) {
            switch (tvSystem) {
                case PAL: {
                    return 1;
                }
                case Dendy: {
                    return 3;
                }
            }
            return 0;
        }
    }
}

