/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;
import nintaco.util.ThreadUtil;

public class PleaseWaitDialog
extends JDialog {
    private static final int DISPLAY_MILLIS = 400;
    private volatile boolean disposed;
    private JLabel messageLabel;
    private JProgressBar progressBar;

    public PleaseWaitDialog(Window parent) {
        super(parent);
        this.initComponents();
        this.progressBar.setIndeterminate(true);
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public final void setMessage(String message) {
        if (StringUtil.isBlank(message)) {
            this.messageLabel.setText("Please wait...");
        } else {
            this.messageLabel.setText(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showAfterDelay() {
        if (EventQueue.isDispatchThread()) {
            if (!this.disposed) {
                PleaseWaitDialog pleaseWaitDialog = this;
                synchronized (pleaseWaitDialog) {
                    long timeout;
                    long displayTime = System.currentTimeMillis() + 400L;
                    while (!this.disposed && (timeout = displayTime - System.currentTimeMillis()) > 0L) {
                        ThreadUtil.threadWait(this, timeout);
                    }
                }
                if (!this.disposed) {
                    this.setVisible(true);
                }
            }
        } else {
            EventQueue.invokeLater(this::showAfterDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (!this.disposed) {
            if (EventQueue.isDispatchThread()) {
                System.err.println("-- THIS SHOULD BE ON A WORKER THREAD --");
                Thread.dumpStack();
            }
            PleaseWaitDialog pleaseWaitDialog = this;
            synchronized (pleaseWaitDialog) {
                this.disposed = true;
                this.notifyAll();
            }
            EventQueue.invokeLater(() -> super.dispose());
        }
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Preparing Content");
        this.setCursor(new Cursor(3));
        this.setModal(true);
        this.setPreferredSize(null);
        this.messageLabel.setText("Please wait...");
        this.messageLabel.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addComponent(this.progressBar, -1, 513, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 23, -2).addContainerGap()));
    }
}

