/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;

public class WideButtonsDialog
extends JDialog {
    private JButton[] buttons;
    private int buttonIndex = -1;
    private JLabel questionLabel;

    public WideButtonsDialog(Window parent, String question, String title, String ... buttonTexts) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.setQuestion(question);
        this.setTitle(title);
        this.setButtons(buttonTexts);
    }

    public int getButtonIndex() {
        return this.buttonIndex;
    }

    private void closeDialog() {
        this.dispose();
    }

    private void setButtonIndex(int buttonIndex) {
        this.buttonIndex = buttonIndex;
        this.closeDialog();
    }

    public final void setQuestion(String question) {
        if (!question.toLowerCase().trim().startsWith("<html>")) {
            question = "<html>" + question + "</html>";
        }
        this.questionLabel.setText(question);
        this.questionLabel.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public final void setButtons(String ... buttonTexts) {
        this.buttons = new JButton[buttonTexts.length];
        int i = this.buttons.length - 1;
        while (i >= 0) {
            JButton button = this.buttons[i] = new JButton(buttonTexts[i]);
            button.setMaximumSize(null);
            button.setMinimumSize(null);
            button.setPreferredSize(null);
            button.setFocusPainted(false);
            int index = i--;
            button.addActionListener(e -> this.setButtonIndex(index));
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.questionLabel, -1, -1, Short.MAX_VALUE);
        GroupLayout.SequentialGroup sequentialGroup = layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.questionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        for (JButton button : this.buttons) {
            horizontalGroup = horizontalGroup.addComponent(button, -1, -1, Short.MAX_VALUE);
            sequentialGroup = sequentialGroup.addComponent(button, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        sequentialGroup = sequentialGroup.addGap(15, 15, 15);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(horizontalGroup).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequentialGroup));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.questionLabel = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WideButtonsDialog.this.formWindowClosing(evt);
            }
        });
        this.questionLabel.setText(" ");
        this.questionLabel.setIconTextGap(16);
        this.questionLabel.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.questionLabel, -1, -1, Short.MAX_VALUE).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.questionLabel, -2, -1, -2).addGap(15, 15, 15)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

