/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.archive;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import javax.swing.JTextField;
import javax.swing.UIManager;
import nintaco.util.StringUtil;

public class SearchTextField
extends JTextField
implements FocusListener {
    public SearchTextField() {
        this.addFocusListener(this);
    }

    @Override
    protected void paintComponent(Graphics G) {
        super.paintComponent(G);
        if (!this.hasFocus() && StringUtil.isBlank(this.getText())) {
            Graphics2D g = (Graphics2D)G;
            Color color = g.getColor();
            Font font = g.getFont();
            RenderingHints hints = g.getRenderingHints();
            AffineTransform transform = g.getTransform();
            g.setFont(this.getFont());
            g.setColor(UIManager.getColor("textInactiveText"));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Insets insets = this.getInsets();
            int ascent = g.getFontMetrics().getAscent();
            double scale = ((double)this.getHeight() - 1.25 * (double)(insets.top + insets.bottom)) / 13.0;
            int y = insets.top + (this.getHeight() - insets.top - insets.bottom - g.getFontMetrics().getHeight()) / 2;
            g.drawString("Search", insets.left + (int)(19.0 * scale), y + ascent);
            g.translate(1.25 * (double)insets.left, 1.25 * (double)insets.top);
            g.scale(scale, scale);
            g.setStroke(new BasicStroke(2.0f));
            g.drawOval(0, 0, 10, 10);
            g.drawLine(9, 9, 13, 13);
            g.setTransform(transform);
            g.setFont(font);
            g.setRenderingHints(hints);
            g.setColor(color);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }
}

