/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.cheats;

import nintaco.cheats.Cheat;
import nintaco.cheats.GameGenie;
import nintaco.cheats.ProActionRocky;
import nintaco.gui.cheats.CheatsTableModel;
import nintaco.util.StringUtil;

public final class CheatRow {
    private final String[] values = new String[CheatsTableModel.COLUMN_NAMES.length];
    private Cheat cheat;
    private boolean showHex;

    public CheatRow(CheatRow cheatRow) {
        this(cheatRow.getCheat());
    }

    public CheatRow(Cheat cheat) {
        this.cheat = new Cheat(cheat);
        this.update(false);
    }

    public String[] getValues() {
        return this.values;
    }

    public Cheat getCheat() {
        return this.cheat;
    }

    public boolean isShowHex() {
        return this.showHex;
    }

    public void update(boolean showHex) {
        this.setShowHex(showHex);
        this.values[5] = StringUtil.replaceBlank(GameGenie.convert(this.cheat), "-");
        this.values[6] = StringUtil.replaceBlank(ProActionRocky.convert(this.cheat), "-");
    }

    public void setShowHex(boolean showHex) {
        this.showHex = showHex;
        this.values[2] = String.format("$%04X", this.cheat.getAddress());
        this.values[3] = this.getByteString(showHex, this.cheat.getDataValue());
        this.values[4] = this.cheat.hasCompareValue() ? this.getByteString(showHex, this.cheat.getCompareValue()) : "-";
    }

    private String getByteString(boolean showHex, int value) {
        return showHex ? String.format("$%02X", value) : Integer.toString(value);
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.cheat.isEnabled();
            }
            case 1: {
                return this.cheat.getDescription();
            }
        }
        return this.values[columnIndex];
    }

    private void updateCheat(Cheat c) {
        if (c != null) {
            c.setEnabled(this.cheat.isEnabled());
            c.setDescription(this.cheat.getDescription());
            this.cheat = c;
            this.update(this.showHex);
        }
    }

    public void setValueAt(Object value, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.cheat.setEnabled((Boolean)value);
                break;
            }
            case 1: {
                String description = ((String)value).trim();
                if (StringUtil.isBlank(description)) {
                    this.cheat.generateDescription();
                    break;
                }
                this.cheat.setDescription(description);
                break;
            }
            case 2: {
                int v = StringUtil.parseInt(value, true, 65535L);
                if (v < 0) break;
                this.cheat.setAddress(v);
                this.update(this.showHex);
                break;
            }
            case 3: {
                int v = StringUtil.parseInt(value, this.showHex, 255L);
                if (v < 0) break;
                this.cheat.setDataValue(v);
                this.update(this.showHex);
                break;
            }
            case 4: {
                this.cheat.setCompareValue(StringUtil.parseInt(value, this.showHex, 255L));
                this.update(this.showHex);
                break;
            }
            case 5: {
                String newCode = ((String)value).trim();
                if (newCode.equals(this.values[5])) break;
                this.updateCheat(GameGenie.convert(newCode));
                break;
            }
            case 6: {
                String newCode = ((String)value).trim();
                if (newCode.equals(this.values[6])) break;
                this.updateCheat(ProActionRocky.convert((String)value));
                break;
            }
        }
    }
}

