/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import nintaco.App;
import nintaco.Breakpoint;
import nintaco.CPU;
import nintaco.MachineRunner;
import nintaco.PPU;
import nintaco.PauseStepType;
import nintaco.disassembler.AddressLabel;
import nintaco.disassembler.AddressTextRange;
import nintaco.disassembler.Disassembler;
import nintaco.disassembler.Instruction;
import nintaco.gui.MetricsTextArea;
import nintaco.gui.asmdasm.AsmDasmFrame;
import nintaco.gui.debugger.DebuggerAppPrefs;
import nintaco.gui.debugger.addresslabel.AddressLabelDialog;
import nintaco.gui.debugger.breakpoint.BreakpointDialog;
import nintaco.gui.debugger.logger.LoggerDialog;
import nintaco.gui.image.ImageFrame;
import nintaco.gui.image.QuickSaveListener;
import nintaco.gui.image.QuickSaveStateInfo;
import nintaco.mappers.Mapper;
import nintaco.preferences.AppPrefs;
import nintaco.preferences.GamePrefs;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class DebuggerFrame
extends JFrame {
    private final AdjustmentListener adjustmentListener;
    private final ImageFrame imageFrame;
    private final QuickSaveListener quickSaveListener = this::onQuickSaveChanged;
    private volatile MachineRunner machineRunner;
    private volatile CPU cpu;
    private volatile PPU ppu;
    private volatile Mapper mapper;
    private volatile boolean textAreaRefreshRequested;
    private volatile List<Instruction> instructions = new ArrayList<Instruction>();
    private volatile int pcValue;
    private volatile int aValue;
    private volatile int xValue;
    private volatile int yValue;
    private volatile int sValue;
    private volatile int ppuVValue;
    private volatile int ppuTValue;
    private volatile int ppuXValue;
    private volatile int cameraXValue;
    private volatile int cameraYValue;
    private volatile boolean nValue;
    private volatile boolean vValue;
    private volatile boolean dValue;
    private volatile boolean iValue;
    private volatile boolean zValue;
    private volatile boolean cValue;
    private volatile boolean ppuWValue;
    private volatile boolean sprite0Value;
    private volatile boolean valuesAcquired;
    private volatile boolean pcModified;
    private volatile boolean aModified;
    private volatile boolean xModified;
    private volatile boolean yModified;
    private volatile boolean sModified;
    private volatile boolean nModified;
    private volatile boolean vModified;
    private volatile boolean dModified;
    private volatile boolean iModified;
    private volatile boolean zModified;
    private volatile boolean cModified;
    private volatile boolean ppuVModified;
    private volatile boolean ppuTModified;
    private volatile boolean ppuXModified;
    private volatile boolean ppuWModified;
    private volatile boolean cameraXModified;
    private volatile boolean cameraYModified;
    private volatile boolean sprite0Modified;
    private volatile boolean officialsOnly = true;
    private int visibleLines = -1;
    private int scrollValue;
    private AddressTextRange lastRange;
    private List<QuickSaveStateInfo> quickSaveStateInfos;
    private JLabel aLabel;
    private JTextField aTextField;
    private JMenuItem addBreakpointMenuItem;
    private JMenuItem addressLabelMenuItem;
    private JComboBox addressTypeComboBox;
    private JButton assemblerButton;
    private JComboBox bookmarksComboBox;
    private JLabel bookmarksLabel;
    private JComboBox branchesComboBox;
    private JButton breakpointsButton;
    private JButton brkButton;
    private JCheckBox cCheckBox;
    private JLabel cameraXNameLabel;
    private JTextField cameraXTextField;
    private JLabel cameraYNameLabel;
    private JTextField cameraYTextField;
    private JButton closeButton;
    private JButton configLoggerButton;
    private JMenuItem copyMenuItem;
    private JCheckBox dCheckBox;
    private JPopupMenu debugPopupMenu;
    private JScrollPane debugScrollPane;
    private JTextArea debugTextArea;
    private JButton defaultsButton;
    private JButton dotButton;
    private JLabel dotLabel;
    private JLabel dotNameLabel;
    private JTextField dotTextField;
    private JMenuItem hexEditorMenuItem;
    private JCheckBox iCheckBox;
    private JCheckBox inspectionsCheckBox;
    private JButton instructionsButton;
    private JTextField instructionsTextField;
    private JButton irqButton;
    private JCheckBox labelsCheckBox;
    private JButton loadButton;
    private JToggleButton loggerToggleButton;
    private JCheckBox machineCodeCheckBox;
    private JButton manageAddressLabelsButton;
    private JCheckBox nCheckBox;
    private JButton nextFrameButton;
    private JButton nmiButton;
    private JButton opcodeButton;
    private JTextField opcodeTextField;
    private JCheckBox pcCheckBox;
    private JLabel pcLabel;
    private JTextField pcTextField;
    private JLabel ppu2002Label;
    private JLabel ppu2002NameLabel;
    private JLabel ppu2004Label;
    private JLabel ppu2004NameLabel;
    private JLabel ppu2007Label;
    private JLabel ppu2007NameLabel;
    private JLabel ppuTNameLabel;
    private JTextField ppuTTextField;
    private JLabel ppuVNameLabel;
    private JTextField ppuVTextField;
    private JCheckBox ppuWCheckBox;
    private JLabel ppuXNameLabel;
    private JTextField ppuXTextField;
    private JButton rstButton;
    private JLabel sLabel;
    private JTextField sTextField;
    private JButton saveButton;
    private JComboBox saveSlotComboBox;
    private JLabel saveSlotLabel;
    private JButton scanlineButton;
    private JLabel scanlineLabel;
    private JLabel scanlineNameLabel;
    private JTextField scanlineTextField;
    private JScrollBar scrollBar;
    private JButton seekPcButton;
    private JButton seekToButton;
    private JMenuItem seekToMenuItem;
    private JTextField seekToTextField;
    private JMenuItem selectAllMenuItem;
    private JPopupMenu.Separator separator1;
    private JCheckBox sprite0CheckBox;
    private JButton sprite0HitButton;
    private JScrollPane stackScrollPane;
    private JTextArea stackTextArea;
    private JButton stepIntoButton;
    private JButton stepOutButton;
    private JButton stepOverButton;
    private JButton stepToButton;
    private JMenuItem stepToMenuItem;
    private JTextField stepToTextField;
    private JToggleButton suspendToggleButton;
    private JCheckBox unofficialOpcodesCheckBox;
    private JCheckBox vCheckBox;
    private JLabel xLabel;
    private JTextField xTextField;
    private JLabel yLabel;
    private JTextField yTextField;
    private JCheckBox zCheckBox;

    public DebuggerFrame(MachineRunner machineRunner) {
        this.initComponents();
        this.initTextComponents();
        this.imageFrame = App.getImageFrame();
        this.imageFrame.addQuickSaveListener(this.quickSaveListener);
        this.adjustmentListener = e -> this.onScrollBarAdjusted();
        this.scrollBar.addAdjustmentListener(this.adjustmentListener);
        this.loadFields();
        this.setMachineRunner(machineRunner);
        GuiUtil.scaleFonts(this);
        GuiUtil.setTextAreaSize(this.debugTextArea, 50, 72);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
    }

    private void initTextComponents() {
        this.debugTextArea.setCursor(new Cursor(2));
        GuiUtil.makeMonospaced(this.stackTextArea);
        GuiUtil.makeMonospaced(this.debugTextArea);
        GuiUtil.makeMonospaced(this.scanlineLabel);
        GuiUtil.makeMonospaced(this.dotLabel);
        GuiUtil.makeMonospaced(this.ppu2002Label);
        GuiUtil.makeMonospaced(this.ppu2004Label);
        GuiUtil.makeMonospaced(this.ppu2007Label);
        GuiUtil.addLoseFocusListener((Window)this, this.seekToTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.stepToTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.scanlineTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.dotTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.opcodeTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.instructionsTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.pcTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.aTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.xTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.yTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.sTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.ppuVTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.ppuTTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.ppuXTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.cameraXTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.cameraYTextField);
    }

    public void refreshAddressLabels() {
        this.initAddressLabels();
        this.requestTextAreaRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAddressLabels() {
        HashMap<Integer, AddressLabel> codeLabels = new HashMap<Integer, AddressLabel>();
        DefaultComboBoxModel<AddressLabel> model = new DefaultComboBoxModel<AddressLabel>();
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            for (AddressLabel label : GamePrefs.getInstance().getDebuggerGamePrefs().getAddressLabels()) {
                if (label.isCode()) {
                    codeLabels.put(label.getKey(), label);
                }
                if (!label.isBookmark()) continue;
                model.addElement(label);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Disassembler.setLabels(codeLabels);
            this.bookmarksComboBox.setModel(model);
            this.updateBookmarksComboBox();
            return;
        }
    }

    private void updateBookmarksComboBox() {
        boolean enabled = this.machineRunner != null && this.bookmarksComboBox.getModel().getSize() > 0;
        this.bookmarksComboBox.setEnabled(enabled);
        this.bookmarksLabel.setEnabled(enabled);
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getDebuggerAppPrefs());
    }

    private void loadFields(DebuggerAppPrefs prefs) {
        this.addressTypeComboBox.setSelectedIndex(prefs.getAddressType());
        this.branchesComboBox.setSelectedIndex(prefs.getBranchesType());
        this.pcCheckBox.setSelected(prefs.isShowPC());
        this.inspectionsCheckBox.setSelected(prefs.isShowInspections());
        this.labelsCheckBox.setSelected(prefs.isShowAddressLabels());
        this.machineCodeCheckBox.setSelected(prefs.isShowMachineCode());
        this.unofficialOpcodesCheckBox.setSelected(prefs.isShowUnofficialOpcodes());
    }

    private void saveFields() {
        DebuggerAppPrefs prefs = AppPrefs.getInstance().getDebuggerAppPrefs();
        prefs.setAddressType(this.addressTypeComboBox.getSelectedIndex());
        prefs.setBranchesType(this.branchesComboBox.getSelectedIndex());
        prefs.setShowPC(this.pcCheckBox.isSelected());
        prefs.setShowInspections(this.inspectionsCheckBox.isSelected());
        prefs.setShowAddressLabels(this.labelsCheckBox.isSelected());
        prefs.setShowMachineCode(this.machineCodeCheckBox.isSelected());
        prefs.setShowUnofficialOpcodes(this.unofficialOpcodesCheckBox.isSelected());
        AppPrefs.save();
    }

    public void destroy() {
        App.disposeTraceLogger();
        this.imageFrame.removeQuickSaveListener(this.quickSaveListener);
        this.saveFields();
        this.dispose();
        App.setBreakpoints(null);
        App.setStepPause(false);
    }

    private void closeFrame() {
        App.destroyDebuggerFrame();
    }

    public void update() {
        if (this.textAreaRefreshRequested) {
            this.textAreaRefreshRequested = false;
            this.refreshDebugTextArea(false);
        }
    }

    public final void setMachineRunner(MachineRunner machineRunner) {
        App.disposeTraceLogger();
        this.machineRunner = machineRunner;
        if (machineRunner == null) {
            this.cpu = null;
            this.ppu = null;
            this.mapper = null;
        } else {
            this.cpu = machineRunner.getCPU();
            this.ppu = machineRunner.getPPU();
            this.mapper = machineRunner.getMapper();
            this.applyBreakpoints();
            this.requestTextAreaRefresh();
        }
        this.initAddressLabels();
        EventQueue.invokeLater(this::enableComponents);
    }

    private void updateVisibleLines() {
        int lines = ((MetricsTextArea)this.debugTextArea).getVisibleLines();
        if (lines != this.visibleLines) {
            this.visibleLines = lines;
            this.requestTextAreaRefresh();
        }
    }

    private void updateFields(int address, int nextScanline, int nextScanlineCycle, int scanline, int scanlineCycle, int ppu2002, int ppu2004, int ppu2007) {
        if (EventQueue.isDispatchThread()) {
            this.stepToTextField.setText(String.format("%04X", address));
            this.scanlineTextField.setText(Integer.toString(nextScanline));
            this.dotTextField.setText(Integer.toString(nextScanlineCycle));
            this.scanlineLabel.setText(String.format("%3d", scanline));
            this.dotLabel.setText(String.format("%3d", scanlineCycle));
            this.ppu2002Label.setText(String.format("%02X", ppu2002));
            this.ppu2004Label.setText(String.format("%02X", ppu2004));
            this.ppu2007Label.setText(String.format("%02X", ppu2007));
        } else {
            EventQueue.invokeLater(() -> this.updateFields(address, nextScanline, nextScanlineCycle, scanline, scanlineCycle, ppu2002, ppu2004, ppu2007));
        }
    }

    private void updateStackTextArea() {
        CPU c = this.cpu;
        if (c == null) {
            return;
        }
        Mapper m = this.mapper;
        if (m == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int s = c.getS(); s <= 255; ++s) {
            sb.append(String.format("%02X ", m.peekCpuMemory(0x100 | s)));
        }
        EventQueue.invokeLater(() -> this.stackTextArea.setText(sb.toString()));
    }

    private void acquireFields() {
        this.acquirePC(false);
        this.acquireA(false);
        this.acquireX(false);
        this.acquireY(false);
        this.acquireS(false);
        boolean n = this.nCheckBox.isSelected();
        boolean bl = this.nModified = this.valuesAcquired && this.nValue != n;
        if (this.nModified) {
            this.nValue = n;
        }
        boolean v = this.vCheckBox.isSelected();
        boolean bl2 = this.vModified = this.valuesAcquired && this.vValue != v;
        if (this.vModified) {
            this.vValue = v;
        }
        boolean d = this.dCheckBox.isSelected();
        boolean bl3 = this.dModified = this.valuesAcquired && this.dValue != d;
        if (this.dModified) {
            this.dValue = d;
        }
        boolean i = this.iCheckBox.isSelected();
        boolean bl4 = this.iModified = this.valuesAcquired && this.iValue != i;
        if (this.iModified) {
            this.iValue = i;
        }
        boolean z = this.zCheckBox.isSelected();
        boolean bl5 = this.zModified = this.valuesAcquired && this.zValue != z;
        if (this.zModified) {
            this.zValue = z;
        }
        boolean c = this.cCheckBox.isSelected();
        boolean bl6 = this.cModified = this.valuesAcquired && this.cValue != c;
        if (this.cModified) {
            this.cValue = c;
        }
    }

    private void assignFields() {
        if (this.pcValue >= 0 && this.pcValue <= 65535) {
            this.pcTextField.setText(String.format("%04X", this.pcValue));
        }
        if (this.aValue >= 0 && this.aValue <= 255) {
            this.aTextField.setText(String.format("%02X", this.aValue));
        }
        if (this.xValue >= 0 && this.xValue <= 255) {
            this.xTextField.setText(String.format("%02X", this.xValue));
        }
        if (this.yValue >= 0 && this.yValue <= 255) {
            this.yTextField.setText(String.format("%02X", this.yValue));
        }
        if (this.sValue >= 0 && this.sValue <= 255) {
            this.sTextField.setText(String.format("%02X", this.sValue));
        }
        if (this.ppuVValue >= 0 && this.ppuVValue <= Short.MAX_VALUE) {
            this.ppuVTextField.setText(String.format("%04X", this.ppuVValue));
        }
        if (this.ppuTValue >= 0 && this.ppuTValue <= Short.MAX_VALUE) {
            this.ppuTTextField.setText(String.format("%04X", this.ppuTValue));
        }
        if (this.ppuXValue >= 0 && this.ppuXValue <= 7) {
            this.ppuXTextField.setText(String.format("%X", this.ppuXValue));
        }
        if (this.cameraXValue >= 0 && this.cameraXValue <= 511) {
            this.cameraXTextField.setText(Integer.toString(this.cameraXValue));
        }
        if (this.cameraYValue >= 0 && this.cameraYValue <= 511) {
            this.cameraYTextField.setText(Integer.toString(this.cameraYValue));
        }
        this.nCheckBox.setSelected(this.nValue);
        this.vCheckBox.setSelected(this.vValue);
        this.dCheckBox.setSelected(this.dValue);
        this.iCheckBox.setSelected(this.iValue);
        this.zCheckBox.setSelected(this.zValue);
        this.cCheckBox.setSelected(this.cValue);
        this.ppuWCheckBox.setSelected(this.ppuWValue);
        this.sprite0CheckBox.setSelected(this.sprite0Value);
    }

    private void requestTextAreaRefresh() {
        this.lastRange = null;
        MachineRunner r = this.machineRunner;
        if (r != null && r.isPaused()) {
            this.refreshDebugTextArea(false);
        } else {
            this.textAreaRefreshRequested = true;
        }
    }

    private void refreshDebugTextArea(boolean scrollToPC) {
        CPU c = this.cpu;
        if (c == null) {
            return;
        }
        Mapper m = this.mapper;
        if (m == null) {
            return;
        }
        int PC = c.getPC();
        int pcLine = -1;
        this.instructions = Disassembler.disassemble(c, this.scrollValue, 0, this.visibleLines, this.officialsOnly);
        StringBuilder sb = new StringBuilder();
        int line = 0;
        int indexOfLastVisibleInstruction = 0;
        if (!this.instructions.isEmpty()) {
            Instruction inst = this.instructions.get(0);
            inst.setStart(0);
            inst.setEnd(inst.getDescription().length());
            inst.setLine((line += inst.getDescriptionLines()) - 1);
            sb.append(inst.getDescription());
            if (inst.getAddress() == PC) {
                pcLine = inst.getLine();
            }
            for (int i = 1; i < this.instructions.size(); ++i) {
                AddressTextRange range;
                sb.append('\n');
                inst = this.instructions.get(i);
                inst.setStart(sb.length());
                inst.setEnd(sb.length() + inst.getDescription().length());
                inst.setLine((line += inst.getDescriptionLines()) - 1);
                if (inst.getLine() < this.visibleLines) {
                    indexOfLastVisibleInstruction = i;
                }
                if (inst.getAddress() == PC) {
                    pcLine = inst.getLine();
                }
                AddressTextRange[] ranges = inst.getRanges();
                for (int j = 0; j < ranges.length && (range = ranges[j]) != null; ++j) {
                    range.setStart(range.getStart() + sb.length());
                    range.setEnd(range.getEnd() + sb.length());
                }
                sb.append(inst.getDescription());
            }
        }
        if (scrollToPC) {
            if (pcLine >= indexOfLastVisibleInstruction - 1) {
                if (pcLine == indexOfLastVisibleInstruction) {
                    EventQueue.invokeLater(this::onScrollDown);
                }
                EventQueue.invokeLater(this::onScrollDown);
            } else if (pcLine < 0) {
                this.scrollValue = Disassembler.getPriorAddress(m, PC, this.officialsOnly);
                EventQueue.invokeLater(() -> this.setScrollBarValue(this.scrollValue));
                this.refreshDebugTextArea(false);
            } else {
                this.updateDebugTextArea(sb.toString());
            }
        } else {
            this.updateDebugTextArea(sb.toString());
        }
    }

    private void updateDebugTextArea(String text) {
        if (EventQueue.isDispatchThread()) {
            this.lastRange = null;
            this.debugTextArea.setText(text);
            this.debugTextArea.setCaretPosition(0);
        } else {
            EventQueue.invokeLater(() -> this.updateDebugTextArea(text));
        }
    }

    private void onScrollBarAdjusted() {
        int value = this.scrollBar.getValue();
        if (value == this.scrollValue - 1) {
            this.onScrollUp();
        } else if (value == this.scrollValue + 1) {
            this.onScrollDown();
        } else {
            this.onScroll(value);
        }
    }

    private void onScrollUp() {
        Mapper m = this.mapper;
        if (m != null) {
            this.setScrollBarValue(Disassembler.getPriorAddress(m, this.scrollValue, this.officialsOnly));
            this.requestTextAreaRefresh();
        }
    }

    private void onScrollDown() {
        Mapper m = this.mapper;
        if (m != null) {
            this.setScrollBarValue(Disassembler.getSuccessiveAddress(m, this.scrollValue, this.officialsOnly));
            this.requestTextAreaRefresh();
        }
    }

    private void onScroll(int value) {
        Mapper m = this.mapper;
        if (m != null) {
            this.setScrollBarValue(Disassembler.getNearestAddress(m, value, this.officialsOnly));
            this.requestTextAreaRefresh();
        }
    }

    private void setScrollBarValue(int value) {
        this.scrollValue = value;
        this.scrollBar.removeAdjustmentListener(this.adjustmentListener);
        this.scrollBar.setValue(value);
        this.scrollBar.addAdjustmentListener(this.adjustmentListener);
    }

    private void enableComponents() {
        MachineRunner r = this.machineRunner;
        boolean machineRunnerAvailable = r != null;
        boolean enabled = machineRunnerAvailable && r.isPaused();
        this.assemblerButton.setEnabled(machineRunnerAvailable);
        this.seekToButton.setEnabled(machineRunnerAvailable);
        this.seekToTextField.setEnabled(machineRunnerAvailable);
        this.suspendToggleButton.setSelected(enabled);
        this.suspendToggleButton.setEnabled(machineRunnerAvailable);
        this.suspendToggleButton.setText(enabled ? "Resume" : "Pause");
        this.stepIntoButton.setEnabled(enabled);
        this.stepOutButton.setEnabled(enabled);
        this.stepOverButton.setEnabled(enabled);
        this.stepToButton.setEnabled(enabled);
        this.stepToTextField.setEnabled(enabled);
        this.seekPcButton.setEnabled(enabled);
        this.nextFrameButton.setEnabled(enabled);
        this.scanlineButton.setEnabled(enabled);
        this.scanlineTextField.setEnabled(enabled);
        this.scanlineNameLabel.setEnabled(enabled);
        this.scanlineLabel.setEnabled(enabled);
        this.dotNameLabel.setEnabled(enabled);
        this.dotLabel.setEnabled(enabled);
        this.dotButton.setEnabled(enabled);
        this.dotTextField.setEnabled(enabled);
        this.sprite0HitButton.setEnabled(enabled);
        this.opcodeButton.setEnabled(enabled);
        this.opcodeTextField.setEnabled(enabled);
        this.instructionsButton.setEnabled(enabled);
        this.instructionsTextField.setEnabled(enabled);
        this.irqButton.setEnabled(enabled);
        this.nmiButton.setEnabled(enabled);
        this.brkButton.setEnabled(enabled);
        this.rstButton.setEnabled(enabled);
        this.manageAddressLabelsButton.setEnabled(machineRunnerAvailable);
        this.breakpointsButton.setEnabled(machineRunnerAvailable);
        this.pcLabel.setEnabled(enabled);
        this.pcTextField.setEnabled(enabled);
        this.aLabel.setEnabled(enabled);
        this.aTextField.setEnabled(enabled);
        this.xLabel.setEnabled(enabled);
        this.xTextField.setEnabled(enabled);
        this.yLabel.setEnabled(enabled);
        this.yTextField.setEnabled(enabled);
        this.sLabel.setEnabled(enabled);
        this.sTextField.setEnabled(enabled);
        this.nCheckBox.setEnabled(enabled);
        this.vCheckBox.setEnabled(enabled);
        this.dCheckBox.setEnabled(enabled);
        this.iCheckBox.setEnabled(enabled);
        this.zCheckBox.setEnabled(enabled);
        this.cCheckBox.setEnabled(enabled);
        this.stackTextArea.setEnabled(enabled);
        this.ppu2002NameLabel.setEnabled(enabled);
        this.ppu2002Label.setEnabled(enabled);
        this.ppu2004NameLabel.setEnabled(enabled);
        this.ppu2004Label.setEnabled(enabled);
        this.ppu2007NameLabel.setEnabled(enabled);
        this.ppu2007Label.setEnabled(enabled);
        this.ppuVNameLabel.setEnabled(enabled);
        this.ppuVTextField.setEnabled(enabled);
        this.ppuTNameLabel.setEnabled(enabled);
        this.ppuTTextField.setEnabled(enabled);
        this.ppuXNameLabel.setEnabled(enabled);
        this.ppuXTextField.setEnabled(enabled);
        this.ppuWCheckBox.setEnabled(enabled);
        this.sprite0CheckBox.setEnabled(enabled);
        this.cameraXNameLabel.setEnabled(enabled);
        this.cameraXTextField.setEnabled(enabled);
        this.cameraYNameLabel.setEnabled(enabled);
        this.cameraYTextField.setEnabled(enabled);
        this.updateBookmarksComboBox();
        this.saveButton.setEnabled(machineRunnerAvailable);
        this.saveSlotLabel.setEnabled(machineRunnerAvailable);
        this.saveSlotComboBox.setEnabled(machineRunnerAvailable);
        this.updateLoadButton();
        this.updateLoggerButton();
        this.configLoggerButton.setEnabled(machineRunnerAvailable);
        this.scrollBar.setEnabled(machineRunnerAvailable);
        if (!machineRunnerAvailable) {
            this.debugTextArea.setText("");
        }
    }

    private int parseSeekToTextField() {
        return StringUtil.parseInt(this.seekToTextField.getText(), true, 65535L);
    }

    private Integer parseScanlineTextField() {
        PPU p = this.ppu;
        if (p == null) {
            return null;
        }
        Integer result = StringUtil.parseInt(this.scanlineTextField.getText(), false, -1L, p.getScanlineCount() - 1);
        return result != null && result == p.getScanlineCount() - 1 ? -1 : result;
    }

    private int parseDotTextField() {
        return StringUtil.parseInt(this.dotTextField.getText(), false, 340L);
    }

    private int parseOpcodeTextField() {
        return StringUtil.parseInt(this.opcodeTextField.getText(), true, 255L);
    }

    private int parseInstructionsTextField() {
        return StringUtil.parseInt(this.instructionsTextField.getText(), false, Integer.MAX_VALUE);
    }

    private void acquirePC(boolean clean) {
        int pc = StringUtil.parseInt(this.pcTextField.getText(), true, 65535L);
        if (pc < 0) {
            if (clean && this.valuesAcquired && this.pcValue >= 0 && this.pcValue <= 65535) {
                this.pcTextField.setText(String.format("%04X", this.pcValue));
            }
        } else {
            this.pcModified |= this.valuesAcquired && this.pcValue != pc;
            if (this.pcModified) {
                this.pcValue = pc;
            }
        }
    }

    private void acquireA(boolean clean) {
        int a = StringUtil.parseInt(this.aTextField.getText(), true, 255L);
        if (a < 0) {
            if (clean && this.valuesAcquired && this.aValue >= 0 && this.aValue <= 255) {
                this.aTextField.setText(String.format("%02X", this.aValue));
            }
        } else {
            this.aModified |= this.valuesAcquired && this.aValue != a;
            if (this.aModified) {
                this.aValue = a;
            }
        }
    }

    private void acquireX(boolean clean) {
        int x = StringUtil.parseInt(this.xTextField.getText(), true, 255L);
        if (x < 0) {
            if (clean && this.valuesAcquired && this.xValue >= 0 && this.xValue <= 255) {
                this.xTextField.setText(String.format("%02X", this.xValue));
            }
        } else {
            this.xModified |= this.valuesAcquired && this.xValue != x;
            if (this.xModified) {
                this.xValue = x;
            }
        }
    }

    private void acquireY(boolean clean) {
        int y = StringUtil.parseInt(this.yTextField.getText(), true, 255L);
        if (y < 0) {
            if (clean && this.valuesAcquired && this.yValue >= 0 && this.yValue <= 255) {
                this.yTextField.setText(String.format("%02X", this.yValue));
            }
        } else {
            this.yModified |= this.valuesAcquired && this.yValue != y;
            if (this.yModified) {
                this.yValue = y;
            }
        }
    }

    private void acquireS(boolean clean) {
        int s = StringUtil.parseInt(this.sTextField.getText(), true, 255L);
        if (s < 0) {
            if (clean && this.valuesAcquired && this.sValue >= 0 && this.sValue <= 255) {
                this.sTextField.setText(String.format("%02X", this.sValue));
            }
        } else {
            this.sModified |= this.valuesAcquired && this.sValue != s;
            if (this.sModified) {
                this.sValue = s;
            }
        }
    }

    private void acquirePpuV(boolean clean) {
        int v = StringUtil.parseInt(this.ppuVTextField.getText(), true, 255L);
        if (v < 0) {
            if (clean && this.valuesAcquired && this.ppuVValue >= 0 && this.ppuVValue <= Short.MAX_VALUE) {
                this.ppuVTextField.setText(String.format("%04X", this.ppuVValue));
            }
        } else {
            this.ppuVModified |= this.valuesAcquired && this.ppuVValue != v;
            if (this.ppuVModified) {
                this.ppuVValue = v;
            }
        }
    }

    private void acquirePpuT(boolean clean) {
        int t = StringUtil.parseInt(this.ppuTTextField.getText(), true, 255L);
        if (t < 0) {
            if (clean && this.valuesAcquired && this.ppuTValue >= 0 && this.ppuTValue <= Short.MAX_VALUE) {
                this.ppuTTextField.setText(String.format("%04X", this.ppuTValue));
            }
        } else {
            this.ppuTModified |= this.valuesAcquired && this.ppuTValue != t;
            if (this.ppuTModified) {
                this.ppuTValue = t;
            }
        }
    }

    private void acquirePpuX(boolean clean) {
        int x = StringUtil.parseInt(this.ppuXTextField.getText(), true, 255L);
        if (x < 0) {
            if (clean && this.valuesAcquired && this.ppuXValue >= 0 && this.ppuXValue <= 7) {
                this.ppuXTextField.setText(String.format("%X", this.ppuXValue));
            }
        } else {
            this.ppuXModified |= this.valuesAcquired && this.ppuXValue != x;
            if (this.ppuXModified) {
                this.ppuXValue = x;
            }
        }
    }

    private void acquireCameraX(boolean clean) {
        int cameraX = StringUtil.parseInt(this.cameraXTextField.getText(), true, 255L);
        if (cameraX < 0) {
            if (clean && this.valuesAcquired && this.cameraXValue >= 0 && this.cameraXValue <= 511) {
                this.cameraXTextField.setText(String.format("%d", this.cameraXValue));
            }
        } else {
            this.cameraXModified |= this.valuesAcquired && this.cameraXValue != cameraX;
            if (this.cameraXModified) {
                this.cameraXValue = cameraX;
            }
        }
    }

    private void acquireCameraY(boolean clean) {
        int cameraY = StringUtil.parseInt(this.cameraYTextField.getText(), true, 255L);
        if (cameraY < 0) {
            if (clean && this.valuesAcquired && this.cameraYValue >= 0 && this.cameraYValue <= 511) {
                this.cameraYTextField.setText(String.format("%d", this.cameraYValue));
            }
        } else {
            this.cameraYModified |= this.valuesAcquired && this.cameraYValue != cameraY;
            if (this.cameraYModified) {
                this.cameraYValue = cameraY;
            }
        }
    }

    public void onPausedChanged(boolean paused) {
        CPU c = this.cpu;
        PPU p = this.ppu;
        Mapper m = this.mapper;
        if (c != null && p != null && m != null) {
            this.refreshDebugTextArea(paused);
            if (paused) {
                this.updateStackTextArea();
                this.pcValue = c.getPC();
                this.aValue = c.getA();
                this.xValue = c.getX();
                this.yValue = c.getY();
                this.sValue = c.getS();
                this.nValue = c.getN() == 1;
                this.vValue = c.getV() == 1;
                this.dValue = c.getD() == 1;
                this.iValue = c.getI() == 1;
                this.zValue = c.getZ() == 1;
                this.cValue = c.getC() == 1;
                this.ppuVValue = p.getV();
                this.ppuTValue = p.getT();
                this.ppuXValue = p.getX();
                this.ppuWValue = p.isW();
                this.sprite0Value = p.isSprite0Hit();
                this.cameraXValue = p.getScrollX();
                this.cameraYValue = p.getScrollY();
                this.valuesAcquired = true;
                EventQueue.invokeLater(this::assignFields);
                this.updateFields(Disassembler.getSuccessiveAddress(m, c.getPC(), this.officialsOnly), p.getNextScanline(), p.getNextScanlineCycle(), p.getScanline(), p.getScanlineCycle(), p.peekRegister(8194), p.peekRegister(8196), p.peekRegister(8199));
            } else {
                if (this.pcModified) {
                    this.pcModified = false;
                    c.setPC(this.pcValue);
                }
                if (this.aModified) {
                    this.aModified = false;
                    c.setA(this.aValue);
                }
                if (this.xModified) {
                    this.xModified = false;
                    c.setX(this.xValue);
                }
                if (this.yModified) {
                    this.yModified = false;
                    c.setY(this.yValue);
                }
                if (this.sModified) {
                    this.sModified = false;
                    c.setS(this.sValue);
                }
                if (this.nModified) {
                    this.nModified = false;
                    c.setN(this.nValue ? 1 : 0);
                }
                if (this.vModified) {
                    this.vModified = false;
                    c.setV(this.vValue ? 1 : 0);
                }
                if (this.dModified) {
                    this.dModified = false;
                    c.setD(this.dValue ? 1 : 0);
                }
                if (this.iModified) {
                    this.iModified = false;
                    c.setI(this.iValue ? 1 : 0);
                }
                if (this.zModified) {
                    this.zModified = false;
                    c.setZ(this.zValue ? 1 : 0);
                }
                if (this.cModified) {
                    this.cModified = false;
                    c.setC(this.cValue ? 1 : 0);
                }
                if (this.ppuVModified) {
                    this.ppuVModified = false;
                    p.setV(this.ppuVValue);
                }
                if (this.ppuTModified) {
                    this.ppuTModified = false;
                    p.setT(this.ppuTValue);
                }
                if (this.ppuXModified) {
                    this.ppuXModified = false;
                    p.setX(this.ppuXValue);
                }
                if (this.ppuWModified) {
                    this.ppuWModified = false;
                    p.setW(this.ppuWValue);
                }
                if (this.sprite0Modified) {
                    this.sprite0Modified = false;
                    p.setSprite0Hit(this.sprite0Value);
                }
                if (this.cameraXModified) {
                    this.cameraXModified = false;
                    p.setScrollX(this.cameraXValue);
                }
                if (this.cameraYModified) {
                    this.cameraYModified = false;
                    p.setScrollY(this.cameraYValue);
                }
            }
        }
        EventQueue.invokeLater(this::enableComponents);
        App.flushTraceLogger();
    }

    private void highlightAddress() {
        GuiUtil.showCursor(this.debugTextArea);
        List<Instruction> insts = this.instructions;
        if (insts != null) {
            int pos = this.debugTextArea.getCaretPosition();
            block0: for (Instruction instruction : insts) {
                if (pos < instruction.getStart() || pos > instruction.getEnd()) continue;
                for (AddressTextRange range : instruction.getRanges()) {
                    if (range == null) break;
                    if (pos < range.getStart() || pos > range.getEnd()) continue;
                    this.debugTextArea.setSelectionStart(range.getStart());
                    this.debugTextArea.setSelectionEnd(range.getEnd());
                    this.handleAddressClick(range);
                    continue block0;
                }
            }
        }
    }

    private void handleAddressClick(AddressTextRange range) {
        this.lastRange = range;
        String address = String.format("%04X", range.getAddress());
        this.seekToTextField.setText(address);
        this.stepToTextField.setText(address);
    }

    private void handlePopupTrigger(MouseEvent e) {
        if (e.isPopupTrigger()) {
            int selectionStart = this.debugTextArea.getSelectionStart();
            int selectionEnd = this.debugTextArea.getSelectionEnd();
            boolean rangeEnabled = this.lastRange != null && this.lastRange.getStart() == selectionStart && this.lastRange.getEnd() == selectionEnd;
            boolean machineRunnerAvailable = this.machineRunner != null;
            this.seekToMenuItem.setEnabled(rangeEnabled && this.seekToButton.isEnabled());
            this.stepToMenuItem.setEnabled(rangeEnabled && this.stepToButton.isEnabled());
            this.addBreakpointMenuItem.setEnabled(rangeEnabled && this.breakpointsButton.isEnabled());
            this.addressLabelMenuItem.setEnabled(rangeEnabled && this.manageAddressLabelsButton.isEnabled());
            this.hexEditorMenuItem.setEnabled(rangeEnabled && machineRunnerAvailable);
            this.copyMenuItem.setEnabled(selectionStart != selectionEnd);
            this.debugPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void applyBreakpoints() {
        App.setBreakpoints(GamePrefs.getInstance().getDebuggerGamePrefs().getBreakpoints());
    }

    private void onQuickSaveChanged(List<QuickSaveStateInfo> quickSaveStateInfos) {
        this.quickSaveStateInfos = quickSaveStateInfos;
        this.updateLoadButton();
    }

    private void updateLoadButton() {
        if (!this.saveButton.isEnabled()) {
            this.loadButton.setEnabled(false);
            return;
        }
        int index = this.saveSlotComboBox.getSelectedIndex();
        if (this.quickSaveStateInfos != null && index < this.quickSaveStateInfos.size()) {
            QuickSaveStateInfo info = this.quickSaveStateInfos.get(index);
            this.loadButton.setEnabled(info.getFile().exists());
        } else {
            this.loadButton.setEnabled(false);
        }
    }

    public void updateLoggerButton() {
        if (App.isTraceLoggerRunning()) {
            this.loggerToggleButton.setSelected(true);
            this.loggerToggleButton.setText("Stop Logger");
        } else {
            this.loggerToggleButton.setSelected(false);
            this.loggerToggleButton.setText("Start Logger");
        }
        this.loggerToggleButton.setEnabled(this.machineRunner != null);
    }

    private void initComponents() {
        this.debugPopupMenu = new JPopupMenu();
        this.copyMenuItem = new JMenuItem();
        this.selectAllMenuItem = new JMenuItem();
        this.separator1 = new JPopupMenu.Separator();
        this.seekToMenuItem = new JMenuItem();
        this.stepToMenuItem = new JMenuItem();
        this.addBreakpointMenuItem = new JMenuItem();
        this.addressLabelMenuItem = new JMenuItem();
        this.hexEditorMenuItem = new JMenuItem();
        this.stepIntoButton = new JButton();
        this.suspendToggleButton = new JToggleButton();
        this.stepOutButton = new JButton();
        this.stepOverButton = new JButton();
        this.stepToButton = new JButton();
        this.stepToTextField = new JTextField();
        this.seekToButton = new JButton();
        this.seekToTextField = new JTextField();
        this.seekPcButton = new JButton();
        this.pcLabel = new JLabel();
        this.aLabel = new JLabel();
        this.xLabel = new JLabel();
        this.yLabel = new JLabel();
        this.sLabel = new JLabel();
        this.sTextField = new JTextField();
        this.yTextField = new JTextField();
        this.xTextField = new JTextField();
        this.aTextField = new JTextField();
        this.pcTextField = new JTextField();
        this.stackScrollPane = new JScrollPane();
        this.stackTextArea = new JTextArea();
        this.nCheckBox = new JCheckBox();
        this.vCheckBox = new JCheckBox();
        this.dCheckBox = new JCheckBox();
        this.iCheckBox = new JCheckBox();
        this.zCheckBox = new JCheckBox();
        this.cCheckBox = new JCheckBox();
        this.nextFrameButton = new JButton();
        this.scanlineButton = new JButton();
        this.scanlineTextField = new JTextField();
        this.dotButton = new JButton();
        this.dotTextField = new JTextField();
        this.scanlineNameLabel = new JLabel();
        this.scanlineLabel = new JLabel();
        this.dotNameLabel = new JLabel();
        this.dotLabel = new JLabel();
        this.sprite0HitButton = new JButton();
        this.nmiButton = new JButton();
        this.irqButton = new JButton();
        this.brkButton = new JButton();
        this.rstButton = new JButton();
        this.opcodeButton = new JButton();
        this.opcodeTextField = new JTextField();
        this.scrollBar = new JScrollBar();
        this.debugScrollPane = new JScrollPane();
        this.debugTextArea = new MetricsTextArea();
        this.manageAddressLabelsButton = new JButton();
        this.bookmarksComboBox = new JComboBox();
        this.breakpointsButton = new JButton();
        this.labelsCheckBox = new JCheckBox();
        this.machineCodeCheckBox = new JCheckBox();
        this.inspectionsCheckBox = new JCheckBox();
        this.addressTypeComboBox = new JComboBox();
        this.pcCheckBox = new JCheckBox();
        this.branchesComboBox = new JComboBox();
        this.instructionsButton = new JButton();
        this.instructionsTextField = new JTextField();
        this.assemblerButton = new JButton();
        this.saveButton = new JButton();
        this.loadButton = new JButton();
        this.saveSlotLabel = new JLabel();
        this.saveSlotComboBox = new JComboBox();
        this.loggerToggleButton = new JToggleButton();
        this.configLoggerButton = new JButton();
        this.unofficialOpcodesCheckBox = new JCheckBox();
        this.ppu2002NameLabel = new JLabel();
        this.ppu2002Label = new JLabel();
        this.ppu2004NameLabel = new JLabel();
        this.ppu2004Label = new JLabel();
        this.ppu2007NameLabel = new JLabel();
        this.ppu2007Label = new JLabel();
        this.ppuVNameLabel = new JLabel();
        this.ppuVTextField = new JTextField();
        this.ppuTNameLabel = new JLabel();
        this.ppuTTextField = new JTextField();
        this.ppuXNameLabel = new JLabel();
        this.ppuXTextField = new JTextField();
        this.ppuWCheckBox = new JCheckBox();
        this.sprite0CheckBox = new JCheckBox();
        this.cameraXNameLabel = new JLabel();
        this.cameraXTextField = new JTextField();
        this.cameraYNameLabel = new JLabel();
        this.cameraYTextField = new JTextField();
        this.closeButton = new JButton();
        this.defaultsButton = new JButton();
        this.bookmarksLabel = new JLabel();
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.debugPopupMenu.add(this.copyMenuItem);
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.debugPopupMenu.add(this.selectAllMenuItem);
        this.debugPopupMenu.add(this.separator1);
        this.seekToMenuItem.setText("Seek To");
        this.seekToMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.seekToMenuItemActionPerformed(evt);
            }
        });
        this.debugPopupMenu.add(this.seekToMenuItem);
        this.stepToMenuItem.setText("Step To");
        this.stepToMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.stepToMenuItemActionPerformed(evt);
            }
        });
        this.debugPopupMenu.add(this.stepToMenuItem);
        this.addBreakpointMenuItem.setText("Breakpoint...");
        this.addBreakpointMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.addBreakpointMenuItemActionPerformed(evt);
            }
        });
        this.debugPopupMenu.add(this.addBreakpointMenuItem);
        this.addressLabelMenuItem.setText("Address Label...");
        this.addressLabelMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.addressLabelMenuItemActionPerformed(evt);
            }
        });
        this.debugPopupMenu.add(this.addressLabelMenuItem);
        this.hexEditorMenuItem.setText("Hex Editor...");
        this.hexEditorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.hexEditorMenuItemActionPerformed(evt);
            }
        });
        this.debugPopupMenu.add(this.hexEditorMenuItem);
        this.setDefaultCloseOperation(0);
        this.setTitle("Debugger");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DebuggerFrame.this.formWindowClosing(evt);
            }
        });
        this.stepIntoButton.setText("Step Into");
        this.stepIntoButton.setToolTipText("Runs one instruction, then pauses.");
        this.stepIntoButton.setFocusPainted(false);
        this.stepIntoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.stepIntoButtonActionPerformed(evt);
            }
        });
        this.suspendToggleButton.setText("Pause");
        this.suspendToggleButton.setFocusPainted(false);
        this.suspendToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.suspendToggleButtonActionPerformed(evt);
            }
        });
        this.stepOutButton.setText("Step Out");
        this.stepOutButton.setToolTipText("Runs until the current subroutine ends.");
        this.stepOutButton.setFocusPainted(false);
        this.stepOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.stepOutButtonActionPerformed(evt);
            }
        });
        this.stepOverButton.setText("Step Over");
        this.stepOverButton.setToolTipText("Runs one instruction, but JSR will run until RTS.");
        this.stepOverButton.setFocusPainted(false);
        this.stepOverButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.stepOverButtonActionPerformed(evt);
            }
        });
        this.stepToButton.setText("Step To:");
        this.stepToButton.setToolTipText("Step to specified execution address.");
        this.stepToButton.setFocusPainted(false);
        this.stepToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.stepToButtonActionPerformed(evt);
            }
        });
        this.stepToTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.stepToTextFieldActionPerformed(evt);
            }
        });
        this.seekToButton.setText("Seek To:");
        this.seekToButton.setToolTipText("Scroll to specified address.");
        this.seekToButton.setFocusPainted(false);
        this.seekToButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.seekToButtonActionPerformed(evt);
            }
        });
        this.seekToTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.seekToTextFieldActionPerformed(evt);
            }
        });
        this.seekPcButton.setText("Seek PC");
        this.seekPcButton.setToolTipText("Scroll to current execution point.");
        this.seekPcButton.setFocusPainted(false);
        this.seekPcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.seekPcButtonActionPerformed(evt);
            }
        });
        this.pcLabel.setText("PC:");
        this.aLabel.setText("A:");
        this.xLabel.setText("X:");
        this.yLabel.setText("Y:");
        this.sLabel.setText("S:");
        this.sTextField.setColumns(3);
        this.sTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.sTextFieldFocusLost(evt);
            }
        });
        this.sTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.sTextFieldActionPerformed(evt);
            }
        });
        this.yTextField.setColumns(3);
        this.yTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.yTextFieldFocusLost(evt);
            }
        });
        this.yTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.yTextFieldActionPerformed(evt);
            }
        });
        this.xTextField.setColumns(3);
        this.xTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.xTextFieldFocusLost(evt);
            }
        });
        this.xTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.xTextFieldActionPerformed(evt);
            }
        });
        this.aTextField.setColumns(3);
        this.aTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.aTextFieldFocusLost(evt);
            }
        });
        this.aTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.aTextFieldActionPerformed(evt);
            }
        });
        this.pcTextField.setColumns(5);
        this.pcTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.pcTextFieldFocusLost(evt);
            }
        });
        this.pcTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.pcTextFieldActionPerformed(evt);
            }
        });
        this.stackScrollPane.setMaximumSize(null);
        this.stackScrollPane.setMinimumSize(null);
        this.stackScrollPane.setPreferredSize(null);
        this.stackTextArea.setEditable(false);
        this.stackTextArea.setColumns(33);
        this.stackTextArea.setLineWrap(true);
        this.stackTextArea.setRows(3);
        this.stackTextArea.setWrapStyleWord(true);
        this.stackTextArea.setMaximumSize(null);
        this.stackTextArea.setPreferredSize(null);
        this.stackScrollPane.setViewportView(this.stackTextArea);
        this.nCheckBox.setText("N");
        this.nCheckBox.setFocusPainted(false);
        this.vCheckBox.setText("V");
        this.vCheckBox.setFocusPainted(false);
        this.dCheckBox.setText("D");
        this.dCheckBox.setFocusPainted(false);
        this.iCheckBox.setText("I");
        this.iCheckBox.setFocusPainted(false);
        this.zCheckBox.setText("Z");
        this.zCheckBox.setFocusPainted(false);
        this.cCheckBox.setText("C");
        this.cCheckBox.setFocusPainted(false);
        this.nextFrameButton.setText("Frame+1");
        this.nextFrameButton.setToolTipText("Step to next frame.");
        this.nextFrameButton.setFocusPainted(false);
        this.nextFrameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.nextFrameButtonActionPerformed(evt);
            }
        });
        this.scanlineButton.setText("Scanline:");
        this.scanlineButton.setToolTipText("Step to specified scanline.");
        this.scanlineButton.setFocusPainted(false);
        this.scanlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.scanlineButtonActionPerformed(evt);
            }
        });
        this.scanlineTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.scanlineTextFieldActionPerformed(evt);
            }
        });
        this.dotButton.setText("Dot:");
        this.dotButton.setToolTipText("Step to specified scanline cycle.");
        this.dotButton.setFocusPainted(false);
        this.dotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.dotButtonActionPerformed(evt);
            }
        });
        this.dotTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.dotTextFieldActionPerformed(evt);
            }
        });
        this.scanlineNameLabel.setText("Scanline:");
        this.scanlineLabel.setText("---");
        this.dotNameLabel.setText("Dot:");
        this.dotLabel.setText("---");
        this.sprite0HitButton.setText("Sprite 0");
        this.sprite0HitButton.setToolTipText("Step to next sprite 0 hit.");
        this.sprite0HitButton.setFocusPainted(false);
        this.sprite0HitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.sprite0HitButtonActionPerformed(evt);
            }
        });
        this.nmiButton.setText("NMI");
        this.nmiButton.setToolTipText("Step to next NMI.");
        this.nmiButton.setFocusPainted(false);
        this.nmiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.nmiButtonActionPerformed(evt);
            }
        });
        this.irqButton.setText("IRQ");
        this.irqButton.setToolTipText("Step to next IRQ.");
        this.irqButton.setFocusPainted(false);
        this.irqButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.irqButtonActionPerformed(evt);
            }
        });
        this.brkButton.setText("BRK");
        this.brkButton.setToolTipText("Step to next BRK.");
        this.brkButton.setFocusPainted(false);
        this.brkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.brkButtonActionPerformed(evt);
            }
        });
        this.rstButton.setText("RST");
        this.rstButton.setToolTipText("Step to next reset.");
        this.rstButton.setFocusPainted(false);
        this.rstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.rstButtonActionPerformed(evt);
            }
        });
        this.opcodeButton.setText("Opcode:");
        this.opcodeButton.setToolTipText("Step to next encounter of specified opcode.");
        this.opcodeButton.setFocusPainted(false);
        this.opcodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.opcodeButtonActionPerformed(evt);
            }
        });
        this.opcodeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.opcodeTextFieldActionPerformed(evt);
            }
        });
        this.scrollBar.setMaximum(65535);
        this.debugScrollPane.setVerticalScrollBarPolicy(21);
        this.debugScrollPane.setPreferredSize(null);
        this.debugScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DebuggerFrame.this.debugScrollPaneComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                DebuggerFrame.this.debugScrollPaneComponentShown(evt);
            }
        });
        this.debugTextArea.setEditable(false);
        this.debugTextArea.setAutoscrolls(false);
        this.debugTextArea.setBorder(null);
        this.debugTextArea.setMaximumSize(null);
        this.debugTextArea.setPreferredSize(null);
        this.debugTextArea.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                DebuggerFrame.this.debugTextAreaMouseWheelMoved(evt);
            }
        });
        this.debugTextArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DebuggerFrame.this.debugTextAreaMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DebuggerFrame.this.debugTextAreaMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DebuggerFrame.this.debugTextAreaMouseReleased(evt);
            }
        });
        this.debugScrollPane.setViewportView(this.debugTextArea);
        this.manageAddressLabelsButton.setText("Labels...");
        this.manageAddressLabelsButton.setFocusPainted(false);
        this.manageAddressLabelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.manageAddressLabelsButtonActionPerformed(evt);
            }
        });
        this.bookmarksComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.bookmarksComboBoxActionPerformed(evt);
            }
        });
        this.breakpointsButton.setText("Breakpoints...");
        this.breakpointsButton.setFocusPainted(false);
        this.breakpointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.breakpointsButtonActionPerformed(evt);
            }
        });
        this.labelsCheckBox.setSelected(true);
        this.labelsCheckBox.setText("Address labels");
        this.labelsCheckBox.setFocusPainted(false);
        this.labelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.labelsCheckBoxActionPerformed(evt);
            }
        });
        this.machineCodeCheckBox.setSelected(true);
        this.machineCodeCheckBox.setText("Machine code");
        this.machineCodeCheckBox.setFocusPainted(false);
        this.machineCodeCheckBox.setMaximumSize(null);
        this.machineCodeCheckBox.setMinimumSize(null);
        this.machineCodeCheckBox.setPreferredSize(null);
        this.machineCodeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.machineCodeCheckBoxActionPerformed(evt);
            }
        });
        this.inspectionsCheckBox.setSelected(true);
        this.inspectionsCheckBox.setText("Inspections");
        this.inspectionsCheckBox.setFocusPainted(false);
        this.inspectionsCheckBox.setMaximumSize(null);
        this.inspectionsCheckBox.setMinimumSize(null);
        this.inspectionsCheckBox.setPreferredSize(null);
        this.inspectionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.inspectionsCheckBoxActionPerformed(evt);
            }
        });
        this.addressTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Bank:Address", "File Offset", "No Addresses"}));
        this.addressTypeComboBox.setFocusable(false);
        this.addressTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.addressTypeComboBoxActionPerformed(evt);
            }
        });
        this.pcCheckBox.setSelected(true);
        this.pcCheckBox.setText("PC");
        this.pcCheckBox.setFocusPainted(false);
        this.pcCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.pcCheckBoxActionPerformed(evt);
            }
        });
        this.branchesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Absolute branches", "Hex branches", "Decimal branches"}));
        this.branchesComboBox.setFocusable(false);
        this.branchesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.branchesComboBoxActionPerformed(evt);
            }
        });
        this.instructionsButton.setText("Insts:");
        this.instructionsButton.setToolTipText("Step ahead by specified number of instructions.");
        this.instructionsButton.setFocusPainted(false);
        this.instructionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.instructionsButtonActionPerformed(evt);
            }
        });
        this.instructionsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.instructionsTextFieldActionPerformed(evt);
            }
        });
        this.assemblerButton.setText("Assembler...");
        this.assemblerButton.setFocusPainted(false);
        this.assemblerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.assemblerButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.setFocusPainted(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.loadButton.setText("Load");
        this.loadButton.setFocusPainted(false);
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.loadButtonActionPerformed(evt);
            }
        });
        this.saveSlotLabel.setText("Save slot:");
        this.saveSlotComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"}));
        this.saveSlotComboBox.setFocusable(false);
        this.saveSlotComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.saveSlotComboBoxActionPerformed(evt);
            }
        });
        this.loggerToggleButton.setText("Start Logger");
        this.loggerToggleButton.setFocusPainted(false);
        this.loggerToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.loggerToggleButtonActionPerformed(evt);
            }
        });
        this.configLoggerButton.setText("Config Logger...");
        this.configLoggerButton.setFocusPainted(false);
        this.configLoggerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.configLoggerButtonActionPerformed(evt);
            }
        });
        this.unofficialOpcodesCheckBox.setText("Unofficial opcodes");
        this.unofficialOpcodesCheckBox.setFocusPainted(false);
        this.unofficialOpcodesCheckBox.setMaximumSize(null);
        this.unofficialOpcodesCheckBox.setMinimumSize(null);
        this.unofficialOpcodesCheckBox.setPreferredSize(null);
        this.unofficialOpcodesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.unofficialOpcodesCheckBoxActionPerformed(evt);
            }
        });
        this.ppu2002NameLabel.setText("$2002:");
        this.ppu2002Label.setText("--");
        this.ppu2004NameLabel.setText("$2004:");
        this.ppu2004Label.setText("--");
        this.ppu2007NameLabel.setText("$2007:");
        this.ppu2007Label.setText("--");
        this.ppuVNameLabel.setText("v:");
        this.ppuVTextField.setColumns(5);
        this.ppuVTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.ppuVTextFieldFocusLost(evt);
            }
        });
        this.ppuVTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.ppuVTextFieldActionPerformed(evt);
            }
        });
        this.ppuTNameLabel.setText("t:");
        this.ppuTTextField.setColumns(5);
        this.ppuTTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.ppuTTextFieldFocusLost(evt);
            }
        });
        this.ppuTTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.ppuTTextFieldActionPerformed(evt);
            }
        });
        this.ppuXNameLabel.setText("x:");
        this.ppuXTextField.setColumns(3);
        this.ppuXTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.ppuXTextFieldFocusLost(evt);
            }
        });
        this.ppuXTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.ppuXTextFieldActionPerformed(evt);
            }
        });
        this.ppuWCheckBox.setText("w");
        this.sprite0CheckBox.setText("Sprite 0");
        this.cameraXNameLabel.setText("Camera X:");
        this.cameraXTextField.setColumns(4);
        this.cameraXTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.cameraXTextFieldFocusLost(evt);
            }
        });
        this.cameraXTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.cameraXTextFieldActionPerformed(evt);
            }
        });
        this.cameraYNameLabel.setText("Camera Y:");
        this.cameraYTextField.setColumns(4);
        this.cameraYTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DebuggerFrame.this.cameraYTextFieldFocusLost(evt);
            }
        });
        this.cameraYTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.cameraYTextFieldActionPerformed(evt);
            }
        });
        this.closeButton.setMnemonic('C');
        this.closeButton.setText("Close");
        this.closeButton.setFocusPainted(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerFrame.this.defaultsButtonActionPerformed(evt);
            }
        });
        this.bookmarksLabel.setText("Bookmarks:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.debugScrollPane, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.scrollBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.loggerToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configLoggerButton)).addGroup(layout.createSequentialGroup().addComponent(this.nmiButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.irqButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.brkButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rstButton)).addGroup(layout.createSequentialGroup().addComponent(this.labelsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.machineCodeCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.unofficialOpcodesCheckBox, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.saveButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveSlotLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveSlotComboBox, -2, -1, -2)).addComponent(this.suspendToggleButton).addGroup(layout.createSequentialGroup().addComponent(this.scanlineButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dotButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dotTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.opcodeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.opcodeTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.instructionsTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.seekToButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.seekToTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepToButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepToTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.stepOverButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepIntoButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stepOutButton)).addGroup(layout.createSequentialGroup().addComponent(this.nextFrameButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sprite0HitButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.seekPcButton)).addGroup(layout.createSequentialGroup().addComponent(this.pcLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pcTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.aLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.xLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.yLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.nCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.zCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.scanlineNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scanlineLabel).addGap(18, 18, 18).addComponent(this.dotNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dotLabel).addGap(18, 18, 18).addComponent(this.ppu2002NameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppu2002Label).addGap(18, 18, 18).addComponent(this.ppu2004NameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppu2004Label).addGap(18, 18, 18).addComponent(this.ppu2007NameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppu2007Label)).addGroup(layout.createSequentialGroup().addComponent(this.ppuVNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppuVTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ppuTNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppuTTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ppuXNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppuXTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ppuWCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sprite0CheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.cameraXNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cameraXTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cameraYNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cameraYTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.manageAddressLabelsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.breakpointsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.assemblerButton)).addComponent(this.stackScrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(layout.createSequentialGroup().addComponent(this.addressTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.branchesComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pcCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inspectionsCheckBox, -2, -1, -2)))).addGroup(layout.createSequentialGroup().addComponent(this.bookmarksLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bookmarksComboBox, 0, -1, -2))).addContainerGap()));
        layout.linkSize(0, this.brkButton, this.dotButton, this.dotTextField, this.instructionsButton, this.instructionsTextField, this.irqButton, this.loadButton, this.manageAddressLabelsButton, this.nextFrameButton, this.nmiButton, this.opcodeButton, this.opcodeTextField, this.rstButton, this.saveButton, this.scanlineButton, this.scanlineTextField, this.seekPcButton, this.seekToButton, this.seekToTextField, this.sprite0HitButton, this.stepIntoButton, this.stepOutButton, this.stepOverButton, this.stepToButton, this.stepToTextField, this.suspendToggleButton);
        layout.linkSize(0, this.configLoggerButton, this.loggerToggleButton);
        layout.linkSize(0, this.closeButton, this.defaultsButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollBar, -1, -1, Short.MAX_VALUE).addComponent(this.debugScrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.suspendToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stepIntoButton).addComponent(this.stepOverButton).addComponent(this.stepOutButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextFrameButton).addComponent(this.sprite0HitButton).addComponent(this.seekPcButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nmiButton).addComponent(this.irqButton).addComponent(this.brkButton).addComponent(this.rstButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.seekToButton).addComponent(this.seekToTextField, -2, -1, -2).addComponent(this.stepToButton).addComponent(this.stepToTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanlineButton).addComponent(this.scanlineTextField, -2, -1, -2).addComponent(this.dotButton).addComponent(this.dotTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.opcodeButton).addComponent(this.opcodeTextField, -2, -1, -2).addComponent(this.instructionsButton).addComponent(this.instructionsTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pcLabel).addComponent(this.pcTextField, -2, -1, -2).addComponent(this.aLabel).addComponent(this.aTextField, -2, -1, -2).addComponent(this.xLabel).addComponent(this.xTextField, -2, -1, -2).addComponent(this.yLabel).addComponent(this.yTextField, -2, -1, -2).addComponent(this.sLabel).addComponent(this.sTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nCheckBox).addComponent(this.vCheckBox).addComponent(this.dCheckBox).addComponent(this.iCheckBox).addComponent(this.zCheckBox).addComponent(this.cCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stackScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scanlineNameLabel).addComponent(this.scanlineLabel).addComponent(this.dotNameLabel).addComponent(this.dotLabel).addComponent(this.ppu2002NameLabel).addComponent(this.ppu2002Label).addComponent(this.ppu2004NameLabel).addComponent(this.ppu2004Label).addComponent(this.ppu2007NameLabel).addComponent(this.ppu2007Label)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ppuVNameLabel).addComponent(this.ppuVTextField, -2, -1, -2).addComponent(this.ppuTNameLabel).addComponent(this.ppuTTextField, -2, -1, -2).addComponent(this.ppuXNameLabel).addComponent(this.ppuXTextField, -2, -1, -2).addComponent(this.ppuWCheckBox).addComponent(this.sprite0CheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cameraXNameLabel).addComponent(this.cameraXTextField, -2, -1, -2).addComponent(this.cameraYNameLabel).addComponent(this.cameraYTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bookmarksComboBox, -2, -1, -2).addComponent(this.bookmarksLabel)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.breakpointsButton).addComponent(this.manageAddressLabelsButton).addComponent(this.assemblerButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressTypeComboBox, -2, -1, -2).addComponent(this.branchesComboBox, -2, -1, -2).addComponent(this.pcCheckBox).addComponent(this.inspectionsCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelsCheckBox).addComponent(this.machineCodeCheckBox, -2, -1, -2).addComponent(this.unofficialOpcodesCheckBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveButton).addComponent(this.loadButton).addComponent(this.saveSlotLabel).addComponent(this.saveSlotComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loggerToggleButton).addComponent(this.configLoggerButton)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.defaultsButton)))).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }

    private void stepIntoButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.Into);
    }

    private void debugTextAreaMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getWheelRotation() > 0) {
            this.onScrollDown();
        } else if (evt.getWheelRotation() < 0) {
            this.onScrollUp();
        }
    }

    private void suspendToggleButtonActionPerformed(ActionEvent evt) {
        App.setStepPause(this.suspendToggleButton.isSelected());
    }

    private void stepOutButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.Out);
    }

    private void stepOverButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.Over);
    }

    private void stepToButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        int address = StringUtil.parseInt(this.stepToTextField.getText(), true, 65535L);
        if (address >= 0) {
            App.stepToAddress(address);
        }
    }

    private void seekToButtonActionPerformed(ActionEvent evt) {
        int address = this.parseSeekToTextField();
        if (address >= 0) {
            this.setScrollBarValue(address);
            this.requestTextAreaRefresh();
        } else {
            switch (address) {
                case -1: {
                    GuiUtil.displayError(this, "Please specify the seek address.");
                    break;
                }
                case -2: {
                    GuiUtil.displayError(this, "The seek address is out of range.");
                    break;
                }
                case -3: {
                    GuiUtil.displayError(this, "The specified seek address is not a valid hex value.");
                }
            }
        }
    }

    private void seekToTextFieldActionPerformed(ActionEvent evt) {
        this.seekToButtonActionPerformed(evt);
        this.requestFocusInWindow();
    }

    private void seekPcButtonActionPerformed(ActionEvent evt) {
        this.refreshDebugTextArea(true);
    }

    private void nextFrameButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.Frame);
    }

    private void scanlineButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        Integer scanline = this.parseScanlineTextField();
        if (scanline == null) {
            if (StringUtil.isBlank(this.scanlineTextField.getText())) {
                GuiUtil.displayError(this, "Please specify the target scanline.");
            } else {
                PPU p = this.ppu;
                if (p == null) {
                    GuiUtil.displayError(this, "Invalid scanline value.");
                } else {
                    GuiUtil.displayError(this, "Enter a scanline value from %d to %d.", -1, p.getScanlineCount() - 2);
                }
            }
        } else {
            App.stepToScanline(scanline);
        }
    }

    private void scanlineTextFieldActionPerformed(ActionEvent evt) {
        this.scanlineButtonActionPerformed(evt);
        this.requestFocusInWindow();
    }

    private void dotButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        int dot = this.parseDotTextField();
        if (dot >= 0) {
            App.stepToDot(dot);
        } else {
            switch (dot) {
                case -1: {
                    GuiUtil.displayError(this, "Please specify the scanline cycle value.");
                    break;
                }
                case -2: {
                    GuiUtil.displayError(this, "Enter a scanline cycle value from 0 to 340.");
                    break;
                }
                case -3: {
                    GuiUtil.displayError(this, "The specified scanline cycle value is not a number.");
                }
            }
        }
    }

    private void dotTextFieldActionPerformed(ActionEvent evt) {
        this.dotButtonActionPerformed(evt);
        this.requestFocusInWindow();
    }

    private void sprite0HitButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.Sprite0);
    }

    private void nmiButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.NMI);
    }

    private void irqButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.IRQ);
    }

    private void brkButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.BRK);
    }

    private void rstButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        App.step(PauseStepType.RST);
    }

    private void opcodeButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        int opcode = this.parseOpcodeTextField();
        if (opcode >= 0) {
            App.stepToOpcode(opcode);
        } else {
            switch (opcode) {
                case -1: {
                    GuiUtil.displayError(this, "Please specify the opcode value.");
                    break;
                }
                case -2: {
                    GuiUtil.displayError(this, "Enter a hexidecimal opcode from 00 to FF.");
                    break;
                }
                case -3: {
                    GuiUtil.displayError(this, "The specified opcode is not a valid hex value.");
                }
            }
        }
    }

    private void opcodeTextFieldActionPerformed(ActionEvent evt) {
        this.opcodeButtonActionPerformed(evt);
        this.requestFocusInWindow();
    }

    private void debugScrollPaneComponentResized(ComponentEvent evt) {
        this.updateVisibleLines();
    }

    private void debugScrollPaneComponentShown(ComponentEvent evt) {
        this.updateVisibleLines();
    }

    private void debugTextAreaMouseClicked(MouseEvent evt) {
        this.highlightAddress();
    }

    private void manageAddressLabelsButtonActionPerformed(ActionEvent evt) {
        AddressLabelDialog dialog = new AddressLabelDialog((Window)this);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.initAddressLabels();
            this.requestTextAreaRefresh();
        }
    }

    private void debugTextAreaMousePressed(MouseEvent evt) {
        this.handlePopupTrigger(evt);
    }

    private void debugTextAreaMouseReleased(MouseEvent evt) {
        this.handlePopupTrigger(evt);
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        this.debugTextArea.selectAll();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.debugTextArea.copy();
    }

    private void seekToMenuItemActionPerformed(ActionEvent evt) {
        if (this.lastRange != null && this.lastRange.getAddress() >= 0 && this.lastRange.getAddress() <= 65535) {
            this.setScrollBarValue(this.lastRange.getAddress());
            this.requestTextAreaRefresh();
        }
    }

    private void stepToMenuItemActionPerformed(ActionEvent evt) {
        if (this.lastRange != null && this.lastRange.getAddress() >= 0 && this.lastRange.getAddress() <= 65535) {
            App.stepToAddress(this.lastRange.getAddress());
        }
    }

    private void addressLabelMenuItemActionPerformed(ActionEvent evt) {
        AddressLabelDialog dialog = new AddressLabelDialog((Window)this);
        dialog.setRange(this.lastRange);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            this.refreshAddressLabels();
        }
    }

    private void bookmarksComboBoxActionPerformed(ActionEvent evt) {
        int address;
        AddressLabel label = (AddressLabel)this.bookmarksComboBox.getSelectedItem();
        if (label != null && (address = label.getAddress()) >= 0 && address <= 65535) {
            this.setScrollBarValue(address);
            this.requestTextAreaRefresh();
        }
    }

    private void hexEditorMenuItemActionPerformed(ActionEvent evt) {
        if (this.lastRange != null && this.lastRange.getAddress() >= 0 && this.lastRange.getAddress() <= 65535) {
            App.createHexEditorFrame();
            if (this.lastRange.getBank() < 0) {
                EventQueue.invokeLater(() -> App.getHexEditorFrame().goToAddress(0, this.lastRange.getAddress()));
            } else {
                EventQueue.invokeLater(() -> App.getHexEditorFrame().goToFileContents(this.lastRange.getAddress()));
            }
        }
    }

    private void breakpointsButtonActionPerformed(ActionEvent evt) {
        if (this.machineRunner != null) {
            BreakpointDialog dialog = new BreakpointDialog((Window)this);
            dialog.setVisible(true);
            if (dialog.isOk()) {
                this.applyBreakpoints();
            }
        }
    }

    private void addBreakpointMenuItemActionPerformed(ActionEvent evt) {
        AddressTextRange range = this.lastRange;
        if (this.machineRunner != null) {
            BreakpointDialog dialog = new BreakpointDialog((Window)this);
            if (range != null) {
                dialog.setBreakpoint(new Breakpoint(0, range.getBank(), range.getAddress(), -1, true));
            }
            dialog.setVisible(true);
            if (dialog.isOk()) {
                this.applyBreakpoints();
            }
        }
    }

    private void labelsCheckBoxActionPerformed(ActionEvent evt) {
        Disassembler.setShowLabels(this.labelsCheckBox.isSelected());
        this.requestTextAreaRefresh();
    }

    private void addressTypeComboBoxActionPerformed(ActionEvent evt) {
        int selectedIndex = this.addressTypeComboBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            Disassembler.setAddressType(selectedIndex);
            this.requestTextAreaRefresh();
        }
    }

    private void machineCodeCheckBoxActionPerformed(ActionEvent evt) {
        Disassembler.setMachineCode(this.machineCodeCheckBox.isSelected());
        this.requestTextAreaRefresh();
    }

    private void inspectionsCheckBoxActionPerformed(ActionEvent evt) {
        Disassembler.setInspections(this.inspectionsCheckBox.isSelected());
        this.requestTextAreaRefresh();
    }

    private void pcCheckBoxActionPerformed(ActionEvent evt) {
        Disassembler.setShowPC(this.pcCheckBox.isSelected());
        this.requestTextAreaRefresh();
    }

    private void branchesComboBoxActionPerformed(ActionEvent evt) {
        int selectedIndex = this.branchesComboBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            Disassembler.setBranchesType(selectedIndex);
            this.requestTextAreaRefresh();
        }
    }

    private void instructionsButtonActionPerformed(ActionEvent evt) {
        this.acquireFields();
        int insts = this.parseInstructionsTextField();
        if (insts > 0) {
            App.stepToInstructions(insts);
        } else if (insts == 0 || insts == -2) {
            GuiUtil.displayError(this, "Enter a number greater-than 1.");
        } else {
            switch (insts) {
                case -1: {
                    GuiUtil.displayError(this, "Please specify the number of instructions to execute.");
                    break;
                }
                case -3: {
                    GuiUtil.displayError(this, "The specified value is not a valid number.");
                }
            }
        }
    }

    private void instructionsTextFieldActionPerformed(ActionEvent evt) {
        this.instructionsButtonActionPerformed(evt);
        this.requestFocusInWindow();
    }

    private void assemblerButtonActionPerformed(ActionEvent evt) {
        List<Instruction> insts = this.instructions;
        if (insts != null && !insts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Instruction instruction : insts) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(instruction.getMachineCode());
            }
            App.createAsmDasmFrame();
            AsmDasmFrame frame = App.getAsmDasmFrame();
            frame.setMachineCode(sb.toString());
            frame.disassemble();
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.imageFrame.quickSaveState(this.saveSlotComboBox.getSelectedIndex() + 1);
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        this.imageFrame.quickLoadState(this.saveSlotComboBox.getSelectedIndex() + 1);
    }

    private void saveSlotComboBoxActionPerformed(ActionEvent evt) {
        this.updateLoadButton();
    }

    private void configLoggerButtonActionPerformed(ActionEvent evt) {
        App.disposeTraceLogger();
        this.updateLoadButton();
        new LoggerDialog((Window)this).setVisible(true);
    }

    private void loggerToggleButtonActionPerformed(ActionEvent evt) {
        App.disposeTraceLogger();
        if (this.loggerToggleButton.isSelected()) {
            App.startTraceLogger();
        }
        this.updateLoggerButton();
    }

    private void stepToTextFieldActionPerformed(ActionEvent evt) {
        this.stepToButtonActionPerformed(evt);
        this.requestFocusInWindow();
    }

    private void pcTextFieldActionPerformed(ActionEvent evt) {
        this.acquirePC(true);
        this.refreshDebugTextArea(true);
        this.requestFocusInWindow();
    }

    private void pcTextFieldFocusLost(FocusEvent evt) {
        this.acquirePC(true);
        this.refreshDebugTextArea(true);
    }

    private void aTextFieldActionPerformed(ActionEvent evt) {
        this.acquireA(true);
        this.requestFocusInWindow();
    }

    private void aTextFieldFocusLost(FocusEvent evt) {
        this.acquireA(true);
    }

    private void xTextFieldActionPerformed(ActionEvent evt) {
        this.acquireX(true);
        this.requestFocusInWindow();
    }

    private void xTextFieldFocusLost(FocusEvent evt) {
        this.acquireX(true);
    }

    private void yTextFieldActionPerformed(ActionEvent evt) {
        this.acquireY(true);
        this.requestFocusInWindow();
    }

    private void yTextFieldFocusLost(FocusEvent evt) {
        this.acquireY(true);
    }

    private void sTextFieldActionPerformed(ActionEvent evt) {
        this.acquireS(true);
        this.requestFocusInWindow();
    }

    private void sTextFieldFocusLost(FocusEvent evt) {
        this.acquireS(true);
    }

    private void unofficialOpcodesCheckBoxActionPerformed(ActionEvent evt) {
        this.officialsOnly = !this.unofficialOpcodesCheckBox.isSelected();
        this.requestTextAreaRefresh();
    }

    private void ppuVTextFieldActionPerformed(ActionEvent evt) {
        this.acquirePpuV(true);
        this.requestFocusInWindow();
    }

    private void ppuVTextFieldFocusLost(FocusEvent evt) {
        this.acquirePpuV(true);
    }

    private void ppuTTextFieldActionPerformed(ActionEvent evt) {
        this.acquirePpuT(true);
        this.requestFocusInWindow();
    }

    private void ppuTTextFieldFocusLost(FocusEvent evt) {
        this.acquirePpuT(true);
    }

    private void ppuXTextFieldActionPerformed(ActionEvent evt) {
        this.acquirePpuX(true);
        this.requestFocusInWindow();
    }

    private void ppuXTextFieldFocusLost(FocusEvent evt) {
        this.acquirePpuX(true);
    }

    private void cameraXTextFieldActionPerformed(ActionEvent evt) {
        this.acquireCameraX(true);
        this.requestFocusInWindow();
    }

    private void cameraXTextFieldFocusLost(FocusEvent evt) {
        this.acquireCameraX(true);
    }

    private void cameraYTextFieldActionPerformed(ActionEvent evt) {
        this.acquireCameraY(true);
        this.requestFocusInWindow();
    }

    private void cameraYTextFieldFocusLost(FocusEvent evt) {
        this.acquireCameraY(true);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new DebuggerAppPrefs());
    }
}

