/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger.breakpoint;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import nintaco.Breakpoint;
import nintaco.util.StringUtil;

public class BreakpointTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"Enabled", "Type", "Bank", "Start", "End"};
    public static final String[] TYPE_NAMES = new String[]{"Execute", "Read", "Write", "Access"};
    private List<Breakpoint> rows = new ArrayList<Breakpoint>();

    public static int getType(String name) {
        switch (name) {
            case "Execute": {
                return 0;
            }
            case "Read": {
                return 1;
            }
            case "Write": {
                return 2;
            }
            case "Access": {
                return 3;
            }
        }
        return -1;
    }

    public int add(Breakpoint breakpoint) {
        int index = this.rows.indexOf(breakpoint);
        if (index >= 0) {
            this.rows.set(index, breakpoint);
            this.fireTableRowsUpdated(index, index);
            return index;
        }
        this.rows.add(breakpoint);
        this.fireTableDataChanged();
        return this.rows.indexOf(breakpoint);
    }

    public void delete(int index) {
        this.rows.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public List<Breakpoint> getRowsCopy() {
        ArrayList<Breakpoint> rs = new ArrayList<Breakpoint>();
        for (Breakpoint row : this.rows) {
            rs.add(new Breakpoint(row));
        }
        return rs;
    }

    public void setRowsCopy(List<Breakpoint> rows) {
        this.rows.clear();
        for (Breakpoint row : rows) {
            this.rows.add(new Breakpoint(row));
        }
        this.fireTableDataChanged();
    }

    public List<Breakpoint> getRows() {
        return this.rows;
    }

    public void setRows(List<Breakpoint> rows) {
        this.rows = rows;
        this.fireTableDataChanged();
    }

    public Breakpoint getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public Breakpoint getRowCopy(int rowIndex) {
        return new Breakpoint(this.getRow(rowIndex));
    }

    public void setRow(int rowIndex, Breakpoint breakpoint) {
        this.rows.set(rowIndex, breakpoint);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    public void setRowCopy(int rowIndex, Breakpoint breakpoint) {
        this.setRow(rowIndex, new Breakpoint(breakpoint));
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : String.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Breakpoint row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return row.isEnabled();
            }
            case 1: {
                return TYPE_NAMES[row.getType()];
            }
            case 2: {
                return row.getBank() >= 0 ? String.format("$%02X", row.getBank()) : "";
            }
            case 3: {
                return String.format("$%04X", row.getStartAddress());
            }
            case 4: {
                return row.getEndAddress() >= 0 ? String.format("$%04X", row.getEndAddress()) : "";
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Breakpoint row = this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                row.setEnabled((Boolean)value);
                break;
            }
            case 1: {
                switch ((String)value) {
                    case "Execute": {
                        row.setType(0);
                        break;
                    }
                    case "Read": {
                        row.setType(1);
                        break;
                    }
                    case "Write": {
                        row.setType(2);
                        break;
                    }
                    case "Access": {
                        row.setType(3);
                    }
                }
                break;
            }
            case 2: {
                int bank = StringUtil.parseInt(value, true, 255L);
                row.setBank(bank >= 0 ? bank : -1);
                break;
            }
            case 3: {
                int startAddress = StringUtil.parseInt(value, true, 65535L);
                if (startAddress < 0 || row.isRange() && startAddress > row.getEndAddress()) break;
                row.setStartAddress(startAddress);
                break;
            }
            case 4: {
                int endAddress = StringUtil.parseInt(value, true, 65535L);
                if (endAddress < 0) {
                    row.setEndAddress(-1);
                    break;
                }
                if (endAddress < row.getStartAddress()) break;
                row.setEndAddress(endAddress);
                break;
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
}

