/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.debugger.breakpoint;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentListener;
import nintaco.Breakpoint;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class CreateBreakpointDialog
extends JDialog {
    private final DocumentListener bankListener = GuiUtil.createDocumentListener(this::bankEdited);
    private final DocumentListener startAddressListener = GuiUtil.createDocumentListener(this::startAddressEdited);
    private final DocumentListener endAddressListener = GuiUtil.createDocumentListener(this::endAddressEdited);
    private Breakpoint breakpoint = new Breakpoint();
    private boolean ok;
    private JLabel addressLabel;
    private JLabel bankLabel;
    private JTextField bankTextField;
    private JButton cancelButton;
    private JLabel dashLabel;
    private JCheckBox enabledCheckBox;
    private JTextField endAddressTextField;
    private JButton okButton;
    private JTextField startAddressTextField;
    private JComboBox typeComboBox;

    public CreateBreakpointDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initTextFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initTextFields() {
        GuiUtil.addLoseFocusListener((Window)this, this.bankTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.startAddressTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.endAddressTextField);
    }

    private void closeDialog() {
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public void setBreakpoint(Breakpoint breakpoint) {
        this.breakpoint = new Breakpoint(breakpoint);
    }

    private void bankEdited() {
        this.breakpoint.setBank(StringUtil.parseInt(this.bankTextField.getText(), true, 255L));
        this.updateButtons();
    }

    private void startAddressEdited() {
        this.breakpoint.setStartAddress(StringUtil.parseInt(this.startAddressTextField.getText(), true, 65535L));
        this.updateButtons();
    }

    private void endAddressEdited() {
        this.breakpoint.setEndAddress(StringUtil.parseInt(this.endAddressTextField.getText(), true, 65535L));
        this.updateButtons();
    }

    private void updateButtons() {
        this.okButton.setEnabled(this.breakpoint.getStartAddress() >= 0 && this.breakpoint.getStartAddress() <= 65535 && (!this.breakpoint.isRange() || this.breakpoint.getStartAddress() <= this.breakpoint.getEndAddress()));
    }

    private void initComponents() {
        this.bankLabel = new JLabel();
        this.bankTextField = new JTextField();
        this.addressLabel = new JLabel();
        this.startAddressTextField = new JTextField();
        this.dashLabel = new JLabel();
        this.endAddressTextField = new JTextField();
        this.typeComboBox = new JComboBox();
        this.enabledCheckBox = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                CreateBreakpointDialog.this.formComponentShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CreateBreakpointDialog.this.formWindowClosing(evt);
            }
        });
        this.bankLabel.setText("Bank:");
        this.bankLabel.setMaximumSize(null);
        this.bankLabel.setMinimumSize(null);
        this.bankLabel.setPreferredSize(null);
        this.bankTextField.setColumns(4);
        this.bankTextField.setMaximumSize(null);
        this.bankTextField.setMinimumSize(null);
        this.bankTextField.setPreferredSize(null);
        this.addressLabel.setText("Address:");
        this.addressLabel.setToolTipText("");
        this.addressLabel.setMaximumSize(null);
        this.addressLabel.setMinimumSize(null);
        this.addressLabel.setPreferredSize(null);
        this.startAddressTextField.setColumns(6);
        this.startAddressTextField.setText("$0000");
        this.startAddressTextField.setMaximumSize(null);
        this.startAddressTextField.setMinimumSize(null);
        this.startAddressTextField.setPreferredSize(null);
        this.dashLabel.setText("<html>&mdash;</html>");
        this.dashLabel.setMaximumSize(null);
        this.dashLabel.setMinimumSize(null);
        this.dashLabel.setPreferredSize(null);
        this.endAddressTextField.setColumns(6);
        this.endAddressTextField.setMaximumSize(null);
        this.endAddressTextField.setMinimumSize(null);
        this.endAddressTextField.setPreferredSize(null);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Execute", "Read", "Write", "Access"}));
        this.typeComboBox.setMaximumSize(null);
        this.typeComboBox.setMinimumSize(null);
        this.typeComboBox.setPreferredSize(null);
        this.enabledCheckBox.setSelected(true);
        this.enabledCheckBox.setText("Enabled");
        this.enabledCheckBox.setMaximumSize(null);
        this.enabledCheckBox.setMinimumSize(null);
        this.enabledCheckBox.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("  Cancel  ");
        this.cancelButton.setMaximumSize(null);
        this.cancelButton.setMinimumSize(null);
        this.cancelButton.setPreferredSize(null);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateBreakpointDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(null);
        this.okButton.setMinimumSize(null);
        this.okButton.setPreferredSize(null);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateBreakpointDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.typeComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.bankLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bankTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.addressLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startAddressTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dashLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endAddressTextField, -2, -1, -2).addGap(18, 18, 18).addComponent(this.enabledCheckBox, -2, -1, -2).addContainerGap(18, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2).addGap(18, 18, 18)));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bankLabel, -2, -1, -2).addComponent(this.bankTextField, -2, -1, -2).addComponent(this.addressLabel, -2, -1, -2).addComponent(this.startAddressTextField, -2, -1, -2).addComponent(this.dashLabel, -2, -1, -2).addComponent(this.endAddressTextField, -2, -1, -2).addComponent(this.typeComboBox, -2, -1, -2).addComponent(this.enabledCheckBox, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addGap(18, 18, 18)));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int type = this.typeComboBox.getSelectedIndex();
        if (this.breakpoint.getStartAddress() >= 0 && this.breakpoint.getStartAddress() <= 65535 && type >= 0) {
            this.ok = true;
            this.breakpoint.setType(type);
            this.breakpoint.setEnabled(this.enabledCheckBox.isSelected());
        }
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formComponentShown(ComponentEvent evt) {
        if (this.breakpoint != null) {
            if (this.breakpoint.getType() >= 0 && this.breakpoint.getType() < 4) {
                this.typeComboBox.setSelectedIndex(this.breakpoint.getType());
            } else {
                this.typeComboBox.setSelectedIndex(0);
            }
            if (this.breakpoint.getBank() >= 0 && this.breakpoint.getBank() <= 255) {
                this.bankTextField.setText(String.format("$%02X", this.breakpoint.getBank()));
            } else {
                this.bankTextField.setText("");
            }
            if (this.breakpoint.getStartAddress() >= 0 && this.breakpoint.getStartAddress() <= 65535) {
                this.startAddressTextField.setText(String.format("$%04X", this.breakpoint.getStartAddress()));
            } else {
                this.startAddressTextField.setText("");
            }
            if (this.breakpoint.getEndAddress() >= 0 && this.breakpoint.getEndAddress() <= 65535) {
                this.endAddressTextField.setText(String.format("$%04X", this.breakpoint.getEndAddress()));
            } else {
                this.endAddressTextField.setText("");
            }
            this.enabledCheckBox.setSelected(this.breakpoint.isEnabled());
        }
        this.updateButtons();
        this.startAddressTextField.selectAll();
        this.startAddressTextField.requestFocus();
        this.bankTextField.getDocument().addDocumentListener(this.bankListener);
        this.endAddressTextField.getDocument().addDocumentListener(this.endAddressListener);
        this.startAddressTextField.getDocument().addDocumentListener(this.startAddressListener);
    }
}

