/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.glasses;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import nintaco.App;
import nintaco.MachineRunner;
import nintaco.PPU;
import nintaco.gui.ImagePanel;
import nintaco.input.DeviceMapper;
import nintaco.input.glasses.GlassesMapper;
import nintaco.mappers.Mapper;
import nintaco.palettes.PaletteUtil;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.GuiUtil;

public class GlassesFrame
extends JFrame {
    private static final int CLEAR_TIMER_RESET_VALUE = 3;
    private final ImagePanel imagePanel = new ImagePanel(512, 240);
    private boolean exchange;
    private boolean lastShutter;
    private int clearTimer = 3;

    public GlassesFrame() {
        this.initComponents();
        this.setContentPane(this.imagePanel);
        GuiUtil.scaleFonts(this);
        this.pack();
        GuiUtil.moveToImageFrameMonitor(this);
        this.setExchange(AppPrefs.getInstance().getInputs().isExchangeGlasses());
    }

    public final void setExchange(boolean exchange) {
        this.exchange = exchange;
        this.clear();
    }

    public void clear() {
        ImagePanel panel = this.imagePanel;
        Arrays.fill(panel.getScreen(), 0);
        panel.render();
    }

    public void update(int[] screen) {
        this.lastShutter ^= true;
        this.render(TVSystem.NTSC, screen, this.lastShutter ^ this.exchange ? 255 : 511);
    }

    public void update(MachineRunner machineRunner) {
        boolean shutter;
        Mapper mapper;
        PPU ppu;
        block5: {
            if (--this.clearTimer == 0) {
                this.clear();
            }
            ppu = machineRunner.getPPU();
            mapper = machineRunner.getMapper();
            if (ppu == null || mapper == null) {
                return;
            }
            DeviceMapper[] deviceMappers = mapper.getDeviceMappers();
            if (deviceMappers == null || deviceMappers.length == 0) {
                return;
            }
            for (int i = deviceMappers.length - 1; i >= 0; --i) {
                if (deviceMappers[i].getInputDevice() != 16) continue;
                shutter = ((GlassesMapper)deviceMappers[i]).isShutter();
                if (shutter != this.lastShutter) {
                    this.lastShutter = shutter;
                    this.clearTimer = 3;
                }
                break block5;
            }
            return;
        }
        int offsetX = shutter ^ this.exchange ? 511 : 255;
        this.render(mapper.getTVSystem(), ppu.getLastScreen(), offsetX);
    }

    private void render(TVSystem tvSystem, int[] screen, int offsetX) {
        ImagePanel panel = this.imagePanel;
        int[] palette = PaletteUtil.getExtendedPalette(tvSystem);
        int[] s = panel.getScreen();
        for (int y = 239; y >= 0; --y) {
            int sy = y << 8;
            int dy = y << 9;
            int sx = 255;
            int dx = offsetX;
            while (sx >= 0) {
                s[dy | dx] = palette[screen[sy | sx]];
                --sx;
                --dx;
            }
        }
        panel.render();
    }

    public void destroy() {
        this.dispose();
    }

    private void closeFrame() {
        App.destroyGlassesFrame();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setTitle("Famicom 3D Glasses");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                GlassesFrame.this.formWindowClosing(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 591, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 285, Short.MAX_VALUE));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeFrame();
    }
}

