/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import nintaco.gui.hexeditor.DataSource;
import nintaco.mappers.Mapper;

public class CpuDataSource
extends DataSource {
    private final Mapper mapper;

    public CpuDataSource(Mapper mapper) {
        super(65536);
        this.mapper = mapper;
    }

    @Override
    public int peek(int address) {
        try {
            return address < 0 ? 0 : this.mapper.peekCpuMemory(address);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Override
    public void write(int address, int value) {
        if (address >= 0) {
            this.mapper.writeMemory(address, value & 0xFF);
        }
    }

    @Override
    public int getIndex() {
        return 0;
    }
}

