/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import nintaco.gui.StyleListener;
import nintaco.util.GuiUtil;

public class HexEditorColumnHeader
extends JComponent
implements StyleListener {
    private static final int MARGIN = 1;
    private Font font;
    private int charWidth = 1;
    private int charHeight = 1;
    private int charAscent;
    private FontMetrics metrics;
    private Dimension preferredSize = new Dimension(1, 1);
    private String dataSourceName;

    public HexEditorColumnHeader() {
        this.styleChanged();
        this.setDataSource(0);
    }

    public final void setDataSource(int dataSource) {
        if (EventQueue.isDispatchThread()) {
            switch (dataSource) {
                case 0: {
                    this.dataSourceName = " CPU";
                    break;
                }
                case 1: {
                    this.dataSourceName = " PPU";
                    break;
                }
                case 2: {
                    this.dataSourceName = "File";
                }
            }
            this.repaint();
        } else {
            EventQueue.invokeLater(() -> this.setDataSource(dataSource));
        }
    }

    @Override
    public final void styleChanged() {
        this.font = GuiUtil.scaleFont(new Font("Monospaced", 0, GuiUtil.getDefaultFont(new JTextArea("M")).getSize()));
        this.setFont(this.font);
        this.metrics = null;
    }

    @Override
    protected void paintComponent(Graphics g) {
        JViewport viewport = (JViewport)this.getParent();
        JScrollPane scrollPane = (JScrollPane)viewport.getParent();
        if (this.metrics == null) {
            this.metrics = g.getFontMetrics(this.font);
            this.charWidth = this.metrics.getWidths()[77];
            this.charHeight = this.metrics.getHeight();
            this.charAscent = this.metrics.getAscent();
            this.preferredSize = new Dimension(2 + 76 * this.charWidth, 2 + this.charHeight);
            EventQueue.invokeLater(scrollPane::updateUI);
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLUE);
        g.drawString(this.dataSourceName, 1 + 3 * this.charWidth, 1 + this.charAscent);
        g.drawString("00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F    0123456789ABCDEF", 1 + 9 * this.charWidth, 1 + this.charAscent);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }
}

