/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.hexeditor.preferences;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nintaco.gui.hexeditor.preferences.Bookmark;
import nintaco.preferences.GamePrefs;

public class HexEditorGamePrefs
implements Serializable {
    private static final long serialVersionUID = 0L;
    private List<Bookmark> bookmarks;
    private String cpuMemoryFile;
    private String ppuMemoryFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBookmarks() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            if (this.bookmarks == null) {
                this.bookmarks = new ArrayList<Bookmark>();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getCpuMemoryFile() {
        return this.cpuMemoryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCpuMemoryFile(String cpuMemoryFile) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.cpuMemoryFile = cpuMemoryFile;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getPpuMemoryFile() {
        return this.ppuMemoryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPpuMemoryFile(String ppuMemoryFile) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.ppuMemoryFile = ppuMemoryFile;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public List<Bookmark> getBookmarks() {
        this.initBookmarks();
        return this.bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsBookmark(int dataSourceIndex, int address) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.initBookmarks();
            for (Bookmark bookmark : this.bookmarks) {
                if (bookmark.getAddress() != address || bookmark.getDataSourceIndex() != dataSourceIndex) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBookmark(int dataSourceIndex, int address) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.initBookmarks();
            for (int i = this.bookmarks.size() - 1; i >= 0; --i) {
                Bookmark bookmark = this.bookmarks.get(i);
                if (bookmark.getAddress() != address || bookmark.getDataSourceIndex() != dataSourceIndex) continue;
                this.bookmarks.remove(i);
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void addBookmark(int dataSourceIndex, int address, String name) {
        this.addBookmark(new Bookmark(dataSourceIndex, address, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmark(Bookmark bookmark) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.initBookmarks();
            this.bookmarks.remove(bookmark);
            this.bookmarks.add(bookmark);
            while (this.bookmarks.size() > 32) {
                this.bookmarks.remove(0);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBookmark(Bookmark bookmark) {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.initBookmarks();
            this.bookmarks.remove(bookmark);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllBookmarks() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            this.initBookmarks();
            this.bookmarks.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

