/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import nintaco.gui.IntPoint;
import nintaco.gui.historyeditor.HistoryTableModel;

public class HistoryTableRowRenderer
extends DefaultTableCellRenderer {
    private static final Color LIGHT_BLUE = new Color(0xDDFFFF);
    private static final Color BLUE = new Color(12842228);
    private static final Color DARK_BLUE = new Color(11331045);
    private static final Color GRAY = new Color(0xEDEDED);
    private static final Color DARK_GRAY = new Color(0xE2E2E2);
    private final IntPoint point = new IntPoint();
    private Font monospacedFont;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int columnIndex) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, columnIndex);
        if (columnIndex < 2) {
            Font tableFont = table.getFont();
            if (this.monospacedFont == null || this.monospacedFont.getSize() != tableFont.getSize()) {
                this.monospacedFont = new Font("Monospaced", 0, tableFont.getSize());
            }
            this.setFont(this.monospacedFont);
            this.setHorizontalAlignment(columnIndex == 0 ? 4 : 0);
        } else {
            this.setFont(table.getFont());
            this.setHorizontalAlignment(0);
        }
        this.setBorder(noFocusBorder);
        HistoryTableModel historyTableModel = (HistoryTableModel)table.getModel();
        if (columnIndex >= 2) {
            this.point.set(columnIndex, rowIndex);
            Color foreground = historyTableModel.getHotCells().get(this.point);
            if (foreground == null) {
                this.setForeground(Color.BLACK);
            } else {
                String s;
                if (!isSelected) {
                    this.setForeground(foreground);
                }
                if ((s = (String)value) != null && s.isEmpty()) {
                    this.setText("-");
                }
            }
        } else if (!isSelected) {
            this.setForeground(Color.BLACK);
        }
        if (!isSelected) {
            boolean headRow;
            int headIndex = historyTableModel.getHeadIndex();
            int tailIndex = historyTableModel.getTailIndex();
            boolean bl = headRow = rowIndex == headIndex;
            if (columnIndex == 0) {
                this.setBackground(Color.WHITE);
            } else if (columnIndex == 1) {
                this.setBackground(headRow || rowIndex > tailIndex ? Color.WHITE : LIGHT_BLUE);
            } else {
                boolean colorTest;
                boolean bl2 = colorTest = (columnIndex - 2 >> 3 & 1) == 0;
                if (rowIndex > tailIndex) {
                    this.setBackground(colorTest ? GRAY : DARK_GRAY);
                } else if (headRow) {
                    this.setBackground(colorTest ? LIGHT_BLUE : BLUE);
                } else {
                    this.setBackground(colorTest ? BLUE : DARK_BLUE);
                }
            }
        }
        return this;
    }
}

