/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.change;

import java.io.Serializable;
import nintaco.gui.historyeditor.BookmarksModel;
import nintaco.gui.historyeditor.HistoryBookmark;
import nintaco.gui.historyeditor.HistoryTableModel;
import nintaco.gui.historyeditor.change.HistoryChange;

public abstract class RangeChange
extends HistoryChange
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected final int rowIndex;
    protected final int[] buttons;
    protected HistoryBookmark[] deletedBookmarks;

    public RangeChange(int rowIndex, int[] buttons) {
        this.rowIndex = rowIndex;
        this.buttons = buttons;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getRowCount() {
        return this.buttons.length;
    }

    public int[] getButtons() {
        return this.buttons;
    }

    public int insert(HistoryTableModel model) {
        if (this.buttons.length > 0) {
            BookmarksModel bookmarksModel = model.getBookmarksModel();
            model.insertRows(this.rowIndex, this.buttons);
            bookmarksModel.handleFramesInserted(this.rowIndex, this.rowIndex + this.buttons.length - 1);
            if (this.deletedBookmarks != null && this.deletedBookmarks.length > 0) {
                for (int i = this.deletedBookmarks.length - 1; i >= 0; --i) {
                    bookmarksModel.add(this.deletedBookmarks[i]);
                }
                model.setBookmarks(bookmarksModel.getBookmarkedRows());
            }
        }
        return this.rowIndex;
    }

    public int delete(HistoryTableModel model) {
        if (this.buttons.length > 0) {
            BookmarksModel bookmarksModel = model.getBookmarksModel();
            model.deleteRows(this.rowIndex, this.buttons);
            this.deletedBookmarks = bookmarksModel.handleFramesDeleted(this.rowIndex, this.rowIndex + this.buttons.length - 1);
            model.setBookmarks(bookmarksModel.getBookmarkedRows());
        }
        return this.rowIndex;
    }
}

