/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.historyeditor.tasks;

import nintaco.App;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.gui.historyeditor.tasks.RenderScreenListener;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.input.InputUtil;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.MainCPU;
import nintaco.movie.Movie;
import nintaco.movie.MovieBlock;
import nintaco.movie.MovieFrame;
import nintaco.task.Task;
import nintaco.util.StreamUtil;

public class RenderScreenTask
extends Task {
    public static final RenderScreenListener DEFAULT_RENDER_SCREEN_LISTENER = (machineRunner, movieFrame) -> {
        SubMonitorFrame subMonitorFrame;
        App.getImageFrame().getImagePane().render(movieFrame.screen);
        if (movieFrame.isVsDualSystem() && (subMonitorFrame = App.getSubMonitorFrame()) != null) {
            subMonitorFrame.getImagePane().render(movieFrame.screen2);
        }
        App.updateRobFrame(movieFrame.robState);
    };
    private final Movie movie;
    private final int renderFrameIndex;
    private final RenderScreenListener renderScreenListener;
    private int frameIndex;
    private int renderIndex;
    private volatile boolean disposeEnabled = true;

    public RenderScreenTask(Movie movie, int renderFrameIndex, boolean renderToImagePane) {
        this(movie, renderFrameIndex, renderToImagePane ? DEFAULT_RENDER_SCREEN_LISTENER : null);
    }

    public RenderScreenTask(Movie movie, int renderFrameIndex, RenderScreenListener renderScreenListener) {
        this.movie = movie;
        this.renderFrameIndex = renderFrameIndex;
        this.renderScreenListener = renderScreenListener;
    }

    public void setDisposeEnabled(boolean disposeEnabled) {
        this.disposeEnabled = disposeEnabled;
    }

    @Override
    public void loop() {
        Machine machine;
        if (!this.running || this.movie == null || this.renderFrameIndex < 0) {
            return;
        }
        this.renderIndex = this.frameIndex = this.renderFrameIndex & 0xFFFFFFC0;
        int blockIndex = this.renderFrameIndex >> Movie.BLOCK_SHIFT;
        if (blockIndex >= this.movie.movieBlocks.size()) {
            return;
        }
        if (this.disposeEnabled && this.movie.movieFrames[0x7F & this.renderFrameIndex].frameIndex == this.renderFrameIndex) {
            if (this.renderScreenListener != null) {
                this.renderScreenListener.completedRendering(null, this.movie.movieFrames[0x7F & this.renderFrameIndex]);
            }
            return;
        }
        MovieBlock movieBlock = this.movie.movieBlocks.get(blockIndex);
        if (movieBlock.saveState == null) {
            return;
        }
        try {
            machine = (Machine)StreamUtil.readObject(movieBlock.saveState);
        }
        catch (Throwable t) {
            return;
        }
        MachineRunner machineRunner = new MachineRunner(machine);
        Mapper mapper = machine.getMapper();
        InputUtil.setMachine(machine);
        mapper.restore(App.getCartFile());
        mapper.restore(App.getFdsFile());
        mapper.restore(App.getNsfFile());
        machine.getPPU().setScreenRenderer(this::render);
        if (this.movie.isVsDualSystem()) {
            ((MainCPU)machine.getCPU()).getSubPPU().setScreenRenderer(this::render2);
        }
        machine.getAPU().setAudioProcessor(this::processOutputSample);
        int completeIndex = 0x3F & this.renderFrameIndex;
        int i = 0;
        while (i < 64 && this.running) {
            MovieFrame movieFrame = this.movie.movieFrames[0x7F & this.frameIndex];
            movieFrame.frameIndex = this.frameIndex;
            movieFrame.audioLength = 0;
            machineRunner.runFrame(movieBlock, i);
            if (i == completeIndex && this.renderScreenListener != null) {
                this.renderScreenListener.completedRendering(machineRunner, movieFrame);
                if (!this.disposeEnabled) {
                    return;
                }
            }
            ++i;
            ++this.frameIndex;
        }
        if (this.disposeEnabled) {
            machineRunner.dispose();
        }
    }

    private void processOutputSample(int value) {
        this.movie.movieFrames[0x7F & this.frameIndex].processOutputSample(value);
    }

    private int[] render() {
        return this.movie.movieFrames[0x7F & this.renderIndex++].screen;
    }

    private int[] render2() {
        return this.movie.movieFrames[0x7F & this.renderIndex - 1].screen2;
    }
}

