/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowStateListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import nintaco.App;
import nintaco.AppMode;
import nintaco.Machine;
import nintaco.MachineRunner;
import nintaco.MessageException;
import nintaco.PPU;
import nintaco.PauseStepType;
import nintaco.apu.SystemAudioProcessor;
import nintaco.files.ArchiveEntry;
import nintaco.files.FilePath;
import nintaco.files.FileUtil;
import nintaco.files.IpsUtil;
import nintaco.files.MutableNesFile;
import nintaco.files.NsfFile;
import nintaco.files.vs.goodnes.GoodNesFileUtil;
import nintaco.files.vs.mame.MameFileUtil;
import nintaco.gui.EditNesHeaderDialog;
import nintaco.gui.FileDrop;
import nintaco.gui.FileExtensionFilter;
import nintaco.gui.FontSizeDialog;
import nintaco.gui.PauseMenuListener;
import nintaco.gui.PleaseWaitDialog;
import nintaco.gui.StyleListener;
import nintaco.gui.TextDialog;
import nintaco.gui.YesNoDialog;
import nintaco.gui.about.AboutDialog;
import nintaco.gui.archive.ArchiveFileChooser;
import nintaco.gui.archive.ArchiveOptionsDialog;
import nintaco.gui.cheats.CheatsDialog;
import nintaco.gui.contentdirectory.ContentDirectoryDialog;
import nintaco.gui.debugger.logger.LoggerDialog;
import nintaco.gui.familybasic.BackgroundEditorFrame;
import nintaco.gui.familybasic.FamilyBasicOptionsDialog;
import nintaco.gui.fds.FamicomDiskSystemOptionsDialog;
import nintaco.gui.image.ImagePane;
import nintaco.gui.image.QuickSaveListener;
import nintaco.gui.image.QuickSaveStateInfo;
import nintaco.gui.image.SubMonitorFrame;
import nintaco.gui.image.filters.VideoFilterDescriptor;
import nintaco.gui.image.preferences.Paths;
import nintaco.gui.image.preferences.View;
import nintaco.gui.input.buttonmapping.ButtonMappingDialog;
import nintaco.gui.input.ports.PortsDialog;
import nintaco.gui.input.settings.InputSettingsDialog;
import nintaco.gui.nsf.NsfOptionsDialog;
import nintaco.gui.nsf.NsfPanel;
import nintaco.gui.overscan.OverscanDialog;
import nintaco.gui.palettes.PaletteOptionsDialog;
import nintaco.gui.rob.RobController;
import nintaco.gui.screenshots.ScreenshotOptionsDialog;
import nintaco.gui.sound.SoundOptionsDialog;
import nintaco.gui.userinterface.UserInterfaceDialog;
import nintaco.gui.userinterface.UserInterfacePrefs;
import nintaco.gui.watchhistory.WatchHistoryFrame;
import nintaco.gui.watchhistory.WatchHistoryPanel;
import nintaco.input.DeviceMapper;
import nintaco.input.InputUtil;
import nintaco.input.familybasic.FamilyBasicUtil;
import nintaco.input.familybasic.datarecorder.DataRecorderMapper;
import nintaco.input.other.EjectDisk;
import nintaco.input.other.FlipDiskSide;
import nintaco.input.other.Glitch;
import nintaco.input.other.InsertCoin;
import nintaco.input.other.PasteProgram;
import nintaco.input.other.PressServiceButton;
import nintaco.input.other.ScreamIntoMicrophone;
import nintaco.input.other.SetDataRecorderMode;
import nintaco.input.other.SetDiskSide;
import nintaco.input.other.SetNoSpriteLimit;
import nintaco.input.other.SetTVSystem;
import nintaco.input.other.SetupROB;
import nintaco.input.other.TypePaste;
import nintaco.mappers.Mapper;
import nintaco.mappers.nintendo.vs.DualAPU;
import nintaco.movie.Movie;
import nintaco.netplay.client.NetplayClient;
import nintaco.palettes.PalettePPU;
import nintaco.palettes.PaletteUtil;
import nintaco.palettes.Palettes;
import nintaco.preferences.AppPrefs;
import nintaco.tv.TVSystem;
import nintaco.util.BrowserUtil;
import nintaco.util.CollectionsUtil;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class ImageFrame
extends JFrame
implements StyleListener {
    public static final long HIDE_MENU_BAR_DELAY = 20000L;
    public static final FileExtensionFilter[] FileExtensionFilters = new FileExtensionFilter[]{null, new FileExtensionFilter(1, "iNES and NES 2.0 files (*.nes)", "nes", "nez"), new FileExtensionFilter(2, "Famicom Disk System files (*.fds)", "fds"), new FileExtensionFilter(3, "UNIF files (*.unf, *.unif)", "unf", "unif"), new FileExtensionFilter(4, "NES Sound Files (*.nsf, *.nsfe)", "nsf", "nsfe"), new FileExtensionFilter(5, "Archives (*.zip, *.rar, *.7z, *.tar*)", "zip", "rar", "7z", "tar.bz2", "tb2", "tbz", "tbz2", "tar.gz", "tgz", "tar.lzma", "tlz", "tar.xz", "txz", "tar.Z", "tZ"), new FileExtensionFilter(6, "All files (*.*)")};
    public static final FileExtensionFilter[] BasicFileExtensionFilters;
    public static final FileExtensionFilter[] TapeFileExtensionFilters;
    public static final String[] SpeedLabels;
    public static final int[] SpeedValues;
    private static final KeyEventDispatcher DisableKeyEventsDispatcher;
    private final KeyListener NoMenuBarKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            e.consume();
            int code = e.getKeyCode();
            if (e.isShiftDown()) {
                if (!e.isAltDown() && !e.isControlDown()) {
                    if (code >= 48 && code <= 57) {
                        ImageFrame.this.quickSaveState(code - 48);
                    } else {
                        switch (code) {
                            case 66: {
                                ImageFrame.this.flipDiskSideMenuItemActionPerformed(null);
                                break;
                            }
                            case 70: {
                                ImageFrame.this.nextFrameMenuItemActionPerformed(null);
                                break;
                            }
                            case 80: {
                                if (!ImageFrame.this.isPauseable()) break;
                                ImageFrame.this.pauseMenuItem.setSelected(!ImageFrame.this.pauseMenuItem.isSelected());
                                ImageFrame.this.pause();
                                break;
                            }
                            case 113: {
                                ImageFrame.this.insertCoinSubLeftMenuItemActionPerformed(null);
                                break;
                            }
                            case 114: {
                                ImageFrame.this.insertCoinSubRightMenuItemActionPerformed(null);
                            }
                        }
                    }
                }
            } else if (e.isControlDown()) {
                if (!e.isAltDown() && code == 82) {
                    ImageFrame.this.resetMenuItemActionPerformed(null);
                }
            } else if (e.isAltDown()) {
                if (code >= 49 && code <= 53) {
                    ImageFrame.this.setScreenScale(code - 48);
                } else {
                    switch (e.getKeyCode()) {
                        case 10: {
                            ImageFrame.this.toggleFullscreenMode();
                            break;
                        }
                        case 83: {
                            GuiUtil.maximize(ImageFrame.this);
                        }
                    }
                }
            } else if (code >= 48 && code <= 57) {
                ImageFrame.this.quickLoadState(code - 48);
            } else {
                switch (code) {
                    case 113: {
                        ImageFrame.this.insertCoinMainLeftMenuItemActionPerformed(null);
                        break;
                    }
                    case 114: {
                        ImageFrame.this.insertCoinMainRightMenuItemActionPerformed(null);
                        break;
                    }
                    case 123: {
                        ImageFrame.this.saveScreenshotMenuItemActionPerformed(null);
                        break;
                    }
                    case 27: {
                        ImageFrame.this.setFullscreenMode(false);
                        ImageFrame.this.setMenuBarVisible(true);
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }
    };
    private final JRadioButtonMenuItem[] speedMenuItems = new JRadioButtonMenuItem[SpeedValues.length];
    private final ImagePane imagePane = new ImagePane();
    private final NsfPanel nsfPanel = new NsfPanel();
    private boolean displayingImagePane;
    private Machine machine;
    private boolean historyTracking;
    private boolean timeRewinding;
    private boolean keyEventsEnabled;
    private boolean smoothScaling;
    private boolean useTvAspectRatio;
    private boolean uniformPixelScaling;
    private String saveFileName;
    private File lastSaveFile;
    private final List<QuickSaveStateInfo> quickSaveStateInfos = new ArrayList<QuickSaveStateInfo>();
    private final List<QuickSaveListener> quickSaveListeners = new ArrayList<QuickSaveListener>();
    private volatile QuickSaveStateInfo newestQuickSaveStateInfo;
    private volatile QuickSaveStateInfo oldestQuickSaveStateInfo;
    private volatile String fileInfo;
    private volatile File basicProgramFile;
    private volatile File tapeFile;
    private ButtonGroup diskSideButtonGroup = new ButtonGroup();
    private JCheckBoxMenuItem[] diskSideMenuItems = new JCheckBoxMenuItem[0];
    private boolean wasMaximized;
    private long exitFullscreenModeTime;
    private JMenuItem aboutMenuItem;
    private JMenuItem applyIPSMenuItem;
    private JMenuItem archiveFileOptionsMenuItem;
    private JMenuItem asmDasmMenuItem;
    private JCheckBoxMenuItem backgroundCheckBoxMenuItem;
    private JMenuItem barcodeBattlerMenuItem;
    private JMenuItem buttonMappingMenuItem;
    private JMenuItem clearHistoryMenuItem;
    private JMenuItem closeMenuItem;
    private JMenuItem connectToNetplayServerMenuItem;
    private JMenuItem contentDirectoryMenuItem;
    private JMenuItem createIPSMenuItem;
    private JMenu debugMenu;
    private JMenuItem debuggerMenuItem;
    private JRadioButtonMenuItem dendyRegionRadioButtonMenuItem;
    private JMenuItem dipSwitchesMenuItem;
    private JMenuItem editFileHeaderMenuItem;
    private JMenuItem editHistoryMenuItem;
    private JMenuItem ejectDiskMenuItem;
    private JMenuItem eraseBatterySaveMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem exportHistoryMenuItem;
    private JMenuItem exportVideoAudioMenuItem;
    private JMenuItem famicom3dGlassesMenuItem;
    private JMenuItem famicomDiskSystemOptionsMenuItem;
    private JMenuItem familyBasicCopyProgramMenuItem;
    private JMenuItem familyBasicEditBackgroundMenuItem;
    private JMenuItem familyBasicEraseTapeMenuItem;
    private JMenuItem familyBasicLoadBackgroundMenuItem;
    private JMenuItem familyBasicLoadProgramMenuItem;
    private JMenuItem familyBasicLoadTapeMenuItem;
    private JMenu familyBasicMenu;
    private JMenuItem familyBasicOptionsMenuItem;
    private JMenuItem familyBasicPasteProgramMenuItem;
    private JRadioButtonMenuItem familyBasicPlayTapeMenuItem;
    private JRadioButtonMenuItem familyBasicRecordTapeMenuItem;
    private JMenuItem familyBasicSaveBackgroundMenuItem;
    private JMenuItem familyBasicSaveProgramMenuItem;
    private JMenuItem familyBasicSaveTapeMenuItem;
    private JRadioButtonMenuItem familyBasicStopTapeMenuItem;
    private ButtonGroup familyBasicTapeButtonGroup;
    private JMenuItem familyBasicTypePasteMenuItem;
    private JMenuItem fileInfoMenuItem;
    private JMenu fileMenu;
    private JMenuItem flipDiskSideMenuItem;
    private JMenuItem fontSizeMenuItem;
    private JCheckBoxMenuItem fpsCheckBoxMenuItem;
    private JMenuItem fullscreenMenuItem;
    private JMenuItem glitchMenuItem;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JMenuItem hexEditorMenuItem;
    private JMenuItem hideMenuBarMenuItem;
    private JMenuItem hotSwapMenuItem;
    private JMenuItem importHistoryMenuItem;
    private JCheckBoxMenuItem inputDevicesCheckBoxMenuItem;
    private JMenuItem inputSettingsMenuItem;
    private JMenuItem insertCoinMainLeftMenuItem;
    private JMenuItem insertCoinMainRightMenuItem;
    private JMenu insertCoinMenu;
    private JMenuItem insertCoinSubLeftMenuItem;
    private JMenuItem insertCoinSubRightMenuItem;
    private JMenu insertDiskMenu;
    private JMenuItem jMenuItem1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JPopupMenu.Separator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JPopupMenu.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator18;
    private JPopupMenu.Separator jSeparator19;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator20;
    private JPopupMenu.Separator jSeparator21;
    private JPopupMenu.Separator jSeparator22;
    private JPopupMenu.Separator jSeparator23;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JPopupMenu.Separator jSeparator8;
    private JPopupMenu.Separator jSeparator9;
    private JMenuItem licenseMenuItem;
    private JMenuItem loadStateMenuItem;
    private ButtonGroup lookAndFeelButtonGroup;
    private JMenu lookAndFeelMenu;
    private JMenu machineMenu;
    private JMenuItem manageCheatsMenuItem;
    private JMenuItem mapMakerMenuItem;
    private JMenuBar menuBar;
    private JMenuItem nametablesMenuItem;
    private JMenuItem newestSlotMenuItem;
    private JMenuItem nextFrameMenuItem;
    private JCheckBoxMenuItem noSpriteLimitCheckBoxMenuItem;
    private JMenuItem nsfOptionsMenuItem;
    private JRadioButtonMenuItem ntscRegionRadioButtonMenuItem;
    private JMenuItem oamDataMenuItem;
    private JMenuItem oldestSlotMenuItem;
    private JMenuItem openMenuItem;
    private JMenu openRecentArchiveMenu;
    private JMenu openRecentDirectoryMenu;
    private JMenu openRecentFileMenu;
    private JMenu optionsMenu;
    private JMenuItem overscanMenuItem;
    private JRadioButtonMenuItem palRegionRadioButtonMenuItem;
    private JMenu paletteMenu;
    private JMenuItem palettesMenuItem;
    private JMenuItem patternTablesMenuItem;
    private JCheckBoxMenuItem pauseMenuItem;
    private JMenuItem portsMenuItem;
    private JMenuItem powerCycleMenuItem;
    private JPopupMenu.Separator quickLoadSeparator;
    private JMenu quickLoadStateMenu;
    private JPopupMenu.Separator quickSaveSeparator;
    private JMenu quickSaveStateMenu;
    private JMenuItem ramSearchMenuItem;
    private JMenuItem ramWatchMenuItem;
    private JMenuItem recentArchivesClearMenuItem;
    private JCheckBoxMenuItem recentArchivesLockCheckBoxMenuItem;
    private JPopupMenu.Separator recentArchivesSeparator;
    private JMenuItem recentDirectoriesClearMenuItem;
    private JCheckBoxMenuItem recentDirectoriesLockCheckBoxMenuItem;
    private JPopupMenu.Separator recentDirectoriesSeparator;
    private JMenuItem recentFilesClearMenuItem;
    private JCheckBoxMenuItem recentFilesLockCheckBoxMenuItem;
    private JPopupMenu.Separator recentFilesSeparator;
    private ButtonGroup regionButtonGroup;
    private JMenuItem resetMenuItem;
    private JCheckBoxMenuItem rewindTimeCheckBoxMenuItem;
    private JMenuItem robMenuItem;
    private JMenuItem runProgramMenuItem;
    private JMenuItem saveScreenshotMenuItem;
    private JMenuItem saveStateMenuItem;
    private JMenuItem screamIntoMicrophoneMenuItem;
    private JMenuItem screenSize1XMenuItem;
    private JMenuItem screenSize2XMenuItem;
    private JMenuItem screenSize3XMenuItem;
    private JMenuItem screenSize4XMenuItem;
    private JMenuItem screenSize5XMenuItem;
    private ButtonGroup screenSizeButtonGroup;
    private JMenuItem screenSizeMaxMenuItem;
    private JMenu screenSizeMenu;
    private JMenuItem screenshotOptionsMenuItem;
    private JMenuItem searchCheatsMenuItem;
    private JPopupMenu.Separator separator1;
    private JPopupMenu.Separator separator15;
    private JPopupMenu.Separator separator16;
    private JPopupMenu.Separator separator2;
    private JPopupMenu.Separator separator3;
    private JPopupMenu.Separator separator5;
    private JPopupMenu.Separator separator7;
    private JPopupMenu.Separator separator8;
    private JMenuItem serviceButtonMainMenuItem;
    private JMenu serviceButtonMenu;
    private JMenuItem serviceButtonSubMenuItem;
    private JMenu showMenu;
    private JCheckBoxMenuItem smoothScalingCheckBoxMenuItem;
    private JMenuItem soundMenuItem;
    private JMenu speedMenu;
    private JCheckBoxMenuItem spriteBoxesCheckBoxMenuItem;
    private JMenuItem spriteSaverMenuItem;
    private JCheckBoxMenuItem spritesCheckBoxMenuItem;
    private JMenuItem startNetplayServerMenuItem;
    private JMenuItem startProgramServerMenuItem;
    private JMenuItem startTraceLoggerMenuItem;
    private JCheckBoxMenuItem statusMessagesCheckBoxMenuItem;
    private JMenuItem subMonitorMenuItem;
    private JMenu toolsMenu;
    private JMenuItem traceLoggerOptionsMenuItem;
    private JCheckBoxMenuItem trackHistoryCheckBoxMenuItem;
    private JCheckBoxMenuItem tvAspectCheckBoxMenuItem;
    private JMenu tvSystemMenu;
    private JCheckBoxMenuItem underscanCheckBoxMenuItem;
    private JCheckBoxMenuItem uniformPixelScalingCheckBoxMenuItem;
    private JMenuItem userInterfaceMenuItem;
    private JMenu videoFilterMenu;
    private JMenu viewMenu;
    private JMenuItem volumeMixerMenuItem;
    private JMenuItem watchHistoryMenuItem;

    public ImageFrame() {
        this.initComponents();
        this.initMenuBar();
        this.createSpeedMenu();
        this.updateContentPane(null, null);
        this.initFileDragAndDrop();
    }

    public void init() {
        AppPrefs.getInstance().getUserInterfacePrefs().apply();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.requestFocus();
    }

    private void initFileDragAndDrop() {
        new FileDrop(this.imagePane, this::filesDropped);
        new FileDrop(this.nsfPanel, this::filesDropped);
    }

    private void initMenuBar() {
        this.createPaletteMenu();
        this.createLookAndFeelMenu();
        this.createRecentFilesMenu();
        this.trackHistoryCheckBoxMenuItem.setSelected(AppPrefs.getInstance().getHistoryPrefs().isTrackHistory());
        PauseMenuListener.addPauseMenuListener(this.menuBar);
        this.initTimeRewinding();
    }

    private void initTimeRewinding() {
        this.setTimeRewinding(this.timeRewinding);
        this.updateMenus();
    }

    private void initShowMenu() {
        View view = AppPrefs.getInstance().getView();
        this.fpsCheckBoxMenuItem.setSelected(view.isShowFPS());
        this.inputDevicesCheckBoxMenuItem.setSelected(view.isShowInputDevices());
        this.backgroundCheckBoxMenuItem.setSelected(view.isBackgroundEnabled());
        this.spritesCheckBoxMenuItem.setSelected(view.isSpritesEnabled());
        this.spriteBoxesCheckBoxMenuItem.setSelected(view.isSpriteBoxesEnabled());
    }

    private void initScreenSizeMenu() {
        View view = AppPrefs.getInstance().getView();
        this.useTvAspectRatio = view.isTvAspect();
        this.tvAspectCheckBoxMenuItem.setSelected(this.useTvAspectRatio);
        this.smoothScaling = view.isSmoothScaling();
        this.smoothScalingCheckBoxMenuItem.setSelected(this.smoothScaling);
        this.uniformPixelScaling = view.isUniformPixelScaling();
        this.uniformPixelScalingCheckBoxMenuItem.setSelected(this.uniformPixelScaling);
        this.underscanCheckBoxMenuItem.setSelected(view.isUnderscan());
        EventQueue.invokeLater(() -> {
            this.setUseTvAspectRatio(this.useTvAspectRatio);
            this.imagePane.setSmoothScaling(this.smoothScaling);
            this.imagePane.setUniformPixelScaling(this.uniformPixelScaling);
        });
    }

    private void filesDropped(File[] files) {
        if (!CollectionsUtil.isBlank(files)) {
            this.fileOpened(files[0], null, false, null, null);
        }
    }

    private void showWatchHistoryFrame(boolean showSave) {
        App.createWatchHistoryFrame();
        WatchHistoryFrame watchHistoryFrame = App.getWatchHistoryFrame();
        if (watchHistoryFrame != null) {
            WatchHistoryPanel watchHistoryPanel = watchHistoryFrame.getWatchHistoryPanel();
            watchHistoryPanel.init();
            watchHistoryPanel.setMovie(null);
            watchHistoryPanel.setShowSave(showSave);
            watchHistoryFrame.pack();
        }
    }

    public void movieLoaded(Movie movie) {
        App.createWatchHistoryFrame();
        WatchHistoryFrame watchHistoryFrame = App.getWatchHistoryFrame();
        if (watchHistoryFrame != null) {
            WatchHistoryPanel watchHistoryPanel = watchHistoryFrame.getWatchHistoryPanel();
            watchHistoryPanel.init();
            watchHistoryPanel.setMovie(movie);
            watchHistoryPanel.setShowSave(false);
            watchHistoryFrame.pack();
        }
    }

    public void setHistoryTracking(boolean historyTracking) {
        if (EventQueue.isDispatchThread()) {
            this.historyTracking = historyTracking;
            this.trackHistoryCheckBoxMenuItem.setSelected(historyTracking);
            this.setTimeRewinding(this.timeRewinding && historyTracking);
        } else {
            EventQueue.invokeLater(() -> this.setHistoryTracking(historyTracking));
        }
    }

    public void setTimeRewinding(boolean timeRewinding) {
        if (EventQueue.isDispatchThread()) {
            this.timeRewinding = timeRewinding;
        } else {
            EventQueue.invokeLater(() -> this.setTimeRewinding(timeRewinding));
        }
    }

    private void fireQuickSaveListeners() {
        for (QuickSaveListener quickSaveListener : this.quickSaveListeners) {
            quickSaveListener.onQuickSaveChanged(this.quickSaveStateInfos);
        }
    }

    public void handleQuickSaveStateMenuNames(String[] quickSaveStateMenuNames, boolean enabled) {
        boolean menusEnabled = quickSaveStateMenuNames != null;
        NetplayClient client = App.getNetplayClient();
        this.quickLoadStateMenu.removeAll();
        this.quickSaveStateMenu.removeAll();
        this.quickLoadStateMenu.setEnabled(menusEnabled);
        this.quickSaveStateMenu.setEnabled(menusEnabled);
        this.quickSaveStateInfos.clear();
        if (!menusEnabled) {
            return;
        }
        for (int i = 0; i < quickSaveStateMenuNames.length; ++i) {
            int index = i + 1;
            String name = quickSaveStateMenuNames[i];
            char key = Character.forDigit(i + 1, 10);
            JMenuItem loadMenuItem = new JMenuItem(name, key);
            GuiUtil.scaleMenuItemFont(loadMenuItem);
            loadMenuItem.setAccelerator(KeyStroke.getKeyStroke(key));
            loadMenuItem.setEnabled(enabled && !name.contains("..."));
            loadMenuItem.addActionListener(e -> client.post(18, index));
            this.quickLoadStateMenu.add(loadMenuItem);
            JMenuItem saveMenuItem = new JMenuItem(name, key);
            saveMenuItem.setEnabled(enabled);
            GuiUtil.scaleMenuItemFont(saveMenuItem);
            saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(key), 1));
            saveMenuItem.addActionListener(e -> client.post(19, index));
            this.quickSaveStateMenu.add(saveMenuItem);
        }
        this.removeAllActionListeners(this.newestSlotMenuItem);
        this.newestSlotMenuItem.addActionListener(e -> client.post(18, 0));
        this.newestSlotMenuItem.setEnabled(enabled);
        this.removeAllActionListeners(this.oldestSlotMenuItem);
        this.oldestSlotMenuItem.addActionListener(e -> client.post(19, 0));
        this.oldestSlotMenuItem.setEnabled(enabled);
        this.quickLoadStateMenu.add(this.quickLoadSeparator);
        this.quickLoadStateMenu.add(this.newestSlotMenuItem);
        this.quickSaveStateMenu.add(this.quickSaveSeparator);
        this.quickSaveStateMenu.add(this.oldestSlotMenuItem);
    }

    private void createVideoFiltersMenu() {
        this.videoFilterMenu.removeAll();
        VideoFilterDescriptor videoFilter = AppPrefs.getInstance().getView().getVideoFilter();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (VideoFilterDescriptor descriptor : VideoFilterDescriptor.values()) {
            if (descriptor == VideoFilterDescriptor.Current) continue;
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(descriptor.getName());
            this.videoFilterMenu.add(menuItem);
            buttonGroup.add(menuItem);
            menuItem.addActionListener(e -> {
                AppPrefs.getInstance().getView().setVideoFilter(descriptor);
                AppPrefs.save();
                this.imagePane.setVideoFilterDescriptor(descriptor);
                boolean tvAspect = descriptor.isUseTvAspectRatio() || this.useTvAspectRatio;
                this.tvAspectCheckBoxMenuItem.setSelected(tvAspect);
                this.setUseTvAspectRatio(tvAspect);
                boolean scaling = descriptor.isSmoothScaling() || this.smoothScaling;
                this.smoothScalingCheckBoxMenuItem.setSelected(scaling);
                this.imagePane.setSmoothScaling(scaling);
                this.setScreenScale(descriptor.getScale());
            });
            if (descriptor != videoFilter) continue;
            menuItem.setSelected(true);
            menuItem.doClick();
        }
    }

    public void createPaletteMenu() {
        if (EventQueue.isDispatchThread()) {
            this.paletteMenu.removeAll();
            ButtonGroup buttonGroup = new ButtonGroup();
            Palettes prefs = AppPrefs.getInstance().getPalettes();
            ArrayList<String> names = new ArrayList<String>();
            HashMap<PalettePPU, String> ppuPaletteMapping = new HashMap<PalettePPU, String>();
            prefs.getPaletteNames(names);
            prefs.getPpuPaletteMapping(ppuPaletteMapping);
            PalettePPU palettePPU = PaletteUtil.getPalettePPU();
            String selectedName = (String)ppuPaletteMapping.get((Object)palettePPU);
            for (String name : names) {
                JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(name);
                buttonGroup.add(menuItem);
                menuItem.addActionListener(e -> this.paletteSelected(palettePPU, name));
                if (name.equals(selectedName)) {
                    menuItem.setSelected(true);
                }
                this.paletteMenu.add(menuItem);
            }
            this.paletteMenu.add(new JSeparator());
            JMenuItem defaultMenuItem = new JMenuItem("Default");
            defaultMenuItem.addActionListener(arg -> {
                String defaultName = PaletteUtil.getDefaultName();
                Enumeration<AbstractButton> e = buttonGroup.getElements();
                while (e.hasMoreElements()) {
                    AbstractButton button = e.nextElement();
                    if (!defaultName.equals(button.getText())) continue;
                    button.setSelected(true);
                    button.doClick();
                    break;
                }
            });
            this.paletteMenu.add(defaultMenuItem);
        } else {
            EventQueue.invokeLater(this::createPaletteMenu);
        }
    }

    private void paletteSelected(PalettePPU palettePPU, String name) {
        Palettes prefs = AppPrefs.getInstance().getPalettes();
        HashMap<PalettePPU, String> ppuPaletteMapping = new HashMap<PalettePPU, String>();
        prefs.getPpuPaletteMapping(ppuPaletteMapping);
        ppuPaletteMapping.put(palettePPU, name);
        prefs.setPpuPaletteMapping(ppuPaletteMapping);
        AppPrefs.save();
        PaletteUtil.update();
    }

    private void createSpeedMenu() {
        this.speedMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < SpeedLabels.length; ++i) {
            JRadioButtonMenuItem menuItem;
            String label = SpeedLabels[i];
            int value = SpeedValues[i];
            this.speedMenuItems[i] = menuItem = new JRadioButtonMenuItem(label);
            if (value == 100) {
                menuItem.setSelected(true);
            }
            buttonGroup.add(menuItem);
            char c = label.charAt(0);
            if (Character.isAlphabetic(c)) {
                menuItem.setMnemonic(c);
            }
            menuItem.addActionListener(e -> App.setSpeed(value));
            this.speedMenu.add(menuItem);
        }
    }

    private void createQuickMenus() {
        this.quickLoadStateMenu.removeAll();
        this.quickSaveStateMenu.removeAll();
        this.quickSaveStateInfos.clear();
        for (int i = 1; i <= 9; ++i) {
            int slot = i;
            File file = new File(String.format("%s-%d", this.saveFileName, i));
            boolean fileExists = file.exists();
            String name = fileExists ? FileUtil.getFileTimestamp(i, file) : String.format("%d  ...                     ", i);
            char key = Character.forDigit(i, 10);
            JMenuItem loadMenuItem = new JMenuItem(name, key);
            GuiUtil.scaleMenuItemFont(loadMenuItem);
            loadMenuItem.setAccelerator(KeyStroke.getKeyStroke(key));
            loadMenuItem.setEnabled(fileExists);
            loadMenuItem.addActionListener(e -> {
                if ((e.getModifiers() & 8) == 0) {
                    this.quickLoadState(slot, file);
                }
            });
            this.quickLoadStateMenu.add(loadMenuItem);
            JMenuItem saveMenuItem = new JMenuItem(name, key);
            GuiUtil.scaleMenuItemFont(saveMenuItem);
            saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.getExtendedKeyCodeForChar(key), 1));
            int index = i;
            saveMenuItem.addActionListener(e -> this.quickSaveState(index, file, loadMenuItem, saveMenuItem));
            this.quickSaveStateMenu.add(saveMenuItem);
            this.quickSaveStateInfos.add(new QuickSaveStateInfo(i, file, file.lastModified(), loadMenuItem, saveMenuItem));
        }
        this.quickLoadStateMenu.add(this.quickLoadSeparator);
        this.quickLoadStateMenu.add(this.newestSlotMenuItem);
        this.quickSaveStateMenu.add(this.quickSaveSeparator);
        this.quickSaveStateMenu.add(this.oldestSlotMenuItem);
        this.findNewestAndOldestSaveSlots();
    }

    private void findNewestAndOldestSaveSlots() {
        QuickSaveStateInfo info;
        QuickSaveStateInfo newest = null;
        QuickSaveStateInfo oldest = null;
        for (QuickSaveStateInfo info2 : this.quickSaveStateInfos) {
            if (newest == null) {
                newest = info2;
                oldest = info2;
                continue;
            }
            if (info2.getModifiedTime() < oldest.getModifiedTime()) {
                oldest = info2;
            }
            if (info2.getModifiedTime() <= newest.getModifiedTime()) continue;
            newest = info2;
        }
        this.removeAllActionListeners(this.newestSlotMenuItem);
        if (newest.getModifiedTime() > 0L) {
            this.newestSlotMenuItem.setEnabled(true);
            info = newest;
            this.newestSlotMenuItem.addActionListener(e -> this.quickLoadState(info.getSlot(), info.getFile()));
        } else {
            newest = null;
            this.newestSlotMenuItem.setEnabled(false);
        }
        this.removeAllActionListeners(this.oldestSlotMenuItem);
        info = oldest;
        this.oldestSlotMenuItem.addActionListener(e -> this.quickSaveState(info.getSlot(), info.getFile(), info.getLoadMenuItem(), info.getSaveMenuItem()));
        this.newestQuickSaveStateInfo = newest;
        this.oldestQuickSaveStateInfo = oldest;
        this.fireQuickSaveListeners();
    }

    public void createLookAndFeelMenu() {
        View view = AppPrefs.getInstance().getView();
        String lookAndFeelClassName = view.getLookAndFeelClassName() == null ? UIManager.getSystemLookAndFeelClassName() : view.getLookAndFeelClassName();
        String metalLookAndFeelClassName = MetalLookAndFeel.class.getCanonicalName();
        UIManager.LookAndFeelInfo[] lookAndFeelInfos = UIManager.getInstalledLookAndFeels();
        Arrays.sort(lookAndFeelInfos, (a, b) -> a.getName().compareToIgnoreCase(b.getName()));
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfos) {
            if (lookAndFeelInfo.getClassName().equals(metalLookAndFeelClassName)) {
                this.addMetalLookAndFeelMenuItems(view);
                continue;
            }
            this.addLookAndFeelMenuItem(lookAndFeelInfo, lookAndFeelClassName);
        }
    }

    private void addMetalLookAndFeelMenuItems(View view) {
        String themeClassName = view.getThemeClassName();
        this.addMetalLookAndFeelMenuItem("Metal Ocean", () -> GuiUtil.setMetalLookAndFeel(new OceanTheme()), OceanTheme.class.getCanonicalName().equals(themeClassName));
        this.addMetalLookAndFeelMenuItem("Metal Steel", () -> GuiUtil.setMetalLookAndFeel(new DefaultMetalTheme()), DefaultMetalTheme.class.getCanonicalName().equals(themeClassName));
    }

    private void addMetalLookAndFeelMenuItem(String label, Runnable run, boolean isSelectedTheme) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(label);
        this.lookAndFeelButtonGroup.add(menuItem);
        if (isSelectedTheme) {
            menuItem.setSelected(true);
            EventQueue.invokeLater(run);
        }
        menuItem.addActionListener(e -> EventQueue.invokeLater(run));
        this.lookAndFeelMenu.add(menuItem);
    }

    private void addLookAndFeelMenuItem(UIManager.LookAndFeelInfo lookAndFeelInfo, String lookAndFeelClassName) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(lookAndFeelInfo.getName());
        this.lookAndFeelButtonGroup.add(menuItem);
        if (lookAndFeelInfo.getClassName().equals(lookAndFeelClassName)) {
            menuItem.setSelected(true);
            EventQueue.invokeLater(() -> GuiUtil.setLookAndFeel(lookAndFeelClassName));
        }
        menuItem.addActionListener(e -> EventQueue.invokeLater(() -> GuiUtil.setLookAndFeel(lookAndFeelInfo.getClassName())));
        this.lookAndFeelMenu.add(menuItem);
    }

    @Override
    public void styleChanged() {
        this.imagePane.updateUI();
        this.nsfPanel.updateUI();
        this.recentArchivesClearMenuItem.updateUI();
        this.recentArchivesLockCheckBoxMenuItem.updateUI();
        this.recentArchivesSeparator.updateUI();
        this.recentFilesClearMenuItem.updateUI();
        this.recentFilesLockCheckBoxMenuItem.updateUI();
        this.recentFilesSeparator.updateUI();
        this.recentDirectoriesClearMenuItem.updateUI();
        this.recentDirectoriesLockCheckBoxMenuItem.updateUI();
        this.recentDirectoriesSeparator.updateUI();
        this.imagePane.paneResized();
    }

    public void updateContentPane(Mapper mapper, NsfFile nsfFile) {
        if (EventQueue.isDispatchThread()) {
            boolean useImagePane;
            WatchHistoryFrame watchHistoryFrame = App.getWatchHistoryFrame();
            if (watchHistoryFrame != null) {
                watchHistoryFrame.getWatchHistoryPanel().resume(false);
            }
            this.nsfPanel.init(mapper, nsfFile);
            boolean bl = useImagePane = nsfFile == null;
            if (useImagePane != this.displayingImagePane) {
                this.displayingImagePane = useImagePane;
                if (useImagePane) {
                    InputUtil.setRewindTimeDisabled(false);
                    this.setContentPane(this.imagePane);
                } else {
                    InputUtil.setRewindTimeDisabled(true);
                    this.setContentPane(this.nsfPanel);
                }
                SwingUtilities.updateComponentTreeUI(this);
                GuiUtil.maxipack(this);
            }
        } else {
            EventQueue.invokeLater(() -> this.updateContentPane(mapper, nsfFile));
        }
    }

    public boolean isDisplayingImagePane() {
        return this.displayingImagePane;
    }

    private void removeAllActionListeners(AbstractButton button) {
        for (ActionListener listener : button.getActionListeners()) {
            button.removeActionListener(listener);
        }
    }

    public void quickLoadState(int slot) {
        QuickSaveStateInfo info;
        QuickSaveStateInfo quickSaveStateInfo = info = slot < 1 ? this.newestQuickSaveStateInfo : this.quickSaveStateInfos.get(slot - 1);
        if (info != null) {
            this.quickLoadState(slot, info.getFile());
        }
    }

    public void quickSaveState(int slot) {
        QuickSaveStateInfo info;
        QuickSaveStateInfo quickSaveStateInfo = info = slot < 1 ? this.oldestQuickSaveStateInfo : this.quickSaveStateInfos.get(slot - 1);
        if (info != null) {
            this.quickSaveState(info.getSlot(), info.getFile(), info.getLoadMenuItem(), info.getSaveMenuItem());
        }
    }

    private void quickLoadState(int slot, File file) {
        if (this.isSaveable()) {
            App.setStepPause(false);
            App.loadState(this, file, slot);
        }
    }

    private void quickSaveState(int slot, File file, JMenuItem loadMenuItem, JMenuItem saveMenuItem) {
        if (this.isSaveable()) {
            App.saveState(this, file, slot, () -> {
                Date date = new Date();
                String name = FileUtil.getFileTimestamp(slot, date);
                loadMenuItem.setEnabled(true);
                loadMenuItem.setText(name);
                saveMenuItem.setText(name);
                this.quickSaveStateInfos.set(slot - 1, new QuickSaveStateInfo(slot, file, date.getTime(), loadMenuItem, saveMenuItem));
                this.findNewestAndOldestSaveSlots();
            });
        }
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        this.nsfPanel.setMachine(machine);
        EventQueue.invokeLater(this::initTimeRewinding);
    }

    public void appModeChanged(AppMode appMode) {
        if (EventQueue.isDispatchThread()) {
            this.nsfPanel.appModeChanged(appMode);
            this.updateMenus();
        } else {
            EventQueue.invokeLater(() -> this.appModeChanged(appMode));
        }
    }

    public void setFileInfo(String fileInfo) {
        this.fileInfo = fileInfo;
    }

    public String getFileInfo() {
        return this.fileInfo;
    }

    public ImagePane getImagePane() {
        return this.imagePane;
    }

    public NsfPanel getNsfPanel() {
        return this.nsfPanel;
    }

    public void adjustSize() {
        if (EventQueue.isDispatchThread()) {
            if (this.imagePane.getBufferStrategy() == null) {
                GuiUtil.maxipack(this);
            }
        } else {
            GuiUtil.invokeAndWait(this::adjustSize);
        }
    }

    private void toggleFullscreenMode() {
        SubMonitorFrame subMonitorFrame = App.getSubMonitorFrame();
        if (this.imagePane.getBufferStrategy() != null || subMonitorFrame != null && subMonitorFrame.getImagePane().getBufferStrategy() != null) {
            if (subMonitorFrame != null) {
                subMonitorFrame.exitFullscreenMode();
            }
            this.exitFullscreenMode();
        } else {
            if (subMonitorFrame != null) {
                subMonitorFrame.enterFullscreenMode();
            }
            this.enterFullscreenMode();
        }
    }

    private void enterFullscreenMode() {
        if (this.imagePane.getBufferStrategy() == null) {
            this.wasMaximized = GuiUtil.isMaximized(this);
            GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
            this.dispose();
            GuiUtil.requestVsync(this, false);
            this.setUndecorated(true);
            this.setMenuBarVisible(false);
            this.setIgnoreRepaint(true);
            device.setFullScreenWindow(this);
            this.createBufferStrategy(3);
            this.imagePane.setBufferStrategy(this.getBufferStrategy());
            EventQueue.invokeLater(() -> this.setVisible(true));
            EventQueue.invokeLater(this.imagePane::redraw);
        }
    }

    private void exitFullscreenMode() {
        if (this.imagePane.getBufferStrategy() != null) {
            this.exitFullscreenModeTime = System.currentTimeMillis();
            this.imagePane.getBufferStrategy().dispose();
            this.imagePane.setBufferStrategy(null);
            this.dispose();
            this.setUndecorated(false);
            this.setIgnoreRepaint(false);
            this.setMenuBarVisible(true);
            if (this.wasMaximized) {
                GuiUtil.maximize(this);
            }
            GuiUtil.requestVsync(this, true);
            EventQueue.invokeLater(() -> this.setVisible(true));
            EventQueue.invokeLater(this.imagePane::redraw);
        }
    }

    public void setFullscreenMode(boolean fullscreenMode) {
        if (EventQueue.isDispatchThread()) {
            SubMonitorFrame subMonitorFrame = App.getSubMonitorFrame();
            if (fullscreenMode) {
                if (subMonitorFrame != null) {
                    subMonitorFrame.enterFullscreenMode();
                }
                this.enterFullscreenMode();
            } else {
                if (subMonitorFrame != null) {
                    subMonitorFrame.exitFullscreenMode();
                }
                this.exitFullscreenMode();
            }
        } else {
            EventQueue.invokeLater(() -> this.setFullscreenMode(fullscreenMode));
        }
    }

    private void openArchiveFile(String archiveFileName, String entryFileName, PleaseWaitDialog pleaseWaitDialog, boolean editHeader, Machine ejectedMachine) {
        if (!this.validateFdsBIOS(entryFileName)) {
            pleaseWaitDialog.dispose();
            if (GuiUtil.invokeAndWait(() -> this.checkFdsBIOS(entryFileName)).booleanValue()) {
                pleaseWaitDialog = new PleaseWaitDialog((Window)this);
                pleaseWaitDialog.setMessage("Reading archive file...");
                pleaseWaitDialog.showAfterDelay();
            } else {
                return;
            }
        }
        this.loadArchiveFile(archiveFileName, entryFileName, pleaseWaitDialog, editHeader, ejectedMachine);
    }

    private void openArchiveFile(String archiveFileName, PleaseWaitDialog pleaseWaitDialog, boolean editHeader, Machine ejectedMachine) {
        List<String> entries = null;
        try {
            entries = ArchiveEntry.toNames(FileUtil.getArchiveEntries(archiveFileName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        List<String> files = entries;
        if (files == null) {
            pleaseWaitDialog.dispose();
            GuiUtil.displayError(this, "Failed to open archive file.");
            App.setNoStepPause(false);
        } else if (files.isEmpty()) {
            int archiveID;
            List<ArchiveEntry> allEntries = null;
            if (!editHeader) {
                try {
                    allEntries = FileUtil.getArchiveEntries(archiveFileName, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((archiveID = MameFileUtil.identifyArchive(allEntries)) >= 0) {
                this.loadMameFile(archiveFileName, allEntries, archiveID, pleaseWaitDialog, ejectedMachine);
            } else {
                pleaseWaitDialog.dispose();
                GuiUtil.displayError(this, "The archive does not contain any supported files.");
                App.setNoStepPause(false);
            }
        } else {
            int defaultEntry = FileUtil.getDefaultArchiveEntry(archiveFileName, entries);
            if (files.size() == 1 || defaultEntry >= 0 && AppPrefs.getInstance().getArchivePrefs().isOpenDefaultArchiveEntry()) {
                this.openArchiveFile(archiveFileName, files.get(defaultEntry), pleaseWaitDialog, editHeader, ejectedMachine);
            } else {
                pleaseWaitDialog.dispose();
                EventQueue.invokeLater(() -> this.showArchiveFileChooser(archiveFileName, files, defaultEntry, editHeader, ejectedMachine));
            }
        }
    }

    private void showArchiveFileChooser(String archiveFileName, List<String> files, int defaultEntry, boolean editHeader, Machine ejectedMachine) {
        ArchiveFileChooser archiveChooser = new ArchiveFileChooser((Window)this, files, defaultEntry);
        archiveChooser.setVisible(true);
        String entryFileName = archiveChooser.getSelectedFile();
        if (entryFileName == null) {
            App.setNoStepPause(false);
        } else if (this.checkFdsBIOS(entryFileName).booleanValue()) {
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            pleaseWaitDialog.setMessage("Reading archive file...");
            new Thread(() -> this.loadArchiveFile(archiveFileName, entryFileName, pleaseWaitDialog, editHeader, ejectedMachine)).start();
            pleaseWaitDialog.showAfterDelay();
        }
    }

    private void loadMameFile(String archiveFileName, List<ArchiveEntry> allEntries, int archiveID, PleaseWaitDialog pleaseWaitDialog, Machine ejectedMachine) {
        String error = null;
        try {
            MameFileUtil.getArchiveInputStream(archiveFileName, allEntries, archiveID, (stream, size) -> this.handleInputStream(archiveFileName, null, pleaseWaitDialog, false, ejectedMachine, stream, size));
        }
        catch (FileNotFoundException e) {
            error = "The selected file was not found.";
        }
        catch (MessageException e) {
            error = e.getMessage();
        }
        catch (Throwable t) {
            error = "Failed to load from archive.";
        }
        if (error != null) {
            pleaseWaitDialog.dispose();
            GuiUtil.displayError("Invalid File Error", this, error);
        }
    }

    private void loadGoodNesFile(String archiveFileName, String entryFileName, List<ArchiveEntry> allEntries, int archiveID, PleaseWaitDialog pleaseWaitDialog, Machine ejectedMachine) {
        String error = null;
        try {
            GoodNesFileUtil.getArchiveInputStream(archiveFileName, allEntries, archiveID, (stream, size) -> this.handleInputStream(archiveFileName, entryFileName, pleaseWaitDialog, false, ejectedMachine, stream, size));
        }
        catch (FileNotFoundException e) {
            error = "The selected file was not found.";
        }
        catch (MessageException e) {
            error = e.getMessage();
        }
        catch (Throwable t) {
            error = "Failed to load from archive.";
        }
        if (error != null) {
            pleaseWaitDialog.dispose();
            GuiUtil.displayError("Invalid File Error", this, error);
        }
    }

    private void loadArchiveFile(String archiveFileName, String entryFileName, PleaseWaitDialog pleaseWaitDialog, boolean editHeader, Machine ejectedMachine) {
        if (!editHeader) {
            App.close();
            int candidateID = GoodNesFileUtil.identifyCandidate(archiveFileName, entryFileName);
            if (candidateID >= 0) {
                List<ArchiveEntry> allEntries;
                try {
                    allEntries = FileUtil.getArchiveEntries(archiveFileName, null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    pleaseWaitDialog.dispose();
                    GuiUtil.displayError("Invalid File Error", this, "Failed to load from archive.");
                    return;
                }
                int archiveID = GoodNesFileUtil.confirmCandidate(archiveFileName, candidateID, allEntries);
                if (archiveID >= 0) {
                    this.loadGoodNesFile(archiveFileName, entryFileName, allEntries, archiveID, pleaseWaitDialog, ejectedMachine);
                    return;
                }
            }
        }
        String error = null;
        try {
            IpsUtil.getArchiveInputStream(archiveFileName, entryFileName, (stream, size) -> this.handleInputStream(archiveFileName, entryFileName, pleaseWaitDialog, editHeader, ejectedMachine, stream, size));
        }
        catch (FileNotFoundException e) {
            error = "The selected file was not found.";
        }
        catch (MessageException e) {
            error = e.getMessage();
        }
        catch (Throwable t) {
            t.printStackTrace();
            error = "Failed to load from archive.";
        }
        if (error != null) {
            pleaseWaitDialog.dispose();
            GuiUtil.displayError("Invalid File Error", this, error);
        }
    }

    private void handleInputStream(String archiveFileName, String entryFileName, PleaseWaitDialog pleaseWaitDialog, boolean editHeader, Machine ejectedMachine, InputStream stream, long size) {
        String errorMessage = null;
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(stream));){
            if (editHeader) {
                AppPrefs.getInstance().getPaths().addRecentDirectory(FileUtil.getDirectoryPath(archiveFileName));
                AppPrefs.save();
                this.editFileHeader(in, size, pleaseWaitDialog, entryFileName);
                EventQueue.invokeLater(this::createRecentFilesMenu);
            } else {
                App.setStepPause(false);
                Mapper m = App.loadFile(in, size, entryFileName, archiveFileName);
                if (App.isVsSystem() && AppPrefs.getInstance().getDipSwitchesAppPrefs().isDisplayDialogOnLoad()) {
                    pleaseWaitDialog.dispose();
                    App.showDipSwitchesDialog();
                    this.fileInfo = App.createMachine(m, ejectedMachine);
                } else {
                    this.fileInfo = App.createMachine(m, ejectedMachine);
                    pleaseWaitDialog.dispose();
                }
                AppPrefs.getInstance().getPaths().addRecentFile(entryFileName, archiveFileName);
                AppPrefs.save();
                this.saveFileName = FileUtil.createSaveFile(StringUtil.isBlank(entryFileName) ? archiveFileName : entryFileName);
                this.lastSaveFile = new File(this.saveFileName);
                EventQueue.invokeLater(this::finishLoad);
            }
        }
        catch (FileNotFoundException e) {
            errorMessage = "The selected file was not found.";
        }
        catch (MessageException e) {
            errorMessage = e.getMessage();
        }
        catch (Throwable t) {
            t.printStackTrace();
            errorMessage = "Failed to load from archive.";
        }
        if (errorMessage != null) {
            pleaseWaitDialog.dispose();
            if (editHeader) {
                App.setNoStepPause(false);
            } else {
                App.close();
            }
            GuiUtil.displayError("Invalid File Error", this, errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDiskFile(String fileName, PleaseWaitDialog pleaseWaitDialog, boolean editHeader, Machine ejectedMachine) {
        FilterInputStream in = null;
        String errorMessage = null;
        try {
            IpsUtil.OpenFileHandle handle = IpsUtil.getOpenFileHandle(fileName);
            in = new DataInputStream(new BufferedInputStream(handle.getInputStream()));
            if (editHeader) {
                AppPrefs.getInstance().getPaths().addRecentDirectory(FileUtil.getDirectoryPath(fileName));
                AppPrefs.save();
                this.editFileHeader((DataInputStream)in, handle.getFileSize(), pleaseWaitDialog, FileUtil.getFileName(fileName));
                EventQueue.invokeLater(this::createRecentFilesMenu);
            } else {
                App.setStepPause(false);
                Mapper m = App.loadFile((DataInputStream)in, handle.getFileSize(), fileName);
                if (App.isVsSystem() && AppPrefs.getInstance().getDipSwitchesAppPrefs().isDisplayDialogOnLoad()) {
                    pleaseWaitDialog.dispose();
                    App.showDipSwitchesDialog();
                    this.fileInfo = App.createMachine(m, ejectedMachine);
                } else {
                    this.fileInfo = App.createMachine(m, ejectedMachine);
                    pleaseWaitDialog.dispose();
                }
                AppPrefs.getInstance().getPaths().addRecentFile(fileName);
                AppPrefs.save();
                this.saveFileName = FileUtil.createSaveFile(fileName);
                this.lastSaveFile = new File(this.saveFileName);
                EventQueue.invokeLater(this::finishLoad);
            }
        }
        catch (FileNotFoundException e) {
            errorMessage = "The selected file was not found.";
        }
        catch (MessageException e) {
            errorMessage = e.getMessage();
        }
        catch (Throwable t) {
            t.printStackTrace();
            errorMessage = "Unable to open file.";
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable e) {}
            }
        }
        if (errorMessage != null) {
            pleaseWaitDialog.dispose();
            if (editHeader) {
                App.setNoStepPause(false);
            } else {
                App.close();
            }
            GuiUtil.displayError("Invalid File Error", this, errorMessage);
        }
    }

    private void finishLoad() {
        App.setSpeed(100);
        UserInterfacePrefs prefs = AppPrefs.getInstance().getUserInterfacePrefs();
        this.createQuickMenus();
        this.createRecentFilesMenu();
        this.updateMenus();
        if (prefs.isHideMenuBar()) {
            this.setMenuBarVisible(false);
        }
        if (prefs.isEnterFullscreen()) {
            this.enterFullscreenMode();
        }
    }

    private void updateMenus() {
        this.fileMenuMenuSelected(null);
        this.machineMenuMenuSelected(null);
        this.viewMenuMenuSelected(null);
        this.toolsMenuMenuSelected(null);
        this.debugMenuMenuSelected(null);
    }

    private boolean validateFdsBIOS(String fileName) {
        return !FileUtil.isFamicomDiskSystemFile(fileName) || App.loadFdsBIOS();
    }

    private Boolean checkFdsBIOS(String fileName) {
        if (!this.validateFdsBIOS(fileName)) {
            YesNoDialog yesNoDialog = new YesNoDialog((Window)this, AppPrefs.getInstance().getFamicomDiskSystemPrefs().getBiosFile() == null ? "<p>Famicom Disk System emulation requires a BIOS file.</p><p></p><p>Set that up?</p>" : "<p>The provided Famicom Disk System BIOS file is missing or invalid.</p><p></p><p>Update the configuration?</p>", "BIOS File Required");
            yesNoDialog.setVisible(true);
            if (!yesNoDialog.isYes()) {
                return false;
            }
            FamicomDiskSystemOptionsDialog fdsDialog = new FamicomDiskSystemOptionsDialog((Window)this);
            fdsDialog.setVisible(true);
            return App.isFdsBiosLoaded();
        }
        return true;
    }

    private void editFileHeader(DataInputStream in, long fileSize, PleaseWaitDialog pleaseWaitDialog, String entryFileName) throws Throwable {
        MutableNesFile nesFile = new MutableNesFile(in, fileSize);
        pleaseWaitDialog.dispose();
        EventQueue.invokeLater(() -> {
            EditNesHeaderDialog editDialog = new EditNesHeaderDialog((Frame)this, true);
            editDialog.setNesFile(nesFile);
            editDialog.setEntryFileName(entryFileName);
            editDialog.pack();
            editDialog.setLocationRelativeTo(this);
            editDialog.setVisible(true);
            if (editDialog.getSaveFile() == null) {
                App.setNoStepPause(false);
            } else {
                PleaseWaitDialog pwDialog = new PleaseWaitDialog((Window)this);
                new Thread(() -> this.saveEditedNesFile(editDialog, pwDialog)).start();
                pwDialog.showAfterDelay();
            }
        });
    }

    private void saveEditedNesFile(EditNesHeaderDialog editDialog, PleaseWaitDialog pleaseWaitDialog) {
        try {
            editDialog.getNesFile().write(editDialog.getSaveFile());
            pleaseWaitDialog.dispose();
        }
        catch (Throwable t) {
            pleaseWaitDialog.dispose();
            GuiUtil.displayError(this, "Failed to save NES file.");
        }
        App.setNoStepPause(false);
    }

    private void exit() {
        App.setNoStepPause(true);
        if (AppPrefs.getInstance().getUserInterfacePrefs().isConfirmExit()) {
            YesNoDialog yesNoDialog = new YesNoDialog((Window)this, "Do you really want to exit?", "Confirm Exit");
            yesNoDialog.setVisible(true);
            if (yesNoDialog.isNo()) {
                App.setNoStepPause(false);
                return;
            }
        }
        try {
            App.close();
            App.destroyFrames();
            AppPrefs.flush();
            this.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createRecentFilesMenu() {
        this.openRecentFileMenu.removeAll();
        Paths paths = AppPrefs.getInstance().getPaths();
        List<FilePath> filePaths = paths.getRecentFiles();
        if (filePaths.isEmpty()) {
            this.openRecentFileMenu.setEnabled(false);
        } else {
            this.openRecentFileMenu.setEnabled(App.getAppMode() == AppMode.Default);
            Class<AppPrefs> clazz = AppPrefs.class;
            // MONITORENTER : nintaco.preferences.AppPrefs.class
            for (FilePath filePath : filePaths) {
                JMenuItem menuItem = new JMenuItem(filePath.toString());
                GuiUtil.scaleMenuItemFont(menuItem);
                menuItem.addActionListener(e -> this.recentFileMenuItemPressed(filePath));
                this.openRecentFileMenu.add(menuItem);
            }
            // MONITOREXIT : clazz
            this.openRecentFileMenu.add(this.recentFilesSeparator);
            this.openRecentFileMenu.add(this.recentFilesLockCheckBoxMenuItem);
            this.openRecentFileMenu.add(this.recentFilesClearMenuItem);
        }
        this.recentFilesLockCheckBoxMenuItem.setSelected(paths.isLockRecentFiles());
        this.createRecentArchivesMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createRecentArchivesMenu() {
        this.openRecentArchiveMenu.removeAll();
        Paths paths = AppPrefs.getInstance().getPaths();
        List<String> archiveFiles = paths.getRecentArchives();
        if (archiveFiles.isEmpty()) {
            this.openRecentArchiveMenu.setEnabled(false);
        } else {
            this.openRecentArchiveMenu.setEnabled(true);
            Class<AppPrefs> clazz = AppPrefs.class;
            // MONITORENTER : nintaco.preferences.AppPrefs.class
            for (String archiveFile : archiveFiles) {
                JMenuItem menuItem = new JMenuItem(FileUtil.getFileName(archiveFile));
                GuiUtil.scaleMenuItemFont(menuItem);
                menuItem.addActionListener(e -> this.recentArchiveMenuItemPressed(archiveFile));
                this.openRecentArchiveMenu.add(menuItem);
            }
            // MONITOREXIT : clazz
            this.openRecentArchiveMenu.add(this.recentArchivesSeparator);
            this.openRecentArchiveMenu.add(this.recentArchivesLockCheckBoxMenuItem);
            this.openRecentArchiveMenu.add(this.recentArchivesClearMenuItem);
        }
        this.recentArchivesLockCheckBoxMenuItem.setSelected(paths.isLockRecentArchives());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void createRecentDirectoriesMenu() {
        this.openRecentDirectoryMenu.removeAll();
        Paths paths = AppPrefs.getInstance().getPaths();
        List<String> directories = paths.getRecentDirectories();
        if (!directories.isEmpty()) {
            Class<AppPrefs> clazz = AppPrefs.class;
            // MONITORENTER : nintaco.preferences.AppPrefs.class
            for (String directory : directories) {
                JMenuItem menuItem = new JMenuItem(directory);
                GuiUtil.scaleMenuItemFont(menuItem);
                menuItem.addActionListener(e -> this.openFile(directory, false, null));
                this.openRecentDirectoryMenu.add(menuItem);
            }
            // MONITOREXIT : clazz
            this.openRecentDirectoryMenu.add(this.recentDirectoriesSeparator);
            this.openRecentDirectoryMenu.add(this.recentDirectoriesLockCheckBoxMenuItem);
            this.openRecentDirectoryMenu.add(this.recentDirectoriesClearMenuItem);
        }
        this.recentDirectoriesLockCheckBoxMenuItem.setSelected(paths.isLockRecentDirectories());
    }

    public void open(FilePath filePath) {
        EventQueue.invokeLater(() -> this.recentFileMenuItemPressed(filePath));
    }

    private void recentFileMenuItemPressed(FilePath filePath) {
        if (!this.checkFdsBIOS(filePath.getEntryPath()).booleanValue()) {
            return;
        }
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        if (filePath.isArchivedEntry()) {
            pleaseWaitDialog.setMessage("Reading archive file...");
            new Thread(() -> this.loadArchiveFile(filePath.getArchivePath(), filePath.getEntryPath(), pleaseWaitDialog, false, null)).start();
        } else {
            pleaseWaitDialog.setMessage("Reading file...");
            new Thread(() -> this.loadDiskFile(filePath.getEntryPath(), pleaseWaitDialog, false, null)).start();
        }
        pleaseWaitDialog.showAfterDelay();
    }

    private void recentArchiveMenuItemPressed(String archiveFile) {
        App.setNoStepPause(true);
        PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
        pleaseWaitDialog.setMessage("Reading archive file...");
        new Thread(() -> this.openArchiveFile(archiveFile, pleaseWaitDialog, false, null)).start();
        pleaseWaitDialog.showAfterDelay();
    }

    private void openFile(String directory, boolean editHeader, Machine ejectedMachine) {
        App.setNoStepPause(true);
        Paths paths = AppPrefs.getInstance().getPaths();
        if (directory == null) {
            directory = paths.getFilesDir();
        }
        JFileChooser chooser = GuiUtil.createFileChooser("Open", directory, (FileFilter[])FileExtensionFilters);
        chooser.setFileFilter(FileExtensionFilters[paths.getFileExtensionFilterIndex()]);
        if (GuiUtil.showOpenDialog(this, chooser, null) == 0) {
            FileFilter fileFilter = chooser.getFileFilter();
            File file = chooser.getSelectedFile();
            if (file == null || StringUtil.isBlank(file.toString())) {
                App.setNoStepPause(false);
                return;
            }
            this.fileOpened(chooser.getSelectedFile(), directory, editHeader, ejectedMachine, fileFilter);
        } else {
            App.setNoStepPause(false);
        }
    }

    public void openFile(String fileName) {
        if (EventQueue.isDispatchThread()) {
            this.openFile(new File(fileName));
        } else {
            EventQueue.invokeLater(() -> this.openFile(fileName));
        }
    }

    public void openFile(File file) {
        if (EventQueue.isDispatchThread()) {
            this.fileOpened(file, null, false, null, null);
        } else {
            EventQueue.invokeLater(() -> this.openFile(file));
        }
    }

    private void fileOpened(File file, String directory, boolean editHeader, Machine ejectedMachine, FileFilter fileFilter) {
        String entryFileName;
        String archiveFileName;
        FilePath filePath;
        if (file == null || StringUtil.isBlank(file.toString())) {
            App.setNoStepPause(false);
            return;
        }
        Paths paths = AppPrefs.getInstance().getPaths();
        if (directory == null) {
            directory = paths.getFilesDir();
        }
        if ((filePath = FilePath.fromLongString(file.toString())) == null) {
            GuiUtil.displayError("Open File Error", this, "Invalid file name.");
            App.setNoStepPause(false);
            return;
        }
        File outerFile = new File(filePath.getOuterPath());
        if (!outerFile.exists()) {
            if (FileUtil.isDirectory(outerFile)) {
                GuiUtil.displayError("Open File Error", this, "The specified directory does not exist.");
                App.setNoStepPause(false);
                String dir = directory;
                EventQueue.invokeLater(() -> this.openFile(dir, editHeader, ejectedMachine));
                return;
            }
            GuiUtil.displayError("Open File Error", this, "The specified file does not exist.");
            App.setNoStepPause(false);
            return;
        }
        if (!outerFile.isFile()) {
            GuiUtil.displayError("Open File Error", this, "The specified path is not a file or an existing directory.");
            App.setNoStepPause(false);
            return;
        }
        if (filePath.isArchivedEntry()) {
            if (!FileUtil.isArchiveFile(filePath.getArchivePath())) {
                GuiUtil.displayError("Open File Error", this, "Unsupported archive file type.");
                App.setNoStepPause(false);
                return;
            }
            archiveFileName = filePath.getArchivePath();
            entryFileName = filePath.getEntryPath();
        } else if (FileUtil.isArchiveFile(filePath.getEntryPath())) {
            archiveFileName = filePath.getEntryPath();
            entryFileName = null;
        } else {
            archiveFileName = null;
            entryFileName = filePath.getEntryPath();
        }
        paths.setFilesDir(FileUtil.getDirectoryPath(filePath.getOuterPath()));
        if (fileFilter instanceof FileExtensionFilter && fileFilter.accept(new File(filePath.getOuterPath()))) {
            paths.setFileExtensionFilterIndex(((FileExtensionFilter)fileFilter).getIndex());
        } else {
            paths.setFileExtensionFilterIndex(0);
        }
        AppPrefs.save();
        if (archiveFileName != null && entryFileName != null && !this.checkFdsBIOS(entryFileName).booleanValue()) {
            App.setNoStepPause(false);
            return;
        }
        if (archiveFileName != null || this.checkFdsBIOS(entryFileName).booleanValue()) {
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            if (archiveFileName != null) {
                pleaseWaitDialog.setMessage("Reading archive file...");
                if (entryFileName != null) {
                    new Thread(() -> this.openArchiveFile(archiveFileName, entryFileName, pleaseWaitDialog, editHeader, ejectedMachine)).start();
                } else {
                    new Thread(() -> this.openArchiveFile(archiveFileName, pleaseWaitDialog, editHeader, ejectedMachine)).start();
                }
            } else {
                pleaseWaitDialog.setMessage("Reading file...");
                new Thread(() -> this.loadDiskFile(entryFileName, pleaseWaitDialog, editHeader, ejectedMachine)).start();
            }
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void saveOrOpenState(int dialogType) {
        App.setNoStepPause(true);
        String directory = AppPrefs.getInstance().getPaths().getSaveStatesDir();
        FileUtil.mkdir(directory);
        JFileChooser chooser = GuiUtil.createFileChooser(dialogType == 1 ? "Save As" : "Open", directory, new FileNameExtensionFilter("Nintaco Save File (save)", "save"));
        chooser.setSelectedFile(this.lastSaveFile);
        if (GuiUtil.showFileChooser(this, chooser, null, dialogType) == 0) {
            if (dialogType == 1) {
                this.saveState(chooser.getSelectedFile());
                App.setNoStepPause(false);
            } else {
                this.loadState(chooser.getSelectedFile());
            }
        } else {
            App.setNoStepPause(false);
        }
    }

    public void saveState(File stateFile) {
        this.lastSaveFile = stateFile;
        App.saveState(this, stateFile, -1);
    }

    public void loadState(File stateFile) {
        this.lastSaveFile = stateFile;
        App.setStepPause(false);
        App.loadState(this, stateFile, -1);
    }

    public void addQuickSaveListener(QuickSaveListener quickSaveListener) {
        this.quickSaveListeners.add(quickSaveListener);
        this.fireQuickSaveListeners();
    }

    public void removeQuickSaveListener(QuickSaveListener quickSaveListener) {
        this.quickSaveListeners.remove(quickSaveListener);
    }

    public void onStepPausedChanged(boolean paused) {
        this.imagePane.setPaused(paused);
        this.pauseMenuItem.setSelected(paused);
        this.nextFrameMenuItem.setEnabled(this.pauseMenuItem.isEnabled() && paused);
    }

    private void enableKeyEvents() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(DisableKeyEventsDispatcher);
    }

    public void setKeyEventsEnabled(boolean keyEventsEnabled) {
        if (EventQueue.isDispatchThread()) {
            this.keyEventsEnabled = keyEventsEnabled;
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.removeKeyEventDispatcher(DisableKeyEventsDispatcher);
            if (!keyEventsEnabled) {
                manager.addKeyEventDispatcher(DisableKeyEventsDispatcher);
            }
        } else {
            EventQueue.invokeLater(() -> this.setKeyEventsEnabled(keyEventsEnabled));
        }
    }

    private void loadBasicProgram(File file, PleaseWaitDialog pleaseWaitDialog) {
        if (GuiUtil.executeMessageTask(this, pleaseWaitDialog, () -> FamilyBasicUtil.loadProgram(file))) {
            this.basicProgramFile = file;
        }
    }

    private void saveBasicProgram(File file, PleaseWaitDialog pleaseWaitDialog) {
        if (GuiUtil.executeMessageTask(this, pleaseWaitDialog, () -> FamilyBasicUtil.saveProgram(file))) {
            this.basicProgramFile = file;
        }
    }

    private void loadTape(File file, PleaseWaitDialog pleaseWaitDialog) {
        boolean loadError = false;
        try {
            this.machine.getMapper().getDataRecorder().loadTape(file);
        }
        catch (Throwable t) {
            loadError = true;
        }
        pleaseWaitDialog.dispose();
        if (loadError) {
            GuiUtil.displayError("Load Tape Error", this, "Failed to load tape file.");
        } else {
            GuiUtil.displayInformation("Tape Loaded", this, "The tape data was successfully retrieved.");
        }
        App.setNoStepPause(false);
    }

    private void saveTape(File file, PleaseWaitDialog pleaseWaitDialog) {
        boolean saveError = false;
        try {
            this.machine.getMapper().getDataRecorder().saveTape(file);
        }
        catch (Throwable t) {
            saveError = true;
        }
        pleaseWaitDialog.dispose();
        if (saveError) {
            GuiUtil.displayError("Save Tape Error", this, "Failed to save tape file.");
        } else {
            GuiUtil.displayInformation("Tape Saved", this, "The tape data was successfully stored.");
        }
        App.setNoStepPause(false);
    }

    private void setScreenScale(int scale) {
        App.runSubMonitorFrame(f -> f.setScreenScale(scale));
        this.setFullscreenMode(false);
        Rectangle area = GuiUtil.getScreenWorkingArea(this);
        if (scale << 8 > area.width || 240 * scale > area.height) {
            this.screenSizeMaxMenuItemActionPerformed(null);
        } else {
            GuiUtil.normalize(this);
            this.imagePane.setScreenScale(scale);
            GuiUtil.maxipack(this);
        }
    }

    private void setMenuBarVisible(boolean visible) {
        if (visible) {
            this.removeKeyListener(this.NoMenuBarKeyListener);
        } else {
            this.addKeyListener(this.NoMenuBarKeyListener);
        }
        this.menuBar.setVisible(visible);
        GuiUtil.maxipack(this);
    }

    private void reset() {
        App.reset();
    }

    private void pause() {
        App.setStepPause(this.pauseMenuItem.isSelected());
    }

    private void nextFrame() {
        App.step(PauseStepType.Frame);
    }

    private void flipDisk() {
        InputUtil.addOtherInput(new FlipDiskSide());
    }

    private void insertCoin(int vsSystem, int coinSlot) {
        InputUtil.addOtherInput(new InsertCoin(vsSystem, coinSlot));
    }

    private void setUseTvAspectRatio(boolean useTvAspectRatio) {
        App.runSubMonitorFrame(f -> f.setUseTvAspectRatio(useTvAspectRatio));
        if (this.imagePane.isUseTvAspectRatio() != useTvAspectRatio) {
            this.imagePane.setUseTvAspectRatio(useTvAspectRatio);
            GuiUtil.maxipack(this);
        }
    }

    private void setTVSystem(TVSystem tvSystem) {
        InputUtil.addOtherInput(new SetTVSystem(tvSystem));
    }

    private boolean isSaveable() {
        AppMode appMode = App.getAppMode();
        return this.machine != null && appMode != AppMode.HistoryEditor && appMode != AppMode.WatchHistory && (appMode != AppMode.NetplayClient || App.getNetplayClient().getQuickSaveNames() != null);
    }

    private boolean isPauseable() {
        AppMode appMode = App.getAppMode();
        return this.machine != null && this.displayingImagePane && appMode != AppMode.WatchHistory && appMode != AppMode.HistoryEditor && appMode != AppMode.NetplayClient;
    }

    private void initComponents() {
        this.screenSizeButtonGroup = new ButtonGroup();
        this.lookAndFeelButtonGroup = new ButtonGroup();
        this.familyBasicTapeButtonGroup = new ButtonGroup();
        this.regionButtonGroup = new ButtonGroup();
        this.jMenuItem1 = new JMenuItem();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.openRecentFileMenu = new JMenu();
        this.recentFilesSeparator = new JPopupMenu.Separator();
        this.recentFilesLockCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.recentFilesClearMenuItem = new JMenuItem();
        this.openRecentArchiveMenu = new JMenu();
        this.recentArchivesSeparator = new JPopupMenu.Separator();
        this.recentArchivesLockCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.recentArchivesClearMenuItem = new JMenuItem();
        this.openRecentDirectoryMenu = new JMenu();
        this.recentDirectoriesSeparator = new JPopupMenu.Separator();
        this.recentDirectoriesLockCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.recentDirectoriesClearMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.separator3 = new JPopupMenu.Separator();
        this.loadStateMenuItem = new JMenuItem();
        this.saveStateMenuItem = new JMenuItem();
        this.separator1 = new JPopupMenu.Separator();
        this.quickLoadStateMenu = new JMenu();
        this.quickLoadSeparator = new JPopupMenu.Separator();
        this.newestSlotMenuItem = new JMenuItem();
        this.quickSaveStateMenu = new JMenu();
        this.quickSaveSeparator = new JPopupMenu.Separator();
        this.oldestSlotMenuItem = new JMenuItem();
        this.separator8 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.machineMenu = new JMenu();
        this.resetMenuItem = new JMenuItem();
        this.powerCycleMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.pauseMenuItem = new JCheckBoxMenuItem();
        this.nextFrameMenuItem = new JMenuItem();
        this.speedMenu = new JMenu();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.tvSystemMenu = new JMenu();
        this.ntscRegionRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.palRegionRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.dendyRegionRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.jSeparator20 = new JPopupMenu.Separator();
        this.insertDiskMenu = new JMenu();
        this.flipDiskSideMenuItem = new JMenuItem();
        this.ejectDiskMenuItem = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.familyBasicMenu = new JMenu();
        this.familyBasicPlayTapeMenuItem = new JRadioButtonMenuItem();
        this.familyBasicRecordTapeMenuItem = new JRadioButtonMenuItem();
        this.familyBasicStopTapeMenuItem = new JRadioButtonMenuItem();
        this.jSeparator8 = new JPopupMenu.Separator();
        this.familyBasicLoadTapeMenuItem = new JMenuItem();
        this.familyBasicSaveTapeMenuItem = new JMenuItem();
        this.familyBasicEraseTapeMenuItem = new JMenuItem();
        this.jSeparator9 = new JPopupMenu.Separator();
        this.familyBasicCopyProgramMenuItem = new JMenuItem();
        this.familyBasicPasteProgramMenuItem = new JMenuItem();
        this.familyBasicTypePasteMenuItem = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.familyBasicLoadProgramMenuItem = new JMenuItem();
        this.familyBasicSaveProgramMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.familyBasicEditBackgroundMenuItem = new JMenuItem();
        this.familyBasicLoadBackgroundMenuItem = new JMenuItem();
        this.familyBasicSaveBackgroundMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.insertCoinMenu = new JMenu();
        this.insertCoinMainLeftMenuItem = new JMenuItem();
        this.insertCoinMainRightMenuItem = new JMenuItem();
        this.insertCoinSubLeftMenuItem = new JMenuItem();
        this.insertCoinSubRightMenuItem = new JMenuItem();
        this.serviceButtonMenu = new JMenu();
        this.serviceButtonMainMenuItem = new JMenuItem();
        this.serviceButtonSubMenuItem = new JMenuItem();
        this.dipSwitchesMenuItem = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.screamIntoMicrophoneMenuItem = new JMenuItem();
        this.jSeparator22 = new JPopupMenu.Separator();
        this.eraseBatterySaveMenuItem = new JMenuItem();
        this.hotSwapMenuItem = new JMenuItem();
        this.glitchMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.fileInfoMenuItem = new JMenuItem();
        this.separator15 = new JPopupMenu.Separator();
        this.barcodeBattlerMenuItem = new JMenuItem();
        this.famicom3dGlassesMenuItem = new JMenuItem();
        this.robMenuItem = new JMenuItem();
        this.subMonitorMenuItem = new JMenuItem();
        this.separator5 = new JPopupMenu.Separator();
        this.showMenu = new JMenu();
        this.statusMessagesCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.fpsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.inputDevicesCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator19 = new JPopupMenu.Separator();
        this.backgroundCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.spritesCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.spriteBoxesCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.noSpriteLimitCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.screenSizeMenu = new JMenu();
        this.screenSize1XMenuItem = new JMenuItem();
        this.screenSize2XMenuItem = new JMenuItem();
        this.screenSize3XMenuItem = new JMenuItem();
        this.screenSize4XMenuItem = new JMenuItem();
        this.screenSize5XMenuItem = new JMenuItem();
        this.screenSizeMaxMenuItem = new JMenuItem();
        this.separator16 = new JPopupMenu.Separator();
        this.tvAspectCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.smoothScalingCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.uniformPixelScalingCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.underscanCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.videoFilterMenu = new JMenu();
        this.paletteMenu = new JMenu();
        this.lookAndFeelMenu = new JMenu();
        this.fontSizeMenuItem = new JMenuItem();
        this.separator7 = new JPopupMenu.Separator();
        this.hideMenuBarMenuItem = new JMenuItem();
        this.fullscreenMenuItem = new JMenuItem();
        this.optionsMenu = new JMenu();
        this.buttonMappingMenuItem = new JMenuItem();
        this.portsMenuItem = new JMenuItem();
        this.inputSettingsMenuItem = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.soundMenuItem = new JMenuItem();
        this.volumeMixerMenuItem = new JMenuItem();
        this.nsfOptionsMenuItem = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.contentDirectoryMenuItem = new JMenuItem();
        this.archiveFileOptionsMenuItem = new JMenuItem();
        this.famicomDiskSystemOptionsMenuItem = new JMenuItem();
        this.familyBasicOptionsMenuItem = new JMenuItem();
        this.traceLoggerOptionsMenuItem = new JMenuItem();
        this.jSeparator18 = new JPopupMenu.Separator();
        this.userInterfaceMenuItem = new JMenuItem();
        this.screenshotOptionsMenuItem = new JMenuItem();
        this.overscanMenuItem = new JMenuItem();
        this.palettesMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.startNetplayServerMenuItem = new JMenuItem();
        this.connectToNetplayServerMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.mapMakerMenuItem = new JMenuItem();
        this.spriteSaverMenuItem = new JMenuItem();
        this.jSeparator11 = new JPopupMenu.Separator();
        this.runProgramMenuItem = new JMenuItem();
        this.startProgramServerMenuItem = new JMenuItem();
        this.jSeparator14 = new JPopupMenu.Separator();
        this.manageCheatsMenuItem = new JMenuItem();
        this.searchCheatsMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.editFileHeaderMenuItem = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.saveScreenshotMenuItem = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.applyIPSMenuItem = new JMenuItem();
        this.createIPSMenuItem = new JMenuItem();
        this.jSeparator21 = new JPopupMenu.Separator();
        this.trackHistoryCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.watchHistoryMenuItem = new JMenuItem();
        this.exportVideoAudioMenuItem = new JMenuItem();
        this.editHistoryMenuItem = new JMenuItem();
        this.clearHistoryMenuItem = new JMenuItem();
        this.importHistoryMenuItem = new JMenuItem();
        this.exportHistoryMenuItem = new JMenuItem();
        this.rewindTimeCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.debugMenu = new JMenu();
        this.debuggerMenuItem = new JMenuItem();
        this.oamDataMenuItem = new JMenuItem();
        this.patternTablesMenuItem = new JMenuItem();
        this.nametablesMenuItem = new JMenuItem();
        this.hexEditorMenuItem = new JMenuItem();
        this.asmDasmMenuItem = new JMenuItem();
        this.ramSearchMenuItem = new JMenuItem();
        this.ramWatchMenuItem = new JMenuItem();
        this.jSeparator23 = new JPopupMenu.Separator();
        this.startTraceLoggerMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.licenseMenuItem = new JMenuItem();
        this.separator2 = new JPopupMenu.Separator();
        this.aboutMenuItem = new JMenuItem();
        this.jMenuItem1.setText("jMenuItem1");
        this.setDefaultCloseOperation(0);
        this.setTitle("Nintaco");
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent evt) {
                ImageFrame.this.formWindowStateChanged(evt);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                ImageFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                ImageFrame.this.formWindowLostFocus(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ImageFrame.this.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                ImageFrame.this.formWindowOpened(evt);
            }
        });
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.fileMenu.setName("");
        this.fileMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.fileMenuMenuSelected(evt);
            }
        });
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText("Open...");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.openRecentFileMenu.setMnemonic('F');
        this.openRecentFileMenu.setText("Open Recent File");
        this.openRecentFileMenu.add(this.recentFilesSeparator);
        this.recentFilesLockCheckBoxMenuItem.setMnemonic('L');
        this.recentFilesLockCheckBoxMenuItem.setText("Lock");
        this.recentFilesLockCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.recentFilesLockCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.openRecentFileMenu.add(this.recentFilesLockCheckBoxMenuItem);
        this.recentFilesClearMenuItem.setMnemonic('C');
        this.recentFilesClearMenuItem.setText("Clear");
        this.recentFilesClearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.recentFilesClearMenuItemActionPerformed(evt);
            }
        });
        this.openRecentFileMenu.add(this.recentFilesClearMenuItem);
        this.fileMenu.add(this.openRecentFileMenu);
        this.openRecentArchiveMenu.setMnemonic('A');
        this.openRecentArchiveMenu.setText("Open Recent Archive");
        this.openRecentArchiveMenu.add(this.recentArchivesSeparator);
        this.recentArchivesLockCheckBoxMenuItem.setMnemonic('L');
        this.recentArchivesLockCheckBoxMenuItem.setSelected(true);
        this.recentArchivesLockCheckBoxMenuItem.setText("Lock");
        this.recentArchivesLockCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.recentArchivesLockCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.openRecentArchiveMenu.add(this.recentArchivesLockCheckBoxMenuItem);
        this.recentArchivesClearMenuItem.setMnemonic('C');
        this.recentArchivesClearMenuItem.setText("Clear");
        this.recentArchivesClearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.recentArchivesClearMenuItemActionPerformed(evt);
            }
        });
        this.openRecentArchiveMenu.add(this.recentArchivesClearMenuItem);
        this.fileMenu.add(this.openRecentArchiveMenu);
        this.openRecentDirectoryMenu.setMnemonic('D');
        this.openRecentDirectoryMenu.setText("Open Recent Directory");
        this.openRecentDirectoryMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.openRecentDirectoryMenuMenuSelected(evt);
            }
        });
        this.openRecentDirectoryMenu.add(this.recentDirectoriesSeparator);
        this.recentDirectoriesLockCheckBoxMenuItem.setMnemonic('L');
        this.recentDirectoriesLockCheckBoxMenuItem.setText("Lock");
        this.recentDirectoriesLockCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.recentDirectoriesLockCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.openRecentDirectoryMenu.add(this.recentDirectoriesLockCheckBoxMenuItem);
        this.recentDirectoriesClearMenuItem.setMnemonic('C');
        this.recentDirectoriesClearMenuItem.setText("Clear");
        this.recentDirectoriesClearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.recentDirectoriesClearMenuItemActionPerformed(evt);
            }
        });
        this.openRecentDirectoryMenu.add(this.recentDirectoriesClearMenuItem);
        this.fileMenu.add(this.openRecentDirectoryMenu);
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeMenuItem.setMnemonic('C');
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.fileMenu.add(this.separator3);
        this.loadStateMenuItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        this.loadStateMenuItem.setMnemonic('L');
        this.loadStateMenuItem.setText("Load State...");
        this.loadStateMenuItem.setEnabled(false);
        this.loadStateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.loadStateMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadStateMenuItem);
        this.saveStateMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.saveStateMenuItem.setText("Save State...");
        this.saveStateMenuItem.setEnabled(false);
        this.saveStateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.saveStateMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveStateMenuItem);
        this.fileMenu.add(this.separator1);
        this.quickLoadStateMenu.setMnemonic('a');
        this.quickLoadStateMenu.setText("Quick Load State");
        this.quickLoadStateMenu.setEnabled(false);
        this.quickLoadStateMenu.add(this.quickLoadSeparator);
        this.newestSlotMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 0));
        this.newestSlotMenuItem.setMnemonic('N');
        this.newestSlotMenuItem.setText("Newest Slot");
        this.quickLoadStateMenu.add(this.newestSlotMenuItem);
        this.fileMenu.add(this.quickLoadStateMenu);
        this.quickSaveStateMenu.setMnemonic('v');
        this.quickSaveStateMenu.setText("Quick Save State");
        this.quickSaveStateMenu.setEnabled(false);
        this.quickSaveStateMenu.add(this.quickSaveSeparator);
        this.oldestSlotMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 1));
        this.oldestSlotMenuItem.setMnemonic('O');
        this.oldestSlotMenuItem.setText("Oldest Slot");
        this.quickSaveStateMenu.add(this.oldestSlotMenuItem);
        this.fileMenu.add(this.quickSaveStateMenu);
        this.fileMenu.add(this.separator8);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.machineMenu.setMnemonic('M');
        this.machineMenu.setText("Machine");
        this.machineMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.machineMenuMenuSelected(evt);
            }
        });
        this.resetMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.resetMenuItem.setMnemonic('R');
        this.resetMenuItem.setText("Reset");
        this.resetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.resetMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.resetMenuItem);
        this.powerCycleMenuItem.setMnemonic('C');
        this.powerCycleMenuItem.setText("Power Cycle");
        this.powerCycleMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.powerCycleMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.powerCycleMenuItem);
        this.machineMenu.add(this.jSeparator1);
        this.pauseMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 1));
        this.pauseMenuItem.setMnemonic('P');
        this.pauseMenuItem.setText("Pause");
        this.pauseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.pauseMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.pauseMenuItem);
        this.nextFrameMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 1));
        this.nextFrameMenuItem.setMnemonic('N');
        this.nextFrameMenuItem.setText("Next Frame");
        this.nextFrameMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.nextFrameMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.nextFrameMenuItem);
        this.speedMenu.setMnemonic('S');
        this.speedMenu.setText("Speed");
        this.speedMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.speedMenuMenuSelected(evt);
            }
        });
        this.machineMenu.add(this.speedMenu);
        this.machineMenu.add(this.jSeparator5);
        this.tvSystemMenu.setMnemonic('T');
        this.tvSystemMenu.setText("TV System");
        this.tvSystemMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.tvSystemMenuMenuSelected(evt);
            }
        });
        this.regionButtonGroup.add(this.ntscRegionRadioButtonMenuItem);
        this.ntscRegionRadioButtonMenuItem.setText("NTSC");
        this.ntscRegionRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.ntscRegionRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.tvSystemMenu.add(this.ntscRegionRadioButtonMenuItem);
        this.regionButtonGroup.add(this.palRegionRadioButtonMenuItem);
        this.palRegionRadioButtonMenuItem.setText("PAL");
        this.palRegionRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.palRegionRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.tvSystemMenu.add(this.palRegionRadioButtonMenuItem);
        this.regionButtonGroup.add(this.dendyRegionRadioButtonMenuItem);
        this.dendyRegionRadioButtonMenuItem.setText("Dendy");
        this.dendyRegionRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.dendyRegionRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.tvSystemMenu.add(this.dendyRegionRadioButtonMenuItem);
        this.machineMenu.add(this.tvSystemMenu);
        this.machineMenu.add(this.jSeparator20);
        this.insertDiskMenu.setMnemonic('D');
        this.insertDiskMenu.setText("Insert Disk");
        this.machineMenu.add(this.insertDiskMenu);
        this.flipDiskSideMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, 1));
        this.flipDiskSideMenuItem.setMnemonic('F');
        this.flipDiskSideMenuItem.setText("Flip Disk Side");
        this.flipDiskSideMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.flipDiskSideMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.flipDiskSideMenuItem);
        this.ejectDiskMenuItem.setMnemonic('E');
        this.ejectDiskMenuItem.setText("Eject Disk");
        this.ejectDiskMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.ejectDiskMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.ejectDiskMenuItem);
        this.machineMenu.add(this.jSeparator13);
        this.familyBasicMenu.setMnemonic('B');
        this.familyBasicMenu.setText("Family BASIC");
        this.familyBasicMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.familyBasicMenuMenuSelected(evt);
            }
        });
        this.familyBasicTapeButtonGroup.add(this.familyBasicPlayTapeMenuItem);
        this.familyBasicPlayTapeMenuItem.setText("Play Tape");
        this.familyBasicPlayTapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicPlayTapeMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicPlayTapeMenuItem);
        this.familyBasicTapeButtonGroup.add(this.familyBasicRecordTapeMenuItem);
        this.familyBasicRecordTapeMenuItem.setText("Record Tape");
        this.familyBasicRecordTapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicRecordTapeMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicRecordTapeMenuItem);
        this.familyBasicTapeButtonGroup.add(this.familyBasicStopTapeMenuItem);
        this.familyBasicStopTapeMenuItem.setSelected(true);
        this.familyBasicStopTapeMenuItem.setText("Stop Tape");
        this.familyBasicStopTapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicStopTapeMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicStopTapeMenuItem);
        this.familyBasicMenu.add(this.jSeparator8);
        this.familyBasicLoadTapeMenuItem.setText("Load Tape...");
        this.familyBasicLoadTapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicLoadTapeMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicLoadTapeMenuItem);
        this.familyBasicSaveTapeMenuItem.setText("Save Tape...");
        this.familyBasicSaveTapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicSaveTapeMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicSaveTapeMenuItem);
        this.familyBasicEraseTapeMenuItem.setText("Erase Tape");
        this.familyBasicEraseTapeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicEraseTapeMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicEraseTapeMenuItem);
        this.familyBasicMenu.add(this.jSeparator9);
        this.familyBasicCopyProgramMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.familyBasicCopyProgramMenuItem.setMnemonic('C');
        this.familyBasicCopyProgramMenuItem.setText("Copy Program");
        this.familyBasicCopyProgramMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicCopyProgramMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicCopyProgramMenuItem);
        this.familyBasicPasteProgramMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.familyBasicPasteProgramMenuItem.setMnemonic('P');
        this.familyBasicPasteProgramMenuItem.setText("Paste Program");
        this.familyBasicPasteProgramMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicPasteProgramMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicPasteProgramMenuItem);
        this.familyBasicTypePasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.familyBasicTypePasteMenuItem.setMnemonic('T');
        this.familyBasicTypePasteMenuItem.setText("Type Paste");
        this.familyBasicTypePasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicTypePasteMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicTypePasteMenuItem);
        this.familyBasicMenu.add(this.jSeparator6);
        this.familyBasicLoadProgramMenuItem.setMnemonic('L');
        this.familyBasicLoadProgramMenuItem.setText("Load Program...");
        this.familyBasicLoadProgramMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicLoadProgramMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicLoadProgramMenuItem);
        this.familyBasicSaveProgramMenuItem.setMnemonic('S');
        this.familyBasicSaveProgramMenuItem.setText("Save Program...");
        this.familyBasicSaveProgramMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicSaveProgramMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicSaveProgramMenuItem);
        this.familyBasicMenu.add(this.jSeparator7);
        this.familyBasicEditBackgroundMenuItem.setMnemonic('E');
        this.familyBasicEditBackgroundMenuItem.setText("Edit Background...");
        this.familyBasicEditBackgroundMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicEditBackgroundMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicEditBackgroundMenuItem);
        this.familyBasicLoadBackgroundMenuItem.setMnemonic('d');
        this.familyBasicLoadBackgroundMenuItem.setText("Load Background...");
        this.familyBasicLoadBackgroundMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicLoadBackgroundMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicLoadBackgroundMenuItem);
        this.familyBasicSaveBackgroundMenuItem.setMnemonic('v');
        this.familyBasicSaveBackgroundMenuItem.setText("Save Background...");
        this.familyBasicSaveBackgroundMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicSaveBackgroundMenuItemActionPerformed(evt);
            }
        });
        this.familyBasicMenu.add(this.familyBasicSaveBackgroundMenuItem);
        this.machineMenu.add(this.familyBasicMenu);
        this.machineMenu.add(this.jSeparator3);
        this.insertCoinMenu.setMnemonic('I');
        this.insertCoinMenu.setText("Insert Coin");
        this.insertCoinMainLeftMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.insertCoinMainLeftMenuItem.setText("Main Left");
        this.insertCoinMainLeftMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.insertCoinMainLeftMenuItemActionPerformed(evt);
            }
        });
        this.insertCoinMenu.add(this.insertCoinMainLeftMenuItem);
        this.insertCoinMainRightMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.insertCoinMainRightMenuItem.setText("Main Right");
        this.insertCoinMainRightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.insertCoinMainRightMenuItemActionPerformed(evt);
            }
        });
        this.insertCoinMenu.add(this.insertCoinMainRightMenuItem);
        this.insertCoinSubLeftMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 1));
        this.insertCoinSubLeftMenuItem.setText("Sub Left");
        this.insertCoinSubLeftMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.insertCoinSubLeftMenuItemActionPerformed(evt);
            }
        });
        this.insertCoinMenu.add(this.insertCoinSubLeftMenuItem);
        this.insertCoinSubRightMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 1));
        this.insertCoinSubRightMenuItem.setText("Sub Right");
        this.insertCoinSubRightMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.insertCoinSubRightMenuItemActionPerformed(evt);
            }
        });
        this.insertCoinMenu.add(this.insertCoinSubRightMenuItem);
        this.machineMenu.add(this.insertCoinMenu);
        this.serviceButtonMenu.setMnemonic('v');
        this.serviceButtonMenu.setText("Press Service Button");
        this.serviceButtonMainMenuItem.setText("Main");
        this.serviceButtonMainMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.serviceButtonMainMenuItemActionPerformed(evt);
            }
        });
        this.serviceButtonMenu.add(this.serviceButtonMainMenuItem);
        this.serviceButtonSubMenuItem.setText("Sub");
        this.serviceButtonSubMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.serviceButtonSubMenuItemActionPerformed(evt);
            }
        });
        this.serviceButtonMenu.add(this.serviceButtonSubMenuItem);
        this.machineMenu.add(this.serviceButtonMenu);
        this.dipSwitchesMenuItem.setMnemonic('w');
        this.dipSwitchesMenuItem.setText("DIP Switches...");
        this.dipSwitchesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.dipSwitchesMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.dipSwitchesMenuItem);
        this.machineMenu.add(this.jSeparator17);
        this.screamIntoMicrophoneMenuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.screamIntoMicrophoneMenuItem.setMnemonic('M');
        this.screamIntoMicrophoneMenuItem.setText("Scream into Microphone");
        this.screamIntoMicrophoneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screamIntoMicrophoneMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.screamIntoMicrophoneMenuItem);
        this.machineMenu.add(this.jSeparator22);
        this.eraseBatterySaveMenuItem.setMnemonic('a');
        this.eraseBatterySaveMenuItem.setText("Erase Battery Save");
        this.eraseBatterySaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.eraseBatterySaveMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.eraseBatterySaveMenuItem);
        this.hotSwapMenuItem.setMnemonic('H');
        this.hotSwapMenuItem.setText("Hot Swap...");
        this.hotSwapMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.hotSwapMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.hotSwapMenuItem);
        this.glitchMenuItem.setMnemonic('G');
        this.glitchMenuItem.setText("Glitch");
        this.glitchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.glitchMenuItemActionPerformed(evt);
            }
        });
        this.machineMenu.add(this.glitchMenuItem);
        this.menuBar.add(this.machineMenu);
        this.viewMenu.setMnemonic('V');
        this.viewMenu.setText("View");
        this.viewMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.viewMenuMenuSelected(evt);
            }
        });
        this.fileInfoMenuItem.setMnemonic('I');
        this.fileInfoMenuItem.setText("File Info...");
        this.fileInfoMenuItem.setEnabled(false);
        this.fileInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.fileInfoMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.fileInfoMenuItem);
        this.viewMenu.add(this.separator15);
        this.barcodeBattlerMenuItem.setMnemonic('B');
        this.barcodeBattlerMenuItem.setText("Barcode Battler II...");
        this.barcodeBattlerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.barcodeBattlerMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.barcodeBattlerMenuItem);
        this.famicom3dGlassesMenuItem.setMnemonic('G');
        this.famicom3dGlassesMenuItem.setText("Famicom 3D Glasses...");
        this.famicom3dGlassesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.famicom3dGlassesMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.famicom3dGlassesMenuItem);
        this.robMenuItem.setMnemonic('R');
        this.robMenuItem.setText("R.O.B...");
        this.robMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.robMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.robMenuItem);
        this.subMonitorMenuItem.setMnemonic('n');
        this.subMonitorMenuItem.setText("Sub Monitor...");
        this.subMonitorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.subMonitorMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.subMonitorMenuItem);
        this.viewMenu.add(this.separator5);
        this.showMenu.setMnemonic('w');
        this.showMenu.setText("Show");
        this.showMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.showMenuMenuSelected(evt);
            }
        });
        this.statusMessagesCheckBoxMenuItem.setMnemonic('M');
        this.statusMessagesCheckBoxMenuItem.setSelected(true);
        this.statusMessagesCheckBoxMenuItem.setText("Status Messages");
        this.statusMessagesCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.statusMessagesCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.showMenu.add(this.statusMessagesCheckBoxMenuItem);
        this.fpsCheckBoxMenuItem.setMnemonic('F');
        this.fpsCheckBoxMenuItem.setSelected(true);
        this.fpsCheckBoxMenuItem.setText("Displayed/Generated FPS");
        this.fpsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.fpsCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.showMenu.add(this.fpsCheckBoxMenuItem);
        this.inputDevicesCheckBoxMenuItem.setMnemonic('I');
        this.inputDevicesCheckBoxMenuItem.setText("Input Devices");
        this.inputDevicesCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.inputDevicesCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.showMenu.add(this.inputDevicesCheckBoxMenuItem);
        this.showMenu.add(this.jSeparator19);
        this.backgroundCheckBoxMenuItem.setMnemonic('B');
        this.backgroundCheckBoxMenuItem.setSelected(true);
        this.backgroundCheckBoxMenuItem.setText("Background");
        this.backgroundCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.backgroundCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.showMenu.add(this.backgroundCheckBoxMenuItem);
        this.spritesCheckBoxMenuItem.setMnemonic('S');
        this.spritesCheckBoxMenuItem.setSelected(true);
        this.spritesCheckBoxMenuItem.setText("Sprites");
        this.spritesCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.spritesCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.showMenu.add(this.spritesCheckBoxMenuItem);
        this.spriteBoxesCheckBoxMenuItem.setMnemonic('x');
        this.spriteBoxesCheckBoxMenuItem.setText("Sprite Bounding Boxes");
        this.spriteBoxesCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.spriteBoxesCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.showMenu.add(this.spriteBoxesCheckBoxMenuItem);
        this.noSpriteLimitCheckBoxMenuItem.setMnemonic('8');
        this.noSpriteLimitCheckBoxMenuItem.setSelected(true);
        this.noSpriteLimitCheckBoxMenuItem.setText("More than 8 sprites per scanline");
        this.noSpriteLimitCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.noSpriteLimitCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.showMenu.add(this.noSpriteLimitCheckBoxMenuItem);
        this.viewMenu.add(this.showMenu);
        this.screenSizeMenu.setMnemonic('S');
        this.screenSizeMenu.setText("Screen Size");
        this.screenSize1XMenuItem.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        this.screenSize1XMenuItem.setMnemonic('1');
        this.screenSize1XMenuItem.setText("1X");
        this.screenSize1XMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screenSize1XMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.screenSize1XMenuItem);
        this.screenSize2XMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.screenSize2XMenuItem.setMnemonic('2');
        this.screenSize2XMenuItem.setText("2X");
        this.screenSize2XMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screenSize2XMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.screenSize2XMenuItem);
        this.screenSize3XMenuItem.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.screenSize3XMenuItem.setMnemonic('3');
        this.screenSize3XMenuItem.setText("3X");
        this.screenSize3XMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screenSize3XMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.screenSize3XMenuItem);
        this.screenSize4XMenuItem.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        this.screenSize4XMenuItem.setMnemonic('4');
        this.screenSize4XMenuItem.setText("4X");
        this.screenSize4XMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screenSize4XMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.screenSize4XMenuItem);
        this.screenSize5XMenuItem.setAccelerator(KeyStroke.getKeyStroke(53, 8));
        this.screenSize5XMenuItem.setMnemonic('5');
        this.screenSize5XMenuItem.setText("5X");
        this.screenSize5XMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screenSize5XMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.screenSize5XMenuItem);
        this.screenSizeMaxMenuItem.setAccelerator(KeyStroke.getKeyStroke(48, 8));
        this.screenSizeMaxMenuItem.setMnemonic('M');
        this.screenSizeMaxMenuItem.setText("Max");
        this.screenSizeMaxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screenSizeMaxMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.screenSizeMaxMenuItem);
        this.screenSizeMenu.add(this.separator16);
        this.tvAspectCheckBoxMenuItem.setMnemonic('T');
        this.tvAspectCheckBoxMenuItem.setText("TV Aspect");
        this.tvAspectCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.tvAspectCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.tvAspectCheckBoxMenuItem);
        this.smoothScalingCheckBoxMenuItem.setMnemonic('S');
        this.smoothScalingCheckBoxMenuItem.setText("Smooth Scaling");
        this.smoothScalingCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.smoothScalingCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.smoothScalingCheckBoxMenuItem);
        this.uniformPixelScalingCheckBoxMenuItem.setMnemonic('p');
        this.uniformPixelScalingCheckBoxMenuItem.setText("Uniform-pixel Scaling");
        this.uniformPixelScalingCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.uniformPixelScalingCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.uniformPixelScalingCheckBoxMenuItem);
        this.underscanCheckBoxMenuItem.setMnemonic('u');
        this.underscanCheckBoxMenuItem.setText("Underscan");
        this.underscanCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.underscanCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.screenSizeMenu.add(this.underscanCheckBoxMenuItem);
        this.viewMenu.add(this.screenSizeMenu);
        this.videoFilterMenu.setMnemonic('V');
        this.videoFilterMenu.setText("Video Filter");
        this.viewMenu.add(this.videoFilterMenu);
        this.paletteMenu.setMnemonic('P');
        this.paletteMenu.setText("Palette");
        this.viewMenu.add(this.paletteMenu);
        this.lookAndFeelMenu.setMnemonic('L');
        this.lookAndFeelMenu.setText("Look and Feel");
        this.viewMenu.add(this.lookAndFeelMenu);
        this.fontSizeMenuItem.setMnemonic('o');
        this.fontSizeMenuItem.setText("Font Size...");
        this.fontSizeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.fontSizeMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.fontSizeMenuItem);
        this.viewMenu.add(this.separator7);
        this.hideMenuBarMenuItem.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.hideMenuBarMenuItem.setMnemonic('H');
        this.hideMenuBarMenuItem.setText("Hide Menu Bar");
        this.hideMenuBarMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.hideMenuBarMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.hideMenuBarMenuItem);
        this.fullscreenMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 8));
        this.fullscreenMenuItem.setMnemonic('F');
        this.fullscreenMenuItem.setText("Fullscreen");
        this.fullscreenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.fullscreenMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.fullscreenMenuItem);
        this.menuBar.add(this.viewMenu);
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.setText("Options");
        this.optionsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.optionsMenuMenuSelected(evt);
            }
        });
        this.buttonMappingMenuItem.setMnemonic('B');
        this.buttonMappingMenuItem.setText("Button Mapping...");
        this.buttonMappingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.buttonMappingMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.buttonMappingMenuItem);
        this.portsMenuItem.setMnemonic('P');
        this.portsMenuItem.setText("Ports...");
        this.portsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.portsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.portsMenuItem);
        this.inputSettingsMenuItem.setMnemonic('I');
        this.inputSettingsMenuItem.setText("Input Settings...");
        this.inputSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.inputSettingsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.inputSettingsMenuItem);
        this.optionsMenu.add(this.jSeparator12);
        this.soundMenuItem.setMnemonic('S');
        this.soundMenuItem.setText("Sound...");
        this.soundMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.soundMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.soundMenuItem);
        this.volumeMixerMenuItem.setMnemonic('V');
        this.volumeMixerMenuItem.setText("Volume Mixer...");
        this.volumeMixerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.volumeMixerMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.volumeMixerMenuItem);
        this.nsfOptionsMenuItem.setMnemonic('N');
        this.nsfOptionsMenuItem.setText("NSF...");
        this.nsfOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.nsfOptionsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.nsfOptionsMenuItem);
        this.optionsMenu.add(this.jSeparator15);
        this.contentDirectoryMenuItem.setMnemonic('C');
        this.contentDirectoryMenuItem.setText("Content Directory...");
        this.contentDirectoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.contentDirectoryMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.contentDirectoryMenuItem);
        this.archiveFileOptionsMenuItem.setMnemonic('A');
        this.archiveFileOptionsMenuItem.setText("Archive Files...");
        this.archiveFileOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.archiveFileOptionsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.archiveFileOptionsMenuItem);
        this.famicomDiskSystemOptionsMenuItem.setMnemonic('F');
        this.famicomDiskSystemOptionsMenuItem.setText("Famicom Disk System...");
        this.famicomDiskSystemOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.famicomDiskSystemOptionsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.famicomDiskSystemOptionsMenuItem);
        this.familyBasicOptionsMenuItem.setMnemonic('m');
        this.familyBasicOptionsMenuItem.setText("Family BASIC...");
        this.familyBasicOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.familyBasicOptionsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.familyBasicOptionsMenuItem);
        this.traceLoggerOptionsMenuItem.setMnemonic('T');
        this.traceLoggerOptionsMenuItem.setText("Trace Logger...");
        this.traceLoggerOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.traceLoggerOptionsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.traceLoggerOptionsMenuItem);
        this.optionsMenu.add(this.jSeparator18);
        this.userInterfaceMenuItem.setMnemonic('U');
        this.userInterfaceMenuItem.setText("User Interface...");
        this.userInterfaceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.userInterfaceMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.userInterfaceMenuItem);
        this.screenshotOptionsMenuItem.setMnemonic('c');
        this.screenshotOptionsMenuItem.setText("Screenshots...");
        this.screenshotOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.screenshotOptionsMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.screenshotOptionsMenuItem);
        this.overscanMenuItem.setMnemonic('O');
        this.overscanMenuItem.setText("Overscan...");
        this.overscanMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.overscanMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.overscanMenuItem);
        this.palettesMenuItem.setMnemonic('P');
        this.palettesMenuItem.setText("Palettes...");
        this.palettesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.palettesMenuItemActionPerformed(evt);
            }
        });
        this.optionsMenu.add(this.palettesMenuItem);
        this.menuBar.add(this.optionsMenu);
        this.toolsMenu.setMnemonic('T');
        this.toolsMenu.setText("Tools");
        this.toolsMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.toolsMenuMenuSelected(evt);
            }
        });
        this.startNetplayServerMenuItem.setMnemonic('N');
        this.startNetplayServerMenuItem.setText("Start Netplay Server...");
        this.startNetplayServerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.startNetplayServerMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.startNetplayServerMenuItem);
        this.connectToNetplayServerMenuItem.setMnemonic('C');
        this.connectToNetplayServerMenuItem.setText("Connect to Netplay Server...");
        this.connectToNetplayServerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.connectToNetplayServerMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.connectToNetplayServerMenuItem);
        this.toolsMenu.add(this.jSeparator4);
        this.mapMakerMenuItem.setMnemonic('M');
        this.mapMakerMenuItem.setText("Map Maker...");
        this.mapMakerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.mapMakerMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.mapMakerMenuItem);
        this.spriteSaverMenuItem.setMnemonic('v');
        this.spriteSaverMenuItem.setText("Sprite Saver...");
        this.spriteSaverMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.spriteSaverMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.spriteSaverMenuItem);
        this.toolsMenu.add(this.jSeparator11);
        this.runProgramMenuItem.setMnemonic('R');
        this.runProgramMenuItem.setText("Run Program...");
        this.runProgramMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.runProgramMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.runProgramMenuItem);
        this.startProgramServerMenuItem.setMnemonic('P');
        this.startProgramServerMenuItem.setText("Start Program Server...");
        this.startProgramServerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.startProgramServerMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.startProgramServerMenuItem);
        this.toolsMenu.add(this.jSeparator14);
        this.manageCheatsMenuItem.setMnemonic('g');
        this.manageCheatsMenuItem.setText("Manage Cheats...");
        this.manageCheatsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.manageCheatsMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.manageCheatsMenuItem);
        this.searchCheatsMenuItem.setMnemonic('S');
        this.searchCheatsMenuItem.setText("Cheat Search...");
        this.searchCheatsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.searchCheatsMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.searchCheatsMenuItem);
        this.toolsMenu.add(this.jSeparator2);
        this.editFileHeaderMenuItem.setMnemonic('H');
        this.editFileHeaderMenuItem.setText("Edit File Header...");
        this.editFileHeaderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.editFileHeaderMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.editFileHeaderMenuItem);
        this.toolsMenu.add(this.jSeparator16);
        this.saveScreenshotMenuItem.setAccelerator(KeyStroke.getKeyStroke(123, 0));
        this.saveScreenshotMenuItem.setText("Save Screenshot");
        this.saveScreenshotMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.saveScreenshotMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.saveScreenshotMenuItem);
        this.toolsMenu.add(this.jSeparator10);
        this.applyIPSMenuItem.setText("Apply IPS Patch...");
        this.applyIPSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.applyIPSMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.applyIPSMenuItem);
        this.createIPSMenuItem.setText("Create IPS Patch...");
        this.createIPSMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.createIPSMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.createIPSMenuItem);
        this.toolsMenu.add(this.jSeparator21);
        this.trackHistoryCheckBoxMenuItem.setMnemonic('H');
        this.trackHistoryCheckBoxMenuItem.setText("Track History");
        this.trackHistoryCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.trackHistoryCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.trackHistoryCheckBoxMenuItem);
        this.watchHistoryMenuItem.setMnemonic('W');
        this.watchHistoryMenuItem.setText("Watch History...");
        this.watchHistoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.watchHistoryMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.watchHistoryMenuItem);
        this.exportVideoAudioMenuItem.setMnemonic('V');
        this.exportVideoAudioMenuItem.setText("Export Video/Audio...");
        this.exportVideoAudioMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.exportVideoAudioMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.exportVideoAudioMenuItem);
        this.editHistoryMenuItem.setMnemonic('E');
        this.editHistoryMenuItem.setText("Edit History...");
        this.editHistoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.editHistoryMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.editHistoryMenuItem);
        this.clearHistoryMenuItem.setMnemonic('a');
        this.clearHistoryMenuItem.setText("Clear History");
        this.clearHistoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.clearHistoryMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.clearHistoryMenuItem);
        this.importHistoryMenuItem.setMnemonic('I');
        this.importHistoryMenuItem.setText("Import History...");
        this.importHistoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.importHistoryMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.importHistoryMenuItem);
        this.exportHistoryMenuItem.setMnemonic('x');
        this.exportHistoryMenuItem.setText("Export History...");
        this.exportHistoryMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.exportHistoryMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.exportHistoryMenuItem);
        this.rewindTimeCheckBoxMenuItem.setMnemonic('T');
        this.rewindTimeCheckBoxMenuItem.setText("Rewind Time");
        this.rewindTimeCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.rewindTimeCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.rewindTimeCheckBoxMenuItem);
        this.menuBar.add(this.toolsMenu);
        this.debugMenu.setMnemonic('D');
        this.debugMenu.setText("Debug");
        this.debugMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                ImageFrame.this.debugMenuMenuSelected(evt);
            }
        });
        this.debuggerMenuItem.setMnemonic('D');
        this.debuggerMenuItem.setText("Debugger...");
        this.debuggerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.debuggerMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.debuggerMenuItem);
        this.oamDataMenuItem.setMnemonic('O');
        this.oamDataMenuItem.setText("OAM Data...");
        this.oamDataMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.oamDataMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.oamDataMenuItem);
        this.patternTablesMenuItem.setMnemonic('P');
        this.patternTablesMenuItem.setText("Pattern Tables...");
        this.patternTablesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.patternTablesMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.patternTablesMenuItem);
        this.nametablesMenuItem.setMnemonic('N');
        this.nametablesMenuItem.setText("Nametables...");
        this.nametablesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.nametablesMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.nametablesMenuItem);
        this.hexEditorMenuItem.setMnemonic('H');
        this.hexEditorMenuItem.setText("Hex Editor...");
        this.hexEditorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.hexEditorMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.hexEditorMenuItem);
        this.asmDasmMenuItem.setMnemonic('A');
        this.asmDasmMenuItem.setText("Assembler-Disassembler...");
        this.asmDasmMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.asmDasmMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.asmDasmMenuItem);
        this.ramSearchMenuItem.setMnemonic('R');
        this.ramSearchMenuItem.setText("RAM Search...");
        this.ramSearchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.ramSearchMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.ramSearchMenuItem);
        this.ramWatchMenuItem.setMnemonic('W');
        this.ramWatchMenuItem.setText("RAM Watch...");
        this.ramWatchMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.ramWatchMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.ramWatchMenuItem);
        this.debugMenu.add(this.jSeparator23);
        this.startTraceLoggerMenuItem.setMnemonic('L');
        this.startTraceLoggerMenuItem.setText("Start Trace Logger");
        this.startTraceLoggerMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.startTraceLoggerMenuItemActionPerformed(evt);
            }
        });
        this.debugMenu.add(this.startTraceLoggerMenuItem);
        this.menuBar.add(this.debugMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setMnemonic('H');
        this.helpMenuItem.setText("Help...");
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.licenseMenuItem.setMnemonic('L');
        this.licenseMenuItem.setText("License...");
        this.licenseMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.licenseMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.licenseMenuItem);
        this.helpMenu.add(this.separator2);
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 279, Short.MAX_VALUE));
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        AppMode appMode = App.getAppMode();
        if (appMode == AppMode.Default || appMode == AppMode.NetplayServer) {
            this.openFile(null, false, null);
        }
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null || this.timeRewinding || App.getAppMode() == AppMode.WatchHistory) {
            App.close();
            if (App.getAppMode() == AppMode.NetplayClient) {
                App.destroyNetplayClientFrame();
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exit();
    }

    private void recentFilesClearMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().clearRecentFiles();
        this.createRecentFilesMenu();
        AppPrefs.save();
    }

    private void recentFilesLockCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().setLockRecentFiles(this.recentFilesLockCheckBoxMenuItem.isSelected());
        AppPrefs.save();
    }

    private void recentDirectoriesLockCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().setLockRecentDirectories(this.recentDirectoriesLockCheckBoxMenuItem.isSelected());
        AppPrefs.save();
    }

    private void recentDirectoriesClearMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().clearRecentDirectories();
        AppPrefs.save();
    }

    private void saveStateMenuItemActionPerformed(ActionEvent evt) {
        if (this.isSaveable() && App.getAppMode() != AppMode.NetplayClient) {
            this.saveOrOpenState(1);
        }
    }

    private void loadStateMenuItemActionPerformed(ActionEvent evt) {
        if (this.isSaveable() && App.getAppMode() != AppMode.NetplayClient) {
            this.saveOrOpenState(0);
        }
    }

    private void fileInfoMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new TextDialog((Window)this, this.fileInfo, "File Information").setVisible(true);
        App.setNoStepPause(false);
    }

    private void fullscreenMenuItemActionPerformed(ActionEvent evt) {
        this.toggleFullscreenMode();
    }

    private void editFileHeaderMenuItemActionPerformed(ActionEvent evt) {
        this.openFile(null, true, null);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        AboutDialog aboutDialog = new AboutDialog((Frame)this, true);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.setVisible(true);
        App.setNoStepPause(false);
    }

    private void fontSizeMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        View view = AppPrefs.getInstance().getView();
        FontSizeDialog fontSizeDialog = new FontSizeDialog((Frame)this, true);
        fontSizeDialog.setFontScale(view.getFontScale());
        fontSizeDialog.setVisible(true);
        if (fontSizeDialog.isFontScaleChanged()) {
            view.setFontScale(fontSizeDialog.getFontScale());
            GuiUtil.updateFrameStyles();
            AppPrefs.save();
        }
        App.setNoStepPause(false);
    }

    private void buttonMappingMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new ButtonMappingDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void hexEditorMenuItemActionPerformed(ActionEvent evt) {
        App.createHexEditorFrame();
    }

    private void manageCheatsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new CheatsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void searchCheatsMenuItemActionPerformed(ActionEvent evt) {
        App.createCheatSearchFrame();
    }

    private void pauseMenuItemActionPerformed(ActionEvent evt) {
        if (this.isPauseable()) {
            this.pause();
        }
    }

    private void nextFrameMenuItemActionPerformed(ActionEvent evt) {
        AppMode appMode = App.getAppMode();
        if (this.machine != null && this.displayingImagePane && appMode != AppMode.WatchHistory && appMode != AppMode.HistoryEditor && appMode != AppMode.NetplayClient && this.pauseMenuItem.isSelected()) {
            this.nextFrame();
        }
    }

    private void resetMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && this.displayingImagePane && App.getAppMode() != AppMode.WatchHistory) {
            if (AppPrefs.getInstance().getUserInterfacePrefs().isConfirmReset()) {
                App.setNoStepPause(true);
                YesNoDialog yesNoDialog = new YesNoDialog((Window)this, "Do you really want to reset?", "Confirm Reset");
                yesNoDialog.setVisible(true);
                App.setNoStepPause(false);
                if (yesNoDialog.isNo()) {
                    return;
                }
            }
            this.reset();
        }
    }

    private void powerCycleMenuItemActionPerformed(ActionEvent evt) {
        if (AppPrefs.getInstance().getUserInterfacePrefs().isConfirmReset()) {
            App.setNoStepPause(true);
            YesNoDialog yesNoDialog = new YesNoDialog((Window)this, "Do you really want to power cycle?", "Confirm Power Cycle");
            yesNoDialog.setVisible(true);
            App.setNoStepPause(false);
            if (yesNoDialog.isNo()) {
                return;
            }
        }
        App.powerCycle();
    }

    private void patternTablesMenuItemActionPerformed(ActionEvent evt) {
        App.createPatternTablesFrame();
    }

    private void nametablesMenuItemActionPerformed(ActionEvent evt) {
        App.createNametablesFrame();
    }

    private void mapMakerMenuItemActionPerformed(ActionEvent evt) {
        App.createMapMakerFrame();
    }

    private void spriteSaverMenuItemActionPerformed(ActionEvent evt) {
        App.createSpriteSaverFrame();
    }

    private void ramSearchMenuItemActionPerformed(ActionEvent evt) {
        App.createRamSearchFrame();
    }

    private void ramWatchMenuItemActionPerformed(ActionEvent evt) {
        App.createRamWatchFrame();
    }

    private void debuggerMenuItemActionPerformed(ActionEvent evt) {
        App.createDebuggerFrame();
    }

    private void asmDasmMenuItemActionPerformed(ActionEvent evt) {
        App.createAsmDasmFrame();
    }

    private void trackHistoryCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean trackHistory = this.trackHistoryCheckBoxMenuItem.isSelected();
        AppPrefs.getInstance().getHistoryPrefs().setTrackHistory(trackHistory);
        AppPrefs.save();
        if (!trackHistory) {
            App.destroyWatchHistoryFrame();
        }
        App.setTrackHistory(trackHistory);
    }

    private void editHistoryMenuItemActionPerformed(ActionEvent evt) {
        App.createHistoryEditorFrame();
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        boolean machineExists = this.machine != null;
        AppMode appMode = App.getAppMode();
        boolean openable = appMode == AppMode.Default || appMode == AppMode.NetplayServer;
        boolean saveable = this.isSaveable();
        Paths paths = AppPrefs.getInstance().getPaths();
        this.openMenuItem.setEnabled(openable);
        this.openRecentFileMenu.setEnabled(!paths.getRecentFiles().isEmpty() && openable);
        this.openRecentArchiveMenu.setEnabled(!paths.getRecentArchives().isEmpty() && openable);
        this.openRecentDirectoryMenu.setEnabled(!paths.getRecentDirectories().isEmpty() && openable);
        this.quickLoadStateMenu.setEnabled(saveable);
        this.quickSaveStateMenu.setEnabled(saveable);
        this.loadStateMenuItem.setEnabled(saveable && appMode != AppMode.NetplayClient);
        this.saveStateMenuItem.setEnabled(saveable && appMode != AppMode.NetplayClient);
        this.closeMenuItem.setEnabled(machineExists || this.timeRewinding || appMode == AppMode.WatchHistory);
    }

    private void openRecentDirectoryMenuMenuSelected(MenuEvent evt) {
        this.createRecentDirectoriesMenu();
    }

    private void portsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new PortsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void inputSettingsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new InputSettingsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void rewindTimeCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        App.requestRewindTime(4, this.rewindTimeCheckBoxMenuItem.isSelected());
    }

    private void startNetplayServerMenuItemActionPerformed(ActionEvent evt) {
        App.createNetplayServerFrame();
    }

    private void connectToNetplayServerMenuItemActionPerformed(ActionEvent evt) {
        App.createNetplayClientFrame();
    }

    private void familyBasicTypePasteMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new TypePaste(GuiUtil.getClipboardString()));
    }

    private void familyBasicPasteProgramMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new PasteProgram(GuiUtil.getClipboardString()));
    }

    private void familyBasicCopyProgramMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        GuiUtil.setClipboardString(FamilyBasicUtil.copyProgram());
        App.setNoStepPause(false);
    }

    private void familyBasicLoadProgramMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        JFileChooser chooser = GuiUtil.createFileChooser("Load BASIC Program", AppPrefs.getInstance().getPaths().getBasicDir(), (FileFilter[])BasicFileExtensionFilters);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setBasicDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.loadBasicProgram(selectedFile, pleaseWaitDialog)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void familyBasicSaveProgramMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        AppPrefs prefs = AppPrefs.getInstance();
        Paths paths = prefs.getPaths();
        File file = GuiUtil.showSaveAsDialog(this, paths.getBasicDir(), this.basicProgramFile == null ? null : this.basicProgramFile.getName(), "bas", BasicFileExtensionFilters[0], true);
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setBasicDir(dir);
            AppPrefs.save();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.saveBasicProgram(file, pleaseWaitDialog)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void familyBasicLoadBackgroundMenuItemActionPerformed(ActionEvent evt) {
        BackgroundEditorFrame.open(this);
    }

    private void familyBasicSaveBackgroundMenuItemActionPerformed(ActionEvent evt) {
        BackgroundEditorFrame.saveAs(this);
    }

    private void familyBasicEditBackgroundMenuItemActionPerformed(ActionEvent evt) {
        App.createBackgroundEditorFrame();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.setKeyEventsEnabled(this.keyEventsEnabled);
        DualAPU.setMainUpdateEnabled(true);
    }

    private void formWindowLostFocus(WindowEvent evt) {
        this.enableKeyEvents();
    }

    private void familyBasicPlayTapeMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new SetDataRecorderMode(2));
    }

    private void familyBasicRecordTapeMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new SetDataRecorderMode(1));
    }

    private void familyBasicStopTapeMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new SetDataRecorderMode(0));
    }

    private void familyBasicLoadTapeMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        JFileChooser chooser = GuiUtil.createFileChooser("Load Tape", AppPrefs.getInstance().getPaths().getTapeDir(), (FileFilter[])TapeFileExtensionFilters);
        if (GuiUtil.showOpenDialog(this, chooser, (p, d) -> p.setTapeDir((String)d)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.loadTape(selectedFile, pleaseWaitDialog)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void familyBasicSaveTapeMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        AppPrefs prefs = AppPrefs.getInstance();
        Paths paths = prefs.getPaths();
        File file = GuiUtil.showSaveAsDialog(this, paths.getTapeDir(), this.tapeFile == null ? null : this.tapeFile.getName(), "tape", TapeFileExtensionFilters[0], true);
        if (file != null) {
            String dir = file.getParent();
            paths.addRecentDirectory(dir);
            paths.setTapeDir(dir);
            AppPrefs.save();
            PleaseWaitDialog pleaseWaitDialog = new PleaseWaitDialog((Window)this);
            new Thread(() -> this.saveTape(file, pleaseWaitDialog)).start();
            pleaseWaitDialog.showAfterDelay();
        } else {
            App.setNoStepPause(false);
        }
    }

    private void familyBasicEraseTapeMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new SetDataRecorderMode(3));
    }

    private void dipSwitchesMenuItemActionPerformed(ActionEvent evt) {
        if (App.isVsSystem() && App.showDipSwitchesDialog().booleanValue() && AppPrefs.getInstance().getDipSwitchesAppPrefs().isResetMachine()) {
            App.reset();
        }
    }

    private void runProgramMenuItemActionPerformed(ActionEvent evt) {
        App.createProgramFrame();
    }

    private void startProgramServerMenuItemActionPerformed(ActionEvent evt) {
        App.createProgramServerFrame();
    }

    private void recentArchivesLockCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().setLockRecentArchives(this.recentArchivesLockCheckBoxMenuItem.isSelected());
        AppPrefs.save();
    }

    private void recentArchivesClearMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getPaths().clearRecentArchives();
        this.createRecentArchivesMenu();
        AppPrefs.save();
    }

    private void famicomDiskSystemOptionsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new FamicomDiskSystemOptionsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void flipDiskSideMenuItemActionPerformed(ActionEvent evt) {
        Mapper m;
        Machine mac = this.machine;
        if (mac != null && (m = mac.getMapper()) != null && m.getDiskSideCount() > 1) {
            this.flipDisk();
        }
    }

    private void ejectDiskMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new EjectDisk());
    }

    private void machineMenuMenuSelected(MenuEvent evt) {
        AppMode appMode = App.getAppMode();
        Machine mac = this.machine;
        boolean machineExists = mac != null && this.displayingImagePane && appMode != AppMode.WatchHistory;
        boolean notNetworkClient = appMode != AppMode.NetplayClient;
        boolean enabled = machineExists && appMode != AppMode.HistoryEditor && notNetworkClient;
        this.powerCycleMenuItem.setEnabled(enabled);
        this.pauseMenuItem.setEnabled(enabled);
        this.nextFrameMenuItem.setEnabled(enabled && this.pauseMenuItem.isSelected());
        this.hotSwapMenuItem.setEnabled(enabled && !mac.isVsDualSystem());
        this.eraseBatterySaveMenuItem.setEnabled(enabled && mac.getMapper().isNonVolatilePrgRamPresent());
        this.resetMenuItem.setEnabled(machineExists);
        this.speedMenu.setEnabled(App.isFileLoaded() && this.displayingImagePane && notNetworkClient);
        this.tvSystemMenu.setEnabled(machineExists);
        this.glitchMenuItem.setEnabled(machineExists);
        this.screamIntoMicrophoneMenuItem.setEnabled(machineExists);
        Mapper m = machineExists ? mac.getMapper() : null;
        int sides = m != null ? m.getDiskSideCount() : 0;
        this.insertDiskMenu.setEnabled(sides > 0);
        this.flipDiskSideMenuItem.setEnabled(sides > 1);
        this.ejectDiskMenuItem.setEnabled(sides > 0);
        if (sides != this.diskSideMenuItems.length) {
            this.insertDiskMenu.removeAll();
            this.diskSideButtonGroup = new ButtonGroup();
            this.diskSideMenuItems = new JCheckBoxMenuItem[sides];
            for (int i = 0; i < sides; ++i) {
                this.diskSideMenuItems[i] = new JCheckBoxMenuItem(String.format("Disk %d Side %s", (i >> 1) + 1, (i & 1) == 0 ? "A" : "B"));
                int side = i;
                this.diskSideMenuItems[i].addActionListener(e -> InputUtil.addOtherInput(new SetDiskSide(side)));
                this.diskSideButtonGroup.add(this.diskSideMenuItems[i]);
                this.insertDiskMenu.add(this.diskSideMenuItems[i]);
            }
        }
        if (sides > 0) {
            int currentSide = m.getDiskSide();
            if (currentSide >= 0) {
                this.diskSideMenuItems[currentSide].setSelected(true);
            } else {
                this.diskSideButtonGroup.clearSelection();
                this.flipDiskSideMenuItem.setEnabled(false);
            }
        }
        boolean usesFamilyKeyboard = false;
        boolean usesDataRecorder = false;
        boolean vsSystem = false;
        boolean vsDualSystem = false;
        if (machineExists) {
            vsSystem = App.isVsSystem();
            vsDualSystem = App.isVsDualSystem();
            DeviceMapper[] deviceMappers = m.getDeviceMappers();
            if (notNetworkClient && deviceMappers != null) {
                for (int i = deviceMappers.length - 1; i >= 0; --i) {
                    int inputDevice = deviceMappers[i].getInputDevice();
                    if (inputDevice == 18) {
                        usesFamilyKeyboard = true;
                        continue;
                    }
                    if (inputDevice != 11) continue;
                    usesDataRecorder = true;
                }
            }
        }
        this.familyBasicMenu.setEnabled(usesFamilyKeyboard || usesDataRecorder);
        this.familyBasicCopyProgramMenuItem.setEnabled(usesFamilyKeyboard);
        this.familyBasicPasteProgramMenuItem.setEnabled(usesFamilyKeyboard);
        this.familyBasicTypePasteMenuItem.setEnabled(usesFamilyKeyboard);
        this.familyBasicLoadProgramMenuItem.setEnabled(usesFamilyKeyboard);
        this.familyBasicSaveProgramMenuItem.setEnabled(usesFamilyKeyboard);
        this.familyBasicEditBackgroundMenuItem.setEnabled(usesFamilyKeyboard);
        this.familyBasicLoadBackgroundMenuItem.setEnabled(usesFamilyKeyboard);
        this.familyBasicSaveBackgroundMenuItem.setEnabled(usesFamilyKeyboard);
        this.insertCoinMenu.setEnabled(vsSystem);
        this.insertCoinMainLeftMenuItem.setEnabled(vsSystem);
        this.insertCoinMainRightMenuItem.setEnabled(vsSystem);
        this.insertCoinSubLeftMenuItem.setEnabled(vsDualSystem);
        this.insertCoinSubRightMenuItem.setEnabled(vsDualSystem);
        this.serviceButtonMenu.setEnabled(vsSystem);
        this.serviceButtonMainMenuItem.setEnabled(vsSystem);
        this.serviceButtonSubMenuItem.setEnabled(vsDualSystem);
        this.dipSwitchesMenuItem.setEnabled(vsSystem && notNetworkClient);
    }

    private void barcodeBattlerMenuItemActionPerformed(ActionEvent evt) {
        App.createBarcodeBattlerFrame();
    }

    private void screenSize1XMenuItemActionPerformed(ActionEvent evt) {
        this.setScreenScale(1);
    }

    private void screenSize2XMenuItemActionPerformed(ActionEvent evt) {
        this.setScreenScale(2);
    }

    private void screenSize3XMenuItemActionPerformed(ActionEvent evt) {
        this.setScreenScale(3);
    }

    private void screenSize4XMenuItemActionPerformed(ActionEvent evt) {
        this.setScreenScale(4);
    }

    private void screenSizeMaxMenuItemActionPerformed(ActionEvent evt) {
        App.runSubMonitorFrame(f -> GuiUtil.maximize(f));
        GuiUtil.maximize(this);
    }

    private void tvAspectCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.useTvAspectRatio = this.tvAspectCheckBoxMenuItem.isSelected();
        AppPrefs.getInstance().getView().setTvAspect(this.useTvAspectRatio);
        AppPrefs.save();
        this.setUseTvAspectRatio(this.useTvAspectRatio);
    }

    private void screenSize5XMenuItemActionPerformed(ActionEvent evt) {
        this.setScreenScale(5);
    }

    private void hideMenuBarMenuItemActionPerformed(ActionEvent evt) {
        SubMonitorFrame subMonitorFrame = App.getSubMonitorFrame();
        if (subMonitorFrame != null && subMonitorFrame.getImagePane().getBufferStrategy() != null) {
            this.exitFullscreenModeTime = System.currentTimeMillis();
            subMonitorFrame.exitFullscreenMode();
        } else if (evt.getModifiers() != 0 || System.currentTimeMillis() - this.exitFullscreenModeTime > 20000L) {
            this.exitFullscreenModeTime = 0L;
            this.setMenuBarVisible(false);
        }
    }

    private void smoothScalingCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.smoothScaling = this.smoothScalingCheckBoxMenuItem.isSelected();
        AppPrefs.getInstance().getView().setSmoothScaling(this.smoothScaling);
        AppPrefs.save();
        this.imagePane.setSmoothScaling(this.smoothScaling);
    }

    private void soundMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new SoundOptionsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void volumeMixerMenuItemActionPerformed(ActionEvent evt) {
        App.createVolumeMixerFrame();
    }

    private void watchHistoryMenuItemActionPerformed(ActionEvent evt) {
        this.showWatchHistoryFrame(false);
    }

    private void exportVideoAudioMenuItemActionPerformed(ActionEvent evt) {
        this.showWatchHistoryFrame(true);
    }

    private void toolsMenuMenuSelected(MenuEvent evt) {
        boolean machineExists;
        boolean notNetplay;
        AppMode appMode = App.getAppMode();
        boolean bl = notNetplay = appMode != AppMode.NetplayClient && appMode != AppMode.NetplayServer;
        if (notNetplay) {
            this.startNetplayServerMenuItem.setText("Start Netplay Server...");
            this.connectToNetplayServerMenuItem.setText("Connect to Netplay Server...");
        } else {
            this.startNetplayServerMenuItem.setText("Netplay Server Controls...");
            this.connectToNetplayServerMenuItem.setText("Netplay Client Controls...");
        }
        boolean bl2 = machineExists = this.machine != null;
        if (App.getProgramFrame() != null) {
            this.runProgramMenuItem.setText("Program Controls...");
            this.startProgramServerMenuItem.setEnabled(false);
        } else {
            this.runProgramMenuItem.setText("Run Program...");
            this.startProgramServerMenuItem.setEnabled(notNetplay);
        }
        if (App.getProgramServerFrame() != null) {
            this.startProgramServerMenuItem.setText("Program Server Controls...");
            this.runProgramMenuItem.setEnabled(false);
        } else {
            this.startProgramServerMenuItem.setText("Start Program Server...");
            this.runProgramMenuItem.setEnabled(notNetplay);
        }
        this.mapMakerMenuItem.setEnabled(machineExists);
        this.spriteSaverMenuItem.setEnabled(machineExists);
        this.manageCheatsMenuItem.setEnabled(machineExists && appMode != AppMode.NetplayClient);
        this.searchCheatsMenuItem.setEnabled(machineExists && appMode != AppMode.NetplayClient);
        this.saveScreenshotMenuItem.setEnabled(machineExists);
        this.startNetplayServerMenuItem.setEnabled(appMode == AppMode.Default || appMode == AppMode.NetplayServer);
        this.connectToNetplayServerMenuItem.setEnabled(appMode == AppMode.Default || appMode == AppMode.NetplayClient);
        this.trackHistoryCheckBoxMenuItem.setEnabled(this.machine != null && appMode == AppMode.Default);
        this.rewindTimeCheckBoxMenuItem.setEnabled((this.machine != null || this.timeRewinding) && appMode != AppMode.WatchHistory && appMode != AppMode.NetplayClient);
        this.rewindTimeCheckBoxMenuItem.setSelected(this.timeRewinding && this.rewindTimeCheckBoxMenuItem.isEnabled());
        boolean enabled = this.historyTracking && !this.timeRewinding && (appMode == AppMode.Default || appMode == AppMode.NetplayServer);
        this.clearHistoryMenuItem.setEnabled(enabled);
        this.exportHistoryMenuItem.setEnabled(enabled);
        this.editHistoryMenuItem.setEnabled(enabled && notNetplay && appMode != AppMode.WatchHistory);
        boolean watchHistoryEnabled = appMode == AppMode.WatchHistory || this.historyTracking && !this.timeRewinding && notNetplay && (appMode == AppMode.Default || appMode == AppMode.NetplayServer);
        this.watchHistoryMenuItem.setEnabled(watchHistoryEnabled);
        this.importHistoryMenuItem.setEnabled(watchHistoryEnabled);
        this.exportVideoAudioMenuItem.setEnabled(watchHistoryEnabled);
    }

    private void exportHistoryMenuItemActionPerformed(ActionEvent evt) {
        WatchHistoryFrame watchHistoryFrame = App.getWatchHistoryFrame();
        if (watchHistoryFrame == null) {
            MachineRunner r = App.getMachineRunner();
            if (r != null) {
                App.exportHistory(r.getMovie());
            }
        } else {
            WatchHistoryPanel watchHistoryPanel = watchHistoryFrame.getWatchHistoryPanel();
            watchHistoryPanel.pause();
            App.exportHistory(watchHistoryPanel.getMovie());
        }
    }

    private void importHistoryMenuItemActionPerformed(ActionEvent evt) {
        App.importHistory();
    }

    private void clearHistoryMenuItemActionPerformed(ActionEvent evt) {
        WatchHistoryFrame watchHistoryFrame = App.getWatchHistoryFrame();
        if (watchHistoryFrame != null) {
            watchHistoryFrame.getWatchHistoryPanel().resume(true);
        } else {
            App.setNoStepPause(true);
            MachineRunner r = App.getMachineRunner();
            if (r != null) {
                Movie movie = new Movie(App.isVsDualSystem());
                r.setMovie(movie);
                r.getMapper().updateButtons(0);
                SystemAudioProcessor.setMovie(movie);
            }
            App.setNoStepPause(false);
        }
    }

    private void saveScreenshotMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null) {
            this.imagePane.requestScreenshot();
        }
    }

    private void palettesMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new PaletteOptionsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void ntscRegionRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.setTVSystem(TVSystem.NTSC);
    }

    private void palRegionRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.setTVSystem(TVSystem.PAL);
    }

    private void dendyRegionRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.setTVSystem(TVSystem.Dendy);
    }

    private void tvSystemMenuMenuSelected(MenuEvent evt) {
        Machine m = App.getMachine();
        if (m != null) {
            switch (m.getMapper().getTVSystem()) {
                case NTSC: {
                    this.ntscRegionRadioButtonMenuItem.setSelected(true);
                    break;
                }
                case PAL: {
                    this.palRegionRadioButtonMenuItem.setSelected(true);
                    break;
                }
                case Dendy: {
                    this.dendyRegionRadioButtonMenuItem.setSelected(true);
                }
            }
        }
    }

    private void overscanMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new OverscanDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void licenseMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new TextDialog((Window)this, App.getLicense(), "License").setVisible(true);
        App.setNoStepPause(false);
    }

    private void screenshotOptionsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new ScreenshotOptionsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void archiveFileOptionsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new ArchiveOptionsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void backgroundCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean backgroundEnabled = this.backgroundCheckBoxMenuItem.isSelected();
        PPU.setBackgroundEnabled(backgroundEnabled);
        AppPrefs.getInstance().getView().setBackgroundEnabled(backgroundEnabled);
        AppPrefs.save();
    }

    private void spritesCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean spritesEnabled = this.spritesCheckBoxMenuItem.isSelected();
        PPU.setSpritesEnabled(spritesEnabled);
        AppPrefs.getInstance().getView().setSpritesEnabled(spritesEnabled);
        AppPrefs.save();
    }

    private void fpsCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean showFPS = this.fpsCheckBoxMenuItem.isSelected();
        this.imagePane.setShowFPS(showFPS);
        AppPrefs.getInstance().getView().setShowFPS(showFPS);
        AppPrefs.save();
    }

    private void inputDevicesCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean showInputDevices = this.inputDevicesCheckBoxMenuItem.isSelected();
        PPU.setShowInputDevices(showInputDevices);
        AppPrefs.getInstance().getView().setShowInputDevices(showInputDevices);
        AppPrefs.save();
    }

    private void statusMessagesCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean showStatusMessages = this.statusMessagesCheckBoxMenuItem.isSelected();
        this.imagePane.setShowStatusMessages(showStatusMessages);
        AppPrefs.getInstance().getView().setShowStatusMessages(showStatusMessages);
        AppPrefs.save();
    }

    private void userInterfaceMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        UserInterfaceDialog dialog = new UserInterfaceDialog((Window)this);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            AppPrefs.getInstance().getUserInterfacePrefs().apply();
        }
        App.setNoStepPause(false);
    }

    private void applyIPSMenuItemActionPerformed(ActionEvent evt) {
        App.createApplyIpsPatchFrame();
    }

    private void createIPSMenuItemActionPerformed(ActionEvent evt) {
        App.createCreateIpsPatchFrame();
    }

    private void spriteBoxesCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean spriteBoxesEnabled = this.spriteBoxesCheckBoxMenuItem.isSelected();
        PPU.setSpriteBoxesEnabled(spriteBoxesEnabled);
        AppPrefs.getInstance().getView().setSpriteBoxesEnabled(spriteBoxesEnabled);
        AppPrefs.save();
    }

    private void oamDataMenuItemActionPerformed(ActionEvent evt) {
        App.createOamDataFrame();
    }

    private void nsfOptionsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new NsfOptionsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void glitchMenuItemActionPerformed(ActionEvent evt) {
        InputUtil.addOtherInput(new Glitch());
    }

    private void contentDirectoryMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new ContentDirectoryDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void hotSwapMenuItemActionPerformed(ActionEvent evt) {
        Machine ejectedMachine = this.machine;
        if (ejectedMachine == null) {
            return;
        }
        App.setNoStepPause(true);
        boolean hotSwap = true;
        if (AppPrefs.getInstance().getUserInterfacePrefs().isConfirmHotSwap()) {
            YesNoDialog dialog = new YesNoDialog((Window)this, "<html><p>Hot Swap changes cartridges without turning off the power. The second game<br/>will begin executing with the memory state of the first game.</p><br/><p>Proceed with Hot Swap?</p></html>", "Confirm Hot Swap");
            dialog.setVisible(true);
            hotSwap = dialog.isYes();
        }
        if (hotSwap) {
            App.close();
            this.openFile(null, false, ejectedMachine);
        } else {
            App.setNoStepPause(false);
        }
    }

    private void noSpriteLimitCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean noSpriteLimit = this.noSpriteLimitCheckBoxMenuItem.isSelected();
        InputUtil.addOtherInput(new SetNoSpriteLimit(noSpriteLimit));
        AppPrefs.getInstance().getView().setNoSpriteLimit(noSpriteLimit);
        AppPrefs.save();
    }

    private void familyBasicOptionsMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        new FamilyBasicOptionsDialog((Window)this).setVisible(true);
        App.setNoStepPause(false);
    }

    private void familyBasicMenuMenuSelected(MenuEvent evt) {
        DataRecorderMapper d;
        int mode = 0;
        Machine m = this.machine;
        if (m != null && (d = m.getMapper().getDataRecorder()) != null) {
            mode = d.getDataRecorderMode();
        }
        boolean filesEnabled = mode == 0;
        this.familyBasicLoadTapeMenuItem.setEnabled(filesEnabled);
        this.familyBasicSaveTapeMenuItem.setEnabled(filesEnabled);
        this.familyBasicEraseTapeMenuItem.setEnabled(filesEnabled);
        switch (mode) {
            case 2: {
                this.familyBasicPlayTapeMenuItem.setSelected(true);
                break;
            }
            case 1: {
                this.familyBasicRecordTapeMenuItem.setSelected(true);
                break;
            }
            default: {
                this.familyBasicStopTapeMenuItem.setSelected(true);
            }
        }
    }

    private void famicom3dGlassesMenuItemActionPerformed(ActionEvent evt) {
        App.createGlassesFrame();
    }

    private void viewMenuMenuSelected(MenuEvent evt) {
        Mapper m;
        boolean barcodeBattlerEnabled = false;
        boolean famicom3dGlassesEnabled = false;
        Machine mac = this.machine;
        Mapper mapper = m = mac == null ? null : mac.getMapper();
        if (m != null) {
            barcodeBattlerEnabled = m.hasDeviceMapper(7);
            famicom3dGlassesEnabled = m.hasDeviceMapper(16);
        }
        this.fileInfoMenuItem.setEnabled(mac != null && this.fileInfo != null);
        this.barcodeBattlerMenuItem.setEnabled(barcodeBattlerEnabled);
        this.famicom3dGlassesMenuItem.setEnabled(famicom3dGlassesEnabled);
        this.robMenuItem.setEnabled(App.isRobGame());
        this.subMonitorMenuItem.setEnabled(App.isVsDualSystem());
    }

    private void speedMenuMenuSelected(MenuEvent evt) {
        int speed = App.getSpeed();
        int bestIndex = 0;
        int delta = Integer.MAX_VALUE;
        for (int i = SpeedValues.length - 1; i >= 0; --i) {
            int d = Math.abs(SpeedValues[i] - speed);
            if (d >= delta) continue;
            delta = d;
            bestIndex = i;
        }
        this.speedMenuItems[bestIndex].setSelected(true);
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        BrowserUtil.openBrowser("http://nintaco.com/faq.html");
    }

    private void screamIntoMicrophoneMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && this.displayingImagePane && App.getAppMode() != AppMode.WatchHistory) {
            InputUtil.addOtherInput(new ScreamIntoMicrophone());
        }
    }

    private void traceLoggerOptionsMenuItemActionPerformed(ActionEvent evt) {
        App.disposeTraceLogger();
        new LoggerDialog((Window)this).setVisible(true);
    }

    private void startTraceLoggerMenuItemActionPerformed(ActionEvent evt) {
        if (App.isTraceLoggerRunning()) {
            App.disposeTraceLogger();
        } else {
            App.startTraceLogger();
        }
    }

    private void debugMenuMenuSelected(MenuEvent evt) {
        boolean machineExists = App.isFileLoaded();
        this.debuggerMenuItem.setEnabled(machineExists);
        this.oamDataMenuItem.setEnabled(machineExists);
        this.patternTablesMenuItem.setEnabled(machineExists);
        this.nametablesMenuItem.setEnabled(machineExists);
        this.hexEditorMenuItem.setEnabled(machineExists);
        this.asmDasmMenuItem.setEnabled(machineExists);
        this.ramSearchMenuItem.setEnabled(machineExists);
        this.ramWatchMenuItem.setEnabled(machineExists);
        if (App.isTraceLoggerRunning() && machineExists) {
            this.startTraceLoggerMenuItem.setText("Stop Trace Logger");
        } else {
            this.startTraceLoggerMenuItem.setText("Start Trace Logger");
        }
        this.startTraceLoggerMenuItem.setEnabled(machineExists);
    }

    private void optionsMenuMenuSelected(MenuEvent evt) {
        this.portsMenuItem.setEnabled(App.getAppMode() != AppMode.NetplayClient);
    }

    private void formWindowStateChanged(WindowEvent evt) {
        EventQueue.invokeLater(() -> {
            this.imagePane.requestRepaint();
            this.invalidate();
            this.validate();
            this.repaint();
        });
    }

    private void formWindowOpened(WindowEvent evt) {
        EventQueue.invokeLater(() -> {
            this.createVideoFiltersMenu();
            this.initShowMenu();
            this.initScreenSizeMenu();
            if (AppPrefs.getInstance().getUserInterfacePrefs().isLaunchFileOpen()) {
                this.openFile(null, false, null);
            }
        });
    }

    private void robMenuItemActionPerformed(ActionEvent evt) {
        RobController rob;
        Machine m = this.machine;
        if (m != null && (rob = m.getPPU().getRob()) != null) {
            new SetupROB(rob).run(m);
        }
    }

    private void showMenuMenuSelected(MenuEvent evt) {
        Machine m = this.machine;
        this.noSpriteLimitCheckBoxMenuItem.setSelected(m == null ? AppPrefs.getInstance().getView().isNoSpriteLimit() : m.getPPU().isNoSpriteLimit());
    }

    private void subMonitorMenuItemActionPerformed(ActionEvent evt) {
        App.createSubMonitorFrame();
    }

    private void insertCoinMainLeftMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && App.isVsSystem()) {
            this.insertCoin(0, 0);
        }
    }

    private void insertCoinMainRightMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && App.isVsSystem()) {
            this.insertCoin(0, 1);
        }
    }

    private void serviceButtonMainMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && App.isVsSystem()) {
            InputUtil.addOtherInput(new PressServiceButton(0));
        }
    }

    private void serviceButtonSubMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && App.isVsDualSystem()) {
            InputUtil.addOtherInput(new PressServiceButton(1));
        }
    }

    private void insertCoinSubLeftMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && App.isVsDualSystem()) {
            this.insertCoin(1, 0);
        }
    }

    private void insertCoinSubRightMenuItemActionPerformed(ActionEvent evt) {
        if (this.machine != null && App.isVsDualSystem()) {
            this.insertCoin(1, 1);
        }
    }

    private void eraseBatterySaveMenuItemActionPerformed(ActionEvent evt) {
        App.setNoStepPause(true);
        YesNoDialog yesNoDialog = new YesNoDialog((Window)this, "<html><p>This will erase all battery-backed data and restart the currently running file.</p><br/><p>Proceed with erase?</p></html>", "Confirm Erase Battery Save");
        yesNoDialog.setVisible(true);
        App.setNoStepPause(false);
        if (yesNoDialog.isYes()) {
            App.eraseBatterySave();
        }
    }

    private void underscanCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        AppPrefs.getInstance().getView().setUnderscan(this.underscanCheckBoxMenuItem.isSelected());
        this.imagePane.updateScreenBorders();
        AppPrefs.save();
    }

    private void uniformPixelScalingCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean uniformPixelScaling = this.uniformPixelScalingCheckBoxMenuItem.isSelected();
        AppPrefs.getInstance().getView().setUniformPixelScaling(uniformPixelScaling);
        this.imagePane.setUniformPixelScaling(uniformPixelScaling);
        AppPrefs.save();
    }

    static {
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add("All supported files");
        for (FileExtensionFilter filter : FileExtensionFilters) {
            if (filter == null) continue;
            for (String extension : filter.getExtensions()) {
                extensions.add(extension);
            }
        }
        ImageFrame.FileExtensionFilters[0] = new FileExtensionFilter(0, extensions.toArray(new String[extensions.size()]));
        BasicFileExtensionFilters = new FileExtensionFilter[]{new FileExtensionFilter(0, "BASIC files (*.bas)", "bas"), new FileExtensionFilter(1, "All files (*.*)")};
        TapeFileExtensionFilters = new FileExtensionFilter[]{new FileExtensionFilter(0, "Tape files (*.tape)", "tape"), new FileExtensionFilter(1, "All files (*.*)")};
        SpeedLabels = new String[]{"Max", "400%", "300%", "200%", "Normal", "75%", "50%", "25%", "10%", "5%", "1%"};
        SpeedValues = new int[]{0, 400, 300, 200, 100, 75, 50, 25, 10, 5, 1};
        DisableKeyEventsDispatcher = e -> true;
    }
}

