/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.image.filters;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;

public abstract class VideoFilter {
    private final BufferedImage image;
    protected final int[] out;

    public VideoFilter(BufferedImage image, int[] out) {
        this.image = image;
        this.out = out;
    }

    public VideoFilter(int scale) {
        this.image = new BufferedImage(256 * scale, 240 * scale, 1);
        this.out = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    public VideoFilter(int width, int height) {
        this.image = new BufferedImage(width, height, 1);
        this.out = ((DataBufferInt)this.image.getRaster().getDataBuffer()).getData();
    }

    public abstract void filter(int[] var1, int var2, int var3);

    public BufferedImage getImage() {
        return this.image;
    }

    public int[] getImageData() {
        return this.out;
    }

    public void reset() {
        Arrays.fill(this.out, 0);
    }

    public void dispose() {
        this.image.flush();
    }

    public void setExtendedPalettes(int[][] extendedPalettes) {
    }

    public void setGhosting(boolean ghosting) {
    }
}

