/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.input.buttonmapping;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import nintaco.gui.WideButtonsDialog;
import nintaco.gui.input.buttonmapping.ButtonMappingTableModel;
import nintaco.gui.input.buttonmapping.PressButtonDialog;
import nintaco.input.ButtonID;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceConfig;
import nintaco.input.DeviceDescriptor;
import nintaco.input.HoldDownOrToggleButtonMapping;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;
import nintaco.input.Ports;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class ButtonMappingDialog
extends JDialog {
    private final List<DeviceConfig> deviceConfigs;
    private boolean okPressed;
    private JButton cancelButton;
    private JButton clearAllButton;
    private JButton clearButton;
    private JComboBox deviceComboBox;
    private JButton okButton;
    private JButton resetAllButton;
    private JButton resetButton;
    private JScrollPane scrollPane;
    private JButton setAllButton;
    private JButton setButton;
    private JTable table;

    public ButtonMappingDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.deviceConfigs = AppPrefs.getInstance().getInputs().copyDeviceConfigs();
        this.initDeviceComboBox();
        this.initTable();
        this.selectPlayer1Device();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public void setInputDevice(int inputDevice) {
        this.deviceComboBox.setSelectedIndex(inputDevice);
    }

    private void initDeviceComboBox() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < 36; ++i) {
            model.addElement(DeviceDescriptor.getDescriptor(i).getDeviceName());
        }
        this.deviceComboBox.setModel(model);
    }

    private void initTable() {
        this.scrollPane.setPreferredSize(null);
        GuiUtil.disableCellBorder(this.table);
        GuiUtil.forceNoClearRowSelect(this.table);
    }

    private void selectPlayer1Device() {
        Ports ports = AppPrefs.getInstance().getInputs().getPorts();
        if (ports.isMultitap()) {
            this.setInputDevice(ports.getDevice(0));
        } else if (ports.getConsoleType() == 2) {
            this.setInputDevice(ports.getDevice(0));
        } else if (ports.getConsoleType() == 0) {
            this.setInputDevice(ports.getDevice(0));
        } else {
            Integer device = ports.getDevice(4);
            if (device == null || device < 0) {
                this.setInputDevice(ports.getDevice(0));
            } else {
                this.setInputDevice(device);
            }
        }
    }

    private void displayDevice(int inputDevice) {
        this.table.setModel(new ButtonMappingTableModel(this.deviceConfigs.get(inputDevice).getButtonMappings()));
        GuiUtil.resizeCellSizes(this.table, true, 13, false, DeviceDescriptor.getDescriptor(35).getButtonName(7), "MMMMMMMMMMMMMMMM");
    }

    private void closeDialog() {
        this.dispose();
        if (this.okPressed) {
            AppPrefs.getInstance().getInputs().setDeviceConfigs(this.deviceConfigs);
            AppPrefs.save();
            InputUtil.handleSettingsChange();
        }
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private int captureRewindTimeSetting() {
        WideButtonsDialog dialog = new WideButtonsDialog((Window)this, "How should the button behave?", "Rewind Time Setup", "Tapping the button toggles the direction of time.", "Time rewinds as long as the button is held down.");
        dialog.setVisible(true);
        return dialog.getButtonIndex();
    }

    private int captureHighSpeedSetting() {
        WideButtonsDialog dialog = new WideButtonsDialog((Window)this, "How should the button behave?", "High-speed Setup", "Tapping the button toggles between normal and high speed.", "Maintain high-speed as long as the button is held down.");
        dialog.setVisible(true);
        return dialog.getButtonIndex();
    }

    private boolean capturePressedButton(boolean showSkipButton) {
        int inputDevice = this.deviceComboBox.getSelectedIndex();
        if (inputDevice < 0) {
            return false;
        }
        DeviceDescriptor descriptor = DeviceDescriptor.getDescriptor(inputDevice);
        int button = this.table.getSelectedRow();
        List<ButtonMapping> list = this.deviceConfigs.get(inputDevice).getButtonMappings();
        ButtonMapping mapping = list.get(button);
        PressButtonDialog dialog = new PressButtonDialog((Window)this, showSkipButton);
        dialog.setButtonName(mapping.getButtonName());
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        ButtonID[] buttonIds = dialog.getButtonIds();
        if (dialog.isSkipped() || buttonIds.length > 0) {
            if (!dialog.isSkipped()) {
                ButtonMapping buttonMapping = descriptor.getButtonMapping(button, buttonIds);
                if (button == descriptor.getRewindTimeButton()) {
                    int buttonIndex = this.captureRewindTimeSetting();
                    if (buttonIndex < 0) {
                        return false;
                    }
                    ((HoldDownOrToggleButtonMapping)buttonMapping).setHoldDown(buttonIndex == 1);
                } else if (button == descriptor.getHighSpeedButton()) {
                    int buttonIndex = this.captureHighSpeedSetting();
                    if (buttonIndex < 0) {
                        return false;
                    }
                    ((HoldDownOrToggleButtonMapping)buttonMapping).setHoldDown(buttonIndex == 1);
                }
                this.deviceConfigs.get(inputDevice).getButtonMappings().set(button, buttonMapping);
            }
            this.displayDevice(inputDevice);
            int nextButton = button + 1;
            if (nextButton == list.size()) {
                return false;
            }
            this.table.getSelectionModel().setSelectionInterval(nextButton, nextButton);
            return true;
        }
        return !dialog.isCanceled();
    }

    private void initComponents() {
        this.deviceComboBox = new JComboBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.setButton = new JButton();
        this.setAllButton = new JButton();
        this.resetButton = new JButton();
        this.resetAllButton = new JButton();
        this.clearButton = new JButton();
        this.clearAllButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Button Mapping");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ButtonMappingDialog.this.formWindowClosing(evt);
            }
        });
        this.deviceComboBox.setFocusable(false);
        this.deviceComboBox.setMinimumSize(null);
        this.deviceComboBox.setPreferredSize(null);
        this.deviceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.deviceComboBoxActionPerformed(evt);
            }
        });
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("   Cancel   ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.scrollPane.setMaximumSize(null);
        this.scrollPane.setName("");
        this.table.setAutoResizeMode(3);
        this.table.setMaximumSize(null);
        this.table.setMinimumSize(null);
        this.table.setPreferredSize(null);
        this.table.setSelectionMode(0);
        this.scrollPane.setViewportView(this.table);
        this.setButton.setMnemonic('S');
        this.setButton.setText("Set");
        this.setButton.setFocusPainted(false);
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.setButtonActionPerformed(evt);
            }
        });
        this.setAllButton.setMnemonic('A');
        this.setAllButton.setText("Set All");
        this.setAllButton.setFocusPainted(false);
        this.setAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.setAllButtonActionPerformed(evt);
            }
        });
        this.resetButton.setMnemonic('R');
        this.resetButton.setText("Reset");
        this.resetButton.setFocusPainted(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.resetButtonActionPerformed(evt);
            }
        });
        this.resetAllButton.setMnemonic('t');
        this.resetAllButton.setText("Reset All");
        this.resetAllButton.setFocusPainted(false);
        this.resetAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.resetAllButtonActionPerformed(evt);
            }
        });
        this.clearButton.setMnemonic('l');
        this.clearButton.setText("Clear");
        this.clearButton.setFocusPainted(false);
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.clearButtonActionPerformed(evt);
            }
        });
        this.clearAllButton.setMnemonic('e');
        this.clearAllButton.setText("Clear All");
        this.clearAllButton.setFocusPainted(false);
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ButtonMappingDialog.this.clearAllButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.setButton).addComponent(this.setAllButton).addComponent(this.resetButton).addComponent(this.resetAllButton).addComponent(this.clearButton).addComponent(this.clearAllButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addGap(8, 8, 8).addComponent(this.cancelButton)).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.deviceComboBox, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.linkSize(0, this.clearAllButton, this.clearButton, this.resetAllButton, this.resetButton, this.setAllButton, this.setButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.deviceComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.setButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setAllButton).addGap(18, 18, 18).addComponent(this.resetButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetAllButton).addGap(18, 18, 18).addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearAllButton).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
    }

    private void setButtonActionPerformed(ActionEvent evt) {
        this.capturePressedButton(false);
    }

    private void setAllButtonActionPerformed(ActionEvent evt) {
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        while (this.capturePressedButton(true)) {
        }
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        int device = this.deviceComboBox.getSelectedIndex();
        int button = this.table.getSelectedRow();
        Inputs.resetDeviceConfig(device, button, this.deviceConfigs);
        this.displayDevice(device);
    }

    private void resetAllButtonActionPerformed(ActionEvent evt) {
        int device = this.deviceComboBox.getSelectedIndex();
        Inputs.resetDeviceConfigs(device, this.deviceConfigs);
        this.displayDevice(device);
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        int device = this.deviceComboBox.getSelectedIndex();
        int button = this.table.getSelectedRow();
        Inputs.clearButtonMapping(device, button, this.deviceConfigs);
        this.displayDevice(device);
    }

    private void clearAllButtonActionPerformed(ActionEvent evt) {
        int device = this.deviceComboBox.getSelectedIndex();
        Inputs.clearDeviceConfig(device, this.deviceConfigs);
        this.displayDevice(device);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okPressed = true;
        AppPrefs.getInstance().getInputs().setDeviceConfigs(this.deviceConfigs);
        AppPrefs.save();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void deviceComboBoxActionPerformed(ActionEvent evt) {
        this.displayDevice(this.deviceComboBox.getSelectedIndex());
    }
}

