/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.ramwatch;

import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import nintaco.gui.ramwatch.RamWatchRow;
import nintaco.util.GuiUtil;
import nintaco.util.StringUtil;

public class EditRamWatchDialog
extends JDialog {
    private final RamWatchRow row = new RamWatchRow();
    private JRadioButton[] wordSizeRadioButtons;
    private JRadioButton[] formatRadioButtons;
    private RamWatchRow result;
    private JLabel addressLabel;
    private JTextField addressTextField;
    private JRadioButton byte1RadioButton;
    private JRadioButton byte2RadioButton;
    private JRadioButton byte4RadioButton;
    private JButton cancelButton;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private ButtonGroup formatButtonGroup;
    private JRadioButton hexRadioButton;
    private JButton hiddenButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton okButton;
    private JRadioButton signedRadioButton;
    private JRadioButton unsignedRadioButton;
    private ButtonGroup wordSizeButtonGroup;

    public EditRamWatchDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.initRadioButtons();
        this.getRootPane().setDefaultButton(this.okButton);
        this.initTextFields();
        this.setValues();
        this.updateOkButton();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.hiddenButton.setVisible(false);
        this.setLocationRelativeTo(parent);
    }

    public RamWatchRow getResult() {
        return this.result;
    }

    private void initRadioButtons() {
        int i;
        this.wordSizeRadioButtons = new JRadioButton[]{this.byte1RadioButton, this.byte2RadioButton, this.byte4RadioButton};
        for (i = this.wordSizeRadioButtons.length - 1; i >= 0; --i) {
            int wordSizeIndex = i;
            this.wordSizeRadioButtons[i].addActionListener(e -> this.row.setWordSizeIndex(wordSizeIndex));
        }
        this.formatRadioButtons = new JRadioButton[]{this.signedRadioButton, this.unsignedRadioButton, this.hexRadioButton};
        for (i = this.formatRadioButtons.length - 1; i >= 0; --i) {
            int valueFormat = i;
            this.formatRadioButtons[i].addActionListener(e -> this.row.setValueFormat(valueFormat));
        }
    }

    private void initTextFields() {
        GuiUtil.addLoseFocusListener((Window)this, this.addressTextField);
        GuiUtil.addLoseFocusListener((Window)this, this.descriptionTextField);
        this.addressTextField.getDocument().addDocumentListener(GuiUtil.createDocumentListener(this::addressTextFieldChanged));
    }

    private void addressTextFieldChanged() {
        this.row.setAddress(StringUtil.parseInt(this.addressTextField.getText(), true, 65535L));
        this.updateOkButton();
    }

    private void updateOkButton() {
        this.okButton.setEnabled(this.row.getAddress() >= 0);
    }

    private void closeDialog() {
        this.dispose();
    }

    private void captureValues() {
        this.row.setAddress(StringUtil.parseInt(this.addressTextField.getText(), true, 65535L));
        this.row.setDescription(this.descriptionTextField.getText().trim());
    }

    private void setValues() {
        this.addressTextField.setText(String.format("$%04X", this.row.getAddress()));
        this.descriptionTextField.setText(this.row.getDescription());
        this.wordSizeRadioButtons[this.row.getWordSizeIndex()].setSelected(true);
        this.formatRadioButtons[this.row.getValueFormat()].setSelected(true);
        if (this.row.getAddress() == 0) {
            this.addressTextField.selectAll();
            this.addressTextField.requestFocus();
        } else {
            this.descriptionTextField.requestFocus();
        }
    }

    public void setRamWatchRow(RamWatchRow row) {
        this.row.set(row);
        this.setValues();
    }

    private void initComponents() {
        this.wordSizeButtonGroup = new ButtonGroup();
        this.formatButtonGroup = new ButtonGroup();
        this.addressLabel = new JLabel();
        this.descriptionLabel = new JLabel();
        this.addressTextField = new JTextField();
        this.descriptionTextField = new JTextField();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel1 = new JPanel();
        this.byte1RadioButton = new JRadioButton();
        this.byte2RadioButton = new JRadioButton();
        this.byte4RadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.signedRadioButton = new JRadioButton();
        this.unsignedRadioButton = new JRadioButton();
        this.hexRadioButton = new JRadioButton();
        this.hiddenButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.setMaximumSize(null);
        this.setMinimumSize(null);
        this.setPreferredSize(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                EditRamWatchDialog.this.formComponentShown(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditRamWatchDialog.this.formWindowClosing(evt);
            }
        });
        this.addressLabel.setText("Address:");
        this.addressLabel.setMaximumSize(null);
        this.addressLabel.setMinimumSize(null);
        this.addressLabel.setPreferredSize(null);
        this.descriptionLabel.setText("Description:");
        this.descriptionLabel.setMaximumSize(null);
        this.descriptionLabel.setMinimumSize(null);
        this.descriptionLabel.setPreferredSize(null);
        this.addressTextField.setColumns(6);
        this.addressTextField.setMaximumSize(null);
        this.addressTextField.setMinimumSize(null);
        this.addressTextField.setPreferredSize(null);
        this.descriptionTextField.setColumns(32);
        this.descriptionTextField.setMaximumSize(null);
        this.descriptionTextField.setMinimumSize(null);
        this.descriptionTextField.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("  Cancel  ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditRamWatchDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditRamWatchDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Word Size"));
        this.jPanel1.setMaximumSize(null);
        this.wordSizeButtonGroup.add(this.byte1RadioButton);
        this.byte1RadioButton.setSelected(true);
        this.byte1RadioButton.setText("1 Byte");
        this.byte1RadioButton.setFocusPainted(false);
        this.wordSizeButtonGroup.add(this.byte2RadioButton);
        this.byte2RadioButton.setText("2 Bytes");
        this.byte2RadioButton.setFocusPainted(false);
        this.wordSizeButtonGroup.add(this.byte4RadioButton);
        this.byte4RadioButton.setText("4 Bytes");
        this.byte4RadioButton.setFocusPainted(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.byte1RadioButton).addComponent(this.byte2RadioButton).addComponent(this.byte4RadioButton)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.byte1RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byte2RadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.byte4RadioButton).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Format"));
        this.jPanel2.setMaximumSize(null);
        this.formatButtonGroup.add(this.signedRadioButton);
        this.signedRadioButton.setSelected(true);
        this.signedRadioButton.setText("Signed");
        this.signedRadioButton.setFocusPainted(false);
        this.formatButtonGroup.add(this.unsignedRadioButton);
        this.unsignedRadioButton.setText("Unsigned");
        this.unsignedRadioButton.setFocusPainted(false);
        this.formatButtonGroup.add(this.hexRadioButton);
        this.hexRadioButton.setText("Hex");
        this.hexRadioButton.setFocusPainted(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.signedRadioButton).addComponent(this.unsignedRadioButton).addComponent(this.hexRadioButton)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.signedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unsignedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hexRadioButton).addContainerGap()));
        this.hiddenButton.setMnemonic('H');
        this.hiddenButton.setText("Hidden Button");
        this.hiddenButton.setFocusPainted(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressLabel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.descriptionLabel, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addressTextField, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.descriptionTextField, -2, 1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.hiddenButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressLabel, -2, -1, -2).addComponent(this.addressTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.descriptionLabel, -2, -1, -2).addComponent(this.descriptionTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel2, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.hiddenButton)).addContainerGap()));
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.addressTextField.setText(String.format("$%04X", this.row.getAddress()));
        this.descriptionTextField.setText(this.row.getDescription());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.captureValues();
        this.result = this.row;
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }
}

