/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.rob;

import java.util.Arrays;
import nintaco.gui.rob.RobCommand;
import nintaco.gui.rob.RobController;
import nintaco.mappers.Mapper;

public class StackUpController
extends RobController {
    private static final long serialVersionUID = 0L;
    private static final int MODE_ADDRESS = 56;
    private static final int SCROLL_ADDRESS = 11;
    private static final int PROGRAM_RUNNING_ADDRESS = 101;
    private static final int VERTICAL_STEPS = 12;
    private static final int HORIZONTAL_STEPS = 16;
    private static final int GRASP_STEPS = 8;
    private static final int ADVANCE_PHASE_STEPS = 16;
    private static final float ACCELERATION = 0.1f;
    private static final float VERTICAL_DELTA = 0.083333336f;
    private static final float HORIZONTAL_DELTA = 0.0625f;
    private static final float GRASP_DELTA = 0.125f;
    private final boolean[] heldBlocks = new boolean[5];
    private final int[][][] puzzles = new int[4][6][5];
    private float fallingVelocity;
    private float stackHeight;

    public StackUpController() {
        this.state.game = 2;
        this.state.reset();
    }

    @Override
    public int pollButtons(int buttons, Mapper mapper) {
        if ((buttons & 0x8080808) != 0) {
            Arrays.fill(this.heldBlocks, false);
            this.fallingVelocity = 0.0f;
            this.stackHeight = 0.0f;
            this.state.reset();
            this.scanMemory(mapper);
        } else if (this.executingCommand == RobCommand.AdvancePhase) {
            int mode = mapper.readMemory(56);
            switch (mode) {
                case 1: 
                case 2: {
                    return buttons | 8;
                }
                case 3: {
                    if (this.counter > 8) {
                        return buttons | 1;
                    }
                    int scroll = mapper.readMemory(11);
                    if (scroll != 128) {
                        ++this.counter;
                        break;
                    }
                    return buttons | 8;
                }
            }
        }
        return buttons;
    }

    @Override
    public void scanMemory(Mapper mapper) {
        int i;
        int mode = mapper.readMemory(56);
        if (mode == 0) {
            return;
        }
        boolean matches = true;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int j = 4; j >= 0; --j) {
                int offset = 5 * i2 + j;
                int startValue = mapper.readMemory(0x520 | offset);
                if (startValue > 5) {
                    return;
                }
                int goalValue = mapper.readMemory(0x500 | offset);
                if (goalValue > 5) {
                    return;
                }
                if (this.puzzles[0][i2][j] != startValue || this.puzzles[1][i2][j] != goalValue) {
                    matches = false;
                }
                this.puzzles[2][i2][j] = startValue;
                this.puzzles[3][i2][j] = goalValue;
            }
        }
        if (matches) {
            if (this.requestedCommand == null && this.executingCommand == null) {
                float[][] blocks = this.state.pieces;
                if (mode == 2 && mapper.readMemory(101) != 1) {
                    return;
                }
                block0 : switch (mode) {
                    case 1: 
                    case 2: {
                        int y;
                        for (i = 4; i >= 0; --i) {
                            y = (int)blocks[i][1];
                            if (y == 0 || this.puzzles[1][y][2 + (int)blocks[i][0]] != i + 1) break block0;
                        }
                        this.request(RobCommand.AdvancePhase);
                        break;
                    }
                    case 3: {
                        int y;
                        for (i = 4; i >= 0; --i) {
                            y = (int)blocks[i][1];
                            if (y == 0 || this.puzzles[1][y][2 + (int)blocks[i][0]] == 0) break block0;
                        }
                        this.request(RobCommand.AdvancePhase);
                    }
                }
            }
        } else {
            int[][] temp = this.puzzles[2];
            this.puzzles[2] = this.puzzles[0];
            this.puzzles[0] = temp;
            temp = this.puzzles[3];
            this.puzzles[3] = this.puzzles[1];
            this.puzzles[1] = temp;
            for (i = 5; i >= 0; --i) {
                for (int j = 4; j >= 0; --j) {
                    int index = this.puzzles[0][i][j];
                    if (index <= 0) continue;
                    this.state.pieces[--index][0] = j - 2;
                    this.state.pieces[index][1] = i;
                }
            }
            this.requestedCommand = null;
            this.executingCommand = null;
            this.counter = 0;
            if (this.state.handsOpen == 0.0f) {
                this.request(RobCommand.OpenHands);
            } else {
                this.request(RobCommand.Repaint);
            }
        }
    }

    @Override
    protected void initMoveUp() {
        if (this.state.handsY == 0.0f) {
            this.executingCommand = null;
        } else {
            this.counter = 12;
        }
    }

    @Override
    protected void initMoveDown() {
        if (this.state.handsY == 5.0f) {
            this.executingCommand = null;
            return;
        }
        float height = this.getStackHeight(this.state.handsX);
        if (this.state.handsOpen == 0.0f && this.state.handsY == height) {
            this.executingCommand = null;
            return;
        }
        this.counter = 12;
    }

    @Override
    protected void initMoveLeft() {
        if (this.state.handsX == -2.0f) {
            this.executingCommand = null;
            return;
        }
        boolean holding = false;
        for (int i = 4; i >= 0; --i) {
            if (!this.heldBlocks[i]) continue;
            holding = true;
            break;
        }
        float height = this.getStackHeight(this.state.handsX);
        if (this.state.handsOpen == 1.0f && this.state.handsY > height || holding && this.state.handsY >= height) {
            this.executingCommand = null;
            return;
        }
        float targetHeight = this.getStackHeight(this.state.handsX - 1.0f);
        if (this.state.handsY > targetHeight || holding && this.state.handsY >= targetHeight) {
            this.executingCommand = null;
            return;
        }
        this.counter = 16;
    }

    @Override
    protected void initMoveRight() {
        if (this.state.handsX == 2.0f) {
            this.executingCommand = null;
            return;
        }
        boolean holding = false;
        for (int i = 4; i >= 0; --i) {
            if (!this.heldBlocks[i]) continue;
            holding = true;
            break;
        }
        float height = this.getStackHeight(this.state.handsX);
        if (this.state.handsOpen == 1.0f && this.state.handsY > height || holding && this.state.handsY >= height) {
            this.executingCommand = null;
            return;
        }
        float targetHeight = this.getStackHeight(this.state.handsX + 1.0f);
        if (this.state.handsY > targetHeight || holding && this.state.handsY >= targetHeight) {
            this.executingCommand = null;
            return;
        }
        this.counter = 16;
    }

    @Override
    protected void initOpenHands() {
        if (this.state.handsOpen == 1.0f) {
            this.executingCommand = null;
        } else {
            this.fallingVelocity = 0.0f;
            this.stackHeight = this.getStackHeight(this.state.handsX);
            this.counter = 8;
        }
    }

    @Override
    protected void initCloseHands() {
        if (this.state.handsOpen == 0.0f) {
            this.executingCommand = null;
        } else {
            this.counter = 8;
        }
    }

    @Override
    protected void initAdvancePhase() {
        this.counter = 16;
    }

    @Override
    protected void executeMoveUp() {
        int i;
        this.state.handsY -= 0.083333336f;
        float[][] blocks = this.state.pieces;
        for (i = 4; i >= 0; --i) {
            if (!this.heldBlocks[i]) continue;
            float[] fArray = blocks[i];
            fArray[1] = fArray[1] - 0.083333336f;
        }
        if (--this.counter == 0) {
            this.state.handsY = Math.round(this.state.handsY);
            for (i = 4; i >= 0; --i) {
                if (!this.heldBlocks[i]) continue;
                blocks[i][1] = Math.round(blocks[i][1]);
            }
            this.executingCommand = null;
        }
    }

    @Override
    protected void executeMoveDown() {
        int i;
        this.state.handsY += 0.083333336f;
        float[][] blocks = this.state.pieces;
        for (i = 4; i >= 0; --i) {
            if (!this.heldBlocks[i]) continue;
            float[] fArray = blocks[i];
            fArray[1] = fArray[1] + 0.083333336f;
        }
        if (--this.counter == 0) {
            this.state.handsY = Math.round(this.state.handsY);
            for (i = 4; i >= 0; --i) {
                if (!this.heldBlocks[i]) continue;
                blocks[i][1] = Math.round(blocks[i][1]);
            }
            this.executingCommand = null;
        }
    }

    @Override
    protected void executeMoveLeft() {
        int i;
        this.state.handsX -= 0.0625f;
        float[][] blocks = this.state.pieces;
        for (i = 4; i >= 0; --i) {
            if (!this.heldBlocks[i]) continue;
            float[] fArray = blocks[i];
            fArray[0] = fArray[0] - 0.0625f;
        }
        if (--this.counter == 0) {
            this.state.handsX = Math.round(this.state.handsX);
            for (i = 4; i >= 0; --i) {
                if (!this.heldBlocks[i]) continue;
                blocks[i][0] = Math.round(blocks[i][0]);
            }
            this.executingCommand = null;
        }
    }

    @Override
    protected void executeMoveRight() {
        int i;
        this.state.handsX += 0.0625f;
        float[][] blocks = this.state.pieces;
        for (i = 4; i >= 0; --i) {
            if (!this.heldBlocks[i]) continue;
            float[] fArray = blocks[i];
            fArray[0] = fArray[0] + 0.0625f;
        }
        if (--this.counter == 0) {
            this.state.handsX = Math.round(this.state.handsX);
            for (i = 4; i >= 0; --i) {
                if (!this.heldBlocks[i]) continue;
                blocks[i][0] = Math.round(blocks[i][0]);
            }
            this.executingCommand = null;
        }
    }

    @Override
    protected void executeOpenHands() {
        if (this.counter > 0) {
            this.state.handsOpen += 0.125f;
            --this.counter;
        }
        this.fallingVelocity += 0.1f;
        boolean fallCompleted = false;
        boolean fallingBlocks = false;
        float[][] blocks = this.state.pieces;
        for (int i = 4; i >= 0; --i) {
            if (!this.heldBlocks[i]) continue;
            fallingBlocks = true;
            float[] fArray = blocks[i];
            fArray[1] = fArray[1] + this.fallingVelocity;
            if (!(blocks[i][1] >= this.stackHeight)) continue;
            fallCompleted = true;
        }
        if (fallCompleted) {
            int i;
            fallingBlocks = false;
            double delta = 0.0;
            for (i = 4; i >= 0; --i) {
                if (!this.heldBlocks[i] || !(blocks[i][1] >= this.stackHeight)) continue;
                delta = Math.max(delta, (double)(blocks[i][1] - this.stackHeight));
            }
            for (i = 4; i >= 0; --i) {
                if (!this.heldBlocks[i]) continue;
                this.heldBlocks[i] = false;
                blocks[i][1] = Math.round((double)blocks[i][1] - delta);
            }
        }
        if (this.counter == 0 && !fallingBlocks) {
            this.state.handsOpen = 1.0f;
            this.executingCommand = null;
        }
    }

    @Override
    protected void executeCloseHands() {
        this.state.handsOpen -= 0.125f;
        if (--this.counter == 0) {
            this.state.handsOpen = 0.0f;
            float[][] blocks = this.state.pieces;
            for (int i = 4; i >= 0; --i) {
                if (blocks[i][0] != this.state.handsX || !(blocks[i][1] <= this.state.handsY)) continue;
                this.heldBlocks[i] = true;
            }
            this.executingCommand = null;
        }
    }

    @Override
    protected void executeAdvancePhase() {
        if (--this.counter == 0) {
            this.executingCommand = null;
            this.request(RobCommand.OpenHands);
        }
    }

    private float getStackHeight(float x) {
        float[][] blocks = this.state.pieces;
        float height = 5.0f;
        for (int i = 4; i >= 0; --i) {
            if (this.heldBlocks[i] || blocks[i][0] != x) continue;
            height = Math.min(height, blocks[i][1] - 1.0f);
        }
        return height;
    }
}

