/*
 * Decompiled with CFR 0.152.
 */
package nintaco.gui.userinterface;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import nintaco.gui.userinterface.InitialRamState;
import nintaco.gui.userinterface.InterframeDelay;
import nintaco.gui.userinterface.UserInterfacePrefs;
import nintaco.preferences.AppPrefs;
import nintaco.util.GuiUtil;

public class UserInterfaceDialog
extends JDialog {
    private boolean ok;
    private JCheckBox acceptBackgroundInputCheckBox;
    private JCheckBox allowMultipleInstancesCheckBox;
    private JCheckBox applyIpsPatchesCheckBox;
    private JButton cancelButton;
    private JCheckBox confirmExitCheckBox;
    private JCheckBox confirmHotSwapCheckBox;
    private JCheckBox confirmResetCheckBox;
    private JButton defaultsButton;
    private JCheckBox disableScreensaverCheckBox;
    private JCheckBox enterFullscreenCheckBox;
    private JCheckBox hideMenuBarCheckBox;
    private JComboBox<String> initialRamStateComboBox;
    private JLabel initialRamStateLabel;
    private JComboBox<String> interframeDelayComboBox;
    private JLabel interframeDelayLabel;
    private JCheckBox launchFileOpenCheckBox;
    private JLabel maxLagFramesLabel;
    private JSpinner maxLagFramesSpinner;
    private JButton okButton;
    private JCheckBox pauseMenuCheckBox;
    private JCheckBox referenceDatabaseCheckBox;
    private JCheckBox runInBackgroundCheckBox;
    private JCheckBox useMulticoreFilteringCheckBox;
    private JCheckBox useVsyncCheckBox;

    public UserInterfaceDialog(Window parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        this.initSpinner();
        this.loadFields();
        GuiUtil.scaleFonts(this);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private void initSpinner() {
        this.maxLagFramesSpinner.setModel(new SpinnerNumberModel(1, 1, 999, 1));
        this.maxLagFramesSpinner.setEditor(new JSpinner.NumberEditor(this.maxLagFramesSpinner, "#"));
        GuiUtil.addLoseFocusListener((Window)this, this.maxLagFramesSpinner);
    }

    private void loadFields() {
        this.loadFields(AppPrefs.getInstance().getUserInterfacePrefs());
    }

    private void loadFields(UserInterfacePrefs prefs) {
        this.launchFileOpenCheckBox.setSelected(prefs.isLaunchFileOpen());
        this.referenceDatabaseCheckBox.setSelected(prefs.isReferenceDatabase());
        this.applyIpsPatchesCheckBox.setSelected(prefs.isApplyIpsPatches());
        this.hideMenuBarCheckBox.setSelected(prefs.isHideMenuBar());
        this.enterFullscreenCheckBox.setSelected(prefs.isEnterFullscreen());
        this.pauseMenuCheckBox.setSelected(prefs.isPauseMenu());
        this.confirmResetCheckBox.setSelected(prefs.isConfirmReset());
        this.confirmExitCheckBox.setSelected(prefs.isConfirmExit());
        this.confirmHotSwapCheckBox.setSelected(prefs.isConfirmHotSwap());
        this.disableScreensaverCheckBox.setSelected(prefs.isDisableScreensaver());
        this.allowMultipleInstancesCheckBox.setSelected(prefs.isAllowMultipleInstances());
        this.runInBackgroundCheckBox.setSelected(prefs.isRunInBackground());
        this.acceptBackgroundInputCheckBox.setSelected(prefs.isAcceptBackgroundInput());
        this.useVsyncCheckBox.setSelected(prefs.isUseVsync());
        this.useMulticoreFilteringCheckBox.setSelected(prefs.isUseMulticoreFiltering());
        this.maxLagFramesSpinner.setValue(prefs.getMaxLagFrames());
        this.interframeDelayComboBox.setSelectedItem((Object)prefs.getInterframeDelay());
        this.initialRamStateComboBox.setSelectedItem((Object)prefs.getInitialRamState());
    }

    private void captureFields() {
        UserInterfacePrefs prefs = AppPrefs.getInstance().getUserInterfacePrefs();
        prefs.setLaunchFileOpen(this.launchFileOpenCheckBox.isSelected());
        prefs.setReferenceDatabase(this.referenceDatabaseCheckBox.isSelected());
        prefs.setApplyIpsPatches(this.applyIpsPatchesCheckBox.isSelected());
        prefs.setHideMenuBar(this.hideMenuBarCheckBox.isSelected());
        prefs.setEnterFullscreen(this.enterFullscreenCheckBox.isSelected());
        prefs.setPauseMenu(this.pauseMenuCheckBox.isSelected());
        prefs.setConfirmReset(this.confirmResetCheckBox.isSelected());
        prefs.setConfirmExit(this.confirmExitCheckBox.isSelected());
        prefs.setConfirmHotSwap(this.confirmHotSwapCheckBox.isSelected());
        prefs.setDisableScreensaver(this.disableScreensaverCheckBox.isSelected());
        prefs.setAllowMultipleInstances(this.allowMultipleInstancesCheckBox.isSelected());
        prefs.setRunInBackground(this.runInBackgroundCheckBox.isSelected());
        prefs.setAcceptBackgroundInput(this.acceptBackgroundInputCheckBox.isSelected());
        prefs.setUseVsync(this.useVsyncCheckBox.isSelected());
        prefs.setUseMulticoreFiltering(this.useMulticoreFilteringCheckBox.isSelected());
        prefs.setMaxLagFrames((Integer)this.maxLagFramesSpinner.getValue());
        prefs.setInterframeDelay((InterframeDelay)((Object)this.interframeDelayComboBox.getSelectedItem()));
        prefs.setInitialRamState((InitialRamState)((Object)this.initialRamStateComboBox.getSelectedItem()));
    }

    private void closeDialog() {
        this.dispose();
    }

    public boolean isOk() {
        return this.ok;
    }

    private void initComponents() {
        this.launchFileOpenCheckBox = new JCheckBox();
        this.referenceDatabaseCheckBox = new JCheckBox();
        this.hideMenuBarCheckBox = new JCheckBox();
        this.enterFullscreenCheckBox = new JCheckBox();
        this.pauseMenuCheckBox = new JCheckBox();
        this.confirmResetCheckBox = new JCheckBox();
        this.confirmExitCheckBox = new JCheckBox();
        this.disableScreensaverCheckBox = new JCheckBox();
        this.allowMultipleInstancesCheckBox = new JCheckBox();
        this.runInBackgroundCheckBox = new JCheckBox();
        this.acceptBackgroundInputCheckBox = new JCheckBox();
        this.useVsyncCheckBox = new JCheckBox();
        this.useMulticoreFilteringCheckBox = new JCheckBox();
        this.interframeDelayLabel = new JLabel();
        this.interframeDelayComboBox = new JComboBox<InterframeDelay>(InterframeDelay.values());
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.defaultsButton = new JButton();
        this.initialRamStateLabel = new JLabel();
        this.initialRamStateComboBox = new JComboBox<InitialRamState>(InitialRamState.values());
        this.confirmHotSwapCheckBox = new JCheckBox();
        this.applyIpsPatchesCheckBox = new JCheckBox();
        this.maxLagFramesLabel = new JLabel();
        this.maxLagFramesSpinner = new JSpinner();
        this.setDefaultCloseOperation(0);
        this.setTitle("User Interface Options");
        this.setPreferredSize(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                UserInterfaceDialog.this.formWindowClosing(evt);
            }
        });
        this.launchFileOpenCheckBox.setText("Launch File | Open... on startup");
        this.launchFileOpenCheckBox.setFocusPainted(false);
        this.launchFileOpenCheckBox.setPreferredSize(null);
        this.referenceDatabaseCheckBox.setText("Soft patch file header on load");
        this.referenceDatabaseCheckBox.setFocusPainted(false);
        this.hideMenuBarCheckBox.setText("Hide menu bar on load");
        this.hideMenuBarCheckBox.setFocusPainted(false);
        this.hideMenuBarCheckBox.setPreferredSize(null);
        this.enterFullscreenCheckBox.setText("Enter fullscreen mode on load");
        this.enterFullscreenCheckBox.setFocusPainted(false);
        this.enterFullscreenCheckBox.setPreferredSize(null);
        this.pauseMenuCheckBox.setText("Pause during menu access");
        this.pauseMenuCheckBox.setFocusPainted(false);
        this.pauseMenuCheckBox.setPreferredSize(null);
        this.confirmResetCheckBox.setText("Confirm reset / power cycle");
        this.confirmResetCheckBox.setFocusPainted(false);
        this.confirmResetCheckBox.setPreferredSize(null);
        this.confirmExitCheckBox.setText("Confirm exit");
        this.confirmExitCheckBox.setFocusPainted(false);
        this.confirmExitCheckBox.setPreferredSize(null);
        this.disableScreensaverCheckBox.setText("Disable screensaver");
        this.disableScreensaverCheckBox.setFocusPainted(false);
        this.disableScreensaverCheckBox.setMaximumSize(null);
        this.disableScreensaverCheckBox.setMinimumSize(null);
        this.disableScreensaverCheckBox.setPreferredSize(null);
        this.allowMultipleInstancesCheckBox.setText("Allow multiple application instances");
        this.allowMultipleInstancesCheckBox.setFocusPainted(false);
        this.allowMultipleInstancesCheckBox.setPreferredSize(null);
        this.runInBackgroundCheckBox.setText("Run in background");
        this.runInBackgroundCheckBox.setFocusPainted(false);
        this.runInBackgroundCheckBox.setPreferredSize(null);
        this.acceptBackgroundInputCheckBox.setText("Accept background input");
        this.acceptBackgroundInputCheckBox.setFocusPainted(false);
        this.acceptBackgroundInputCheckBox.setPreferredSize(null);
        this.useVsyncCheckBox.setText("Use VSync in window mode");
        this.useVsyncCheckBox.setFocusPainted(false);
        this.useVsyncCheckBox.setPreferredSize(null);
        this.useMulticoreFilteringCheckBox.setText("Use multiple cores for video filtering");
        this.useMulticoreFilteringCheckBox.setFocusPainted(false);
        this.useMulticoreFilteringCheckBox.setPreferredSize(null);
        this.interframeDelayLabel.setText("Inter-frame delay:");
        this.interframeDelayLabel.setPreferredSize(null);
        this.interframeDelayComboBox.setFocusable(false);
        this.interframeDelayComboBox.setPreferredSize(null);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText(" Cancel ");
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserInterfaceDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setFocusPainted(false);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserInterfaceDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.defaultsButton.setMnemonic('D');
        this.defaultsButton.setText("Defaults");
        this.defaultsButton.setFocusPainted(false);
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserInterfaceDialog.this.defaultsButtonActionPerformed(evt);
            }
        });
        this.initialRamStateLabel.setText("Initial RAM state:");
        this.initialRamStateLabel.setPreferredSize(null);
        this.initialRamStateComboBox.setFocusable(false);
        this.initialRamStateComboBox.setPreferredSize(null);
        this.confirmHotSwapCheckBox.setText("Confirm hot swap");
        this.confirmHotSwapCheckBox.setFocusPainted(false);
        this.confirmHotSwapCheckBox.setMaximumSize(null);
        this.confirmHotSwapCheckBox.setMinimumSize(null);
        this.confirmHotSwapCheckBox.setPreferredSize(null);
        this.applyIpsPatchesCheckBox.setText("Apply IPS patches on load");
        this.maxLagFramesLabel.setText("Max lag frames:");
        this.maxLagFramesLabel.setMaximumSize(null);
        this.maxLagFramesLabel.setPreferredSize(null);
        this.maxLagFramesSpinner.setMaximumSize(null);
        this.maxLagFramesSpinner.setMinimumSize(null);
        this.maxLagFramesSpinner.setPreferredSize(null);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 13, Short.MAX_VALUE).addComponent(this.defaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.interframeDelayLabel, -2, -1, -2).addComponent(this.initialRamStateLabel, -2, -1, -2).addComponent(this.maxLagFramesLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.interframeDelayComboBox, -2, -1, -2).addComponent(this.maxLagFramesSpinner, -2, -1, -2).addComponent(this.initialRamStateComboBox, -2, -1, -2))).addComponent(this.confirmHotSwapCheckBox, -2, -1, -2).addComponent(this.confirmExitCheckBox, -2, -1, -2).addComponent(this.disableScreensaverCheckBox, -2, -1, -2).addComponent(this.launchFileOpenCheckBox, -2, -1, -2).addComponent(this.referenceDatabaseCheckBox).addComponent(this.hideMenuBarCheckBox, -2, -1, -2).addComponent(this.enterFullscreenCheckBox, -2, -1, -2).addComponent(this.pauseMenuCheckBox, -2, -1, -2).addComponent(this.confirmResetCheckBox, -2, -1, -2).addComponent(this.allowMultipleInstancesCheckBox, -2, -1, -2).addComponent(this.runInBackgroundCheckBox, -2, -1, -2).addComponent(this.acceptBackgroundInputCheckBox, -2, -1, -2).addComponent(this.useVsyncCheckBox, -2, -1, -2).addComponent(this.useMulticoreFilteringCheckBox, -2, -1, -2).addComponent(this.applyIpsPatchesCheckBox)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.defaultsButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.launchFileOpenCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referenceDatabaseCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.applyIpsPatchesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hideMenuBarCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enterFullscreenCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pauseMenuCheckBox, -2, -1, -2).addGap(0, 0, 0).addComponent(this.confirmResetCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confirmExitCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.confirmHotSwapCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableScreensaverCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allowMultipleInstancesCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.runInBackgroundCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.acceptBackgroundInputCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useVsyncCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useMulticoreFilteringCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxLagFramesSpinner, -2, -1, -2).addComponent(this.maxLagFramesLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.interframeDelayLabel, -2, -1, -2).addComponent(this.interframeDelayComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialRamStateComboBox, -2, -1, -2).addComponent(this.initialRamStateLabel, -2, -1, -2)).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton).addComponent(this.defaultsButton)).addContainerGap()));
    }

    private void defaultsButtonActionPerformed(ActionEvent evt) {
        this.loadFields(new UserInterfacePrefs());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.captureFields();
        AppPrefs.save();
        this.closeDialog();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeDialog();
    }
}

