/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;

public abstract class DeviceConfig
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected final int inputDevice;
    protected List<ButtonMapping> buttonMappings;
    protected transient DeviceDescriptor descriptor;

    public DeviceConfig(int inputDevice) {
        this(inputDevice, new ArrayList<ButtonMapping>());
        int buttonCount = this.descriptor.getButtonCount();
        for (int i = 0; i < buttonCount; ++i) {
            this.buttonMappings.add(this.descriptor.getDefaultButtonMapping(i));
        }
    }

    public DeviceConfig(int inputDevice, List<ButtonMapping> buttonMappings) {
        this.inputDevice = inputDevice;
        this.buttonMappings = buttonMappings;
        this.initDeviceDescriptor();
    }

    public DeviceConfig(DeviceConfig deviceConfig) {
        this.inputDevice = deviceConfig.getInputDevice();
        this.buttonMappings = new ArrayList<ButtonMapping>();
        for (ButtonMapping buttonMapping : deviceConfig.getButtonMappings()) {
            this.buttonMappings.add(buttonMapping.copy());
        }
        this.initDeviceDescriptor();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initDeviceDescriptor();
    }

    public abstract DeviceConfig copy();

    private void initDeviceDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = DeviceDescriptor.getDescriptor(this.inputDevice);
        }
    }

    public DeviceDescriptor getDeviceDescriptor() {
        this.initDeviceDescriptor();
        return this.descriptor;
    }

    public List<ButtonMapping> getButtonMappings() {
        return this.buttonMappings;
    }

    public void setButtonMappings(List<ButtonMapping> buttonMappings) {
        this.buttonMappings = buttonMappings;
    }

    public int getInputDevice() {
        return this.inputDevice;
    }

    public void clear() {
        int buttonCount = this.descriptor.getButtonCount();
        for (int i = 0; i < buttonCount; ++i) {
            this.buttonMappings.set(i, this.descriptor.getNoButtonMapping(i));
        }
    }
}

