/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.bandaihypershot;

import nintaco.input.icons.InputIcons;
import nintaco.input.zapper.ZapperMapper;
import nintaco.util.BitUtil;

public class BandaiHyperShotMapper
extends ZapperMapper {
    private int buttons;
    private int shiftRegister;
    private boolean strobe;

    public BandaiHyperShotMapper() {
        super(1);
    }

    @Override
    public int getInputDevice() {
        return 6;
    }

    @Override
    public void handleScanline() {
        if (this.photoSensor > 0) {
            --this.photoSensor;
        }
        this.updatePortValue();
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
        this.trigger = BitUtil.getBit(buttons, 8);
        this.coordinates = buttons >> 16 & 0xFFFF;
        this.offscreen = this.coordinates == 65535;
        this.updatePortValue();
    }

    @Override
    public void writePort(int value) {
        this.strobe = BitUtil.getBitBool(value, 0);
        if (this.strobe) {
            this.shiftRegister = 0xFFFFFE00 | this.buttons >> 7 & 0x1FE;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 0) {
            int value = this.shiftRegister & 2;
            if (!this.strobe) {
                this.shiftRegister >>= 1;
            }
            return value;
        }
        return this.portValue;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 0 ? this.shiftRegister & 2 : this.portValue;
    }

    @Override
    public void render(int[] screen) {
        int bs = this.buttons >> 8;
        int x = 168;
        int y = 202;
        InputIcons.BandaiHyperShot.render(screen, 168, 202);
        if (BitUtil.getBitBool(bs, 0)) {
            InputIcons.BandaiHyperShotTrigger.render(screen, 180, 217);
        }
        if (BitUtil.getBitBool(bs, 1)) {
            InputIcons.BandaiHyperShotTrigger.render(screen, 196, 216);
        }
        if (BitUtil.getBitBool(bs, 3)) {
            InputIcons.GamepadStart.render(screen, 187, 211);
        }
        if (BitUtil.getBitBool(bs, 4)) {
            InputIcons.GamepadStart.render(screen, 192, 211);
        }
        if (BitUtil.getBitBool(bs, 5)) {
            InputIcons.GamepadDPad.render(screen, 178, 206);
        }
        if (BitUtil.getBitBool(bs, 6)) {
            InputIcons.GamepadDPad.render(screen, 178, 212);
        }
        if (BitUtil.getBitBool(bs, 7)) {
            InputIcons.GamepadDPad.render(screen, 175, 209);
        }
        if (BitUtil.getBitBool(bs, 8)) {
            InputIcons.GamepadDPad.render(screen, 181, 209);
        }
        int X = this.coordinates & 0xFF;
        int Y = this.coordinates >> 8 & 0xFF;
        if (Y < 240) {
            InputIcons.ZapperTarget.renderSafe(screen, X - 7, Y - 7);
        }
    }
}

