/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.battlebox;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import nintaco.input.DeviceMapper;
import nintaco.preferences.GamePrefs;
import nintaco.util.BitUtil;
import nintaco.util.StreamUtil;

public class BattleBoxMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient int[] sram = new int[512];
    private int dataIn;
    private int dataOut;
    private int input;
    private int bitsIn;
    private int output;
    private int addr0;
    private boolean clock;
    private boolean lastClock;
    private boolean eraseWriteEnabled;

    public BattleBoxMapper() {
        int[] battleBoxRam = GamePrefs.getInstance().getStorageUnitRam();
        if (battleBoxRam != null && battleBoxRam.length == 512) {
            this.sram = battleBoxRam;
        }
    }

    @Override
    public int getInputDevice() {
        return 8;
    }

    @Override
    public void update(int buttons) {
    }

    @Override
    public void writePort(int value) {
        this.clock = BitUtil.getBitBool(value, 0);
        if (this.clock) {
            if (!this.lastClock) {
                this.input = this.input << 1 | this.dataIn;
                block0 : switch (++this.bitsIn) {
                    case 16: {
                        this.bitsIn = 32;
                        switch (this.input >> 4 & 0xF) {
                            case 8: {
                                int address = this.input >> 7 & 0x1FC | this.addr0;
                                this.output = BitUtil.reverseBits(this.sram[address | 2]) << 8 | BitUtil.reverseBits(this.sram[address]);
                                break block0;
                            }
                            case 6: {
                                if (!this.eraseWriteEnabled) break;
                                this.bitsIn = 16;
                                break block0;
                            }
                            case 3: {
                                if (!this.eraseWriteEnabled) break;
                                Arrays.fill(this.sram, 0);
                                break block0;
                            }
                            case 11: {
                                this.output = -1;
                                break block0;
                            }
                            case 9: {
                                this.eraseWriteEnabled = true;
                                break block0;
                            }
                            case 13: {
                                this.eraseWriteEnabled = false;
                            }
                        }
                        break;
                    }
                    case 32: {
                        int address = this.input >> 23 & 0x1FC | this.addr0;
                        this.sram[address] = this.input >> 8 & 0xFF;
                        this.sram[address | 2] = this.input & 0xFF;
                        break;
                    }
                }
            }
        } else if (this.lastClock) {
            this.dataOut = this.output & 1;
            this.output >>= 1;
        }
        this.lastClock = this.clock;
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 1) {
            this.dataIn ^= 1;
            if (this.clock) {
                this.bitsIn = 0;
                this.output = 0;
                this.addr0 ^= 1;
            }
            return (this.dataIn << 4 | this.dataOut << 3) ^ 0x18;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return (this.dataIn << 4 | this.dataOut << 3) ^ 0x18;
    }

    @Override
    public void close(boolean saveNonVolatileData) {
        if (saveNonVolatileData) {
            GamePrefs.getInstance().setStorageUnitRam(this.sram);
            GamePrefs.save();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.sram = StreamUtil.readSparseByteArray(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        StreamUtil.writeSparseByteArray(out, this.sram);
    }

    public static interface Command {
        public static final int Read = 8;
        public static final int Program = 6;
        public static final int ChipErase = 3;
        public static final int BusyMonitor = 11;
        public static final int EWEnable = 9;
        public static final int EWDisable = 13;
    }
}

