/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.familybasic.datarecorder;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import nintaco.CPU;
import nintaco.Machine;
import nintaco.input.DeviceMapper;
import nintaco.input.familybasic.datarecorder.BitList;
import nintaco.util.BitUtil;

public class DataRecorderMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final BitList bitList = new BitList();
    private volatile CPU cpu;
    private int recorderMode = 0;
    private long counter;
    private boolean enabled;
    private int readIndex;
    private int samplingPeriod;

    @Override
    public void setMachine(Machine machine) {
        if (machine == null) {
            this.cpu = null;
            this.recorderMode = 0;
        } else {
            this.cpu = machine.getCPU();
        }
    }

    @Override
    public int getInputDevice() {
        return 11;
    }

    @Override
    public void update(int buttons) {
    }

    public int getDataRecorderMode() {
        return this.recorderMode;
    }

    public void setDataRecorderMode(int mode, int samplingPeriod) {
        this.samplingPeriod = samplingPeriod;
        if (mode != this.recorderMode) {
            if (mode == 1 || mode == 3) {
                bitList.clear();
            }
            this.readIndex = 0;
            this.counter = this.cpu.getCycleCounter();
            this.recorderMode = mode == 3 ? 0 : mode;
        }
    }

    @Override
    public void writePort(int value) {
        this.enabled = BitUtil.getBitBool(value, 2);
        if (this.enabled && this.recorderMode == 1) {
            int bit = value & 1;
            long cycleCounter = this.cpu.getCycleCounter();
            while (this.counter < cycleCounter) {
                this.counter += (long)this.samplingPeriod;
                bitList.add(bit);
            }
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (this.enabled && portIndex == 0 && this.recorderMode == 2 && this.readIndex < bitList.size()) {
            long cycleCounter = this.cpu.getCycleCounter();
            while (this.counter < cycleCounter) {
                this.counter += (long)this.samplingPeriod;
                if (++this.readIndex < bitList.size()) continue;
                return 0;
            }
            return bitList.get(this.readIndex) << 1;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        if (this.enabled && portIndex == 0 && this.recorderMode == 2 && !bitList.isEmpty()) {
            return bitList.get(this.readIndex) << 1;
        }
        return 0;
    }

    public void saveTape(File file) throws Throwable {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            bitList.save(out);
        }
    }

    public void loadTape(File file) throws Throwable {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
            bitList.load(in);
        }
    }
}

