/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.konamihypershot;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;
import nintaco.input.Inputs;
import nintaco.input.gamepad.Autofire;

public class KonamiHyperShotDescriptor
extends DeviceDescriptor {
    public static final int Run1 = 0;
    public static final int Jump1 = 1;
    public static final int AutofireRun1 = 2;
    public static final int AutofireJump1 = 3;
    public static final int ToggleAutofire1 = 4;
    public static final int Run2 = 5;
    public static final int Jump2 = 6;
    public static final int AutofireRun2 = 7;
    public static final int AutofireJump2 = 8;
    public static final int ToggleAutofire2 = 9;
    public static final int RewindTime = 10;
    private static final Component.Identifier.Key[] DEFAULTS = new Component.Identifier.Key[]{Component.Identifier.Key.X, Component.Identifier.Key.Z, Component.Identifier.Key.S, Component.Identifier.Key.A, Component.Identifier.Key.Q, Component.Identifier.Key.V, Component.Identifier.Key.C, Component.Identifier.Key.F, Component.Identifier.Key.D, Component.Identifier.Key.E, Component.Identifier.Key.EQUALS};
    private final Autofire[] autofires = new Autofire[]{new Autofire(2), new Autofire(2)};

    public KonamiHyperShotDescriptor() {
        super(19);
    }

    @Override
    public void handleSettingsChange(Inputs inputs) {
        super.handleSettingsChange(inputs);
        this.autofires[0].setRate(inputs.getAutofireRate() - 1);
        this.autofires[1].setRate(inputs.getAutofireRate() - 1);
    }

    @Override
    public String getDeviceName() {
        return "Konami Hyper Shot";
    }

    @Override
    public int getButtonCount() {
        return 11;
    }

    @Override
    public int getRewindTimeButton() {
        return 10;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Run 1";
            }
            case 1: {
                return "Jump 1";
            }
            case 2: {
                return "Autofire Run 1";
            }
            case 3: {
                return "Autofire Jump 1";
            }
            case 4: {
                return "Toggle Autofire 1";
            }
            case 5: {
                return "Run 2";
            }
            case 6: {
                return "Jump 2";
            }
            case 7: {
                return "Autofire Run 2";
            }
            case 8: {
                return "Autofire Jump 2";
            }
            case 9: {
                return "Toggle Autofire 2";
            }
            case 10: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultKeyboard(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        this.autofires[0].setToggle(pressedValues[4] != 0);
        this.autofires[0].buttonStates[0].update(pressedValues[2] != 0, pressedValues[0] != 0);
        this.autofires[0].buttonStates[1].update(pressedValues[3] != 0, pressedValues[1] != 0);
        this.autofires[1].setToggle(pressedValues[9] != 0);
        this.autofires[1].buttonStates[0].update(pressedValues[7] != 0, pressedValues[5] != 0);
        this.autofires[1].buttonStates[1].update(pressedValues[8] != 0, pressedValues[6] != 0);
        this.updateRewindTime(pressedValues[10] != 0, portIndex);
        int buttons = 0;
        if (this.autofires[1].buttonStates[1].asserted || !this.autofires[0].enabled && pressedValues[6] != 0) {
            buttons |= 8;
        }
        if (this.autofires[1].buttonStates[0].asserted || !this.autofires[0].enabled && pressedValues[5] != 0) {
            buttons |= 4;
        }
        if (this.autofires[0].buttonStates[1].asserted || !this.autofires[0].enabled && pressedValues[1] != 0) {
            buttons |= 2;
        }
        if (this.autofires[0].buttonStates[0].asserted || !this.autofires[0].enabled && pressedValues[0] != 0) {
            buttons |= 1;
        }
        return bits | buttons << 16;
    }
}

