/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.snesmouse;

import net.java.games.input.Component;
import nintaco.input.ButtonMapping;
import nintaco.input.DeviceDescriptor;
import nintaco.input.InputUtil;

public class SnesMouseDescriptor
extends DeviceDescriptor {
    public static final int LeftButton = 0;
    public static final int RightButton = 1;
    public static final int RewindTime = 2;
    private static final Component.Identifier.Button[] DEFAULTS = new Component.Identifier.Button[]{Component.Identifier.Button.LEFT, Component.Identifier.Button.RIGHT, Component.Identifier.Button.MIDDLE};

    public SnesMouseDescriptor() {
        super(29);
    }

    @Override
    public String getDeviceName() {
        return "SNES Mouse";
    }

    @Override
    public int getButtonCount() {
        return 3;
    }

    @Override
    public int getRewindTimeButton() {
        return 2;
    }

    @Override
    public String getButtonName(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Right";
            }
            case 2: {
                return "Rewind Time";
            }
        }
        return "Unknown";
    }

    @Override
    public ButtonMapping getDefaultButtonMapping(int buttonIndex) {
        return this.getDefaultButtonMapping(InputUtil.getDefaultMouse(), buttonIndex, (Component.Identifier[])DEFAULTS);
    }

    @Override
    public int setButtonBits(int bits, int consoleType, int portIndex, int[] pressedValues) {
        boolean rewindTime = pressedValues[2] != 0;
        this.updateRewindTime(rewindTime, portIndex);
        int buttons = 0;
        if (pressedValues[0] != 0) {
            buttons |= 0x40;
        }
        if (pressedValues[1] != 0) {
            buttons |= 0x80;
        }
        return bits | ((int)InputUtil.getMouseDeltaY() & 0xFF) << 24 | ((int)InputUtil.getMouseDeltaX() & 0xFF) << 16 | (portIndex == 0 ? buttons : buttons << 8);
    }
}

