/*
 * Decompiled with CFR 0.152.
 */
package nintaco.input.uforce;

import java.io.Serializable;
import nintaco.input.DeviceMapper;
import nintaco.input.icons.InputIcons;
import nintaco.util.BitUtil;
import nintaco.util.MathUtil;

public class UForceMapper
extends DeviceMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int RELEASED = 0;
    private static final int PRESSED = 30;
    private int shiftRegister;
    private int buttons;
    private int byteIndex;
    private boolean strobe;
    private int topSensor;
    private boolean topSensorPressed;
    private int bottomSensor;
    private boolean bottomSensorPressed;
    private boolean enabled1;
    private boolean enabled3A;

    @Override
    public int getInputDevice() {
        return 35;
    }

    @Override
    public void writePort(int value) {
        boolean bl = this.strobe = (value & 1) == 1;
        if (this.strobe) {
            switch (this.byteIndex) {
                case 0: {
                    this.shiftRegister = this.buttons >> 9 & 3;
                    break;
                }
                case 1: {
                    if (this.enabled1) {
                        this.setShiftRegisterFromButtons(6);
                        break;
                    }
                    this.setShiftRegister(this.bottomSensor);
                    break;
                }
                case 2: {
                    this.setShiftRegisterFromButtons(7);
                    break;
                }
                case 3: {
                    if (this.enabled3A) {
                        this.setShiftRegisterFromButtons(4);
                        break;
                    }
                    this.setShiftRegister(this.bottomSensor);
                    break;
                }
                case 4: {
                    this.setShiftRegisterFromButtons(5);
                    break;
                }
                case 5: {
                    this.setShiftRegisterFromButtons(3);
                    break;
                }
                case 6: {
                    this.setShiftRegisterFromButtons(1);
                    break;
                }
                case 7: {
                    this.setShiftRegisterFromButtons(2);
                    break;
                }
                case 8: {
                    this.setShiftRegister(this.topSensor);
                }
            }
            if (++this.byteIndex > 8) {
                this.byteIndex = 0;
            }
        }
    }

    private void setShiftRegisterFromButtons(int bit) {
        this.setShiftRegister(BitUtil.getBitBool(this.buttons, bit) ? 30 : 0);
    }

    private void setShiftRegister(int value) {
        this.shiftRegister = value == 0 ? 2 : 0;
        this.shiftRegister |= (value ^= 0x1F) << 3 | (value & 1) << 2;
    }

    @Override
    public void update(int buttons) {
        this.buttons = buttons;
        if (BitUtil.getBitBool(buttons, 0)) {
            this.topSensorPressed = true;
            this.topSensor = 30;
        } else if (this.topSensorPressed) {
            this.topSensorPressed = false;
            this.topSensor = 0;
        } else {
            this.topSensor = MathUtil.clamp(this.topSensor + (byte)(buttons >> 16), 0, 30);
        }
        if (BitUtil.getBitBool(buttons, 8)) {
            this.bottomSensorPressed = true;
            this.enabled3A = false;
            this.bottomSensor = 30;
        } else if (this.bottomSensorPressed) {
            this.bottomSensorPressed = false;
            this.enabled3A = false;
            this.bottomSensor = 0;
        } else {
            byte deltaY = (byte)(buttons >> 24);
            this.bottomSensor = MathUtil.clamp(this.bottomSensor - deltaY, 0, 30);
            if (deltaY != 0) {
                this.enabled1 = false;
                this.enabled3A = false;
            }
        }
        if (BitUtil.getBitBool(buttons, 4)) {
            this.enabled3A = true;
            this.bottomSensor = 0;
        }
        if (BitUtil.getBitBool(buttons, 6)) {
            this.enabled1 = true;
        }
    }

    @Override
    public int readPort(int portIndex) {
        if (portIndex == 0) {
            int value = BitUtil.getBit(this.shiftRegister, 7);
            if (!this.strobe) {
                this.shiftRegister <<= 1;
            }
            return value;
        }
        return 0;
    }

    @Override
    public int peekPort(int portIndex) {
        return portIndex == 0 ? this.shiftRegister & 1 : 0;
    }

    @Override
    public void render(int[] screen) {
        int x = 8;
        int y = 170;
        InputIcons.UForce.render(screen, 8, 170);
        if (BitUtil.getBitBool(this.buttons, 9)) {
            InputIcons.FamilyBasicKeyboardKey.render(screen, 15, 220);
        }
        if (BitUtil.getBitBool(this.buttons, 10)) {
            InputIcons.FamilyBasicKeyboardKey.render(screen, 12, 218);
        }
        if (this.topSensor != 0) {
            InputIcons.GamepadAB.render(screen, 18, 172);
        }
        if (BitUtil.getBitBool(this.buttons, 1)) {
            InputIcons.GamepadAB.render(screen, 14, 179);
        }
        if (BitUtil.getBitBool(this.buttons, 2)) {
            InputIcons.GamepadAB.render(screen, 22, 179);
        }
        if (BitUtil.getBitBool(this.buttons, 3)) {
            InputIcons.GamepadAB.render(screen, 14, 188);
        }
        if (this.enabled3A ? BitUtil.getBitBool(this.buttons, 4) : this.bottomSensor != 0) {
            InputIcons.GamepadAB.render(screen, 22, 188);
        }
        if (BitUtil.getBitBool(this.buttons, 5)) {
            InputIcons.GamepadAB.render(screen, 14, 202);
        }
        if (this.enabled1 ? BitUtil.getBitBool(this.buttons, 6) : this.bottomSensor != 0) {
            InputIcons.GamepadAB.render(screen, 14, 211);
        }
        if (BitUtil.getBitBool(this.buttons, 7)) {
            InputIcons.GamepadAB.render(screen, 22, 211);
        }
        if (this.bottomSensor != 0) {
            InputIcons.GamepadAB.render(screen, 18, 218);
        }
    }
}

