/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.ave;

import nintaco.files.NesFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class Maxi15
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean nina03;
    private int outer;
    private int inner;

    public Maxi15(NesFile nesFile) {
        super(nesFile, 2, 1);
    }

    @Override
    public void init() {
        this.writeOuterBankControl(0);
        this.writeInnerBankControl(0);
    }

    @Override
    public int readMemory(int address) {
        int value;
        if (address < 32768) {
            value = this.memory[address];
        } else {
            value = this.prgROM[(this.prgBanks[1] | address & Short.MAX_VALUE) & this.prgRomSizeMask];
            switch (address & 0xFFF8) {
                case 65408: 
                case 65416: 
                case 65424: 
                case 65432: {
                    this.writeOuterBankControl(value);
                    break;
                }
                case 65512: 
                case 65520: {
                    this.writeInnerBankControl(value);
                }
            }
        }
        return value;
    }

    private void writeOuterBankControl(int value) {
        if (this.outer == 0) {
            this.outer = value;
            this.setNametableMirroring(BitUtil.getBit(value, 7));
            this.nina03 = BitUtil.getBitBool(value, 6);
            this.updateBanks();
        }
    }

    private void writeInnerBankControl(int value) {
        this.inner = value;
        this.updateBanks();
    }

    private void updateBanks() {
        if (this.nina03) {
            this.setPrgBank(this.outer & 0xE | this.inner & 1);
            this.setChrBank((this.outer & 0xE) << 2 | (this.inner & 0x70) >> 4);
        } else {
            this.setPrgBank(this.outer & 0xF);
            this.setChrBank((this.outer & 0xF) << 2 | (this.inner & 0x30) >> 4);
        }
    }
}

