/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.fukutakeshoten;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class StudyBox
extends Mapper {
    private static final long serialVersionUID = 0L;
    private int xramBank;
    private int tapeReady;
    private int tapeReadyDelay;
    private int reg4202;

    public StudyBox(CartFile cartFile) {
        super(cartFile, 4, 1);
        this.xram = new int[32768];
    }

    @Override
    public void init() {
        this.xramBank = 0;
        this.setPrgBank(2, 0);
        this.setPrgBank(3, 0);
        this.setChrBank(0);
    }

    @Override
    public int readMemory(int address) {
        if ((address & 0xE000) == 24576) {
            return this.xram[this.xramBank | address & 0x1FFF];
        }
        if ((address & 0xFE00) == 16896) {
            switch (address) {
                case 16896: 
                case 16899: {
                    return 0;
                }
                case 16897: {
                    return 16;
                }
                case 16898: {
                    return this.tapeReady;
                }
            }
            return 255;
        }
        return super.readMemory(address);
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        if ((address & 0xE000) == 24576) {
            this.xram[this.xramBank | address & 0x1FFF] = value;
        } else if ((address & 0xFE00) == 16896) {
            switch (address & 3) {
                case 0: {
                    this.xramBank = (value & 0xC0) << 7;
                    break;
                }
                case 1: {
                    this.setPrgBank(2, value);
                    break;
                }
                case 2: {
                    this.reg4202 = value;
                    this.tapeReadyDelay = 100;
                }
            }
        }
    }

    @Override
    public void update() {
        if (this.tapeReadyDelay > 0 && --this.tapeReadyDelay == 0) {
            this.tapeReady = (this.reg4202 & 0x10) << 2;
        }
    }
}

