/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.homebrew;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.preferences.GamePrefs;
import nintaco.util.BitUtil;

public class COOLGIRL
extends Mapper {
    private static final int save_flash_size = 0x400000;
    private static final int save_flash_mask = 0x3FFFFF;
    private boolean REG_WRAM_enabled;
    private int REG_WRAM_page;
    private boolean REG_can_write_CHR_RAM;
    private boolean REG_map_ROM_on_6000;
    private int REG_flags;
    private int REG_mapper;
    private boolean REG_can_write_PRG;
    private int REG_mirroring;
    private boolean REG_four_screen;
    private boolean REG_lockout;
    private int REG_PRG_base;
    private int REG_PRG_mask;
    private int REG_PRG_mode;
    private int REG_PRG_bank_6000;
    private int REG_PRG_bank_A;
    private int REG_PRG_bank_B;
    private int REG_PRG_bank_C;
    private int REG_PRG_bank_D;
    private int REG_CHR_mask;
    private int REG_CHR_mode;
    private int REG_CHR_bank_A;
    private int REG_CHR_bank_B;
    private int REG_CHR_bank_C;
    private int REG_CHR_bank_D;
    private int REG_CHR_bank_E;
    private int REG_CHR_bank_F;
    private int REG_CHR_bank_G;
    private int REG_CHR_bank_H;
    private boolean REG_scanline_IRQ_enabled;
    private int REG_scanline_IRQ_counter;
    private int REG_scanline_IRQ_latch;
    private boolean REG_scanline_IRQ_reload;
    private boolean REG_scanline2_IRQ_enabled;
    private int REG_scanline2_IRQ_line;
    private boolean REG_scanline2_IRQ_pending;
    private int REG_CPU_IRQ_value;
    private int REG_CPU_IRQ_control;
    private int REG_CPU_IRQ_latch;
    private int REG_VRC4_IRQ_prescaler;
    private int REG_VRC4_IRQ_prescaler_counter;
    private int REG_R0;
    private int REG_R1;
    private int REG_R2;
    private int REG_R3;
    private int REG_R4;
    private int REG_R5;
    private int flash_state;
    private final int[] flash_buffer_a = new int[10];
    private final int[] flash_buffer_v = new int[10];
    private final boolean[] flashBanks = new boolean[8];
    private boolean ppu_latch0;
    private boolean ppu_latch1;
    private int ppu_mapper163_latch;
    private final int[] TKSMIR = new int[8];
    private int REG_PRG_bank_6000_mapped;
    private int REG_PRG_bank_A_mapped;
    private int REG_PRG_bank_B_mapped;
    private int REG_PRG_bank_C_mapped;
    private int REG_PRG_bank_D_mapped;
    private int LastPPUScanline;
    private boolean LastPPUIsRendering;
    private transient int[] SAVE_FLASH;

    public COOLGIRL(CartFile cartFile) {
        super(cartFile, 8, 8);
        this.xram = new int[32768];
        this.loadFlash();
    }

    @Override
    public void init() {
        this.REG_WRAM_enabled = false;
        this.REG_WRAM_page = 0;
        this.REG_can_write_CHR_RAM = false;
        this.REG_map_ROM_on_6000 = false;
        this.REG_flags = 0;
        this.REG_mapper = 0;
        this.REG_can_write_PRG = false;
        this.REG_mirroring = 0;
        this.REG_four_screen = false;
        this.REG_lockout = false;
        this.REG_PRG_base = 0;
        this.REG_PRG_mask = 248;
        this.REG_PRG_mode = 0;
        this.REG_PRG_bank_6000 = 0;
        this.REG_PRG_bank_A = 0;
        this.REG_PRG_bank_B = 1;
        this.REG_PRG_bank_C = 254;
        this.REG_PRG_bank_D = 255;
        this.REG_CHR_mask = 0;
        this.REG_CHR_mode = 0;
        this.REG_CHR_bank_A = 0;
        this.REG_CHR_bank_B = 1;
        this.REG_CHR_bank_C = 2;
        this.REG_CHR_bank_D = 3;
        this.REG_CHR_bank_E = 4;
        this.REG_CHR_bank_F = 5;
        this.REG_CHR_bank_G = 6;
        this.REG_CHR_bank_H = 7;
        this.REG_scanline_IRQ_enabled = false;
        this.REG_scanline_IRQ_counter = 0;
        this.REG_scanline_IRQ_latch = 0;
        this.REG_scanline_IRQ_reload = false;
        this.REG_scanline2_IRQ_enabled = false;
        this.REG_scanline2_IRQ_line = 0;
        this.REG_CPU_IRQ_value = 0;
        this.REG_CPU_IRQ_control = 0;
        this.REG_CPU_IRQ_latch = 0;
        this.REG_VRC4_IRQ_prescaler = 0;
        this.REG_VRC4_IRQ_prescaler_counter = 0;
        this.REG_R0 = 0;
        this.REG_R1 = 0;
        this.REG_R2 = 0;
        this.REG_R3 = 0;
        this.REG_R4 = 0;
        this.REG_R5 = 0;
        this.updateState();
    }

    @Override
    public void resetting() {
        this.init();
    }

    private void updatePrgBanks() {
        this.REG_PRG_bank_6000_mapped = this.REG_PRG_base << 1 | this.REG_PRG_bank_6000 & ((~this.REG_PRG_mask & 0x7F) << 1 | 1);
        this.REG_PRG_bank_A_mapped = this.REG_PRG_base << 1 | this.REG_PRG_bank_A & ((~this.REG_PRG_mask & 0x7F) << 1 | 1);
        this.REG_PRG_bank_B_mapped = this.REG_PRG_base << 1 | this.REG_PRG_bank_B & ((~this.REG_PRG_mask & 0x7F) << 1 | 1);
        this.REG_PRG_bank_C_mapped = this.REG_PRG_base << 1 | this.REG_PRG_bank_C & ((~this.REG_PRG_mask & 0x7F) << 1 | 1);
        this.REG_PRG_bank_D_mapped = this.REG_PRG_base << 1 | this.REG_PRG_bank_D & ((~this.REG_PRG_mask & 0x7F) << 1 | 1);
        boolean REG_A_CHIP = this.REG_PRG_bank_A_mapped >= 130560;
        boolean REG_B_CHIP = this.REG_PRG_bank_B_mapped >= 130560;
        boolean REG_C_CHIP = this.REG_PRG_bank_C_mapped >= 130560;
        boolean REG_D_CHIP = this.REG_PRG_bank_D_mapped >= 130560;
        switch (this.REG_PRG_mode & 7) {
            default: {
                this.set2PrgBanks(4, this.REG_PRG_bank_A_mapped & 0xFFFFFFFE, REG_A_CHIP);
                this.set2PrgBanks(6, this.REG_PRG_bank_C_mapped & 0xFFFFFFFE, REG_C_CHIP);
                break;
            }
            case 1: {
                this.set2PrgBanks(4, this.REG_PRG_bank_C_mapped & 0xFFFFFFFE, REG_C_CHIP);
                this.set2PrgBanks(6, this.REG_PRG_bank_A_mapped & 0xFFFFFFFE, REG_A_CHIP);
                break;
            }
            case 4: {
                this.setPrgBank(4, this.REG_PRG_bank_A_mapped, REG_A_CHIP);
                this.setPrgBank(5, this.REG_PRG_bank_B_mapped, REG_B_CHIP);
                this.setPrgBank(6, this.REG_PRG_bank_C_mapped, REG_C_CHIP);
                this.setPrgBank(7, this.REG_PRG_bank_D_mapped, REG_D_CHIP);
                break;
            }
            case 5: {
                this.setPrgBank(4, this.REG_PRG_bank_C_mapped, REG_C_CHIP);
                this.setPrgBank(5, this.REG_PRG_bank_B_mapped, REG_B_CHIP);
                this.setPrgBank(6, this.REG_PRG_bank_A_mapped, REG_A_CHIP);
                this.setPrgBank(7, this.REG_PRG_bank_D_mapped, REG_D_CHIP);
                break;
            }
            case 6: {
                this.set4PrgBanks(4, this.REG_PRG_bank_B_mapped & 0xFFFFFFFC, REG_A_CHIP);
                break;
            }
            case 7: {
                this.set4PrgBanks(4, this.REG_PRG_bank_A_mapped & 0xFFFFFFFC, REG_A_CHIP);
            }
        }
        if (this.REG_map_ROM_on_6000) {
            this.setPrgBank(3, this.REG_PRG_bank_6000_mapped);
        } else if (this.REG_WRAM_enabled) {
            this.setPrgBank(3, this.REG_WRAM_page);
        } else {
            this.setPrgBank(3, -5);
        }
    }

    private void setPrgBank(int bank, int value, boolean flashBank) {
        this.setPrgBank(bank, value);
        this.flashBanks[bank] = flashBank;
    }

    private void set2PrgBanks(int firstBank, int firstValue, boolean flashBank) {
        this.setPrgBank(firstBank, firstValue, flashBank);
        this.setPrgBank(firstBank + 1, firstValue + 1, flashBank);
    }

    private void set4PrgBanks(int firstBank, int firstValue, boolean flashBank) {
        this.setPrgBank(firstBank, firstValue, flashBank);
        this.setPrgBank(firstBank + 1, firstValue + 1, flashBank);
        this.setPrgBank(firstBank + 2, firstValue + 2, flashBank);
        this.setPrgBank(firstBank + 3, firstValue + 3, flashBank);
    }

    @Override
    protected void setChrBank(int bank, int value) {
        super.setChrBank(bank, value & ((~this.REG_CHR_mask & 0x1F) + 1 << 3) - 1);
    }

    private void updateChrBanks() {
        switch (this.REG_CHR_mode & 7) {
            default: {
                this.set8ChrBanks(0, this.REG_CHR_bank_A & 0xFFFFFFFC);
                break;
            }
            case 1: {
                this.set4ChrBanks(0, this.ppu_mapper163_latch & 0xFFFFFFFD);
                this.set4ChrBanks(4, this.ppu_mapper163_latch & 0xFFFFFFFD);
                break;
            }
            case 2: {
                this.set2ChrBanks(0, this.REG_CHR_bank_A & 0xFFFFFFFE);
                this.TKSMIR[0] = this.TKSMIR[1] = this.REG_CHR_bank_A;
                this.set2ChrBanks(2, this.REG_CHR_bank_C & 0xFFFFFFFE);
                this.TKSMIR[2] = this.TKSMIR[3] = this.REG_CHR_bank_C;
                this.setChrBank(4, this.REG_CHR_bank_E);
                this.TKSMIR[4] = this.REG_CHR_bank_E;
                this.setChrBank(5, this.REG_CHR_bank_F);
                this.TKSMIR[5] = this.REG_CHR_bank_F;
                this.setChrBank(6, this.REG_CHR_bank_G);
                this.TKSMIR[6] = this.REG_CHR_bank_G;
                this.setChrBank(7, this.REG_CHR_bank_H);
                this.TKSMIR[7] = this.REG_CHR_bank_H;
                break;
            }
            case 3: {
                this.setChrBank(0, this.REG_CHR_bank_E);
                this.TKSMIR[0] = this.REG_CHR_bank_E;
                this.setChrBank(1, this.REG_CHR_bank_F);
                this.TKSMIR[1] = this.REG_CHR_bank_F;
                this.setChrBank(2, this.REG_CHR_bank_G);
                this.TKSMIR[2] = this.REG_CHR_bank_G;
                this.setChrBank(3, this.REG_CHR_bank_H);
                this.TKSMIR[3] = this.REG_CHR_bank_H;
                this.set2ChrBanks(4, this.REG_CHR_bank_A & 0xFFFFFFFE);
                this.TKSMIR[4] = this.TKSMIR[5] = this.REG_CHR_bank_A;
                this.set2ChrBanks(6, this.REG_CHR_bank_C & 0xFFFFFFFE);
                this.TKSMIR[6] = this.TKSMIR[7] = this.REG_CHR_bank_C;
                break;
            }
            case 4: {
                this.set4ChrBanks(0, this.REG_CHR_bank_A & 0xFFFFFFFD);
                this.set4ChrBanks(4, this.REG_CHR_bank_E & 0xFFFFFFFD);
                break;
            }
            case 5: {
                this.set4ChrBanks(0, (this.ppu_latch0 ? this.REG_CHR_bank_B : this.REG_CHR_bank_A) & 0xFFFFFFFD);
                this.set4ChrBanks(4, (this.ppu_latch1 ? this.REG_CHR_bank_F : this.REG_CHR_bank_E) & 0xFFFFFFFD);
                break;
            }
            case 6: {
                this.set2ChrBanks(0, this.REG_CHR_bank_A & 0xFFFFFFFE);
                this.set2ChrBanks(2, this.REG_CHR_bank_C & 0xFFFFFFFE);
                this.set2ChrBanks(4, this.REG_CHR_bank_E & 0xFFFFFFFE);
                this.set2ChrBanks(6, this.REG_CHR_bank_G & 0xFFFFFFFE);
                break;
            }
            case 7: {
                this.setChrBank(0, this.REG_CHR_bank_A);
                this.setChrBank(1, this.REG_CHR_bank_B);
                this.setChrBank(2, this.REG_CHR_bank_C);
                this.setChrBank(3, this.REG_CHR_bank_D);
                this.setChrBank(4, this.REG_CHR_bank_E);
                this.setChrBank(5, this.REG_CHR_bank_F);
                this.setChrBank(6, this.REG_CHR_bank_G);
                this.setChrBank(7, this.REG_CHR_bank_H);
            }
        }
    }

    private void updateMirroring() {
        if (this.REG_four_screen) {
            this.setNametableMirroring(4);
        } else if (this.REG_mapper != 20 || !BitUtil.getBitBool(this.REG_flags, 0)) {
            this.setNametableMirroring(this.REG_mirroring);
        }
    }

    private void updateState() {
        this.updatePrgBanks();
        this.updateChrBanks();
        this.updateMirroring();
    }

    @Override
    public int readMemory(int address) {
        switch (address & 0xF000) {
            case 20480: {
                return this.read5(address);
            }
            case 24576: 
            case 28672: {
                return this.read67(address);
            }
            case 32768: 
            case 36864: 
            case 40960: 
            case 45056: 
            case 49152: 
            case 53248: 
            case 57344: 
            case 61440: {
                return this.read8_F(address);
            }
        }
        return this.memory[address];
    }

    private int read5(int address) {
        switch (this.REG_mapper) {
            case 0: {
                return 0;
            }
            case 6: {
                if ((address & 0x700) == 256) {
                    return this.REG_R2 | this.REG_R0 | this.REG_R1 | ~this.REG_R3;
                }
                if ((address & 0x700) != 1280) break;
                return (this.REG_R5 & 1) != 0 ? this.REG_R2 : this.REG_R1;
            }
            case 15: {
                if (address != 20996) break;
                int result = (this.REG_scanline2_IRQ_pending ? 128 : 0) | (!this.LastPPUIsRendering || this.LastPPUScanline + 1 >= 241 ? 0 : 64);
                this.cpu.setMapperIrq(false);
                this.REG_scanline2_IRQ_pending = false;
                return result;
            }
        }
        return 255;
    }

    private void write5(int address, int value) {
        if (!this.REG_lockout) {
            switch (address & 7) {
                case 0: {
                    this.REG_PRG_base = this.REG_PRG_base & 0xFF | value << 8;
                    break;
                }
                case 1: {
                    this.REG_PRG_base = this.REG_PRG_base & 0xFF00 | value;
                    break;
                }
                case 2: {
                    this.REG_PRG_mask = value & 0xFF;
                    break;
                }
                case 3: {
                    this.REG_PRG_mode = (value & 0xE0) >> 5;
                    this.REG_CHR_bank_A = this.REG_CHR_bank_A & 7 | value << 3;
                    break;
                }
                case 4: {
                    this.REG_CHR_mode = (value & 0xE0) >> 5;
                    this.REG_CHR_mask = value & 0x1F;
                    break;
                }
                case 5: {
                    this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC1 | (value & 0x7C) >> 1;
                    this.REG_WRAM_page = value & 3;
                    break;
                }
                case 6: {
                    this.REG_flags = (value & 0xE0) >> 5;
                    this.REG_mapper = value & 0x1F;
                    break;
                }
                case 7: {
                    this.REG_lockout = BitUtil.getBitBool(value, 7);
                    this.REG_four_screen = BitUtil.getBitBool(value, 5);
                    this.REG_mirroring = (value & 0x18) >> 3;
                    this.REG_can_write_PRG = BitUtil.getBitBool(value, 2);
                    this.REG_can_write_CHR_RAM = BitUtil.getBitBool(value, 1);
                    this.REG_WRAM_enabled = BitUtil.getBitBool(value, 0);
                }
            }
            if (this.REG_mapper == 17) {
                this.REG_PRG_bank_B = 253;
            } else if (this.REG_mapper == 14) {
                this.REG_PRG_bank_B = 1;
            }
        }
        switch (this.REG_mapper) {
            case 6: {
                if (address == 20737) {
                    if (this.REG_R4 != 0 && value == 0) {
                        this.REG_R5 ^= 1;
                    }
                    this.REG_R4 = value;
                    break;
                }
                if (address == 20736 && value == 6) {
                    this.REG_PRG_mode &= 0xFE;
                    this.REG_PRG_bank_B = 12;
                    break;
                }
                switch (address >> 8 & 3) {
                    case 2: {
                        this.REG_PRG_mode |= 1;
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0x3F | (value & 3) << 6;
                        this.REG_R0 = value;
                        break;
                    }
                    case 0: {
                        this.REG_PRG_mode |= 1;
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC3 | (value & 0xF) << 2;
                        this.REG_CHR_mode = this.REG_CHR_mode & 0xFE | value >> 7;
                        this.REG_R1 = value;
                        break;
                    }
                    case 3: {
                        this.REG_R2 = value;
                        break;
                    }
                    case 1: {
                        this.REG_R3 = value;
                    }
                }
                break;
            }
            case 15: {
                switch (address) {
                    case 20741: {
                        if (value == 255) {
                            this.REG_four_screen = true;
                            break;
                        }
                        this.REG_four_screen = false;
                        switch (value >> 2 & 1 | value >> 3 & 2) {
                            case 0: {
                                this.REG_mirroring = 2;
                                break;
                            }
                            case 1: {
                                this.REG_mirroring = 0;
                                break;
                            }
                            case 2: {
                                this.REG_mirroring = 1;
                                break;
                            }
                            case 3: {
                                this.REG_mirroring = 3;
                            }
                        }
                        break;
                    }
                    case 20757: {
                        this.REG_PRG_bank_A = value & 0xFFFFFFFE;
                        this.REG_PRG_bank_B = value | 1;
                        break;
                    }
                    case 20758: {
                        this.REG_PRG_bank_C = value;
                        break;
                    }
                    case 20759: {
                        this.REG_PRG_bank_D = value;
                        break;
                    }
                    case 20768: {
                        this.REG_CHR_bank_A = value;
                        break;
                    }
                    case 20769: {
                        this.REG_CHR_bank_B = value;
                        break;
                    }
                    case 20770: {
                        this.REG_CHR_bank_C = value;
                        break;
                    }
                    case 20771: {
                        this.REG_CHR_bank_D = value;
                        break;
                    }
                    case 20776: {
                        this.REG_CHR_bank_E = value;
                        break;
                    }
                    case 20777: {
                        this.REG_CHR_bank_F = value;
                        break;
                    }
                    case 20778: {
                        this.REG_CHR_bank_G = value;
                        break;
                    }
                    case 20779: {
                        this.REG_CHR_bank_H = value;
                        break;
                    }
                    case 20995: {
                        this.cpu.setMapperIrq(false);
                        this.REG_scanline2_IRQ_pending = false;
                        this.REG_scanline2_IRQ_line = value;
                        break;
                    }
                    case 20996: {
                        this.cpu.setMapperIrq(false);
                        this.REG_scanline2_IRQ_pending = false;
                        this.REG_scanline2_IRQ_enabled = BitUtil.getBitBool(value, 7);
                    }
                }
                break;
            }
            case 20: {
                if ((this.REG_flags & 2) == 0) break;
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC3 | (value & 0xF) << 2 | (value & 0xF0) >> 2;
            }
        }
        this.updateState();
    }

    private int read67(int address) {
        if (this.REG_map_ROM_on_6000) {
            return this.prgROM[(this.prgBanks[3] | address & this.prgAddressMask) & this.prgRomSizeMask];
        }
        if (this.REG_WRAM_enabled) {
            return this.xram[(this.prgBanks[3] | address & 0x1FFF) & Short.MAX_VALUE];
        }
        return 255;
    }

    private int read8_F(int address) {
        int bank = address >> this.prgShift;
        if (this.flashBanks[bank]) {
            return this.SAVE_FLASH[(this.prgBanks[bank] | address & this.prgAddressMask) & 0x3FFFFF];
        }
        return this.prgROM[(this.prgBanks[bank] | address & this.prgAddressMask) & this.prgRomSizeMask];
    }

    private void write67(int address, int value) {
        if (this.REG_mapper == 12) {
            this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0xE7 | (value & 1) << 4 | (value & 2) << 2;
        } else if (this.REG_mapper == 20 && (this.REG_flags & 2) != 0) {
            this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC3 | (value & 0xF) << 2 | (value & 0xF0) >> 2;
        }
        if (!this.REG_map_ROM_on_6000 && this.REG_WRAM_enabled) {
            this.xram[(this.prgBanks[3] | address & 0x1FFF) & Short.MAX_VALUE] = value;
        }
    }

    private void writeFlash(int address, int value) {
        if (this.flash_state < 10) {
            int sector_address;
            this.flash_buffer_a[this.flash_state] = address & 0xFFF;
            this.flash_buffer_v[this.flash_state] = value;
            ++this.flash_state;
            this.flash_state &= 0xFF;
            if (this.flash_state == 6 && this.flash_buffer_a[0] == 2730 && this.flash_buffer_v[0] == 170 && this.flash_buffer_a[1] == 1365 && this.flash_buffer_v[1] == 85 && this.flash_buffer_a[2] == 2730 && this.flash_buffer_v[2] == 128 && this.flash_buffer_a[3] == 2730 && this.flash_buffer_v[3] == 170 && this.flash_buffer_a[4] == 1365 && this.flash_buffer_v[4] == 85 && this.flash_buffer_v[5] == 48) {
                for (int i = sector_address = this.REG_PRG_bank_A_mapped << 13; i < sector_address + 131072; ++i) {
                    this.SAVE_FLASH[i & 0x3FFFFF] = 255;
                }
                this.flash_state = 0;
            }
            if (this.flash_state == 4 && this.flash_buffer_a[0] == 2730 && this.flash_buffer_v[0] == 170 && this.flash_buffer_a[1] == 1365 && this.flash_buffer_v[1] == 85 && this.flash_buffer_a[2] == 2730 && this.flash_buffer_v[2] == 160) {
                sector_address = this.REG_PRG_bank_A_mapped << 13;
                int flash_addr = sector_address + (address & Short.MAX_VALUE);
                this.SAVE_FLASH[flash_addr & 0x3FFFFF] = value;
                this.flash_state = 0;
            }
        }
        if (value == 240) {
            this.flash_state = 0;
        }
    }

    @Override
    public void writeRegister(int address, int value) {
        if (this.REG_can_write_PRG) {
            this.writeFlash(address, value);
        }
        block0 : switch (this.REG_mapper) {
            case 1: {
                if ((this.REG_flags & 1) == 0 || (address & 0xF000) != 36864) {
                    this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC1 | (value & 0x1F) << 1;
                    break;
                }
                this.REG_mirroring = 2 + (value >> 4 & 1);
                break;
            }
            case 2: {
                this.REG_CHR_bank_A = this.REG_CHR_bank_A & 7 | value << 3;
                break;
            }
            case 3: {
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF1 | (value & 7) << 1;
                this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0x87 | (value & 0xF0) >> 1;
                this.REG_mirroring = value >> 3 & 1 ^ 1;
                break;
            }
            case 4: {
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xE1 | (value & 0xF) << 1;
                this.REG_mirroring = value >> 6 ^ value >> 6 & 2;
                break;
            }
            case 5: {
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF1 | (value & 0x70) >> 3;
                this.REG_can_write_CHR_RAM = BitUtil.getBitBool(value, 0);
                break;
            }
            case 7: {
                switch (address >> 10 & 0x1C | address & 3) {
                    case 0: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 1: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 2: {
                        this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 3: {
                        this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 4: {
                        this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 5: {
                        this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 6: {
                        break block0;
                    }
                    case 7: {
                        break block0;
                    }
                    case 8: {
                        this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 9: {
                        this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 10: {
                        this.REG_CHR_bank_B = this.REG_CHR_bank_B & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 11: {
                        this.REG_CHR_bank_B = this.REG_CHR_bank_B & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 12: {
                        this.REG_CHR_bank_C = this.REG_CHR_bank_C & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 13: {
                        this.REG_CHR_bank_C = this.REG_CHR_bank_C & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 14: {
                        this.REG_CHR_bank_D = this.REG_CHR_bank_D & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 15: {
                        this.REG_CHR_bank_D = this.REG_CHR_bank_D & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 16: {
                        this.REG_CHR_bank_E = this.REG_CHR_bank_E & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 17: {
                        this.REG_CHR_bank_E = this.REG_CHR_bank_E & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 18: {
                        this.REG_CHR_bank_F = this.REG_CHR_bank_F & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 19: {
                        this.REG_CHR_bank_F = this.REG_CHR_bank_F & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 20: {
                        this.REG_CHR_bank_G = this.REG_CHR_bank_G & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 21: {
                        this.REG_CHR_bank_G = this.REG_CHR_bank_G & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 22: {
                        this.REG_CHR_bank_H = this.REG_CHR_bank_H & 0xF0 | value & 0xF;
                        break block0;
                    }
                    case 23: {
                        this.REG_CHR_bank_H = this.REG_CHR_bank_H & 0xF | (value & 0xF) << 4;
                        break block0;
                    }
                    case 24: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xFFF0 | value & 0xF;
                        break block0;
                    }
                    case 25: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xFF0F | (value & 0xF) << 4;
                        break block0;
                    }
                    case 26: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xF0FF | (value & 0xF) << 8;
                        break block0;
                    }
                    case 27: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xFFF | (value & 0xF) << 12;
                        break block0;
                    }
                    case 28: {
                        this.cpu.setMapperIrq(false);
                        this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_latch;
                        break block0;
                    }
                    case 29: {
                        this.cpu.setMapperIrq(false);
                        this.REG_CPU_IRQ_control = value & 0xF;
                        break block0;
                    }
                    case 30: {
                        this.REG_mirroring = value ^ (value >> 1 & 1 ^ 1);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC3 | (value & 0xF) << 2;
                if ((this.REG_flags & 1) != 0) break;
                this.REG_mirroring = 2 + (value >> 4 & 1);
                break;
            }
            case 9: {
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC3 | (address & 0x780) >> 5;
                this.REG_CHR_bank_A = this.REG_CHR_bank_A & 7 | (address & 7) << 5 | (value & 3) << 3;
                this.REG_mirroring = address >> 13 & 1;
                break;
            }
            case 10: {
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF3 | (value & 3) << 2;
                this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0x87 | (value & 0xF0) >> 1;
                break;
            }
            case 11: {
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF3 | (value & 0x30) >> 2;
                this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0xE7 | (value & 3) << 3;
                break;
            }
            case 13: {
                switch (address >> 12 & 7) {
                    case 0: {
                        switch (address & 3) {
                            case 0: {
                                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC0 | value & 0x3F;
                                break;
                            }
                            case 1: {
                                this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xC0 | value & 0x3F;
                                break;
                            }
                            case 2: {
                                this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xC0 | value & 0x3F;
                                break;
                            }
                            case 3: {
                                this.REG_PRG_bank_D = this.REG_PRG_bank_D & 0xC0 | value & 0x3F;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (address & 7) {
                            case 0: {
                                this.REG_CHR_bank_A = value;
                                break;
                            }
                            case 1: {
                                this.REG_CHR_bank_B = value;
                                break;
                            }
                            case 2: {
                                this.REG_CHR_bank_C = value;
                                break;
                            }
                            case 3: {
                                this.REG_CHR_bank_D = value;
                                break;
                            }
                            case 4: {
                                this.REG_CHR_bank_E = value;
                                break;
                            }
                            case 5: {
                                this.REG_CHR_bank_F = value;
                                break;
                            }
                            case 6: {
                                this.REG_CHR_bank_G = value;
                                break;
                            }
                            case 7: {
                                this.REG_CHR_bank_H = value;
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (address & 7) {
                            case 0: {
                                if ((value & 1) != 0) {
                                    this.REG_scanline_IRQ_enabled = true;
                                    break;
                                }
                                this.REG_scanline_IRQ_enabled = false;
                                this.cpu.setMapperIrq(false);
                                break;
                            }
                            case 2: {
                                this.REG_scanline_IRQ_enabled = false;
                                this.cpu.setMapperIrq(false);
                                break;
                            }
                            case 3: {
                                this.REG_scanline_IRQ_enabled = true;
                                break;
                            }
                            case 5: {
                                this.REG_scanline_IRQ_latch = value ^ this.REG_R0;
                                this.REG_scanline_IRQ_reload = true;
                                break;
                            }
                            case 6: {
                                this.REG_R0 = value;
                            }
                        }
                    }
                    case 5: {
                        if ((address & 3) != 1) break;
                        this.REG_mirroring = value & 3;
                    }
                }
                break;
            }
            case 14: {
                switch (address >> 9 & 0x38 | address & 7) {
                    case 0: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 9: {
                        this.REG_mirroring = value >> 7 & 1;
                        break;
                    }
                    case 11: {
                        this.REG_CPU_IRQ_control = this.REG_CPU_IRQ_control & 0xFE | value >> 7 & 1;
                        this.cpu.setMapperIrq(false);
                        break;
                    }
                    case 12: {
                        this.REG_CPU_IRQ_value = this.REG_R0 << 8 | this.REG_R1;
                        this.cpu.setMapperIrq(false);
                        break;
                    }
                    case 13: {
                        this.REG_R0 = value;
                        break;
                    }
                    case 14: {
                        this.REG_R1 = value;
                        break;
                    }
                    case 16: {
                        this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 24: {
                        this.REG_CHR_bank_A = value;
                        break;
                    }
                    case 25: {
                        this.REG_CHR_bank_B = value;
                        break;
                    }
                    case 26: {
                        this.REG_CHR_bank_C = value;
                        break;
                    }
                    case 27: {
                        this.REG_CHR_bank_D = value;
                        break;
                    }
                    case 28: {
                        this.REG_CHR_bank_E = value;
                        break;
                    }
                    case 29: {
                        this.REG_CHR_bank_F = value;
                        break;
                    }
                    case 30: {
                        this.REG_CHR_bank_G = value;
                        break;
                    }
                    case 31: {
                        this.REG_CHR_bank_H = value;
                        break;
                    }
                    case 32: {
                        this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xC0 | value & 0x3F;
                    }
                }
                break;
            }
            case 16: {
                if ((value & 0x80) != 0) {
                    this.REG_R0 = this.REG_R0 & 0xC0 | 0x20;
                    this.REG_PRG_mode = 0;
                    this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xE0 | 0x1E;
                    break;
                }
                this.REG_R0 = this.REG_R0 & 0xC0 | (value & 1) << 5 | (this.REG_R0 & 0x3E) >> 1;
                if ((this.REG_R0 & 1) == 0) break;
                switch (address >> 13 & 3) {
                    case 0: {
                        switch (this.REG_R0 & 0x18) {
                            case 24: {
                                this.REG_PRG_mode = 0;
                                this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xE0 | 0x1E;
                                break;
                            }
                            case 16: {
                                this.REG_PRG_mode = 1;
                                this.REG_PRG_bank_C &= 0xE0;
                                break;
                            }
                            default: {
                                this.REG_PRG_mode = 7;
                            }
                        }
                        this.REG_CHR_mode = (this.REG_R0 >> 5 & 1) != 0 ? 4 : 0;
                        this.REG_mirroring = this.REG_R0 >> 1 & 3 ^ 2;
                        break;
                    }
                    case 1: {
                        this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0x83 | (this.REG_R0 & 0x3E) << 1;
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xDF | this.REG_R0 & 0x20;
                        this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xDF | this.REG_R0 & 0x20;
                        break;
                    }
                    case 2: {
                        this.REG_CHR_bank_E = this.REG_CHR_bank_E & 0x83 | (this.REG_R0 & 0x3E) << 1;
                        break;
                    }
                    case 3: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xE1 | this.REG_R0 & 0x1E;
                        this.REG_WRAM_enabled = !BitUtil.getBitBool(this.REG_R0, 5);
                    }
                }
                this.REG_R0 = this.REG_R0 & 0xC0 | 0x20;
                if ((this.REG_flags & 1) == 0) break;
                if ((this.REG_CHR_mode & 4) != 0) {
                    this.REG_WRAM_page = 2 | this.REG_CHR_bank_A >> 6 ^ 1;
                    break;
                }
                this.REG_WRAM_page = 2 | this.REG_CHR_bank_A >> 5 ^ 1;
                break;
            }
            case 17: {
                switch (address >> 12 & 7) {
                    case 2: {
                        if ((this.REG_flags & 1) == 0) {
                            this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF0 | value & 0xF;
                            break;
                        }
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xE1 | (value & 0xF) << 1;
                        break;
                    }
                    case 3: {
                        this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0x83 | (value & 0x1F) << 2;
                        break;
                    }
                    case 4: {
                        this.REG_CHR_bank_B = this.REG_CHR_bank_B & 0x83 | (value & 0x1F) << 2;
                        break;
                    }
                    case 5: {
                        this.REG_CHR_bank_E = this.REG_CHR_bank_E & 0x83 | (value & 0x1F) << 2;
                        break;
                    }
                    case 6: {
                        this.REG_CHR_bank_F = this.REG_CHR_bank_F & 0x83 | (value & 0x1F) << 2;
                        break;
                    }
                    case 7: {
                        this.REG_mirroring = value & 1;
                    }
                }
                break;
            }
            case 18: {
                this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0x87 | (value & 0xF) << 3;
                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF1 | (value & 0x70) >> 3;
                this.REG_mirroring = 2 | value >> 7;
                break;
            }
            case 19: {
                switch (address >> 12 & 7) {
                    case 0: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xFFF0 | value & 0xF;
                        break;
                    }
                    case 1: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xFF0F | (value & 0xF) << 4;
                        break;
                    }
                    case 2: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xF0FF | (value & 0xF) << 8;
                        break;
                    }
                    case 3: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xFFF | (value & 0xF) << 12;
                        break;
                    }
                    case 4: {
                        this.cpu.setMapperIrq(false);
                        this.REG_CPU_IRQ_control = this.REG_CPU_IRQ_control & 0xF8 | value & 7;
                        if ((this.REG_CPU_IRQ_control & 2) == 0) break;
                        this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_latch;
                        break;
                    }
                    case 5: {
                        this.cpu.setMapperIrq(false);
                        this.REG_CPU_IRQ_control = this.REG_CPU_IRQ_control & 0xFD | (this.REG_CPU_IRQ_control & 1) << 1;
                        break;
                    }
                    case 7: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xF1 | (value & 7) << 1;
                    }
                }
                break;
            }
            case 20: {
                switch (address >> 12 & 6 | address & 1) {
                    case 0: {
                        this.REG_R0 = this.REG_R0 & 0xF8 | value & 7;
                        if ((this.REG_flags & 2) == 0) {
                            this.REG_PRG_mode = BitUtil.getBitBool(value, 6) ? 5 : 4;
                        }
                        this.REG_CHR_mode = BitUtil.getBitBool(value, 7) ? 3 : 2;
                        break;
                    }
                    case 1: {
                        switch (this.REG_R0 & 7) {
                            case 0: {
                                this.REG_CHR_bank_A = value;
                                break;
                            }
                            case 1: {
                                this.REG_CHR_bank_C = value;
                                break;
                            }
                            case 2: {
                                this.REG_CHR_bank_E = value;
                                break;
                            }
                            case 3: {
                                this.REG_CHR_bank_F = value;
                                break;
                            }
                            case 4: {
                                this.REG_CHR_bank_G = value;
                                break;
                            }
                            case 5: {
                                this.REG_CHR_bank_H = value;
                                break;
                            }
                            case 6: {
                                if ((this.REG_flags & 2) != 0) break;
                                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC0 | value & 0x3F;
                                break;
                            }
                            case 7: {
                                if ((this.REG_flags & 2) != 0) break;
                                this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xC0 | value & 0x3F;
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.REG_mirroring = value & 1;
                        break;
                    }
                    case 4: {
                        this.REG_scanline_IRQ_latch = value;
                        break;
                    }
                    case 5: {
                        this.REG_scanline_IRQ_reload = true;
                        break;
                    }
                    case 6: {
                        this.REG_scanline_IRQ_enabled = false;
                        this.cpu.setMapperIrq(false);
                        break;
                    }
                    case 7: {
                        this.REG_scanline_IRQ_enabled = true;
                    }
                }
                break;
            }
            case 21: {
                switch (address >> 13 & 3) {
                    case 0: {
                        this.REG_R0 = this.REG_R0 & 0xF8 | value & 7;
                        break;
                    }
                    case 1: {
                        switch (this.REG_R0 & 7) {
                            case 0: {
                                this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC0 | value & 0x3F;
                                break;
                            }
                            case 1: {
                                this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xC0 | value & 0x3F;
                                break;
                            }
                            case 2: {
                                this.REG_CHR_bank_A = value;
                                break;
                            }
                            case 3: {
                                this.REG_CHR_bank_C = value;
                                break;
                            }
                            case 4: {
                                this.REG_CHR_bank_E = value;
                                break;
                            }
                            case 5: {
                                this.REG_CHR_bank_F = value;
                                break;
                            }
                            case 6: {
                                this.REG_CHR_bank_G = value;
                                break;
                            }
                            case 7: {
                                this.REG_CHR_bank_H = value;
                            }
                        }
                        break;
                    }
                    case 3: {
                        this.REG_mirroring = value & 1;
                    }
                }
                break;
            }
            case 22: {
                switch (address >> 11 & 0xC | address & 3) {
                    case 0: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC0 | value & 0x3F;
                        if ((this.REG_flags & 1) != 0) break;
                        this.REG_mirroring = value >> 6 & 1;
                        break;
                    }
                    case 1: {
                        this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 2: {
                        this.REG_CHR_bank_A = value << 1;
                        break;
                    }
                    case 3: {
                        this.REG_CHR_bank_C = value << 1;
                        break;
                    }
                    case 4: {
                        this.REG_CHR_bank_E = value;
                        break;
                    }
                    case 5: {
                        this.REG_CHR_bank_F = value;
                        break;
                    }
                    case 6: {
                        this.REG_CHR_bank_G = value;
                        break;
                    }
                    case 7: {
                        this.REG_CHR_bank_H = value;
                        break;
                    }
                    case 12: {
                        if ((this.REG_flags & 1) != 0) {
                            this.REG_mirroring = value >> 6 & 1;
                        }
                    }
                    case 8: {
                        this.REG_scanline_IRQ_latch = value;
                        break;
                    }
                    case 9: {
                        this.REG_scanline_IRQ_reload = true;
                        break;
                    }
                    case 10: {
                        this.REG_scanline_IRQ_enabled = true;
                        break;
                    }
                    case 11: {
                        this.REG_scanline_IRQ_enabled = false;
                        this.cpu.setMapperIrq(false);
                    }
                }
                break;
            }
            case 24: {
                int vrc_2b_hi = address >> 1 & 1 | address >> 3 & 1 | address >> 5 & 1 | address >> 7 & 1;
                int vrc_2b_low = address & 1 | address >> 2 & 1 | address >> 4 & 1 | address >> 6 & 1;
                switch (address >> 10 & 0x1C | ((this.REG_flags & 1) != 0 ? vrc_2b_low : vrc_2b_hi) << 1 | ((this.REG_flags & 1) != 0 ? vrc_2b_hi : vrc_2b_low)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xE0 | value & 0x1F;
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (value == 255) break;
                        this.REG_mirroring = value & 3;
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.REG_PRG_mode = this.REG_PRG_mode & 0xFE | value >> 1 & 1;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xE0 | value & 0x1F;
                    }
                }
                if ((this.REG_flags & 2) == 0) {
                    switch (address >> 10 & 0x1C | ((this.REG_flags & 1) != 0 ? vrc_2b_low : vrc_2b_hi) << 1 | ((this.REG_flags & 1) != 0 ? vrc_2b_hi : vrc_2b_low)) {
                        case 12: {
                            this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0xF0 | value & 0xF;
                            break;
                        }
                        case 13: {
                            this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0xF | (value & 0xF) << 4;
                            break;
                        }
                        case 14: {
                            this.REG_CHR_bank_B = this.REG_CHR_bank_B & 0xF0 | value & 0xF;
                            break;
                        }
                        case 15: {
                            this.REG_CHR_bank_B = this.REG_CHR_bank_B & 0xF | (value & 0xF) << 4;
                            break;
                        }
                        case 16: {
                            this.REG_CHR_bank_C = this.REG_CHR_bank_C & 0xF0 | value & 0xF;
                            break;
                        }
                        case 17: {
                            this.REG_CHR_bank_C = this.REG_CHR_bank_C & 0xF | (value & 0xF) << 4;
                            break;
                        }
                        case 18: {
                            this.REG_CHR_bank_D = this.REG_CHR_bank_D & 0xF0 | value & 0xF;
                            break;
                        }
                        case 19: {
                            this.REG_CHR_bank_D = this.REG_CHR_bank_D & 0xF | (value & 0xF) << 4;
                            break;
                        }
                        case 20: {
                            this.REG_CHR_bank_E = this.REG_CHR_bank_E & 0xF0 | value & 0xF;
                            break;
                        }
                        case 21: {
                            this.REG_CHR_bank_E = this.REG_CHR_bank_E & 0xF | (value & 0xF) << 4;
                            break;
                        }
                        case 22: {
                            this.REG_CHR_bank_F = this.REG_CHR_bank_F & 0xF0 | value & 0xF;
                            break;
                        }
                        case 23: {
                            this.REG_CHR_bank_F = this.REG_CHR_bank_F & 0xF | (value & 0xF) << 4;
                            break;
                        }
                        case 24: {
                            this.REG_CHR_bank_G = this.REG_CHR_bank_G & 0xF0 | value & 0xF;
                            break;
                        }
                        case 25: {
                            this.REG_CHR_bank_G = this.REG_CHR_bank_G & 0xF | (value & 0xF) << 4;
                            break;
                        }
                        case 26: {
                            this.REG_CHR_bank_H = this.REG_CHR_bank_H & 0xF0 | value & 0xF;
                            break;
                        }
                        case 27: {
                            this.REG_CHR_bank_H = this.REG_CHR_bank_H & 0xF | (value & 0xF) << 4;
                        }
                    }
                } else {
                    switch (address >> 10 & 0x1C | ((this.REG_flags & 1) != 0 ? vrc_2b_low : vrc_2b_hi) << 1 | ((this.REG_flags & 1) != 0 ? vrc_2b_hi : vrc_2b_low)) {
                        case 12: {
                            this.REG_CHR_bank_A = this.REG_CHR_bank_A & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 13: {
                            this.REG_CHR_bank_A = this.REG_CHR_bank_A & 7 | (value & 0xF) << 3;
                            break;
                        }
                        case 14: {
                            this.REG_CHR_bank_B = this.REG_CHR_bank_B & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 15: {
                            this.REG_CHR_bank_B = this.REG_CHR_bank_B & 7 | (value & 0xF) << 3;
                            break;
                        }
                        case 16: {
                            this.REG_CHR_bank_C = this.REG_CHR_bank_C & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 17: {
                            this.REG_CHR_bank_C = this.REG_CHR_bank_C & 7 | (value & 0xF) << 3;
                            break;
                        }
                        case 18: {
                            this.REG_CHR_bank_D = this.REG_CHR_bank_D & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 19: {
                            this.REG_CHR_bank_D = this.REG_CHR_bank_D & 7 | (value & 0xF) << 3;
                            break;
                        }
                        case 20: {
                            this.REG_CHR_bank_E = this.REG_CHR_bank_E & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 21: {
                            this.REG_CHR_bank_E = this.REG_CHR_bank_E & 7 | (value & 0xF) << 3;
                            break;
                        }
                        case 22: {
                            this.REG_CHR_bank_F = this.REG_CHR_bank_F & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 23: {
                            this.REG_CHR_bank_F = this.REG_CHR_bank_F & 7 | (value & 0xF) << 3;
                            break;
                        }
                        case 24: {
                            this.REG_CHR_bank_G = this.REG_CHR_bank_G & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 25: {
                            this.REG_CHR_bank_G = this.REG_CHR_bank_G & 7 | (value & 0xF) << 3;
                            break;
                        }
                        case 26: {
                            this.REG_CHR_bank_H = this.REG_CHR_bank_H & 0x78 | (value & 0xE) >> 1;
                            break;
                        }
                        case 27: {
                            this.REG_CHR_bank_H = this.REG_CHR_bank_H & 7 | (value & 0xF) << 3;
                        }
                    }
                }
                if ((address >> 12 & 7) != 7) break;
                switch (((this.REG_flags & 1) != 0 ? vrc_2b_low : vrc_2b_hi) << 1 | ((this.REG_flags & 1) != 0 ? vrc_2b_hi : vrc_2b_low)) {
                    case 0: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xF0 | value & 0xF;
                        break;
                    }
                    case 1: {
                        this.REG_CPU_IRQ_latch = this.REG_CPU_IRQ_latch & 0xF | (value & 0xF) << 4;
                        break;
                    }
                    case 2: {
                        this.cpu.setMapperIrq(false);
                        this.REG_CPU_IRQ_control = this.REG_CPU_IRQ_control & 0xF8 | value & 7;
                        if ((this.REG_CPU_IRQ_control & 2) == 0) break;
                        this.REG_VRC4_IRQ_prescaler_counter = 0;
                        this.REG_VRC4_IRQ_prescaler = 0;
                        this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_latch;
                        break;
                    }
                    case 3: {
                        this.cpu.setMapperIrq(false);
                        this.REG_CPU_IRQ_control = this.REG_CPU_IRQ_control & 0xFD | (this.REG_CPU_IRQ_control & 1) << 1;
                    }
                }
                break;
            }
            case 25: {
                if ((address >> 13 & 3) == 0) {
                    this.REG_R0 = this.REG_R0 & 0xF0 | value & 0xF;
                    break;
                }
                if ((address >> 13 & 3) != 1) break;
                switch (this.REG_R0 & 0xF) {
                    case 0: {
                        this.REG_CHR_bank_A = value;
                        break;
                    }
                    case 1: {
                        this.REG_CHR_bank_B = value;
                        break;
                    }
                    case 2: {
                        this.REG_CHR_bank_C = value;
                        break;
                    }
                    case 3: {
                        this.REG_CHR_bank_D = value;
                        break;
                    }
                    case 4: {
                        this.REG_CHR_bank_E = value;
                        break;
                    }
                    case 5: {
                        this.REG_CHR_bank_F = value;
                        break;
                    }
                    case 6: {
                        this.REG_CHR_bank_G = value;
                        break;
                    }
                    case 7: {
                        this.REG_CHR_bank_H = value;
                        break;
                    }
                    case 8: {
                        this.REG_WRAM_enabled = BitUtil.getBitBool(value, 7);
                        this.REG_map_ROM_on_6000 = !BitUtil.getBitBool(value, 6);
                        this.REG_PRG_bank_6000 = value & 0x3F;
                        break;
                    }
                    case 9: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 10: {
                        this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 11: {
                        this.REG_PRG_bank_C = this.REG_PRG_bank_C & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 12: {
                        this.REG_mirroring = value & 3;
                        break;
                    }
                    case 13: {
                        this.REG_CPU_IRQ_control = value >> 6 & 1 | value & 1;
                        this.cpu.setMapperIrq(false);
                        break;
                    }
                    case 14: {
                        this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_value & 0xFF00 | value;
                        break;
                    }
                    case 15: {
                        this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_value & 0xFF | value << 8;
                    }
                }
                break;
            }
            case 26: {
                block247 : switch (address >> 12 & 3) {
                    case 0: {
                        this.REG_PRG_bank_A = this.REG_PRG_bank_A & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 1: {
                        this.REG_PRG_mode = this.REG_PRG_mode & 6 | value >> 1 & 1;
                        this.REG_mirroring = value & 1;
                        break;
                    }
                    case 2: {
                        this.REG_PRG_bank_B = this.REG_PRG_bank_B & 0xC0 | value & 0x3F;
                        break;
                    }
                    case 3: {
                        switch (address & 7) {
                            case 0: {
                                this.REG_CHR_bank_A = value;
                                break block247;
                            }
                            case 1: {
                                this.REG_CHR_bank_B = value;
                                break block247;
                            }
                            case 2: {
                                this.REG_CHR_bank_C = value;
                                break block247;
                            }
                            case 3: {
                                this.REG_CHR_bank_D = value;
                                break block247;
                            }
                            case 4: {
                                this.REG_CHR_bank_E = value;
                                break block247;
                            }
                            case 5: {
                                this.REG_CHR_bank_F = value;
                                break block247;
                            }
                            case 6: {
                                this.REG_CHR_bank_G = value;
                                break block247;
                            }
                            case 7: {
                                this.REG_CHR_bank_H = value;
                            }
                        }
                    }
                }
                break;
            }
            case 31: {
                this.REG_PRG_bank_6000 = (value >> 1 & 0xF) + 4;
                this.REG_map_ROM_on_6000 = true;
            }
        }
        this.updateState();
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address & 0xF000) {
            case 0: 
            case 4096: 
            case 8192: 
            case 12288: 
            case 16384: {
                break;
            }
            case 20480: {
                this.write5(address, value);
                break;
            }
            case 24576: 
            case 28672: {
                this.write67(address, value);
                break;
            }
            default: {
                this.writeRegister(address, value);
            }
        }
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (address < 8192) {
            if (this.REG_can_write_CHR_RAM) {
                this.xChrRam[(this.chrBanks[address >> this.chrShift] | address & this.chrAddressMask) & this.chrRamSizeMask] = value;
            }
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public void update() {
        switch (this.REG_mapper) {
            case 7: {
                if ((this.REG_CPU_IRQ_control & 1) == 0) break;
                if ((this.REG_CPU_IRQ_control & 8) != 0) {
                    if ((this.REG_CPU_IRQ_value & 0xF) == 0) {
                        this.cpu.setMapperIrq(true);
                    }
                    this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_value & 0xFFF0 | this.REG_CPU_IRQ_value - 1 & 0xF;
                    break;
                }
                if ((this.REG_CPU_IRQ_control & 4) != 0) {
                    if ((this.REG_CPU_IRQ_value & 0xFF) == 0) {
                        this.cpu.setMapperIrq(true);
                    }
                    this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_value & 0xFF00 | this.REG_CPU_IRQ_value - 1 & 0xFF;
                    break;
                }
                if ((this.REG_CPU_IRQ_control & 2) != 0) {
                    if ((this.REG_CPU_IRQ_value & 0xFFF) == 0) {
                        this.cpu.setMapperIrq(true);
                    }
                    this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_value & 0xF000 | this.REG_CPU_IRQ_value - 1 & 0xFFF;
                    break;
                }
                if (this.REG_CPU_IRQ_value == 0) {
                    this.cpu.setMapperIrq(true);
                }
                --this.REG_CPU_IRQ_value;
                this.REG_CPU_IRQ_value &= 0xFFFF;
                break;
            }
            case 14: {
                if ((this.REG_CPU_IRQ_control & 1) == 0 || this.REG_CPU_IRQ_value <= 0) break;
                --this.REG_CPU_IRQ_value;
                this.REG_CPU_IRQ_value &= 0xFFFF;
                if (this.REG_CPU_IRQ_value != 0) break;
                this.cpu.setMapperIrq(true);
                break;
            }
            case 19: {
                if ((this.REG_CPU_IRQ_control & 2) == 0) break;
                if ((this.REG_CPU_IRQ_control & 4) != 0) {
                    this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_value & 0xFF00 | this.REG_CPU_IRQ_value + 1 & 0xFF;
                    if ((this.REG_CPU_IRQ_value & 0xFF) != 0) break;
                    this.cpu.setMapperIrq(true);
                    this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_value & 0xFF00 | this.REG_CPU_IRQ_latch & 0xFF;
                    break;
                }
                ++this.REG_CPU_IRQ_value;
                this.REG_CPU_IRQ_value &= 0xFFFF;
                if (this.REG_CPU_IRQ_value != 0) break;
                this.cpu.setMapperIrq(true);
                this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_latch;
                break;
            }
            case 24: {
                if ((this.REG_CPU_IRQ_control & 2) == 0) break;
                if ((this.REG_CPU_IRQ_control & 4) != 0) {
                    ++this.REG_CPU_IRQ_value;
                    this.REG_CPU_IRQ_value &= 0xFFFF;
                    if ((this.REG_CPU_IRQ_value & 0xFF) != 0) break;
                    this.cpu.setMapperIrq(true);
                    this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_latch;
                    break;
                }
                ++this.REG_VRC4_IRQ_prescaler;
                this.REG_VRC4_IRQ_prescaler &= 0xFF;
                if (((this.REG_VRC4_IRQ_prescaler_counter & 2) != 0 || this.REG_VRC4_IRQ_prescaler != 114) && ((this.REG_VRC4_IRQ_prescaler_counter & 2) == 0 || this.REG_VRC4_IRQ_prescaler != 113)) break;
                ++this.REG_CPU_IRQ_value;
                this.REG_CPU_IRQ_value &= 0xFFFF;
                this.REG_VRC4_IRQ_prescaler = 0;
                ++this.REG_VRC4_IRQ_prescaler_counter;
                if (this.REG_VRC4_IRQ_prescaler_counter == 3) {
                    this.REG_VRC4_IRQ_prescaler_counter = 0;
                }
                if ((this.REG_CPU_IRQ_value & 0xFF) != 0) break;
                this.cpu.setMapperIrq(true);
                this.REG_CPU_IRQ_value = this.REG_CPU_IRQ_latch;
                break;
            }
            case 25: {
                if (this.REG_CPU_IRQ_value == 0 && (this.REG_CPU_IRQ_control & 1) != 0) {
                    this.cpu.setMapperIrq(true);
                }
                --this.REG_CPU_IRQ_value;
                this.REG_CPU_IRQ_value &= 0xFFFF;
            }
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        this.LastPPUScanline = scanline;
        this.LastPPUIsRendering = rendering;
        if (rendering && scanlineCycle == 260) {
            if (this.REG_scanline_IRQ_reload || this.REG_scanline_IRQ_counter == 0) {
                this.REG_scanline_IRQ_counter = this.REG_scanline_IRQ_latch;
                this.REG_scanline_IRQ_reload = false;
            } else {
                --this.REG_scanline_IRQ_counter;
                this.REG_scanline_IRQ_counter &= 0xFF;
            }
            if (this.REG_scanline_IRQ_counter == 0 && this.REG_scanline_IRQ_enabled) {
                this.cpu.setMapperIrq(true);
            }
            if (this.REG_scanline2_IRQ_line == scanline + 1 && this.REG_scanline2_IRQ_enabled) {
                this.cpu.setMapperIrq(true);
                this.REG_scanline2_IRQ_pending = true;
            }
            if (this.REG_mapper == 6) {
                if (scanline == 239) {
                    this.ppu_mapper163_latch = 0;
                    this.updateChrBanks();
                } else if (scanline == 127) {
                    this.ppu_mapper163_latch = 1;
                    this.updateChrBanks();
                }
            }
        }
        if (this.REG_mapper == 20 && (this.REG_flags & 1) != 0) {
            this.setNametableMirroring(2 + (this.TKSMIR[(address & 0x1FFF) >> 10] >> 7 & 1));
        } else if (this.REG_mapper == 17) {
            switch (address >> 4) {
                case 253: {
                    this.ppu_latch0 = false;
                    this.updateChrBanks();
                    break;
                }
                case 254: {
                    this.ppu_latch0 = true;
                    this.updateChrBanks();
                    break;
                }
                case 509: {
                    this.ppu_latch1 = false;
                    this.updateChrBanks();
                    break;
                }
                case 510: {
                    this.ppu_latch1 = true;
                    this.updateChrBanks();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFlash() {
        if (this.SAVE_FLASH == null || this.SAVE_FLASH.length != 0x400000) {
            this.SAVE_FLASH = new int[0x400000];
        }
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            int[] flash = GamePrefs.getInstance().getStorageUnitRam();
            if (flash != null && flash.length == 0x400000) {
                System.arraycopy(flash, 0, this.SAVE_FLASH, 0, 0x400000);
            } else {
                Arrays.fill(this.SAVE_FLASH, 0);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void readTransients(DataInput in) throws IOException {
        super.readTransients(in);
        this.loadFlash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveNonVolatilePrgRam() {
        Class<GamePrefs> clazz = GamePrefs.class;
        synchronized (GamePrefs.class) {
            GamePrefs prefs = GamePrefs.getInstance();
            int[] flash = prefs.getStorageUnitRam();
            if (flash == null || flash.length != 0x400000) {
                flash = new int[0x400000];
            }
            System.arraycopy(this.SAVE_FLASH, 0, flash, 0, 0x400000);
            prefs.setStorageUnitRam(flash);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            GamePrefs.save();
            super.saveNonVolatilePrgRam();
            return;
        }
    }
}

