/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.irem;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class H3001
extends Mapper {
    private static final long serialVersionUID = 0L;
    private boolean irqEnabled;
    private int irqReloadValue;
    private int irqCounter;

    public H3001(CartFile cartFile) {
        super(cartFile, 8, 8);
    }

    @Override
    public void init() {
        this.setPrgBank(4, 0);
        this.setPrgBank(5, 1);
        this.setPrgBank(6, 254);
        this.setPrgBank(7, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address) {
            case 32768: {
                this.setPrgBank(4, value);
                break;
            }
            case 36865: {
                this.writeNametableMirroring(value);
                break;
            }
            case 36867: {
                this.writeIrqEnable(value);
                break;
            }
            case 36868: {
                this.writeReloadIrqCounter();
                break;
            }
            case 36869: {
                this.writeHighIrqReloadValue(value);
                break;
            }
            case 36870: {
                this.writeLowIrqReloadValue(value);
                break;
            }
            case 40960: {
                this.setPrgBank(5, value);
                break;
            }
            case 45056: 
            case 45057: 
            case 45058: 
            case 45059: 
            case 45060: 
            case 45061: 
            case 45062: 
            case 45063: {
                this.setChrBank(address & 7, value);
                break;
            }
            case 49152: {
                this.setPrgBank(6, value);
            }
        }
    }

    private void writeNametableMirroring(int value) {
        this.setNametableMirroring(BitUtil.getBit(value, 7));
    }

    private void writeIrqEnable(int value) {
        this.irqEnabled = BitUtil.getBitBool(value, 7);
        this.cpu.setMapperIrq(false);
    }

    private void writeReloadIrqCounter() {
        this.irqCounter = this.irqReloadValue;
        this.cpu.setMapperIrq(false);
    }

    private void writeHighIrqReloadValue(int value) {
        this.irqReloadValue = this.irqReloadValue & 0xFF | value << 8;
    }

    private void writeLowIrqReloadValue(int value) {
        this.irqReloadValue = this.irqReloadValue & 0xFF00 | value;
    }

    @Override
    public void update() {
        if (this.irqEnabled && this.irqCounter > 0 && --this.irqCounter == 0) {
            this.cpu.setMapperIrq(true);
        }
    }
}

