/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.jy;

import java.util.Arrays;
import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.util.BitUtil;

public class JY
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] multipliers = new int[2];
    private final int[] commands = new int[4];
    private final int[] prgRegs = new int[4];
    private final int[] chrLows = new int[8];
    private final int[] chrHighs = new int[8];
    private final int[] chrLatches = new int[2];
    private final int[] ntRegs = new int[4];
    private final int[] ntAddress = new int[4];
    private final boolean[] ntRAM = new boolean[4];
    private final boolean mapper209;
    private final boolean mapper211;
    protected int dipswitches;
    private int reg5803;
    protected int irqIncrement;
    protected int irqSource;
    protected int irqXOR;
    protected int irqCounter;
    protected int irqPrescaler;
    protected boolean irqPrescaler3BitMode;
    protected boolean irqEnabled;
    protected boolean lastA12;

    public JY(CartFile cartFile, int mapperNumber) {
        super(cartFile, 8, 8);
        switch (mapperNumber) {
            case 209: {
                this.mapper209 = true;
                this.mapper211 = false;
                break;
            }
            case 211: {
                this.mapper209 = false;
                this.mapper211 = true;
                this.dipswitches = 192;
                break;
            }
            default: {
                this.mapper209 = false;
                this.mapper211 = false;
            }
        }
        this.reg5803 = 255;
        this.multipliers[1] = 255;
        this.multipliers[0] = 255;
        Arrays.fill(this.prgRegs, 255);
        Arrays.fill(this.chrLows, 255);
        Arrays.fill(this.chrHighs, 255);
    }

    @Override
    public void init() {
        this.chrLatches[0] = 0;
        this.chrLatches[1] = 4;
        this.updatePrgBanks();
        this.updateChrBanks();
    }

    @Override
    public void resetting() {
        this.dipswitches = this.dipswitches + 64 & 0xC0;
        Arrays.fill(this.commands, 0);
        Arrays.fill(this.prgRegs, 255);
        this.init();
    }

    @Override
    public void writeMemory(int address, int value) {
        this.memory[address] = value;
        switch (address & 0xF000) {
            case 20480: {
                this.writeMultiplier(address, value);
                break;
            }
            case 32768: {
                if (address > 36848) break;
                this.writePrg(address, value);
                break;
            }
            case 36864: {
                this.writeChrLow(address, value);
                break;
            }
            case 40960: {
                this.writeChrHigh(address, value);
                break;
            }
            case 45056: {
                this.writeNametables(address, value);
                break;
            }
            case 49152: {
                this.writeIrq(address, value);
                break;
            }
            case 53248: {
                if (address >= 54784) break;
                this.writeMode(address, value);
            }
        }
        if (this.irqEnabled && this.irqSource == 3) {
            this.incrementIrqPrescaler();
        }
    }

    @Override
    public int readMemory(int address) {
        if (address >= 24576) {
            return this.prgROM[(this.prgBanks[address >> 13] | address & 0x1FFF) & this.prgRomSizeMask];
        }
        if (address >= 20480) {
            return this.readMultiplier(address);
        }
        return this.memory[address];
    }

    @Override
    public int readVRAM(int address) {
        int high;
        if (this.irqEnabled && this.irqSource == 2) {
            this.incrementIrqPrescaler();
        }
        if (this.mapper209 && (high = address >> 8) < 32 && (high & 0xF) == 15) {
            int low = address & 0xF0;
            if (low == 208) {
                this.chrLatches[(high & 0x10) >> 4] = (high & 0x10) >> 2;
                this.updateChrBanks();
            } else if (low == 224) {
                this.chrLatches[(high & 0x10) >> 4] = (high & 0x10) >> 2 | 2;
                this.updateChrBanks();
            }
        }
        if (!this.nametableMappingEnabled && address >= 8192 && address <= 16127) {
            int index = address >> 10 & 3;
            int addr = this.ntAddress[index] | address & 0x3FF;
            if (this.ntRAM[index]) {
                return this.vram[addr];
            }
            return this.chrROM[addr & this.chrRomSizeMask];
        }
        return super.readVRAM(address);
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (!this.nametableMappingEnabled && address >= 8192 && address <= 16127) {
            int index = address >> 10 & 3;
            if (this.ntRAM[index]) {
                this.vram[this.ntAddress[index] | address & 0x3FF] = value;
            }
        } else {
            super.writeVRAM(address, value);
        }
    }

    public void updateMirroring() {
        if (BitUtil.getBitBool(this.commands[0], 5) && this.mapper209 || this.mapper211) {
            this.nametableMappingEnabled = false;
            if (BitUtil.getBitBool(this.commands[0], 6)) {
                for (int x = 3; x >= 0; --x) {
                    this.ntRAM[x] = false;
                    this.ntAddress[x] = this.ntRegs[x] << 10;
                }
            } else {
                for (int x = 3; x >= 0; --x) {
                    if ((this.commands[1] & 0x80) == (this.ntRegs[x] & 0x80)) {
                        this.ntRAM[x] = true;
                        this.ntAddress[x] = 0x2000 | (this.ntRegs[x] & 1) << 10;
                        continue;
                    }
                    this.ntRAM[x] = false;
                    this.ntAddress[x] = this.ntRegs[x] << 10;
                }
            }
        } else {
            this.nametableMappingEnabled = true;
            this.setNametableMirroring(this.commands[1] & 3);
        }
    }

    protected void updatePrgBanks() {
        int bankMode = (this.commands[3] & 6) << 5;
        switch (this.commands[0] & 7) {
            case 0: {
                if (BitUtil.getBitBool(this.commands[0], 7)) {
                    this.setPrgBank(3, (this.prgRegs[3] << 2) + 3 & 0x3F | bankMode);
                }
                this.setPrgBanks(4, 4, (0xF | (this.commands[3] & 6) << 3) << 2);
                break;
            }
            case 1: {
                if (BitUtil.getBitBool(this.commands[0], 7)) {
                    this.setPrgBank(3, (this.prgRegs[3] << 1) + 1 & 0x3F | bankMode);
                }
                this.setPrgBanks(4, 2, (this.prgRegs[1] & 0x1F | (this.commands[3] & 6) << 4) << 1);
                this.setPrgBanks(6, 2, (0x1F | (this.commands[3] & 6) << 4) << 1);
                break;
            }
            case 2: 
            case 3: {
                if (BitUtil.getBitBool(this.commands[0], 7)) {
                    this.setPrgBank(3, this.prgRegs[3] & 0x3F | bankMode);
                }
                this.setPrgBank(4, this.prgRegs[0] & 0x3F | bankMode);
                this.setPrgBank(5, this.prgRegs[1] & 0x3F | bankMode);
                this.setPrgBank(6, this.prgRegs[2] & 0x3F | bankMode);
                this.setPrgBank(7, 0x3F | bankMode);
                break;
            }
            case 4: {
                if (BitUtil.getBitBool(this.commands[0], 7)) {
                    this.setPrgBank(3, (this.prgRegs[3] << 2) + 3 & 0x3F | bankMode);
                }
                this.setPrgBanks(4, 4, (this.prgRegs[3] & 0xF | (this.commands[3] & 6) << 3) << 2);
                break;
            }
            case 5: {
                if (BitUtil.getBitBool(this.commands[0], 7)) {
                    this.setPrgBank(3, (this.prgRegs[3] << 1) + 1 & 0x3F | bankMode);
                }
                this.setPrgBanks(4, 2, (this.prgRegs[1] & 0x1F | (this.commands[3] & 6) << 4) << 1);
                this.setPrgBanks(6, 2, (this.prgRegs[3] & 0x1F | (this.commands[3] & 6) << 4) << 1);
                break;
            }
            case 6: 
            case 7: {
                if (BitUtil.getBitBool(this.commands[0], 7)) {
                    this.setPrgBank(3, this.prgRegs[3] & 0x3F | bankMode);
                }
                this.setPrgBank(4, this.prgRegs[0] & 0x3F | bankMode);
                this.setPrgBank(5, this.prgRegs[1] & 0x3F | bankMode);
                this.setPrgBank(6, this.prgRegs[2] & 0x3F | bankMode);
                this.setPrgBank(7, this.prgRegs[3] & 0x3F | bankMode);
            }
        }
    }

    protected void updateChrBanks() {
        int bank = 0;
        int mask = 65535;
        if (!BitUtil.getBitBool(this.commands[3], 5)) {
            bank = this.commands[3] & 1 | (this.commands[3] & 0x18) >> 2;
            switch (this.commands[0] & 0x18) {
                case 0: {
                    bank <<= 5;
                    mask = 31;
                    break;
                }
                case 8: {
                    bank <<= 6;
                    mask = 63;
                    break;
                }
                case 16: {
                    bank <<= 7;
                    mask = 127;
                    break;
                }
                case 24: {
                    bank <<= 8;
                    mask = 255;
                }
            }
        }
        switch (this.commands[0] & 0x18) {
            case 0: {
                this.setChrBanks(0, 8, ((this.chrLows[0] | this.chrHighs[0] << 8) & mask | bank) << 3);
                break;
            }
            case 8: {
                this.setChrBanks(0, 4, ((this.chrLows[this.chrLatches[0]] | this.chrHighs[this.chrLatches[0]] << 8) & mask | bank) << 2);
                this.setChrBanks(4, 4, ((this.chrLows[this.chrLatches[1]] | this.chrHighs[this.chrLatches[1]] << 8) & mask | bank) << 2);
                break;
            }
            case 16: {
                for (int x = 6; x >= 0; x -= 2) {
                    this.setChrBanks(x, 2, ((this.chrLows[x] | this.chrHighs[x] << 8) & mask | bank) << 1);
                }
                break;
            }
            case 24: {
                for (int x = 7; x >= 0; --x) {
                    this.setChrBank(x, (this.chrLows[x] | this.chrHighs[x] << 8) & mask | bank);
                }
                break;
            }
        }
    }

    private void writeMultiplier(int address, int value) {
        switch (address & 0x5C03) {
            case 22528: {
                this.multipliers[0] = value;
                break;
            }
            case 22529: {
                this.multipliers[1] = value;
                break;
            }
            case 22531: {
                this.reg5803 = value;
            }
        }
    }

    private int readMultiplier(int address) {
        switch (address & 0x5C03) {
            case 22528: {
                return this.multipliers[0] * this.multipliers[1] & 0xFF;
            }
            case 22529: {
                return this.multipliers[0] * this.multipliers[1] >> 8 & 0xFF;
            }
            case 22531: {
                return this.reg5803;
            }
        }
        return this.dipswitches;
    }

    private void writePrg(int address, int value) {
        this.prgRegs[address & 3] = value;
        this.updatePrgBanks();
    }

    private void writeChrLow(int address, int value) {
        this.chrLows[address & 7] = value;
        this.updateChrBanks();
    }

    private void writeChrHigh(int address, int value) {
        this.chrHighs[address & 7] = value;
        this.updateChrBanks();
    }

    private void writeNametables(int address, int value) {
        if (BitUtil.getBitBool(address, 2)) {
            int n = address & 3;
            this.ntRegs[n] = this.ntRegs[n] & 0xFF;
            int n2 = address & 3;
            this.ntRegs[n2] = this.ntRegs[n2] | value << 8;
        } else {
            int n = address & 3;
            this.ntRegs[n] = this.ntRegs[n] & 0xFF00;
            int n3 = address & 3;
            this.ntRegs[n3] = this.ntRegs[n3] | value;
        }
        this.updateMirroring();
    }

    private void writeIrq(int address, int value) {
        switch (address & 7) {
            case 0: {
                this.writeIrqEnable(value);
                break;
            }
            case 1: {
                this.writeIrqMode(value);
                break;
            }
            case 2: {
                this.writeIrqAcknowledge();
                break;
            }
            case 3: {
                this.writeIrqEnable();
                break;
            }
            case 4: {
                this.writeIrqPrescaler(value);
                break;
            }
            case 5: {
                this.writeIrqCounter(value);
                break;
            }
            case 6: {
                this.writeIrqXOR(value);
            }
        }
    }

    private void writeMode(int address, int value) {
        this.commands[address & 3] = value;
        this.updatePrgBanks();
        this.updateChrBanks();
        this.updateMirroring();
    }

    protected void writeIrqMode(int value) {
        switch (value >> 6) {
            case 1: {
                this.irqIncrement = 1;
                break;
            }
            case 2: {
                this.irqIncrement = -1;
                break;
            }
            default: {
                this.irqIncrement = 0;
            }
        }
        this.irqPrescaler3BitMode = BitUtil.getBitBool(value, 2);
        this.irqSource = value & 3;
    }

    protected void writeIrqAcknowledge() {
        this.cpu.setMapperIrq(false);
        this.irqEnabled = false;
    }

    protected void writeIrqEnable(int value) {
        if (BitUtil.getBitBool(value, 0)) {
            this.writeIrqEnable();
        } else {
            this.writeIrqAcknowledge();
        }
    }

    protected void writeIrqEnable() {
        this.irqEnabled = true;
    }

    protected void writeIrqPrescaler(int value) {
        this.irqPrescaler = (value ^ this.irqXOR) & 0xFF;
    }

    protected void writeIrqCounter(int value) {
        this.irqCounter = (value ^ this.irqXOR) & 0xFF;
    }

    protected void writeIrqXOR(int value) {
        this.irqXOR = value;
    }

    protected void incrementIrqPrescaler() {
        if (this.irqIncrement == 1) {
            if (this.irqPrescaler3BitMode) {
                if ((this.irqPrescaler & 7) == 7) {
                    this.irqPrescaler &= 0xF8;
                    this.incrementIrqCounter();
                } else {
                    this.irqPrescaler = this.irqPrescaler & 0xF8 | (this.irqPrescaler & 7) + 1;
                }
            } else if (this.irqPrescaler == 255) {
                this.irqPrescaler = 0;
                this.incrementIrqCounter();
            } else {
                ++this.irqPrescaler;
            }
        } else if (this.irqIncrement == -1) {
            if (this.irqPrescaler3BitMode) {
                if ((this.irqPrescaler & 7) == 0) {
                    this.irqPrescaler |= 7;
                    this.incrementIrqCounter();
                } else {
                    this.irqPrescaler = this.irqPrescaler & 0xF8 | (this.irqPrescaler & 7) - 1;
                }
            } else if (this.irqPrescaler == 0) {
                this.irqPrescaler = 255;
                this.incrementIrqCounter();
            } else {
                --this.irqPrescaler;
            }
        }
    }

    protected void incrementIrqCounter() {
        if (this.irqIncrement == 1) {
            if (this.irqCounter == 255) {
                this.irqCounter = 0;
                if (this.irqEnabled) {
                    this.cpu.setMapperIrq(true);
                }
            } else {
                ++this.irqCounter;
            }
        } else if (this.irqIncrement == -1) {
            if (this.irqCounter == 0) {
                this.irqCounter = 255;
                if (this.irqEnabled) {
                    this.cpu.setMapperIrq(true);
                }
            } else {
                --this.irqCounter;
            }
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled && this.irqSource == 0) {
            this.incrementIrqPrescaler();
        }
    }

    @Override
    public void handlePpuCycle(int scanline, int scanlineCycle, int address, boolean rendering) {
        boolean a12;
        boolean bl = a12 = (address & 0x1000) != 0;
        if (this.irqEnabled && this.irqSource == 1 && !this.lastA12 && a12) {
            this.incrementIrqPrescaler();
        }
        this.lastA12 = a12;
    }
}

