/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.kaiser;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;

public class Kaiser7032
extends Mapper {
    private static final long serialVersionUID = 0L;
    private final int[] regs = new int[4];
    private int irqReloadValue;
    private int irqCounter;
    private int regIndex;
    private boolean irqEnabled;

    public Kaiser7032(CartFile cartFile) {
        super(cartFile, 8, 8, 32768, 24576);
        this.setPrgBank(7, -1);
    }

    @Override
    protected void writeRegister(int address, int value) {
        switch (address & 0xF000) {
            case 32768: {
                this.irqReloadValue = this.irqReloadValue & 0xFFF0 | value & 0xF;
                break;
            }
            case 36864: {
                this.irqReloadValue = this.irqReloadValue & 0xFF0F | (value & 0xF) << 4;
                break;
            }
            case 40960: {
                this.irqReloadValue = this.irqReloadValue & 0xF0FF | (value & 0xF) << 8;
                break;
            }
            case 45056: {
                this.irqReloadValue = this.irqReloadValue & 0xFFF | (value & 0xF) << 12;
                break;
            }
            case 49152: {
                boolean bl = this.irqEnabled = value != 0;
                if (this.irqEnabled) {
                    this.irqCounter = this.irqReloadValue;
                }
                this.cpu.setMapperIrq(false);
                break;
            }
            case 53248: {
                this.cpu.setMapperIrq(false);
                break;
            }
            case 57344: {
                this.regIndex = (value & 0xF) - 1;
                break;
            }
            case 61440: {
                if (this.regIndex <= 2) {
                    this.regs[this.regIndex] = this.regs[this.regIndex] & 0x10 | value & 0xF;
                } else if (this.regIndex == 3) {
                    this.regs[3] = value;
                }
                switch (address & 0xFC00) {
                    case 61440: {
                        int bank = address & 3;
                        if (bank >= 3) break;
                        this.regs[bank] = value & 0x10 | this.regs[bank] & 0xF;
                        break;
                    }
                    case 63488: {
                        this.setNametableMirroring(value & 1);
                        break;
                    }
                    case 64512: {
                        this.setChrBank(address & 7, value);
                    }
                }
                this.setPrgBank(3, this.regs[3]);
                this.setPrgBank(4, this.regs[0]);
                this.setPrgBank(5, this.regs[1]);
                this.setPrgBank(6, this.regs[2]);
            }
        }
    }

    @Override
    public void update() {
        if (this.irqEnabled && ++this.irqCounter == 65535) {
            this.irqCounter = this.irqReloadValue;
            this.cpu.setMapperIrq(true);
        }
    }
}

