/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami;

import nintaco.files.CartFile;
import nintaco.mappers.konami.VrcIrq;
import nintaco.util.BitUtil;

public class VRC2And4
extends VrcIrq {
    private static final long serialVersionUID = 0L;
    protected static final int VRC2a = 0;
    protected static final int VRC2b = 1;
    protected static final int VRC2c = 2;
    protected static final int VRC4a = 3;
    protected static final int VRC4b = 4;
    protected static final int VRC4c = 5;
    protected static final int VRC4d = 6;
    protected static final int VRC4e = 7;
    protected static final int VRC4f = 8;
    protected final int[] chrLow = new int[8];
    protected final int[] chrHigh = new int[8];
    protected boolean useHeuristics;
    protected boolean prgSwapMode;
    protected int variant;
    protected int prgSelect0;
    protected int prgSelect1;
    protected int prgHigh;
    protected int ganbareGoemonGaiden;

    public VRC2And4(CartFile cartFile) {
        super(cartFile);
        this.detectVariant(cartFile);
    }

    @Override
    public void init() {
        super.init();
        this.updateBanks();
    }

    protected void detectVariant(CartFile cartFile) {
        block0 : switch (cartFile.getMapperNumber()) {
            case 22: {
                this.variant = 0;
                break;
            }
            case 23: {
                this.prgHigh = 32;
                this.variant = cartFile.getSubmapperNumber() == 2 ? 7 : 1;
                break;
            }
            case 25: {
                this.prgHigh = 32;
                switch (cartFile.getSubmapperNumber()) {
                    case 2: {
                        this.variant = 6;
                        break block0;
                    }
                    case 3: {
                        this.variant = 2;
                        break block0;
                    }
                }
                this.variant = 4;
                break;
            }
            case 27: {
                this.variant = 8;
                break;
            }
            default: {
                this.variant = cartFile.getSubmapperNumber() == 2 ? 5 : 3;
            }
        }
        this.useHeuristics = cartFile.getSubmapperNumber() == 0 && cartFile.getMapperNumber() != 22 && cartFile.getMapperNumber() != 27;
    }

    protected int translateAddress(int address) {
        int A0 = 0;
        int A1 = 0;
        if (this.useHeuristics) {
            switch (this.variant) {
                case 2: 
                case 4: 
                case 6: {
                    A0 = (address >> 1 | address >> 3) & 1;
                    A1 = (address | address >> 2) & 1;
                    break;
                }
                case 3: 
                case 5: {
                    A0 = (address >> 1 | address >> 6) & 1;
                    A1 = (address >> 2 | address >> 7) & 1;
                    break;
                }
                case 1: 
                case 7: {
                    A0 = (address | address >> 2) & 1;
                    A1 = (address >> 1 | address >> 3) & 1;
                }
            }
        } else {
            switch (this.variant) {
                case 0: {
                    A0 = address >> 1 & 1;
                    A1 = address & 1;
                    break;
                }
                case 8: {
                    A0 = address & 1;
                    A1 = address >> 1 & 1;
                    break;
                }
                case 2: 
                case 4: {
                    A0 = address >> 1 & 1;
                    A1 = address & 1;
                    break;
                }
                case 6: {
                    A0 = address >> 3 & 1;
                    A1 = address >> 2 & 1;
                    break;
                }
                case 3: {
                    A0 = address >> 1 & 1;
                    A1 = address >> 2 & 1;
                    break;
                }
                case 5: {
                    A0 = address >> 6 & 1;
                    A1 = address >> 7 & 1;
                    break;
                }
                case 1: {
                    A0 = address & 1;
                    A1 = address >> 1 & 1;
                    break;
                }
                case 7: {
                    A0 = address >> 2 & 1;
                    A1 = address >> 3 & 1;
                }
            }
        }
        return address & 0xFF00 | A1 << 1 | A0;
    }

    protected void updatePrgBanks() {
        if (this.prgSwapMode) {
            this.setPrgBank(4, this.prgHigh | 0x1E);
            this.setPrgBank(6, this.prgHigh | this.prgSelect0);
        } else {
            this.setPrgBank(4, this.prgHigh | this.prgSelect0);
            this.setPrgBank(6, this.prgHigh | 0x1E);
        }
        this.setPrgBank(5, this.prgHigh | this.prgSelect1);
        this.setPrgBank(7, this.prgHigh | 0x1F);
    }

    protected void updateChrBanks() {
        if (this.chrRamPresent) {
            for (int i = 7; i >= 0; --i) {
                this.setChrBank(i, i);
            }
        } else if (this.ganbareGoemonGaiden > 0) {
            --this.ganbareGoemonGaiden;
            this.setChrBank(0, 252);
            this.setChrBank(1, 253);
            this.setChrBank(2, 255);
        } else {
            for (int i = 7; i >= 0; --i) {
                int bank = this.chrLow[i] | this.chrHigh[i] << 4;
                if (this.variant == 0) {
                    bank >>= 1;
                }
                this.setChrBank(i, bank);
            }
        }
    }

    protected void updateBanks() {
        this.updatePrgBanks();
        this.updateChrBanks();
    }

    protected void writePrgSwapMode(int value) {
        this.prgSwapMode = BitUtil.getBitBool(value, 1);
        this.updateBanks();
    }

    protected void writePrgSelect0(int value) {
        this.prgSelect0 = value & 0x1F;
        this.updateBanks();
    }

    protected void writePrgSelect1(int value) {
        this.prgSelect1 = value & 0x1F;
        this.updateBanks();
    }

    protected void writeChrSelectLow(int bank, int value) {
        this.chrLow[bank] = value & 0xF;
        this.updateBanks();
    }

    protected void writeChrSelectHigh(int bank, int value) {
        this.chrHigh[bank] = value & 0x1F;
        this.updateBanks();
    }

    protected void writeMirroringControl(int value) {
        int mask = 3;
        if (!(this.useHeuristics || this.variant != 0 && this.variant != 1)) {
            mask = 1;
        }
        this.setNametableMirroring(value & mask);
    }

    @Override
    protected void writeRegister(int address, int value) {
        if (this.variant == 0 && address == 49159) {
            this.ganbareGoemonGaiden = 8;
        }
        if ((address = this.translateAddress(address) & 0xF00F) >= 32768 && address <= 32774) {
            this.writePrgSelect0(value);
        } else if (this.variant <= 2 && address >= 36864 && address <= 36867 || this.variant >= 3 && address >= 36864 && address <= 36865) {
            this.writeMirroringControl(value);
        } else if (this.variant >= 3 && address >= 36866 && address <= 36867) {
            this.writePrgSwapMode(value);
        } else if (address >= 40960 && address <= 40966) {
            this.writePrgSelect1(value);
        } else if (address >= 45056 && address <= 57350) {
            if (this.chrRamPresent) {
                this.prgHigh = (value & 8) << 2;
                this.updateBanks();
            } else {
                int bank = ((address >> 12 & 7) - 3 << 1) + (address >> 1 & 1);
                if (BitUtil.getBitBool(address, 0)) {
                    this.writeChrSelectHigh(bank, value);
                } else {
                    this.writeChrSelectLow(bank, value);
                }
            }
        } else if (address == 61440) {
            this.writeIrqLatchLow(value);
        } else if (address == 61441) {
            this.writeIrqLatchHigh(value);
        } else if (address == 61442) {
            this.writeIrqControl(value);
        } else if (address == 61443) {
            this.writeIrqAcknowledge();
        }
    }
}

