/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.konami.vrc6;

import nintaco.mappers.Audio;
import nintaco.mappers.konami.vrc6.VrcPulseGenerator;
import nintaco.mappers.konami.vrc6.VrcSawtoothGenerator;

public final class VRC6Audio
extends Audio {
    private static final long serialVersionUID = 0L;
    private static final float[] audioScale = new float[61];
    private final VrcPulseGenerator pulse1 = new VrcPulseGenerator();
    private final VrcPulseGenerator pulse2 = new VrcPulseGenerator();
    private final VrcSawtoothGenerator sawtooth = new VrcSawtoothGenerator();

    public static void setVolume(int volume) {
        for (int i = 0; i < audioScale.length; ++i) {
            VRC6Audio.audioScale[i] = (float)(i * volume) * 253.14f / (float)(audioScale.length - 1);
        }
    }

    @Override
    public void reset() {
        this.pulse1.reset();
        this.pulse2.reset();
        this.sawtooth.reset();
    }

    @Override
    public boolean writeRegister(int address, int value) {
        switch (address) {
            case 36864: {
                this.pulse1.writeControl(value);
                return true;
            }
            case 36865: {
                this.pulse1.writeFrequencyLow(value);
                return true;
            }
            case 36866: {
                this.pulse1.writeFrequencyHigh(value);
                return true;
            }
            case 36867: {
                this.pulse1.writeFrequencyControl(value);
                this.pulse2.writeFrequencyControl(value);
                this.sawtooth.writeFrequencyControl(value);
                return true;
            }
            case 40960: {
                this.pulse2.writeControl(value);
                return true;
            }
            case 40961: {
                this.pulse2.writeFrequencyLow(value);
                return true;
            }
            case 40962: {
                this.pulse2.writeFrequencyHigh(value);
                return true;
            }
            case 45056: {
                this.sawtooth.writeAccumulatorRate(value);
                return true;
            }
            case 45057: {
                this.sawtooth.writeFrequencyLow(value);
                return true;
            }
            case 45058: {
                this.sawtooth.writeFrequencyHigh(value);
                return true;
            }
        }
        return false;
    }

    @Override
    public float getAudioSample() {
        return audioScale[this.pulse1.getValue() + this.pulse2.getValue() + this.sawtooth.getValue()];
    }

    @Override
    public int getAudioMixerScale() {
        return 40221;
    }

    @Override
    public void update() {
        this.pulse1.update();
        this.pulse2.update();
        this.sawtooth.update();
    }

    static {
        VRC6Audio.setVolume(100);
    }
}

