/*
 * Decompiled with CFR 0.152.
 */
package nintaco.mappers.namco;

import nintaco.files.CartFile;
import nintaco.mappers.Mapper;
import nintaco.mappers.namco.Namco163Audio;
import nintaco.util.BitUtil;

public class NamcoX
extends Mapper {
    private static final long serialVersionUID = 0L;
    private static final int[] NAMETABLE_MIRRORING = new int[]{2, 0, 1, 3};
    protected final Namco163Audio audio = new Namco163Audio();
    protected final boolean[] ntRamEnabled = new boolean[2];
    protected final boolean[] ramWritable = new boolean[4];
    protected int namcoType;
    protected int irqCounter;
    protected boolean irqEnabled;
    protected boolean prgRamEnabled;

    public NamcoX(CartFile cartFile) {
        super(cartFile, 8, 12);
        this.setPrgBank(7, -1);
    }

    @Override
    public void init() {
    }

    protected void setNamcoType(int namcoType) {
        this.namcoType = namcoType;
        if (namcoType == 163) {
            this.nametableMappingEnabled = false;
        }
    }

    @Override
    public int readVRAM(int address) {
        if (this.namcoType == 163) {
            if (address < 12288) {
                int bank = this.chrBanks[address >> 10];
                if (bank >= 224 && (address >= 8192 || this.ntRamEnabled[address >> 12])) {
                    return this.vram[0x2000 | (bank & 1) << 10 | address & 0x3FF];
                }
                return this.chrROM[this.chrBanks[address >> 10] << 10 | address & 0x3FF];
            }
            return this.vram[address];
        }
        if (address < 8192) {
            return this.chrROM[this.chrBanks[address >> 10] << 10 | address & 0x3FF];
        }
        return this.vram[address];
    }

    @Override
    public void writeVRAM(int address, int value) {
        if (this.namcoType == 163) {
            if (address < 12288) {
                int bank = this.chrBanks[address >> 10];
                if (bank >= 224 && (address >= 8192 || this.ntRamEnabled[address >> 12])) {
                    this.vram[0x2000 | (bank & 1) << 10 | address & 0x3FF] = value;
                }
            } else {
                this.vram[address] = value;
            }
        } else {
            this.vram[address] = value;
        }
    }

    @Override
    public int readMemory(int address) {
        if (address >= 24576 && address < 32768) {
            if (this.namcoType == 340) {
                this.setNamcoType(175);
            }
            if (this.namcoType == 163 || this.namcoType == 175 && this.prgRamEnabled) {
                return this.memory[address];
            }
            return 0;
        }
        if (address >= 32768) {
            return this.prgROM[(this.prgBanks[address >> 13] | address & 0x1FFF) & this.prgRomSizeMask];
        }
        int value = this.audio.readRegister(address);
        if (value >= 0) {
            this.setNamcoType(163);
            return value;
        }
        switch (address & 0xF800) {
            case 20480: {
                return this.readIrqCounterLow();
            }
            case 22528: {
                return this.readIrqCounterHigh();
            }
        }
        return this.memory[address];
    }

    @Override
    public void writeMemory(int address, int value) {
        if (address >= 24576 && address < 32768) {
            if (this.namcoType == 340) {
                this.setNamcoType(175);
            }
            if (this.namcoType == 163) {
                if (this.ramWritable[address >> 11 & 3]) {
                    this.memory[address] = value;
                }
            } else if (this.namcoType == 175 && this.prgRamEnabled) {
                this.memory[address] = value;
            }
        } else if (address >= 18432) {
            this.audio.writeRegister(address, value);
            switch (address & 0xF800) {
                case 18432: {
                    this.setNamcoType(163);
                    break;
                }
                case 20480: {
                    this.writeIrqCounterLow(value);
                    break;
                }
                case 22528: {
                    this.writeIrqCounterHigh(value);
                    break;
                }
                case 32768: {
                    this.writeChrBank(0, value);
                    break;
                }
                case 34816: {
                    this.writeChrBank(1, value);
                    break;
                }
                case 36864: {
                    this.writeChrBank(2, value);
                    break;
                }
                case 38912: {
                    this.writeChrBank(3, value);
                    break;
                }
                case 40960: {
                    this.writeChrBank(4, value);
                    break;
                }
                case 43008: {
                    this.writeChrBank(5, value);
                    break;
                }
                case 45056: {
                    this.writeChrBank(6, value);
                    break;
                }
                case 47104: {
                    this.writeChrBank(7, value);
                    break;
                }
                case 49152: {
                    this.writePrgRamEnable(value);
                    this.writeChrBank(8, value);
                    break;
                }
                case 51200: {
                    this.writeChrBank(9, value);
                    break;
                }
                case 53248: {
                    this.writeChrBank(10, value);
                    break;
                }
                case 55296: {
                    this.writeChrBank(11, value);
                    break;
                }
                case 57344: {
                    this.writePrgSelect1(value);
                    break;
                }
                case 59392: {
                    this.writePrgSelect2(value);
                    break;
                }
                case 61440: {
                    this.writePrgSelect3(value);
                    break;
                }
                case 63488: {
                    this.writeWriteProtect(value);
                    break;
                }
                default: {
                    this.memory[address] = value;
                    break;
                }
            }
        } else {
            this.memory[address] = value;
        }
    }

    protected void writeChrBank(int bank, int value) {
        this.chrBanks[bank] = value;
        if (bank == 8) {
            if (this.namcoType != 163) {
                this.setNamcoType(175);
            }
        } else if (bank >= 9) {
            this.setNamcoType(163);
        }
    }

    protected void writePrgSelect1(int value) {
        this.writePrgBank(4, value & 0x3F);
        if (BitUtil.getBitBool(value, 7) || this.namcoType != 163 && !this.audio.isSoundEnabled()) {
            this.setNamcoType(340);
        }
        if (this.namcoType == 340) {
            this.setNametableMirroring(NAMETABLE_MIRRORING[value >> 6]);
        }
    }

    protected void writePrgSelect2(int value) {
        this.writePrgBank(5, value);
        this.ntRamEnabled[0] = !BitUtil.getBitBool(value, 6);
        this.ntRamEnabled[1] = !BitUtil.getBitBool(value, 7);
    }

    protected void writePrgSelect3(int value) {
        this.writePrgBank(6, value);
    }

    protected void writePrgBank(int bank, int value) {
        this.setPrgBank(bank, value & 0x3F);
    }

    protected int readIrqCounterLow() {
        return this.irqCounter & 0xFF;
    }

    protected int readIrqCounterHigh() {
        return this.irqCounter >> 8;
    }

    protected void writeIrqCounterLow(int value) {
        this.cpu.setMapperIrq(false);
        this.irqCounter = this.readIrqCounterHigh() << 8 | value;
        this.setNamcoType(163);
    }

    protected void writeIrqCounterHigh(int value) {
        this.cpu.setMapperIrq(false);
        this.irqCounter = this.readIrqCounterLow() | (value & 0x7F) << 8;
        this.irqEnabled = BitUtil.getBitBool(value, 7);
        this.setNamcoType(163);
    }

    protected void writeWriteProtect(int value) {
        if ((0xF0 & value) == 64) {
            this.ramWritable[0] = !BitUtil.getBitBool(value, 0);
            this.ramWritable[1] = !BitUtil.getBitBool(value, 1);
            this.ramWritable[2] = !BitUtil.getBitBool(value, 2);
            this.ramWritable[3] = !BitUtil.getBitBool(value, 3);
        } else {
            this.ramWritable[3] = false;
            this.ramWritable[2] = false;
            this.ramWritable[1] = false;
            this.ramWritable[0] = false;
        }
        this.setNamcoType(163);
    }

    protected void writePrgRamEnable(int value) {
        this.prgRamEnabled = BitUtil.getBitBool(value, 0);
    }

    @Override
    public void update() {
        if (this.irqEnabled && this.irqCounter < Short.MAX_VALUE && ++this.irqCounter == Short.MAX_VALUE) {
            this.cpu.setMapperIrq(true);
        }
        this.audio.update();
    }

    @Override
    public int getAudioMixerScale() {
        return this.audio.getAudioMixerScale();
    }

    @Override
    public float getAudioSample() {
        return this.audio.getAudioSample();
    }
}

